/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block.pattern;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;

public class BlockStateMatcher
implements Predicate<BlockState> {
    public static final Predicate<BlockState> field_185928_a = blockState -> true;
    private final StateContainer<Block, BlockState> field_177641_a;
    private final Map<IProperty<?>, Predicate<Object>> field_177640_b = Maps.newHashMap();

    private BlockStateMatcher(StateContainer<Block, BlockState> stateContainer) {
        this.field_177641_a = stateContainer;
    }

    public static BlockStateMatcher func_177638_a(Block block) {
        return new BlockStateMatcher(block.func_176194_O());
    }

    @Override
    public boolean test(@Nullable BlockState blockState) {
        if (blockState == null || !blockState.func_177230_c().equals(this.field_177641_a.func_177622_c())) {
            return false;
        }
        if (this.field_177640_b.isEmpty()) {
            return true;
        }
        for (Map.Entry<IProperty<?>, Predicate<Object>> entry : this.field_177640_b.entrySet()) {
            if (this.func_185927_a(blockState, entry.getKey(), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    protected <T extends Comparable<T>> boolean func_185927_a(BlockState blockState, IProperty<T> iProperty, Predicate<Object> predicate) {
        T t = blockState.func_177229_b(iProperty);
        return predicate.test(t);
    }

    public <V extends Comparable<V>> BlockStateMatcher func_201028_a(IProperty<V> iProperty, Predicate<Object> predicate) {
        if (!this.field_177641_a.func_177623_d().contains(iProperty)) {
            throw new IllegalArgumentException(this.field_177641_a + " cannot support property " + iProperty);
        }
        this.field_177640_b.put(iProperty, predicate);
        return this;
    }

    @Override
    public /* synthetic */ boolean test(@Nullable Object object) {
        return this.test((BlockState)object);
    }
}

