/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.arguments;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.EntitySelector;
import net.minecraft.command.arguments.EntitySelectorParser;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.TranslationTextComponent;

public class GameProfileArgument
implements ArgumentType<IProfileProvider> {
    private static final Collection<String> field_201311_b = Arrays.asList("Player", "0123", "dd12be42-52a9-4a91-a8a1-11c01849e498", "@e");
    public static final SimpleCommandExceptionType field_197111_a = new SimpleCommandExceptionType((Message)new TranslationTextComponent("argument.player.unknown", new Object[0]));

    public static Collection<GameProfile> func_197109_a(CommandContext<CommandSource> commandContext, String string) throws CommandSyntaxException {
        return ((IProfileProvider)commandContext.getArgument(string, IProfileProvider.class)).getNames((CommandSource)commandContext.getSource());
    }

    public static GameProfileArgument func_197108_a() {
        return new GameProfileArgument();
    }

    public IProfileProvider parse(StringReader stringReader) throws CommandSyntaxException {
        if (stringReader.canRead() && stringReader.peek() == '@') {
            EntitySelectorParser entitySelectorParser = new EntitySelectorParser(stringReader);
            EntitySelector \u26032 = entitySelectorParser.func_201345_m();
            if (\u26032.func_197351_b()) {
                throw EntityArgument.field_197100_c.create();
            }
            return new ProfileProvider(\u26032);
        }
        int n = stringReader.getCursor();
        while (stringReader.canRead() && stringReader.peek() != ' ') {
            stringReader.skip();
        }
        String \u26033 = stringReader.getString().substring(n, stringReader.getCursor());
        return commandSource -> {
            GameProfile gameProfile = commandSource.func_197028_i().func_152358_ax().func_152655_a(\u26033);
            if (gameProfile == null) {
                throw field_197111_a.create();
            }
            return Collections.singleton(gameProfile);
        };
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder2) {
        if (commandContext.getSource() instanceof ISuggestionProvider) {
            StringReader stringReader = new StringReader(suggestionsBuilder2.getInput());
            stringReader.setCursor(suggestionsBuilder2.getStart());
            EntitySelectorParser \u26032 = new EntitySelectorParser(stringReader);
            try {
                \u26032.func_201345_m();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            return \u26032.func_201993_a(suggestionsBuilder2, suggestionsBuilder -> ISuggestionProvider.func_197005_b(((ISuggestionProvider)commandContext.getSource()).func_197011_j(), suggestionsBuilder));
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return field_201311_b;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static class ProfileProvider
    implements IProfileProvider {
        private final EntitySelector field_197106_a;

        public ProfileProvider(EntitySelector entitySelector) {
            this.field_197106_a = entitySelector;
        }

        @Override
        public Collection<GameProfile> getNames(CommandSource commandSource) throws CommandSyntaxException {
            List<ServerPlayerEntity> list = this.field_197106_a.func_197342_d(commandSource);
            if (list.isEmpty()) {
                throw EntityArgument.field_197102_e.create();
            }
            ArrayList \u26032 = Lists.newArrayList();
            for (ServerPlayerEntity serverPlayerEntity : list) {
                \u26032.add(serverPlayerEntity.func_146103_bH());
            }
            return \u26032;
        }
    }

    @FunctionalInterface
    public static interface IProfileProvider {
        public Collection<GameProfile> getNames(CommandSource var1) throws CommandSyntaxException;
    }
}

