/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SilverfishBlock;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class SilverfishEntity
extends MonsterEntity {
    private SummonSilverfishGoal field_175460_b;

    public SilverfishEntity(EntityType<? extends SilverfishEntity> entityType, World world) {
        super((EntityType<? extends MonsterEntity>)entityType, world);
    }

    @Override
    protected void func_184651_r() {
        this.field_175460_b = new SummonSilverfishGoal(this);
        this.field_70714_bg.func_75776_a(1, new SwimGoal(this));
        this.field_70714_bg.func_75776_a(3, this.field_175460_b);
        this.field_70714_bg.func_75776_a(4, new MeleeAttackGoal(this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, new HideInStoneGoal(this));
        this.field_70715_bh.func_75776_a(1, new HurtByTargetGoal(this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, new NearestAttackableTargetGoal<PlayerEntity>((MobEntity)this, PlayerEntity.class, true));
    }

    @Override
    public double func_70033_W() {
        return 0.1;
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize entitySize) {
        return 0.1f;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
    }

    @Override
    protected boolean func_225502_at_() {
        return false;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187793_eY;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187850_fa;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187795_eZ;
    }

    @Override
    protected void func_180429_a(BlockPos blockPos, BlockState blockState) {
        this.func_184185_a(SoundEvents.field_187852_fb, 0.15f, 1.0f);
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float f) {
        if (this.func_180431_b(damageSource)) {
            return false;
        }
        if ((damageSource instanceof EntityDamageSource || damageSource == DamageSource.field_76376_m) && this.field_175460_b != null) {
            this.field_175460_b.func_179462_f();
        }
        return super.func_70097_a(damageSource, f);
    }

    @Override
    public void func_70071_h_() {
        this.field_70761_aq = this.field_70177_z;
        super.func_70071_h_();
    }

    @Override
    public void func_181013_g(float f) {
        this.field_70177_z = f;
        super.func_181013_g(f);
    }

    @Override
    public float func_205022_a(BlockPos blockPos, IWorldReader iWorldReader) {
        if (SilverfishBlock.func_196466_i(iWorldReader.func_180495_p(blockPos.func_177977_b()))) {
            return 10.0f;
        }
        return super.func_205022_a(blockPos, iWorldReader);
    }

    public static boolean func_223331_b(EntityType<SilverfishEntity> entityType, IWorld iWorld, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        if (SilverfishEntity.func_223324_d(entityType, iWorld, spawnReason, blockPos, random)) {
            PlayerEntity playerEntity = iWorld.func_217366_a((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5, 5.0, true);
            return playerEntity == null;
        }
        return false;
    }

    @Override
    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    static class HideInStoneGoal
    extends RandomWalkingGoal {
        private Direction field_179483_b;
        private boolean field_179484_c;

        public HideInStoneGoal(SilverfishEntity silverfishEntity) {
            super(silverfishEntity, 1.0, 10);
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean func_75250_a() {
            if (this.field_75457_a.func_70638_az() != null) {
                return false;
            }
            if (!this.field_75457_a.func_70661_as().func_75500_f()) {
                return false;
            }
            Random random = this.field_75457_a.func_70681_au();
            if (this.field_75457_a.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b) && random.nextInt(10) == 0) {
                this.field_179483_b = Direction.func_176741_a(random);
                BlockPos blockPos = new BlockPos(this.field_75457_a.func_226277_ct_(), this.field_75457_a.func_226278_cu_() + 0.5, this.field_75457_a.func_226281_cx_()).func_177972_a(this.field_179483_b);
                BlockState \u26032 = this.field_75457_a.field_70170_p.func_180495_p(blockPos);
                if (SilverfishBlock.func_196466_i(\u26032)) {
                    this.field_179484_c = true;
                    return true;
                }
            }
            this.field_179484_c = false;
            return super.func_75250_a();
        }

        @Override
        public boolean func_75253_b() {
            if (this.field_179484_c) {
                return false;
            }
            return super.func_75253_b();
        }

        @Override
        public void func_75249_e() {
            if (!this.field_179484_c) {
                super.func_75249_e();
                return;
            }
            World world = this.field_75457_a.field_70170_p;
            BlockPos \u26032 = new BlockPos(this.field_75457_a.func_226277_ct_(), this.field_75457_a.func_226278_cu_() + 0.5, this.field_75457_a.func_226281_cx_()).func_177972_a(this.field_179483_b);
            BlockState \u26033 = world.func_180495_p(\u26032);
            if (SilverfishBlock.func_196466_i(\u26033)) {
                world.func_180501_a(\u26032, SilverfishBlock.func_196467_h(\u26033.func_177230_c()), 3);
                this.field_75457_a.func_70656_aK();
                this.field_75457_a.func_70106_y();
            }
        }
    }

    static class SummonSilverfishGoal
    extends Goal {
        private final SilverfishEntity field_179464_a;
        private int field_179463_b;

        public SummonSilverfishGoal(SilverfishEntity silverfishEntity) {
            this.field_179464_a = silverfishEntity;
        }

        public void func_179462_f() {
            if (this.field_179463_b == 0) {
                this.field_179463_b = 20;
            }
        }

        @Override
        public boolean func_75250_a() {
            return this.field_179463_b > 0;
        }

        @Override
        public void func_75246_d() {
            --this.field_179463_b;
            if (this.field_179463_b <= 0) {
                World world = this.field_179464_a.field_70170_p;
                Random \u26032 = this.field_179464_a.func_70681_au();
                BlockPos \u26033 = new BlockPos(this.field_179464_a);
                int \u26034 = 0;
                block0: while (\u26034 <= 5 && \u26034 >= -5) {
                    int n = 0;
                    while (n <= 10 && n >= -10) {
                        \u26037 = 0;
                        while (\u26037 <= 10 && \u26037 >= -10) {
                            BlockPos blockPos = \u26033.func_177982_a(n, \u26034, \u26037);
                            BlockState \u26035 = world.func_180495_p(blockPos);
                            Block \u26036 = \u26035.func_177230_c();
                            if (\u26036 instanceof SilverfishBlock) {
                                if (world.func_82736_K().func_223586_b(GameRules.field_223599_b)) {
                                    world.func_225521_a_(blockPos, true, this.field_179464_a);
                                } else {
                                    world.func_180501_a(blockPos, ((SilverfishBlock)\u26036).func_196468_d().func_176223_P(), 3);
                                }
                                if (\u26032.nextBoolean()) break block0;
                            }
                            int \u26037 = (\u26037 <= 0 ? 1 : 0) - \u26037;
                        }
                        n = (n <= 0 ? 1 : 0) - n;
                    }
                    \u26034 = (\u26034 <= 0 ? 1 : 0) - \u26034;
                }
            }
        }
    }
}

