/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.player;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerAbilities;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.inventory.EnderChestInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.AxeItem;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffers;
import net.minecraft.item.ShootableItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.potion.Effects;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.CommandBlockLogic;
import net.minecraft.tileentity.CommandBlockTileEntity;
import net.minecraft.tileentity.JigsawTileEntity;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.tileentity.StructureBlockTileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.FoodStats;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Unit;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class PlayerEntity
extends LivingEntity {
    public static final EntitySize field_213835_bs = EntitySize.func_220314_b(0.6f, 1.8f);
    private static final Map<Pose, EntitySize> field_213836_b = ImmutableMap.builder().put((Object)Pose.STANDING, (Object)field_213835_bs).put((Object)Pose.SLEEPING, (Object)field_213377_as).put((Object)Pose.FALL_FLYING, (Object)EntitySize.func_220314_b(0.6f, 0.6f)).put((Object)Pose.SWIMMING, (Object)EntitySize.func_220314_b(0.6f, 0.6f)).put((Object)Pose.SPIN_ATTACK, (Object)EntitySize.func_220314_b(0.6f, 0.6f)).put((Object)Pose.CROUCHING, (Object)EntitySize.func_220314_b(0.6f, 1.5f)).put((Object)Pose.DYING, (Object)EntitySize.func_220311_c(0.2f, 0.2f)).build();
    private static final DataParameter<Float> field_184829_a = EntityDataManager.func_187226_a(PlayerEntity.class, DataSerializers.field_187193_c);
    private static final DataParameter<Integer> field_184830_b = EntityDataManager.func_187226_a(PlayerEntity.class, DataSerializers.field_187192_b);
    protected static final DataParameter<Byte> field_184827_bp = EntityDataManager.func_187226_a(PlayerEntity.class, DataSerializers.field_187191_a);
    protected static final DataParameter<Byte> field_184828_bq = EntityDataManager.func_187226_a(PlayerEntity.class, DataSerializers.field_187191_a);
    protected static final DataParameter<CompoundNBT> field_192032_bt = EntityDataManager.func_187226_a(PlayerEntity.class, DataSerializers.field_192734_n);
    protected static final DataParameter<CompoundNBT> field_192033_bu = EntityDataManager.func_187226_a(PlayerEntity.class, DataSerializers.field_192734_n);
    private long field_223730_e;
    public final PlayerInventory field_71071_by = new PlayerInventory(this);
    protected EnderChestInventory field_71078_a = new EnderChestInventory();
    public final PlayerContainer field_71069_bz;
    public Container field_71070_bA;
    protected FoodStats field_71100_bB = new FoodStats();
    protected int field_71101_bC;
    public float field_71107_bF;
    public float field_71109_bG;
    public int field_71090_bL;
    public double field_71091_bM;
    public double field_71096_bN;
    public double field_71097_bO;
    public double field_71094_bP;
    public double field_71095_bQ;
    public double field_71085_bR;
    private int field_71076_b;
    protected boolean field_204230_bP;
    private BlockPos field_71077_c;
    private boolean field_82248_d;
    public final PlayerAbilities field_71075_bZ = new PlayerAbilities();
    public int field_71068_ca;
    public int field_71067_cb;
    public float field_71106_cc;
    protected int field_175152_f;
    protected final float field_71102_ce = 0.02f;
    private int field_82249_h;
    private final GameProfile field_146106_i;
    private ItemStack field_184831_bT = ItemStack.field_190927_a;
    private final CooldownTracker field_184832_bU = this.func_184815_l();
    @Nullable
    public FishingBobberEntity field_71104_cf;

    public PlayerEntity(World world, GameProfile gameProfile) {
        super((EntityType<? extends LivingEntity>)EntityType.field_200729_aH, world);
        this.func_184221_a(PlayerEntity.func_146094_a(gameProfile));
        this.field_146106_i = gameProfile;
        this.field_71069_bz = new PlayerContainer(this.field_71071_by, !world.field_72995_K, this);
        this.field_71070_bA = this.field_71069_bz;
        BlockPos blockPos = world.func_175694_M();
        this.func_70012_b((double)blockPos.func_177958_n() + 0.5, blockPos.func_177956_o() + 1, (double)blockPos.func_177952_p() + 0.5, 0.0f, 0.0f);
        this.field_70741_aB = 180.0f;
    }

    public boolean func_223729_a(World world, BlockPos blockPos, GameType gameType) {
        if (!gameType.func_82752_c()) {
            return false;
        }
        if (gameType == GameType.SPECTATOR) {
            return true;
        }
        if (this.func_175142_cm()) {
            return false;
        }
        ItemStack itemStack = this.func_184614_ca();
        return itemStack.func_190926_b() || !itemStack.func_206848_a(world.func_205772_D(), new CachedBlockInfo(world, blockPos, false));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.1f);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_188790_f);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_188792_h);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184829_a, Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(field_184830_b, 0);
        this.field_70180_af.func_187214_a(field_184827_bp, (byte)0);
        this.field_70180_af.func_187214_a(field_184828_bq, (byte)1);
        this.field_70180_af.func_187214_a(field_192032_bt, new CompoundNBT());
        this.field_70180_af.func_187214_a(field_192033_bu, new CompoundNBT());
    }

    @Override
    public void func_70071_h_() {
        this.field_70145_X = this.func_175149_v();
        if (this.func_175149_v()) {
            this.field_70122_E = false;
        }
        if (this.field_71090_bL > 0) {
            --this.field_71090_bL;
        }
        if (this.func_70608_bn()) {
            ++this.field_71076_b;
            if (this.field_71076_b > 100) {
                this.field_71076_b = 100;
            }
            if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_72935_r()) {
                this.func_225652_a_(false, true);
            }
        } else if (this.field_71076_b > 0) {
            ++this.field_71076_b;
            if (this.field_71076_b >= 110) {
                this.field_71076_b = 0;
            }
        }
        this.func_204229_de();
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_71070_bA != null && !this.field_71070_bA.func_75145_c(this)) {
            this.func_71053_j();
            this.field_71070_bA = this.field_71069_bz;
        }
        if (this.func_70027_ad() && this.field_71075_bZ.field_75102_a) {
            this.func_70066_B();
        }
        this.func_184820_o();
        if (!this.field_70170_p.field_72995_K) {
            this.field_71100_bB.func_75118_a(this);
            this.func_195066_a(Stats.field_188097_g);
            if (this.func_70089_S()) {
                this.func_195066_a(Stats.field_188098_h);
            }
            if (this.func_226273_bm_()) {
                this.func_195066_a(Stats.field_226147_n_);
            }
            if (!this.func_70608_bn()) {
                this.func_195066_a(Stats.field_203284_n);
            }
        }
        int n = 29999999;
        double \u26032 = MathHelper.func_151237_a(this.func_226277_ct_(), -2.9999999E7, 2.9999999E7);
        double \u26033 = MathHelper.func_151237_a(this.func_226281_cx_(), -2.9999999E7, 2.9999999E7);
        if (\u26032 != this.func_226277_ct_() || \u26033 != this.func_226281_cx_()) {
            this.func_70107_b(\u26032, this.func_226278_cu_(), \u26033);
        }
        ++this.field_184617_aD;
        ItemStack \u26034 = this.func_184614_ca();
        if (!ItemStack.func_77989_b(this.field_184831_bT, \u26034)) {
            if (!ItemStack.func_185132_d(this.field_184831_bT, \u26034)) {
                this.func_184821_cY();
            }
            this.field_184831_bT = \u26034.func_77946_l();
        }
        this.func_203041_m();
        this.field_184832_bU.func_185144_a();
        this.func_213832_dB();
    }

    public boolean func_226563_dT_() {
        return this.func_225608_bj_();
    }

    protected boolean func_226564_dU_() {
        return this.func_225608_bj_();
    }

    protected boolean func_226565_dV_() {
        return this.func_225608_bj_();
    }

    protected boolean func_204229_de() {
        this.field_204230_bP = this.func_213290_a(FluidTags.field_206959_a, true);
        return this.field_204230_bP;
    }

    private void func_203041_m() {
        ItemStack itemStack = this.func_184582_a(EquipmentSlotType.HEAD);
        if (itemStack.func_77973_b() == Items.field_203179_ao && !this.func_208600_a(FluidTags.field_206959_a)) {
            this.func_195064_c(new EffectInstance(Effects.field_76427_o, 200, 0, false, false, true));
        }
    }

    protected CooldownTracker func_184815_l() {
        return new CooldownTracker();
    }

    private void func_184820_o() {
        this.field_71091_bM = this.field_71094_bP;
        this.field_71096_bN = this.field_71095_bQ;
        this.field_71097_bO = this.field_71085_bR;
        double d = this.func_226277_ct_() - this.field_71094_bP;
        \u2603 = this.func_226278_cu_() - this.field_71095_bQ;
        \u2603 = this.func_226281_cx_() - this.field_71085_bR;
        \u2603 = 10.0;
        if (d > 10.0) {
            this.field_71091_bM = this.field_71094_bP = this.func_226277_ct_();
        }
        if (\u2603 > 10.0) {
            this.field_71097_bO = this.field_71085_bR = this.func_226281_cx_();
        }
        if (\u2603 > 10.0) {
            this.field_71096_bN = this.field_71095_bQ = this.func_226278_cu_();
        }
        if (d < -10.0) {
            this.field_71091_bM = this.field_71094_bP = this.func_226277_ct_();
        }
        if (\u2603 < -10.0) {
            this.field_71097_bO = this.field_71085_bR = this.func_226281_cx_();
        }
        if (\u2603 < -10.0) {
            this.field_71096_bN = this.field_71095_bQ = this.func_226278_cu_();
        }
        this.field_71094_bP += d * 0.25;
        this.field_71085_bR += \u2603 * 0.25;
        this.field_71095_bQ += \u2603 * 0.25;
    }

    protected void func_213832_dB() {
        if (!this.func_213298_c(Pose.SWIMMING)) {
            return;
        }
        Pose pose = this.func_184613_cA() ? Pose.FALL_FLYING : (this.func_70608_bn() ? Pose.SLEEPING : (this.func_203007_ba() ? Pose.SWIMMING : (this.func_204805_cN() ? Pose.SPIN_ATTACK : (this.func_225608_bj_() && !this.field_71075_bZ.field_75100_b ? Pose.CROUCHING : Pose.STANDING))));
        \u2603 = this.func_175149_v() || this.func_184218_aH() || this.func_213298_c(pose) ? pose : (this.func_213298_c(Pose.CROUCHING) ? Pose.CROUCHING : Pose.SWIMMING);
        this.func_213301_b(\u2603);
    }

    @Override
    public int func_82145_z() {
        return this.field_71075_bZ.field_75102_a ? 1 : 80;
    }

    @Override
    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187808_ef;
    }

    @Override
    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_187806_ee;
    }

    @Override
    protected SoundEvent func_204208_ah() {
        return SoundEvents.field_204328_gh;
    }

    @Override
    public int func_82147_ab() {
        return 10;
    }

    @Override
    public void func_184185_a(SoundEvent soundEvent, float f, float f2) {
        this.field_70170_p.func_184148_a(this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), soundEvent, this.func_184176_by(), f, f2);
    }

    public void func_213823_a(SoundEvent soundEvent, SoundCategory soundCategory, float f, float f2) {
    }

    @Override
    public SoundCategory func_184176_by() {
        return SoundCategory.PLAYERS;
    }

    @Override
    protected int func_190531_bD() {
        return 20;
    }

    protected void func_71053_j() {
        this.field_71070_bA = this.field_71069_bz;
    }

    @Override
    public void func_70098_U() {
        if (!this.field_70170_p.field_72995_K && this.func_226564_dU_() && this.func_184218_aH()) {
            this.func_184210_p();
            this.func_226284_e_(false);
            return;
        }
        double d = this.func_226277_ct_();
        \u2603 = this.func_226278_cu_();
        \u2603 = this.func_226281_cx_();
        float \u26032 = this.field_70177_z;
        float \u26033 = this.field_70125_A;
        super.func_70098_U();
        this.field_71107_bF = this.field_71109_bG;
        this.field_71109_bG = 0.0f;
        this.func_71015_k(this.func_226277_ct_() - d, this.func_226278_cu_() - \u2603, this.func_226281_cx_() - \u2603);
        if (this.func_184187_bx() instanceof PigEntity) {
            this.field_70125_A = \u26033;
            this.field_70177_z = \u26032;
            this.field_70761_aq = ((PigEntity)this.func_184187_bx()).field_70761_aq;
        }
    }

    @Override
    protected void func_70626_be() {
        super.func_70626_be();
        this.func_82168_bl();
        this.field_70759_as = this.field_70177_z;
    }

    @Override
    public void func_70636_d() {
        if (this.field_71101_bC > 0) {
            --this.field_71101_bC;
        }
        if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223606_i)) {
            if (this.func_110143_aJ() < this.func_110138_aP() && this.field_70173_aa % 20 == 0) {
                this.func_70691_i(1.0f);
            }
            if (this.field_71100_bB.func_75121_c() && this.field_70173_aa % 10 == 0) {
                this.field_71100_bB.func_75114_a(this.field_71100_bB.func_75116_a() + 1);
            }
        }
        this.field_71071_by.func_70429_k();
        this.field_71107_bF = this.field_71109_bG;
        super.func_70636_d();
        IAttributeInstance iAttributeInstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (!this.field_70170_p.field_72995_K) {
            iAttributeInstance.func_111128_a(this.field_71075_bZ.func_75094_b());
        }
        this.field_70747_aH = 0.02f;
        if (this.func_70051_ag()) {
            this.field_70747_aH = (float)((double)this.field_70747_aH + 0.005999999865889549);
        }
        this.func_70659_e((float)iAttributeInstance.func_111126_e());
        float \u26032 = !this.field_70122_E || this.func_110143_aJ() <= 0.0f || this.func_203007_ba() ? 0.0f : Math.min(0.1f, MathHelper.func_76133_a(PlayerEntity.func_213296_b(this.func_213322_ci())));
        this.field_71109_bG += (\u26032 - this.field_71109_bG) * 0.4f;
        if (this.func_110143_aJ() > 0.0f && !this.func_175149_v()) {
            AxisAlignedBB axisAlignedBB = this.func_184218_aH() && !this.func_184187_bx().field_70128_L ? this.func_174813_aQ().func_111270_a(this.func_184187_bx().func_174813_aQ()).func_72314_b(1.0, 0.0, 1.0) : this.func_174813_aQ().func_72314_b(1.0, 0.5, 1.0);
            List<Entity> \u26033 = this.field_70170_p.func_72839_b(this, axisAlignedBB);
            for (int i = 0; i < \u26033.size(); ++i) {
                Entity entity = \u26033.get(i);
                if (entity.field_70128_L) continue;
                this.func_71044_o(entity);
            }
        }
        this.func_192028_j(this.func_192023_dk());
        this.func_192028_j(this.func_192025_dl());
        if (!this.field_70170_p.field_72995_K && (this.field_70143_R > 0.5f || this.func_70090_H()) || this.field_71075_bZ.field_75100_b || this.func_70608_bn()) {
            this.func_192030_dh();
        }
    }

    private void func_192028_j(@Nullable CompoundNBT compoundNBT) {
        if (compoundNBT != null && !compoundNBT.func_74764_b("Silent") || !compoundNBT.func_74767_n("Silent")) {
            String string = compoundNBT.func_74779_i("id");
            EntityType.func_220327_a(string).filter(entityType -> entityType == EntityType.field_200783_W).ifPresent(entityType -> ParrotEntity.func_192005_a(this.field_70170_p, this));
        }
    }

    private void func_71044_o(Entity entity) {
        entity.func_70100_b_(this);
    }

    public int func_71037_bA() {
        return this.field_70180_af.func_187225_a(field_184830_b);
    }

    public void func_85040_s(int n) {
        this.field_70180_af.func_187227_b(field_184830_b, n);
    }

    public void func_85039_t(int n) {
        \u2603 = this.func_71037_bA();
        this.field_70180_af.func_187227_b(field_184830_b, \u2603 + n);
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        super.func_70645_a(damageSource);
        this.func_226264_Z_();
        if (!this.func_175149_v()) {
            this.func_213345_d(damageSource);
        }
        if (damageSource != null) {
            this.func_213293_j(-MathHelper.func_76134_b((this.field_70739_aP + this.field_70177_z) * ((float)Math.PI / 180)) * 0.1f, 0.1f, -MathHelper.func_76126_a((this.field_70739_aP + this.field_70177_z) * ((float)Math.PI / 180)) * 0.1f);
        } else {
            this.func_213293_j(0.0, 0.1, 0.0);
        }
        this.func_195066_a(Stats.field_188069_A);
        this.func_175145_a(Stats.field_199092_j.func_199076_b(Stats.field_188098_h));
        this.func_175145_a(Stats.field_199092_j.func_199076_b(Stats.field_203284_n));
        this.func_70066_B();
        this.func_70052_a(0, false);
    }

    @Override
    protected void func_213337_cE() {
        super.func_213337_cE();
        if (!this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c)) {
            this.func_190776_cN();
            this.field_71071_by.func_70436_m();
        }
    }

    protected void func_190776_cN() {
        for (int i = 0; i < this.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemStack = this.field_71071_by.func_70301_a(i);
            if (itemStack.func_190926_b() || !EnchantmentHelper.func_190939_c(itemStack)) continue;
            this.field_71071_by.func_70304_b(i);
        }
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        if (damageSource == DamageSource.field_76370_b) {
            return SoundEvents.field_193806_fH;
        }
        if (damageSource == DamageSource.field_76369_e) {
            return SoundEvents.field_193805_fG;
        }
        if (damageSource == DamageSource.field_220302_v) {
            return SoundEvents.field_219671_iL;
        }
        return SoundEvents.field_187800_eb;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187798_ea;
    }

    public boolean func_225609_n_(boolean bl) {
        return this.func_146097_a(this.field_71071_by.func_70298_a(this.field_71071_by.field_70461_c, bl && !this.field_71071_by.func_70448_g().func_190926_b() ? this.field_71071_by.func_70448_g().func_190916_E() : 1), false, true) != null;
    }

    @Nullable
    public ItemEntity func_71019_a(ItemStack itemStack, boolean bl) {
        return this.func_146097_a(itemStack, false, bl);
    }

    @Nullable
    public ItemEntity func_146097_a(ItemStack itemStack, boolean bl, boolean bl2) {
        if (itemStack.func_190926_b()) {
            return null;
        }
        double d = this.func_226280_cw_() - (double)0.3f;
        ItemEntity \u26032 = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), d, this.func_226281_cx_(), itemStack);
        \u26032.func_174867_a(40);
        if (bl2) {
            \u26032.func_200216_c(this.func_110124_au());
        }
        if (bl) {
            float f = this.field_70146_Z.nextFloat() * 0.5f;
            \u2603 = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
            \u26032.func_213293_j(-MathHelper.func_76126_a(\u2603) * f, 0.2f, MathHelper.func_76134_b(\u2603) * f);
        } else {
            float f = 0.3f;
            \u2603 = MathHelper.func_76126_a(this.field_70125_A * ((float)Math.PI / 180));
            \u2603 = MathHelper.func_76134_b(this.field_70125_A * ((float)Math.PI / 180));
            \u2603 = MathHelper.func_76126_a(this.field_70177_z * ((float)Math.PI / 180));
            \u2603 = MathHelper.func_76134_b(this.field_70177_z * ((float)Math.PI / 180));
            \u2603 = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
            \u2603 = 0.02f * this.field_70146_Z.nextFloat();
            \u26032.func_213293_j((double)(-\u2603 * \u2603 * 0.3f) + Math.cos(\u2603) * (double)\u2603, -\u2603 * 0.3f + 0.1f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f, (double)(\u2603 * \u2603 * 0.3f) + Math.sin(\u2603) * (double)\u2603);
        }
        return \u26032;
    }

    public float func_184813_a(BlockState blockState) {
        float f = this.field_71071_by.func_184438_a(blockState);
        if (f > 1.0f) {
            int n = EnchantmentHelper.func_185293_e(this);
            ItemStack \u26032 = this.func_184614_ca();
            if (n > 0 && !\u26032.func_190926_b()) {
                f += (float)(n * n + 1);
            }
        }
        if (EffectUtils.func_205135_a(this)) {
            f *= 1.0f + (float)(EffectUtils.func_205134_b(this) + 1) * 0.2f;
        }
        if (this.func_70644_a(Effects.field_76419_f)) {
            float f2;
            switch (this.func_70660_b(Effects.field_76419_f).func_76458_c()) {
                case 0: {
                    f2 = 0.3f;
                    break;
                }
                case 1: {
                    f2 = 0.09f;
                    break;
                }
                case 2: {
                    f2 = 0.0027f;
                    break;
                }
                default: {
                    f2 = 8.1E-4f;
                }
            }
            f *= f2;
        }
        if (this.func_208600_a(FluidTags.field_206959_a) && !EnchantmentHelper.func_185287_i(this)) {
            f /= 5.0f;
        }
        if (!this.field_70122_E) {
            f /= 5.0f;
        }
        return f;
    }

    public boolean func_184823_b(BlockState blockState) {
        return blockState.func_185904_a().func_76229_l() || this.field_71071_by.func_184432_b(blockState);
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        this.func_184221_a(PlayerEntity.func_146094_a(this.field_146106_i));
        ListNBT listNBT = compoundNBT.func_150295_c("Inventory", 10);
        this.field_71071_by.func_70443_b(listNBT);
        this.field_71071_by.field_70461_c = compoundNBT.func_74762_e("SelectedItemSlot");
        this.field_71076_b = compoundNBT.func_74765_d("SleepTimer");
        this.field_71106_cc = compoundNBT.func_74760_g("XpP");
        this.field_71068_ca = compoundNBT.func_74762_e("XpLevel");
        this.field_71067_cb = compoundNBT.func_74762_e("XpTotal");
        this.field_175152_f = compoundNBT.func_74762_e("XpSeed");
        if (this.field_175152_f == 0) {
            this.field_175152_f = this.field_70146_Z.nextInt();
        }
        this.func_85040_s(compoundNBT.func_74762_e("Score"));
        if (compoundNBT.func_150297_b("SpawnX", 99) && compoundNBT.func_150297_b("SpawnY", 99) && compoundNBT.func_150297_b("SpawnZ", 99)) {
            this.field_71077_c = new BlockPos(compoundNBT.func_74762_e("SpawnX"), compoundNBT.func_74762_e("SpawnY"), compoundNBT.func_74762_e("SpawnZ"));
            this.field_82248_d = compoundNBT.func_74767_n("SpawnForced");
        }
        this.field_71100_bB.func_75112_a(compoundNBT);
        this.field_71075_bZ.func_75095_b(compoundNBT);
        if (compoundNBT.func_150297_b("EnderItems", 9)) {
            this.field_71078_a.func_70486_a(compoundNBT.func_150295_c("EnderItems", 10));
        }
        if (compoundNBT.func_150297_b("ShoulderEntityLeft", 10)) {
            this.func_192029_h(compoundNBT.func_74775_l("ShoulderEntityLeft"));
        }
        if (compoundNBT.func_150297_b("ShoulderEntityRight", 10)) {
            this.func_192031_i(compoundNBT.func_74775_l("ShoulderEntityRight"));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_74768_a("DataVersion", SharedConstants.func_215069_a().getWorldVersion());
        compoundNBT.func_218657_a("Inventory", this.field_71071_by.func_70442_a(new ListNBT()));
        compoundNBT.func_74768_a("SelectedItemSlot", this.field_71071_by.field_70461_c);
        compoundNBT.func_74777_a("SleepTimer", (short)this.field_71076_b);
        compoundNBT.func_74776_a("XpP", this.field_71106_cc);
        compoundNBT.func_74768_a("XpLevel", this.field_71068_ca);
        compoundNBT.func_74768_a("XpTotal", this.field_71067_cb);
        compoundNBT.func_74768_a("XpSeed", this.field_175152_f);
        compoundNBT.func_74768_a("Score", this.func_71037_bA());
        if (this.field_71077_c != null) {
            compoundNBT.func_74768_a("SpawnX", this.field_71077_c.func_177958_n());
            compoundNBT.func_74768_a("SpawnY", this.field_71077_c.func_177956_o());
            compoundNBT.func_74768_a("SpawnZ", this.field_71077_c.func_177952_p());
            compoundNBT.func_74757_a("SpawnForced", this.field_82248_d);
        }
        this.field_71100_bB.func_75117_b(compoundNBT);
        this.field_71075_bZ.func_75091_a(compoundNBT);
        compoundNBT.func_218657_a("EnderItems", this.field_71078_a.func_70487_g());
        if (!this.func_192023_dk().isEmpty()) {
            compoundNBT.func_218657_a("ShoulderEntityLeft", this.func_192023_dk());
        }
        if (!this.func_192025_dl().isEmpty()) {
            compoundNBT.func_218657_a("ShoulderEntityRight", this.func_192025_dl());
        }
    }

    @Override
    public boolean func_180431_b(DamageSource damageSource) {
        if (super.func_180431_b(damageSource)) {
            return true;
        }
        if (damageSource == DamageSource.field_76369_e) {
            return !this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_226679_A_);
        }
        if (damageSource == DamageSource.field_76379_h) {
            return !this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_226680_B_);
        }
        if (damageSource.func_76347_k()) {
            return !this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_226681_C_);
        }
        return false;
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float f) {
        if (this.func_180431_b(damageSource)) {
            return false;
        }
        if (this.field_71075_bZ.field_75102_a && !damageSource.func_76357_e()) {
            return false;
        }
        this.field_70708_bq = 0;
        if (this.func_110143_aJ() <= 0.0f) {
            return false;
        }
        this.func_192030_dh();
        if (damageSource.func_76350_n()) {
            if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
                f = 0.0f;
            }
            if (this.field_70170_p.func_175659_aa() == Difficulty.EASY) {
                f = Math.min(f / 2.0f + 1.0f, f);
            }
            if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                f = f * 3.0f / 2.0f;
            }
        }
        if (f == 0.0f) {
            return false;
        }
        return super.func_70097_a(damageSource, f);
    }

    @Override
    protected void func_190629_c(LivingEntity livingEntity) {
        super.func_190629_c(livingEntity);
        if (livingEntity.func_184614_ca().func_77973_b() instanceof AxeItem) {
            this.func_190777_m(true);
        }
    }

    public boolean func_96122_a(PlayerEntity playerEntity) {
        Team team = this.func_96124_cp();
        \u2603 = playerEntity.func_96124_cp();
        if (team == null) {
            return true;
        }
        if (!team.func_142054_a(\u2603)) {
            return true;
        }
        return team.func_96665_g();
    }

    @Override
    protected void func_70675_k(float f) {
        this.field_71071_by.func_70449_g(f);
    }

    @Override
    protected void func_184590_k(float f) {
        if (f >= 3.0f && this.field_184627_bm.func_77973_b() == Items.field_185159_cQ) {
            int n = 1 + MathHelper.func_76141_d(f);
            Hand \u26032 = this.func_184600_cs();
            this.field_184627_bm.func_222118_a(n, this, playerEntity -> playerEntity.func_213334_d(\u26032));
            if (this.field_184627_bm.func_190926_b()) {
                if (\u26032 == Hand.MAIN_HAND) {
                    this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                } else {
                    this.func_184201_a(EquipmentSlotType.OFFHAND, ItemStack.field_190927_a);
                }
                this.field_184627_bm = ItemStack.field_190927_a;
                this.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            }
        }
    }

    @Override
    protected void func_70665_d(DamageSource damageSource, float f) {
        if (this.func_180431_b(damageSource)) {
            return;
        }
        f = this.func_70655_b(damageSource, f);
        \u2603 = f = this.func_70672_c(damageSource, f);
        f = Math.max(f - this.func_110139_bj(), 0.0f);
        this.func_110149_m(this.func_110139_bj() - (\u2603 - f));
        \u2603 = \u2603 - f;
        if (\u2603 > 0.0f && \u2603 < 3.4028235E37f) {
            this.func_195067_a(Stats.field_212738_J, Math.round(\u2603 * 10.0f));
        }
        if (f == 0.0f) {
            return;
        }
        this.func_71020_j(damageSource.func_76345_d());
        \u2603 = this.func_110143_aJ();
        this.func_70606_j(this.func_110143_aJ() - f);
        this.func_110142_aN().func_94547_a(damageSource, \u2603, f);
        if (f < 3.4028235E37f) {
            this.func_195067_a(Stats.field_188112_z, Math.round(f * 10.0f));
        }
    }

    public void func_175141_a(SignTileEntity signTileEntity) {
    }

    public void func_184809_a(CommandBlockLogic commandBlockLogic) {
    }

    public void func_184824_a(CommandBlockTileEntity commandBlockTileEntity) {
    }

    public void func_189807_a(StructureBlockTileEntity structureBlockTileEntity) {
    }

    public void func_213826_a(JigsawTileEntity jigsawTileEntity) {
    }

    public void func_184826_a(AbstractHorseEntity abstractHorseEntity, IInventory iInventory) {
    }

    public OptionalInt func_213829_a(@Nullable INamedContainerProvider iNamedContainerProvider) {
        return OptionalInt.empty();
    }

    public void func_213818_a(int n, MerchantOffers merchantOffers, int n2, int n3, boolean bl, boolean bl2) {
    }

    public void func_184814_a(ItemStack itemStack, Hand hand) {
    }

    public ActionResultType func_190775_a(Entity entity, Hand hand) {
        if (this.func_175149_v()) {
            if (entity instanceof INamedContainerProvider) {
                this.func_213829_a((INamedContainerProvider)((Object)entity));
            }
            return ActionResultType.PASS;
        }
        ItemStack itemStack = this.func_184586_b(hand);
        \u2603 = itemStack.func_77946_l();
        if (entity.func_184230_a(this, hand)) {
            if (this.field_71075_bZ.field_75098_d && itemStack == this.func_184586_b(hand) && itemStack.func_190916_E() < \u2603.func_190916_E()) {
                itemStack.func_190920_e(\u2603.func_190916_E());
            }
            return ActionResultType.SUCCESS;
        }
        if (!itemStack.func_190926_b() && entity instanceof LivingEntity) {
            if (this.field_71075_bZ.field_75098_d) {
                itemStack = \u2603;
            }
            if (itemStack.func_111282_a(this, (LivingEntity)entity, hand)) {
                if (itemStack.func_190926_b() && !this.field_71075_bZ.field_75098_d) {
                    this.func_184611_a(hand, ItemStack.field_190927_a);
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    @Override
    public double func_70033_W() {
        return -0.35;
    }

    @Override
    public void func_184210_p() {
        super.func_184210_p();
        this.field_184245_j = 0;
    }

    @Override
    protected boolean func_70610_aX() {
        return super.func_70610_aX() || this.func_70608_bn();
    }

    @Override
    protected Vec3d func_225514_a_(Vec3d \u260322, MoverType moverType) {
        Vec3d \u260322;
        if ((moverType == MoverType.SELF || moverType == MoverType.PLAYER) && this.field_70122_E && this.func_226565_dV_()) {
            double d = \u260322.field_72450_a;
            \u2603 = \u260322.field_72449_c;
            \u2603 = 0.05;
            while (d != 0.0 && this.field_70170_p.func_226665_a__(this, this.func_174813_aQ().func_72317_d(d, -this.field_70138_W, 0.0))) {
                if (d < 0.05 && d >= -0.05) {
                    d = 0.0;
                    continue;
                }
                if (d > 0.0) {
                    d -= 0.05;
                    continue;
                }
                d += 0.05;
            }
            while (\u2603 != 0.0 && this.field_70170_p.func_226665_a__(this, this.func_174813_aQ().func_72317_d(0.0, -this.field_70138_W, \u2603))) {
                if (\u2603 < 0.05 && \u2603 >= -0.05) {
                    \u2603 = 0.0;
                    continue;
                }
                if (\u2603 > 0.0) {
                    \u2603 -= 0.05;
                    continue;
                }
                \u2603 += 0.05;
            }
            while (d != 0.0 && \u2603 != 0.0 && this.field_70170_p.func_226665_a__(this, this.func_174813_aQ().func_72317_d(d, -this.field_70138_W, \u2603))) {
                d = d < 0.05 && d >= -0.05 ? 0.0 : (d > 0.0 ? (d -= 0.05) : (d += 0.05));
                if (\u2603 < 0.05 && \u2603 >= -0.05) {
                    \u2603 = 0.0;
                    continue;
                }
                if (\u2603 > 0.0) {
                    \u2603 -= 0.05;
                    continue;
                }
                \u2603 += 0.05;
            }
            \u260322 = new Vec3d(d, \u260322.field_72448_b, \u2603);
        }
        return \u260322;
    }

    public void func_71059_n(Entity entity2) {
        if (!entity2.func_70075_an()) {
            return;
        }
        if (entity2.func_85031_j(this)) {
            return;
        }
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        \u2603 = entity2 instanceof LivingEntity ? EnchantmentHelper.func_152377_a(this.func_184614_ca(), ((LivingEntity)entity2).func_70668_bt()) : EnchantmentHelper.func_152377_a(this.func_184614_ca(), CreatureAttribute.field_223222_a_);
        \u2603 = this.func_184825_o(0.5f);
        \u2603 *= \u2603;
        this.func_184821_cY();
        if ((f *= 0.2f + \u2603 * \u2603 * 0.8f) > 0.0f || \u2603 > 0.0f) {
            boolean bl = \u2603 > 0.9f;
            \u2603 = false;
            int \u26032 = 0;
            \u26032 += EnchantmentHelper.func_77501_a(this);
            if (this.func_70051_ag() && bl) {
                this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187721_dT, this.func_184176_by(), 1.0f, 1.0f);
                ++\u26032;
                \u2603 = true;
            }
            \u2603 = bl && this.field_70143_R > 0.0f && !this.field_70122_E && !this.func_70617_f_() && !this.func_70090_H() && !this.func_70644_a(Effects.field_76440_q) && !this.func_184218_aH() && entity2 instanceof LivingEntity;
            boolean bl2 = \u2603 = \u2603 && !this.func_70051_ag();
            if (\u2603) {
                f *= 1.5f;
            }
            f += \u2603;
            \u2603 = false;
            double \u26033 = this.field_70140_Q - this.field_70141_P;
            if (bl && !\u2603 && !\u2603 && this.field_70122_E && \u26033 < (double)this.func_70689_ay() && (\u2603 = this.func_184586_b(Hand.MAIN_HAND)).func_77973_b() instanceof SwordItem) {
                \u2603 = true;
            }
            float \u26034 = 0.0f;
            bl3 = false;
            int \u26035 = EnchantmentHelper.func_90036_a(this);
            if (entity2 instanceof LivingEntity) {
                \u26034 = ((LivingEntity)entity2).func_110143_aJ();
                if (\u26035 > 0 && !entity2.func_70027_ad()) {
                    bl3 = true;
                    entity2.func_70015_d(1);
                }
            }
            Vec3d \u26036 = entity2.func_213322_ci();
            \u2603 = entity2.func_70097_a(DamageSource.func_76365_a(this), f);
            if (\u2603) {
                Entity entity2;
                Object \u26037;
                if (\u26032 > 0) {
                    if (entity2 instanceof LivingEntity) {
                        ((LivingEntity)entity2).func_70653_a(this, (float)\u26032 * 0.5f, MathHelper.func_76126_a(this.field_70177_z * ((float)Math.PI / 180)), -MathHelper.func_76134_b(this.field_70177_z * ((float)Math.PI / 180)));
                    } else {
                        entity2.func_70024_g(-MathHelper.func_76126_a(this.field_70177_z * ((float)Math.PI / 180)) * (float)\u26032 * 0.5f, 0.1, MathHelper.func_76134_b(this.field_70177_z * ((float)Math.PI / 180)) * (float)\u26032 * 0.5f);
                    }
                    this.func_213317_d(this.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
                    this.func_70031_b(false);
                }
                if (\u2603) {
                    float f2 = 1.0f + EnchantmentHelper.func_191527_a(this) * f;
                    \u26037 = this.field_70170_p.func_217357_a(LivingEntity.class, entity2.func_174813_aQ().func_72314_b(1.0, 0.25, 1.0));
                    Iterator<LivingEntity> iterator = \u26037.iterator();
                    while (iterator.hasNext()) {
                        LivingEntity livingEntity = iterator.next();
                        if (livingEntity == this || livingEntity == entity2 || this.func_184191_r(livingEntity) || livingEntity instanceof ArmorStandEntity && ((ArmorStandEntity)livingEntity).func_181026_s() || !(this.func_70068_e(livingEntity) < 9.0)) continue;
                        livingEntity.func_70653_a(this, 0.4f, MathHelper.func_76126_a(this.field_70177_z * ((float)Math.PI / 180)), -MathHelper.func_76134_b(this.field_70177_z * ((float)Math.PI / 180)));
                        livingEntity.func_70097_a(DamageSource.func_76365_a(this), f2);
                    }
                    this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187730_dW, this.func_184176_by(), 1.0f, 1.0f);
                    this.func_184810_cG();
                }
                if (entity2 instanceof ServerPlayerEntity && entity2.field_70133_I) {
                    ((ServerPlayerEntity)entity2).field_71135_a.func_147359_a(new SEntityVelocityPacket(entity2));
                    entity2.field_70133_I = false;
                    entity2.func_213317_d(\u26036);
                }
                if (\u2603) {
                    this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187718_dS, this.func_184176_by(), 1.0f, 1.0f);
                    this.func_71009_b(entity2);
                }
                if (!\u2603 && !\u2603) {
                    if (bl) {
                        this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187727_dV, this.func_184176_by(), 1.0f, 1.0f);
                    } else {
                        this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187733_dX, this.func_184176_by(), 1.0f, 1.0f);
                    }
                }
                if (\u2603 > 0.0f) {
                    this.func_71047_c(entity2);
                }
                this.func_130011_c(entity2);
                if (entity2 instanceof LivingEntity) {
                    EnchantmentHelper.func_151384_a((LivingEntity)entity2, this);
                }
                EnchantmentHelper.func_151385_b(this, entity2);
                ItemStack \u26038 = this.func_184614_ca();
                \u26037 = entity2;
                if (entity2 instanceof EnderDragonPartEntity) {
                    \u26037 = ((EnderDragonPartEntity)entity2).field_213852_b;
                }
                if (!this.field_70170_p.field_72995_K && !\u26038.func_190926_b() && \u26037 instanceof LivingEntity) {
                    \u26038.func_77961_a((LivingEntity)\u26037, this);
                    if (\u26038.func_190926_b()) {
                        this.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
                    }
                }
                if (entity2 instanceof LivingEntity) {
                    float f3 = \u26034 - ((LivingEntity)entity2).func_110143_aJ();
                    this.func_195067_a(Stats.field_188111_y, Math.round(f3 * 10.0f));
                    if (\u26035 > 0) {
                        entity2.func_70015_d(\u26035 * 4);
                    }
                    if (this.field_70170_p instanceof ServerWorld && f3 > 2.0f) {
                        int n = (int)((double)f3 * 0.5);
                        ((ServerWorld)this.field_70170_p).func_195598_a(ParticleTypes.field_197615_h, entity2.func_226277_ct_(), entity2.func_226283_e_(0.5), entity2.func_226281_cx_(), n, 0.1, 0.0, 0.1, 0.2);
                    }
                }
                this.func_71020_j(0.1f);
            } else {
                boolean bl3;
                this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187724_dU, this.func_184176_by(), 1.0f, 1.0f);
                if (bl3) {
                    entity2.func_70066_B();
                }
            }
        }
    }

    @Override
    protected void func_204804_d(LivingEntity livingEntity) {
        this.func_71059_n(livingEntity);
    }

    public void func_190777_m(boolean bl) {
        float f = 0.25f + (float)EnchantmentHelper.func_185293_e(this) * 0.05f;
        if (bl) {
            f += 0.75f;
        }
        if (this.field_70146_Z.nextFloat() < f) {
            this.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
            this.func_184602_cy();
            this.field_70170_p.func_72960_a(this, (byte)30);
        }
    }

    public void func_71009_b(Entity entity) {
    }

    public void func_71047_c(Entity entity) {
    }

    public void func_184810_cG() {
        double d = -MathHelper.func_76126_a(this.field_70177_z * ((float)Math.PI / 180));
        \u2603 = MathHelper.func_76134_b(this.field_70177_z * ((float)Math.PI / 180));
        if (this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_195598_a(ParticleTypes.field_197603_N, this.func_226277_ct_() + d, this.func_226283_e_(0.5), this.func_226281_cx_() + \u2603, 0, d, 0.0, \u2603, 0.0);
        }
    }

    @Override
    public void func_70106_y() {
        super.func_70106_y();
        this.field_71069_bz.func_75134_a(this);
        if (this.field_71070_bA != null) {
            this.field_71070_bA.func_75134_a(this);
        }
    }

    public boolean func_175144_cb() {
        return false;
    }

    public GameProfile func_146103_bH() {
        return this.field_146106_i;
    }

    public Either<SleepResult, Unit> func_213819_a(BlockPos blockPos) {
        Direction direction = this.field_70170_p.func_180495_p(blockPos).func_177229_b(HorizontalBlock.field_185512_D);
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70608_bn() || !this.func_70089_S()) {
                return Either.left((Object)((Object)SleepResult.OTHER_PROBLEM));
            }
            if (!this.field_70170_p.field_73011_w.func_76569_d()) {
                return Either.left((Object)((Object)SleepResult.NOT_POSSIBLE_HERE));
            }
            if (this.field_70170_p.func_72935_r()) {
                this.func_226560_a_(blockPos, false, true);
                return Either.left((Object)((Object)SleepResult.NOT_POSSIBLE_NOW));
            }
            if (!this.func_190774_a(blockPos, direction)) {
                return Either.left((Object)((Object)SleepResult.TOO_FAR_AWAY));
            }
            if (this.func_213828_b(blockPos, direction)) {
                return Either.left((Object)((Object)SleepResult.OBSTRUCTED));
            }
            if (!this.func_184812_l_()) {
                double d = 8.0;
                \u2603 = 5.0;
                Vec3d \u26032 = new Vec3d((double)blockPos.func_177958_n() + 0.5, blockPos.func_177956_o(), (double)blockPos.func_177952_p() + 0.5);
                List<MonsterEntity> \u26033 = this.field_70170_p.func_175647_a(MonsterEntity.class, new AxisAlignedBB(\u26032.func_82615_a() - 8.0, \u26032.func_82617_b() - 5.0, \u26032.func_82616_c() - 8.0, \u26032.func_82615_a() + 8.0, \u26032.func_82617_b() + 5.0, \u26032.func_82616_c() + 8.0), monsterEntity -> monsterEntity.func_191990_c(this));
                if (!\u26033.isEmpty()) {
                    return Either.left((Object)((Object)SleepResult.NOT_SAFE));
                }
            }
        }
        this.func_213342_e(blockPos);
        this.field_71076_b = 0;
        if (this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_72854_c();
        }
        return Either.right((Object)((Object)Unit.INSTANCE));
    }

    @Override
    public void func_213342_e(BlockPos blockPos) {
        this.func_175145_a(Stats.field_199092_j.func_199076_b(Stats.field_203284_n));
        this.func_226560_a_(blockPos, false, true);
        super.func_213342_e(blockPos);
    }

    private boolean func_190774_a(BlockPos blockPos, Direction direction) {
        return this.func_230126_g_(blockPos) || this.func_230126_g_(blockPos.func_177972_a(direction.func_176734_d()));
    }

    private boolean func_230126_g_(BlockPos blockPos) {
        Vec3d vec3d = new Vec3d((double)blockPos.func_177958_n() + 0.5, blockPos.func_177956_o(), (double)blockPos.func_177952_p() + 0.5);
        return Math.abs(this.func_226277_ct_() - vec3d.func_82615_a()) <= 3.0 && Math.abs(this.func_226278_cu_() - vec3d.func_82617_b()) <= 2.0 && Math.abs(this.func_226281_cx_() - vec3d.func_82616_c()) <= 3.0;
    }

    private boolean func_213828_b(BlockPos blockPos, Direction direction) {
        BlockPos blockPos2 = blockPos.func_177984_a();
        return !this.func_207401_g(blockPos2) || !this.func_207401_g(blockPos2.func_177972_a(direction.func_176734_d()));
    }

    public void func_225652_a_(boolean bl, boolean bl2) {
        super.func_213366_dy();
        if (this.field_70170_p instanceof ServerWorld && bl2) {
            ((ServerWorld)this.field_70170_p).func_72854_c();
        }
        this.field_71076_b = bl ? 0 : 100;
    }

    @Override
    public void func_213366_dy() {
        this.func_225652_a_(true, true);
    }

    public static Optional<Vec3d> func_213822_a(IWorldReader iWorldReader2, BlockPos blockPos, boolean bl) {
        IWorldReader iWorldReader2;
        Block block = iWorldReader2.func_180495_p(blockPos).func_177230_c();
        if (!(block instanceof BedBlock)) {
            if (!bl) {
                return Optional.empty();
            }
            boolean bl2 = block.func_181623_g();
            \u2603 = iWorldReader2.func_180495_p(blockPos.func_177984_a()).func_177230_c().func_181623_g();
            if (bl2 && \u2603) {
                return Optional.of(new Vec3d((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.1, (double)blockPos.func_177952_p() + 0.5));
            }
            return Optional.empty();
        }
        return BedBlock.func_220172_a(EntityType.field_200729_aH, iWorldReader2, blockPos, 0);
    }

    public boolean func_71026_bH() {
        return this.func_70608_bn() && this.field_71076_b >= 100;
    }

    public int func_71060_bI() {
        return this.field_71076_b;
    }

    public void func_146105_b(ITextComponent iTextComponent, boolean bl) {
    }

    public BlockPos func_180470_cg() {
        return this.field_71077_c;
    }

    public boolean func_82245_bX() {
        return this.field_82248_d;
    }

    public void func_226560_a_(BlockPos blockPos, boolean bl, boolean bl2) {
        if (blockPos != null) {
            if (bl2 && !blockPos.equals(this.field_71077_c)) {
                this.func_145747_a(new TranslationTextComponent("block.minecraft.bed.set_spawn", new Object[0]));
            }
            this.field_71077_c = blockPos;
            this.field_82248_d = bl;
        } else {
            this.field_71077_c = null;
            this.field_82248_d = false;
        }
    }

    public void func_195066_a(ResourceLocation resourceLocation) {
        this.func_71029_a(Stats.field_199092_j.func_199076_b(resourceLocation));
    }

    public void func_195067_a(ResourceLocation resourceLocation, int n) {
        this.func_71064_a(Stats.field_199092_j.func_199076_b(resourceLocation), n);
    }

    public void func_71029_a(Stat<?> stat) {
        this.func_71064_a(stat, 1);
    }

    public void func_71064_a(Stat<?> stat, int n) {
    }

    public void func_175145_a(Stat<?> stat) {
    }

    public int func_195065_a(Collection<IRecipe<?>> collection) {
        return 0;
    }

    public void func_193102_a(ResourceLocation[] resourceLocationArray) {
    }

    public int func_195069_b(Collection<IRecipe<?>> collection) {
        return 0;
    }

    @Override
    public void func_70664_aZ() {
        super.func_70664_aZ();
        this.func_195066_a(Stats.field_75953_u);
        if (this.func_70051_ag()) {
            this.func_71020_j(0.2f);
        } else {
            this.func_71020_j(0.05f);
        }
    }

    @Override
    public void func_213352_e(Vec3d vec3d) {
        double d = this.func_226277_ct_();
        \u2603 = this.func_226278_cu_();
        \u2603 = this.func_226281_cx_();
        if (this.func_203007_ba() && !this.func_184218_aH()) {
            d3 = this.func_70040_Z().field_72448_b;
            double d2 = \u2603 = d3 < -0.2 ? 0.085 : 0.06;
            if (d3 <= 0.0 || this.field_70703_bu || !this.field_70170_p.func_180495_p(new BlockPos(this.func_226277_ct_(), this.func_226278_cu_() + 1.0 - 0.1, this.func_226281_cx_())).func_204520_s().func_206888_e()) {
                Vec3d vec3d2 = this.func_213322_ci();
                this.func_213317_d(vec3d2.func_72441_c(0.0, (d3 - vec3d2.field_72448_b) * \u2603, 0.0));
            }
        }
        if (this.field_71075_bZ.field_75100_b && !this.func_184218_aH()) {
            double d3 = this.func_213322_ci().field_72448_b;
            float \u26032 = this.field_70747_aH;
            this.field_70747_aH = this.field_71075_bZ.func_75093_a() * (float)(this.func_70051_ag() ? 2 : 1);
            super.func_213352_e(vec3d);
            Vec3d \u26033 = this.func_213322_ci();
            this.func_213293_j(\u26033.field_72450_a, d3 * 0.6, \u26033.field_72449_c);
            this.field_70747_aH = \u26032;
            this.field_70143_R = 0.0f;
            this.func_70052_a(7, false);
        } else {
            super.func_213352_e(vec3d);
        }
        this.func_71000_j(this.func_226277_ct_() - d, this.func_226278_cu_() - \u2603, this.func_226281_cx_() - \u2603);
    }

    @Override
    public void func_205343_av() {
        if (this.field_71075_bZ.field_75100_b) {
            this.func_204711_a(false);
        } else {
            super.func_205343_av();
        }
    }

    protected boolean func_207401_g(BlockPos blockPos) {
        return !this.field_70170_p.func_180495_p(blockPos).func_229980_m_(this.field_70170_p, blockPos);
    }

    @Override
    public float func_70689_ay() {
        return (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
    }

    public void func_71000_j(double d4, double d2, double d3) {
        if (this.func_184218_aH()) {
            return;
        }
        if (this.func_203007_ba()) {
            int n = Math.round(MathHelper.func_76133_a(d4 * d4 + d2 * d2 + d3 * d3) * 100.0f);
            if (n > 0) {
                this.func_195067_a(Stats.field_75946_m, n);
                this.func_71020_j(0.01f * (float)n * 0.01f);
            }
        } else if (this.func_213290_a(FluidTags.field_206959_a, true)) {
            double d4;
            int \u26032 = Math.round(MathHelper.func_76133_a(d4 * d4 + d2 * d2 + d3 * d3) * 100.0f);
            if (\u26032 > 0) {
                this.func_195067_a(Stats.field_211756_w, \u26032);
                this.func_71020_j(0.01f * (float)\u26032 * 0.01f);
            }
        } else if (this.func_70090_H()) {
            int \u26033 = Math.round(MathHelper.func_76133_a(d4 * d4 + d3 * d3) * 100.0f);
            if (\u26033 > 0) {
                this.func_195067_a(Stats.field_211755_s, \u26033);
                this.func_71020_j(0.01f * (float)\u26033 * 0.01f);
            }
        } else if (this.func_70617_f_()) {
            if (d2 > 0.0) {
                this.func_195067_a(Stats.field_188103_o, (int)Math.round(d2 * 100.0));
            }
        } else if (this.field_70122_E) {
            int \u26034 = Math.round(MathHelper.func_76133_a(d4 * d4 + d3 * d3) * 100.0f);
            if (\u26034 > 0) {
                if (this.func_70051_ag()) {
                    this.func_195067_a(Stats.field_188102_l, \u26034);
                    this.func_71020_j(0.1f * (float)\u26034 * 0.01f);
                } else if (this.func_213453_ef()) {
                    this.func_195067_a(Stats.field_188101_k, \u26034);
                    this.func_71020_j(0.0f * (float)\u26034 * 0.01f);
                } else {
                    this.func_195067_a(Stats.field_188100_j, \u26034);
                    this.func_71020_j(0.0f * (float)\u26034 * 0.01f);
                }
            }
        } else if (this.func_184613_cA()) {
            int \u26035 = Math.round(MathHelper.func_76133_a(d4 * d4 + d2 * d2 + d3 * d3) * 100.0f);
            this.func_195067_a(Stats.field_188110_v, \u26035);
        } else {
            int \u26036 = Math.round(MathHelper.func_76133_a(d4 * d4 + d3 * d3) * 100.0f);
            if (\u26036 > 25) {
                this.func_195067_a(Stats.field_188104_p, \u26036);
            }
        }
    }

    private void func_71015_k(double d, double d2, double d3) {
        if (this.func_184218_aH() && (\u2603 = Math.round(MathHelper.func_76133_a(d * d + d2 * d2 + d3 * d3) * 100.0f)) > 0) {
            if (this.func_184187_bx() instanceof AbstractMinecartEntity) {
                this.func_195067_a(Stats.field_188106_r, \u2603);
            } else if (this.func_184187_bx() instanceof BoatEntity) {
                this.func_195067_a(Stats.field_188107_s, \u2603);
            } else if (this.func_184187_bx() instanceof PigEntity) {
                this.func_195067_a(Stats.field_188108_t, \u2603);
            } else if (this.func_184187_bx() instanceof AbstractHorseEntity) {
                this.func_195067_a(Stats.field_188109_u, \u2603);
            }
        }
    }

    @Override
    public boolean func_225503_b_(float f, float f2) {
        if (this.field_71075_bZ.field_75101_c) {
            return false;
        }
        if (f >= 2.0f) {
            this.func_195067_a(Stats.field_75943_n, (int)Math.round((double)f * 100.0));
        }
        return super.func_225503_b_(f, f2);
    }

    public boolean func_226566_ei_() {
        ItemStack itemStack;
        if (!this.field_70122_E && !this.func_184613_cA() && !this.func_70090_H() && (itemStack = this.func_184582_a(EquipmentSlotType.CHEST)).func_77973_b() == Items.field_185160_cR && ElytraItem.func_185069_d(itemStack)) {
            this.func_226567_ej_();
            return true;
        }
        return false;
    }

    public void func_226567_ej_() {
        this.func_70052_a(7, true);
    }

    public void func_226568_ek_() {
        this.func_70052_a(7, true);
        this.func_70052_a(7, false);
    }

    @Override
    protected void func_71061_d_() {
        if (!this.func_175149_v()) {
            super.func_71061_d_();
        }
    }

    @Override
    protected SoundEvent func_184588_d(int n) {
        if (n > 4) {
            return SoundEvents.field_187736_dY;
        }
        return SoundEvents.field_187804_ed;
    }

    @Override
    public void func_70074_a(LivingEntity livingEntity) {
        this.func_71029_a(Stats.field_199090_h.func_199076_b(livingEntity.func_200600_R()));
    }

    @Override
    public void func_213295_a(BlockState blockState, Vec3d vec3d) {
        if (!this.field_71075_bZ.field_75100_b) {
            super.func_213295_a(blockState, vec3d);
        }
    }

    public void func_195068_e(int n) {
        this.func_85039_t(n);
        this.field_71106_cc += (float)n / (float)this.func_71050_bK();
        this.field_71067_cb = MathHelper.func_76125_a(this.field_71067_cb + n, 0, Integer.MAX_VALUE);
        while (this.field_71106_cc < 0.0f) {
            float f = this.field_71106_cc * (float)this.func_71050_bK();
            if (this.field_71068_ca > 0) {
                this.func_82242_a(-1);
                this.field_71106_cc = 1.0f + f / (float)this.func_71050_bK();
                continue;
            }
            this.func_82242_a(-1);
            this.field_71106_cc = 0.0f;
        }
        while (this.field_71106_cc >= 1.0f) {
            this.field_71106_cc = (this.field_71106_cc - 1.0f) * (float)this.func_71050_bK();
            this.func_82242_a(1);
            this.field_71106_cc /= (float)this.func_71050_bK();
        }
    }

    public int func_175138_ci() {
        return this.field_175152_f;
    }

    public void func_192024_a(ItemStack itemStack, int n) {
        this.field_71068_ca -= n;
        if (this.field_71068_ca < 0) {
            this.field_71068_ca = 0;
            this.field_71106_cc = 0.0f;
            this.field_71067_cb = 0;
        }
        this.field_175152_f = this.field_70146_Z.nextInt();
    }

    public void func_82242_a(int n) {
        this.field_71068_ca += n;
        if (this.field_71068_ca < 0) {
            this.field_71068_ca = 0;
            this.field_71106_cc = 0.0f;
            this.field_71067_cb = 0;
        }
        if (n > 0 && this.field_71068_ca % 5 == 0 && (float)this.field_82249_h < (float)this.field_70173_aa - 100.0f) {
            float f = this.field_71068_ca > 30 ? 1.0f : (float)this.field_71068_ca / 30.0f;
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187802_ec, this.func_184176_by(), f * 0.75f, 1.0f);
            this.field_82249_h = this.field_70173_aa;
        }
    }

    public int func_71050_bK() {
        if (this.field_71068_ca >= 30) {
            return 112 + (this.field_71068_ca - 30) * 9;
        }
        if (this.field_71068_ca >= 15) {
            return 37 + (this.field_71068_ca - 15) * 5;
        }
        return 7 + this.field_71068_ca * 2;
    }

    public void func_71020_j(float f) {
        if (this.field_71075_bZ.field_75102_a) {
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_71100_bB.func_75113_a(f);
        }
    }

    public FoodStats func_71024_bL() {
        return this.field_71100_bB;
    }

    public boolean func_71043_e(boolean bl) {
        return this.field_71075_bZ.field_75102_a || bl || this.field_71100_bB.func_75121_c();
    }

    public boolean func_70996_bM() {
        return this.func_110143_aJ() > 0.0f && this.func_110143_aJ() < this.func_110138_aP();
    }

    public boolean func_175142_cm() {
        return this.field_71075_bZ.field_75099_e;
    }

    public boolean func_175151_a(BlockPos blockPos, Direction direction, ItemStack itemStack) {
        if (this.field_71075_bZ.field_75099_e) {
            return true;
        }
        BlockPos blockPos2 = blockPos.func_177972_a(direction.func_176734_d());
        CachedBlockInfo \u26032 = new CachedBlockInfo(this.field_70170_p, blockPos2, false);
        return itemStack.func_206847_b(this.field_70170_p.func_205772_D(), \u26032);
    }

    @Override
    protected int func_70693_a(PlayerEntity playerEntity) {
        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c) || this.func_175149_v()) {
            return 0;
        }
        int n = this.field_71068_ca * 7;
        if (n > 100) {
            return 100;
        }
        return n;
    }

    @Override
    protected boolean func_70684_aJ() {
        return true;
    }

    @Override
    protected boolean func_225502_at_() {
        return !this.field_71075_bZ.field_75100_b && (!this.field_70122_E || !this.func_226273_bm_());
    }

    public void func_71016_p() {
    }

    public void func_71033_a(GameType gameType) {
    }

    @Override
    public ITextComponent func_200200_C_() {
        return new StringTextComponent(this.field_146106_i.getName());
    }

    public EnderChestInventory func_71005_bN() {
        return this.field_71078_a;
    }

    @Override
    public ItemStack func_184582_a(EquipmentSlotType equipmentSlotType) {
        if (equipmentSlotType == EquipmentSlotType.MAINHAND) {
            return this.field_71071_by.func_70448_g();
        }
        if (equipmentSlotType == EquipmentSlotType.OFFHAND) {
            return this.field_71071_by.field_184439_c.get(0);
        }
        if (equipmentSlotType.func_188453_a() == EquipmentSlotType.Group.ARMOR) {
            return this.field_71071_by.field_70460_b.get(equipmentSlotType.func_188454_b());
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void func_184201_a(EquipmentSlotType equipmentSlotType, ItemStack itemStack) {
        if (equipmentSlotType == EquipmentSlotType.MAINHAND) {
            this.func_184606_a_(itemStack);
            this.field_71071_by.field_70462_a.set(this.field_71071_by.field_70461_c, itemStack);
        } else if (equipmentSlotType == EquipmentSlotType.OFFHAND) {
            this.func_184606_a_(itemStack);
            this.field_71071_by.field_184439_c.set(0, itemStack);
        } else if (equipmentSlotType.func_188453_a() == EquipmentSlotType.Group.ARMOR) {
            this.func_184606_a_(itemStack);
            this.field_71071_by.field_70460_b.set(equipmentSlotType.func_188454_b(), itemStack);
        }
    }

    public boolean func_191521_c(ItemStack itemStack) {
        this.func_184606_a_(itemStack);
        return this.field_71071_by.func_70441_a(itemStack);
    }

    @Override
    public Iterable<ItemStack> func_184214_aD() {
        return Lists.newArrayList((Object[])new ItemStack[]{this.func_184614_ca(), this.func_184592_cb()});
    }

    @Override
    public Iterable<ItemStack> func_184193_aE() {
        return this.field_71071_by.field_70460_b;
    }

    public boolean func_192027_g(CompoundNBT compoundNBT) {
        if (this.func_184218_aH() || !this.field_70122_E || this.func_70090_H()) {
            return false;
        }
        if (this.func_192023_dk().isEmpty()) {
            this.func_192029_h(compoundNBT);
            this.field_223730_e = this.field_70170_p.func_82737_E();
            return true;
        }
        if (this.func_192025_dl().isEmpty()) {
            this.func_192031_i(compoundNBT);
            this.field_223730_e = this.field_70170_p.func_82737_E();
            return true;
        }
        return false;
    }

    protected void func_192030_dh() {
        if (this.field_223730_e + 20L < this.field_70170_p.func_82737_E()) {
            this.func_192026_k(this.func_192023_dk());
            this.func_192029_h(new CompoundNBT());
            this.func_192026_k(this.func_192025_dl());
            this.func_192031_i(new CompoundNBT());
        }
    }

    private void func_192026_k(CompoundNBT compoundNBT) {
        if (!this.field_70170_p.field_72995_K && !compoundNBT.isEmpty()) {
            EntityType.func_220330_a(compoundNBT, this.field_70170_p).ifPresent(entity -> {
                if (entity instanceof TameableEntity) {
                    ((TameableEntity)entity).func_184754_b(this.field_96093_i);
                }
                entity.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + (double)0.7f, this.func_226281_cx_());
                ((ServerWorld)this.field_70170_p).func_217470_d((Entity)entity);
            });
        }
    }

    @Override
    public abstract boolean func_175149_v();

    @Override
    public boolean func_203007_ba() {
        return !this.field_71075_bZ.field_75100_b && !this.func_175149_v() && super.func_203007_ba();
    }

    public abstract boolean func_184812_l_();

    @Override
    public boolean func_96092_aw() {
        return !this.field_71075_bZ.field_75100_b;
    }

    public Scoreboard func_96123_co() {
        return this.field_70170_p.func_96441_U();
    }

    @Override
    public ITextComponent func_145748_c_() {
        ITextComponent iTextComponent = ScorePlayerTeam.func_200541_a(this.func_96124_cp(), this.func_200200_C_());
        return this.func_208016_c(iTextComponent);
    }

    public ITextComponent func_208017_dF() {
        return new StringTextComponent("").func_150257_a(this.func_200200_C_()).func_150258_a(" (").func_150258_a(this.field_146106_i.getId().toString()).func_150258_a(")");
    }

    private ITextComponent func_208016_c(ITextComponent iTextComponent) {
        String string = this.func_146103_bH().getName();
        return iTextComponent.func_211710_a(style -> style.func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tell " + string + " ")).func_150209_a(this.func_174823_aP()).func_179989_a(string));
    }

    @Override
    public String func_195047_I_() {
        return this.func_146103_bH().getName();
    }

    @Override
    public float func_213348_b(Pose pose, EntitySize entitySize) {
        switch (pose) {
            case SWIMMING: 
            case FALL_FLYING: 
            case SPIN_ATTACK: {
                return 0.4f;
            }
            case CROUCHING: {
                return 1.27f;
            }
        }
        return 1.62f;
    }

    @Override
    public void func_110149_m(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        this.func_184212_Q().func_187227_b(field_184829_a, Float.valueOf(f));
    }

    @Override
    public float func_110139_bj() {
        return this.func_184212_Q().func_187225_a(field_184829_a).floatValue();
    }

    public static UUID func_146094_a(GameProfile gameProfile) {
        UUID uUID = gameProfile.getId();
        if (uUID == null) {
            uUID = PlayerEntity.func_175147_b(gameProfile.getName());
        }
        return uUID;
    }

    public static UUID func_175147_b(String string) {
        return UUID.nameUUIDFromBytes(("OfflinePlayer:" + string).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean func_174820_d(int n, ItemStack itemStack) {
        if (n >= 0 && n < this.field_71071_by.field_70462_a.size()) {
            this.field_71071_by.func_70299_a(n, itemStack);
            return true;
        }
        EquipmentSlotType equipmentSlotType = n == 100 + EquipmentSlotType.HEAD.func_188454_b() ? EquipmentSlotType.HEAD : (n == 100 + EquipmentSlotType.CHEST.func_188454_b() ? EquipmentSlotType.CHEST : (n == 100 + EquipmentSlotType.LEGS.func_188454_b() ? EquipmentSlotType.LEGS : (n == 100 + EquipmentSlotType.FEET.func_188454_b() ? EquipmentSlotType.FEET : null)));
        if (n == 98) {
            this.func_184201_a(EquipmentSlotType.MAINHAND, itemStack);
            return true;
        }
        if (n == 99) {
            this.func_184201_a(EquipmentSlotType.OFFHAND, itemStack);
            return true;
        }
        if (equipmentSlotType != null) {
            if (!itemStack.func_190926_b() && (itemStack.func_77973_b() instanceof ArmorItem || itemStack.func_77973_b() instanceof ElytraItem ? MobEntity.func_184640_d(itemStack) != equipmentSlotType : equipmentSlotType != EquipmentSlotType.HEAD)) {
                return false;
            }
            this.field_71071_by.func_70299_a(equipmentSlotType.func_188454_b() + this.field_71071_by.field_70462_a.size(), itemStack);
            return true;
        }
        int \u26032 = n - 200;
        if (\u26032 >= 0 && \u26032 < this.field_71078_a.func_70302_i_()) {
            this.field_71078_a.func_70299_a(\u26032, itemStack);
            return true;
        }
        return false;
    }

    @Override
    public HandSide func_184591_cq() {
        return this.field_70180_af.func_187225_a(field_184828_bq) == 0 ? HandSide.LEFT : HandSide.RIGHT;
    }

    public void func_184819_a(HandSide handSide) {
        this.field_70180_af.func_187227_b(field_184828_bq, (byte)(handSide != HandSide.LEFT ? 1 : 0));
    }

    public CompoundNBT func_192023_dk() {
        return this.field_70180_af.func_187225_a(field_192032_bt);
    }

    protected void func_192029_h(CompoundNBT compoundNBT) {
        this.field_70180_af.func_187227_b(field_192032_bt, compoundNBT);
    }

    public CompoundNBT func_192025_dl() {
        return this.field_70180_af.func_187225_a(field_192033_bu);
    }

    protected void func_192031_i(CompoundNBT compoundNBT) {
        this.field_70180_af.func_187227_b(field_192033_bu, compoundNBT);
    }

    public float func_184818_cX() {
        return (float)(1.0 / this.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111126_e() * 20.0);
    }

    public float func_184825_o(float f) {
        return MathHelper.func_76131_a(((float)this.field_184617_aD + f) / this.func_184818_cX(), 0.0f, 1.0f);
    }

    public void func_184821_cY() {
        this.field_184617_aD = 0;
    }

    public CooldownTracker func_184811_cZ() {
        return this.field_184832_bU;
    }

    @Override
    protected float func_225515_ai_() {
        return this.field_71075_bZ.field_75100_b || this.func_184613_cA() ? 1.0f : super.func_225515_ai_();
    }

    public float func_184817_da() {
        return (float)this.func_110148_a(SharedMonsterAttributes.field_188792_h).func_111126_e();
    }

    public boolean func_195070_dx() {
        return this.field_71075_bZ.field_75098_d && this.func_184840_I() >= 2;
    }

    @Override
    public boolean func_213365_e(ItemStack itemStack) {
        EquipmentSlotType equipmentSlotType = MobEntity.func_184640_d(itemStack);
        return this.func_184582_a(equipmentSlotType).func_190926_b();
    }

    @Override
    public EntitySize func_213305_a(Pose pose) {
        return field_213836_b.getOrDefault((Object)pose, field_213835_bs);
    }

    @Override
    public ItemStack func_213356_f(ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof ShootableItem)) {
            return ItemStack.field_190927_a;
        }
        Predicate<ItemStack> predicate = ((ShootableItem)itemStack.func_77973_b()).func_220006_d();
        ItemStack \u26032 = ShootableItem.func_220005_a(this, predicate);
        if (!\u26032.func_190926_b()) {
            return \u26032;
        }
        predicate = ((ShootableItem)itemStack.func_77973_b()).func_220004_b();
        for (int i = 0; i < this.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemStack2 = this.field_71071_by.func_70301_a(i);
            if (!predicate.test(itemStack2)) continue;
            return itemStack2;
        }
        return this.field_71075_bZ.field_75098_d ? new ItemStack(Items.field_151032_g) : ItemStack.field_190927_a;
    }

    @Override
    public ItemStack func_213357_a(World world, ItemStack itemStack) {
        this.func_71024_bL().func_221410_a(itemStack.func_77973_b(), itemStack);
        this.func_71029_a(Stats.field_75929_E.func_199076_b(itemStack.func_77973_b()));
        world.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
        if (this instanceof ServerPlayerEntity) {
            CriteriaTriggers.field_193138_y.func_193148_a((ServerPlayerEntity)this, itemStack);
        }
        return super.func_213357_a(world, itemStack);
    }

    public static enum SleepResult {
        NOT_POSSIBLE_HERE,
        NOT_POSSIBLE_NOW(new TranslationTextComponent("block.minecraft.bed.no_sleep", new Object[0])),
        TOO_FAR_AWAY(new TranslationTextComponent("block.minecraft.bed.too_far_away", new Object[0])),
        OBSTRUCTED(new TranslationTextComponent("block.minecraft.bed.obstructed", new Object[0])),
        OTHER_PROBLEM,
        NOT_SAFE(new TranslationTextComponent("block.minecraft.bed.not_safe", new Object[0]));

        @Nullable
        private final ITextComponent field_221260_g;

        private SleepResult() {
            this.field_221260_g = null;
        }

        private SleepResult(ITextComponent iTextComponent) {
            this.field_221260_g = iTextComponent;
        }

        @Nullable
        public ITextComponent func_221259_a() {
            return this.field_221260_g;
        }
    }
}

