/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.brigadier.arguments.StringArgumentType;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.PackCompatibility;
import net.minecraft.resources.data.PackMetadataSection;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.HoverEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourcePackInfo
implements AutoCloseable {
    private static final Logger field_195799_a = LogManager.getLogger();
    private static final PackMetadataSection field_212500_b = new PackMetadataSection(new TranslationTextComponent("resourcePack.broken_assets", new Object[0]).func_211709_a(TextFormatting.RED, TextFormatting.ITALIC), SharedConstants.func_215069_a().getPackVersion());
    private final String field_195800_b;
    private final Supplier<IResourcePack> field_195801_c;
    private final ITextComponent field_195802_d;
    private final ITextComponent field_195803_e;
    private final PackCompatibility field_195804_f;
    private final Priority field_195805_g;
    private final boolean field_195806_h;
    private final boolean field_195807_i;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static <T extends ResourcePackInfo> T func_195793_a(String string, boolean bl, Supplier<IResourcePack> supplier, IFactory<T> iFactory, Priority priority) {
        try (IResourcePack iResourcePack = supplier.get();){
            PackMetadataSection packMetadataSection = iResourcePack.func_195760_a(PackMetadataSection.field_198964_a);
            if (bl && packMetadataSection == null) {
                field_195799_a.error("Broken/missing pack.mcmeta detected, fudging it into existance. Please check that your launcher has downloaded all assets for the game correctly!");
                packMetadataSection = field_212500_b;
            }
            if (packMetadataSection != null) {
                T t = iFactory.create(string, bl, supplier, iResourcePack, packMetadataSection, priority);
                return t;
            }
            field_195799_a.warn("Couldn't find pack meta for pack {}", (Object)string);
            return null;
        }
        catch (IOException iOException) {
            field_195799_a.warn("Couldn't get pack info for: {}", (Object)iOException.toString());
        }
        return null;
    }

    public ResourcePackInfo(String string, boolean bl, Supplier<IResourcePack> supplier, ITextComponent iTextComponent, ITextComponent iTextComponent2, PackCompatibility packCompatibility, Priority priority, boolean bl2) {
        this.field_195800_b = string;
        this.field_195801_c = supplier;
        this.field_195802_d = iTextComponent;
        this.field_195803_e = iTextComponent2;
        this.field_195804_f = packCompatibility;
        this.field_195806_h = bl;
        this.field_195805_g = priority;
        this.field_195807_i = bl2;
    }

    public ResourcePackInfo(String string, boolean bl, Supplier<IResourcePack> supplier, IResourcePack iResourcePack, PackMetadataSection packMetadataSection, Priority priority) {
        this(string, bl, supplier, new StringTextComponent(iResourcePack.func_195762_a()), packMetadataSection.func_198963_a(), PackCompatibility.func_198969_a(packMetadataSection.func_198962_b()), priority, false);
    }

    public ITextComponent func_195794_a(boolean bl) {
        return TextComponentUtils.func_197676_a(new StringTextComponent(this.field_195800_b)).func_211710_a(style -> style.func_150238_a(bl ? TextFormatting.GREEN : TextFormatting.RED).func_179989_a(StringArgumentType.escapeIfRequired((String)this.field_195800_b)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new StringTextComponent("").func_150257_a(this.field_195802_d).func_150258_a("\n").func_150257_a(this.field_195803_e))));
    }

    public PackCompatibility func_195791_d() {
        return this.field_195804_f;
    }

    public IResourcePack func_195796_e() {
        return this.field_195801_c.get();
    }

    public String func_195790_f() {
        return this.field_195800_b;
    }

    public boolean func_195797_g() {
        return this.field_195806_h;
    }

    public boolean func_195798_h() {
        return this.field_195807_i;
    }

    public Priority func_195792_i() {
        return this.field_195805_g;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ResourcePackInfo)) {
            return false;
        }
        ResourcePackInfo resourcePackInfo = (ResourcePackInfo)object;
        return this.field_195800_b.equals(resourcePackInfo.field_195800_b);
    }

    public int hashCode() {
        return this.field_195800_b.hashCode();
    }

    @Override
    public void close() {
    }

    public static enum Priority {
        TOP,
        BOTTOM;


        public <T, P extends ResourcePackInfo> int func_198993_a(List<T> list2, T t, Function<T, P> function, boolean bl) {
            List<T> list2;
            Priority priority = \u2603 = bl ? this.func_198992_a() : this;
            if (\u2603 == BOTTOM) {
                for (int i = 0; i < list2.size() && (\u2603 = (ResourcePackInfo)function.apply(list2.get(i))).func_195798_h() && \u2603.func_195792_i() == this; ++i) {
                }
                list2.add(i, t);
                return i;
            }
            for (int i = list2.size() - 1; i >= 0 && (\u2603 = (ResourcePackInfo)function.apply(list2.get(i))).func_195798_h() && \u2603.func_195792_i() == this; --i) {
            }
            list2.add(i + 1, t);
            return i + 1;
        }

        public Priority func_198992_a() {
            return this == TOP ? BOTTOM : TOP;
        }
    }

    @FunctionalInterface
    public static interface IFactory<T extends ResourcePackInfo> {
        @Nullable
        public T create(String var1, boolean var2, Supplier<IResourcePack> var3, IResourcePack var4, PackMetadataSection var5, Priority var6);
    }
}

