/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.state;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.state.IProperty;
import net.minecraft.state.IStateHolder;
import net.minecraft.state.StateHolder;
import net.minecraft.util.MapPopulator;

public class StateContainer<O, S extends IStateHolder<S>> {
    private static final Pattern field_185921_a = Pattern.compile("^[a-z0-9_]+$");
    private final O field_177627_c;
    private final ImmutableSortedMap<String, IProperty<?>> field_177624_d;
    private final ImmutableList<S> field_177625_e;

    protected <A extends StateHolder<O, S>> StateContainer(O o, IFactory<O, S, A> iFactory2, Map<String, IProperty<?>> map) {
        IFactory iFactory2;
        this.field_177627_c = o;
        this.field_177624_d = ImmutableSortedMap.copyOf(map);
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        ArrayList \u26032 = Lists.newArrayList();
        Stream<List<List<Object>>> \u26033 = Stream.of(Collections.emptyList());
        for (Object object : this.field_177624_d.values()) {
            \u26033 = \u26033.flatMap(arg_0 -> StateContainer.func_200999_a((IProperty)object, arg_0));
        }
        \u26033.forEach(list2 -> {
            Map map2 = MapPopulator.func_179400_b(this.field_177624_d.values(), list2);
            Object \u26032 = iFactory2.create(o, ImmutableMap.copyOf(map2));
            linkedHashMap.put(map2, \u26032);
            \u26032.add(\u26032);
        });
        for (Object object : \u26032) {
            ((StateHolder)object).func_206874_a(linkedHashMap);
        }
        this.field_177625_e = ImmutableList.copyOf((Iterable)\u26032);
    }

    public ImmutableList<S> func_177619_a() {
        return this.field_177625_e;
    }

    public S func_177621_b() {
        return (S)((IStateHolder)this.field_177625_e.get(0));
    }

    public O func_177622_c() {
        return this.field_177627_c;
    }

    public Collection<IProperty<?>> func_177623_d() {
        return this.field_177624_d.values();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("block", this.field_177627_c).add("properties", this.field_177624_d.values().stream().map(IProperty::func_177701_a).collect(Collectors.toList())).toString();
    }

    @Nullable
    public IProperty<?> func_185920_a(String string) {
        return (IProperty)this.field_177624_d.get((Object)string);
    }

    private static /* synthetic */ Stream func_200999_a(IProperty iProperty, List list) {
        return iProperty.func_177700_c().stream().map(comparable -> {
            ArrayList arrayList = Lists.newArrayList((Iterable)list);
            arrayList.add(comparable);
            return arrayList;
        });
    }

    public static class Builder<O, S extends IStateHolder<S>> {
        private final O field_206895_a;
        private final Map<String, IProperty<?>> field_206896_b = Maps.newHashMap();

        public Builder(O o) {
            this.field_206895_a = o;
        }

        public Builder<O, S> func_206894_a(IProperty<?> ... iPropertyArray) {
            for (IProperty<?> iProperty : iPropertyArray) {
                this.func_206892_a(iProperty);
                this.field_206896_b.put(iProperty.func_177701_a(), iProperty);
            }
            return this;
        }

        private <T extends Comparable<T>> void func_206892_a(IProperty<T> iProperty) {
            String string = iProperty.func_177701_a();
            if (!field_185921_a.matcher(string).matches()) {
                throw new IllegalArgumentException(this.field_206895_a + " has invalidly named property: " + string);
            }
            Collection<T> \u26032 = iProperty.func_177700_c();
            if (\u26032.size() <= 1) {
                throw new IllegalArgumentException(this.field_206895_a + " attempted use property " + string + " with <= 1 possible values");
            }
            for (Comparable comparable : \u26032) {
                String string2 = iProperty.func_177702_a(comparable);
                if (field_185921_a.matcher(string2).matches()) continue;
                throw new IllegalArgumentException(this.field_206895_a + " has property: " + string + " with invalidly named value: " + string2);
            }
            if (this.field_206896_b.containsKey(string)) {
                throw new IllegalArgumentException(this.field_206895_a + " has duplicate property: " + string);
            }
        }

        public <A extends StateHolder<O, S>> StateContainer<O, S> func_206893_a(IFactory<O, S, A> iFactory) {
            return new StateContainer<O, S>(this.field_206895_a, iFactory, this.field_206896_b);
        }
    }

    public static interface IFactory<O, S extends IStateHolder<S>, A extends StateHolder<O, S>> {
        public A create(O var1, ImmutableMap<IProperty<?>, Comparable<?>> var2);
    }
}

