/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.text;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.ITargetedTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TranslationTextComponentFormatException;

public class TranslationTextComponent
extends TextComponent
implements ITargetedTextComponent {
    private static final LanguageMap field_200526_d = new LanguageMap();
    private static final LanguageMap field_200527_e = LanguageMap.func_74808_a();
    private final String field_150276_d;
    private final Object[] field_150277_e;
    private final Object field_150274_f = new Object();
    private long field_150275_g = -1L;
    protected final List<ITextComponent> field_150278_b = Lists.newArrayList();
    public static final Pattern field_150279_c = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");

    public TranslationTextComponent(String string, Object ... objectArray) {
        this.field_150276_d = string;
        this.field_150277_e = objectArray;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object instanceof ITextComponent) {
                ITextComponent iTextComponent = ((ITextComponent)object).func_212638_h();
                this.field_150277_e[i] = iTextComponent;
                iTextComponent.func_150256_b().func_150221_a(this.func_150256_b());
                continue;
            }
            if (object != null) continue;
            this.field_150277_e[i] = "null";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    synchronized void func_150270_g() {
        Object object = this.field_150274_f;
        synchronized (object) {
            long l = field_200527_e.func_150510_c();
            if (l == this.field_150275_g) {
                return;
            }
            this.field_150275_g = l;
            this.field_150278_b.clear();
        }
        String string = field_200527_e.func_74805_b(this.field_150276_d);
        try {
            this.func_150269_b(string);
        }
        catch (TranslationTextComponentFormatException \u26032) {
            this.field_150278_b.clear();
            this.field_150278_b.add(new StringTextComponent(string));
        }
    }

    protected void func_150269_b(String string) {
        Matcher matcher = field_150279_c.matcher(string);
        try {
            int n;
            int n2 = 0;
            n = 0;
            while (matcher.find(n)) {
                Object \u26034;
                Object \u26032;
                \u2603 = matcher.start();
                \u2603 = matcher.end();
                if (\u2603 > n) {
                    \u26032 = new StringTextComponent(String.format(string.substring(n, \u2603), new Object[0]));
                    \u26032.func_150256_b().func_150221_a(this.func_150256_b());
                    this.field_150278_b.add((ITextComponent)\u26032);
                }
                \u26032 = matcher.group(2);
                String \u26033 = string.substring(\u2603, \u2603);
                if ("%".equals(\u26032) && "%%".equals(\u26033)) {
                    \u26034 = new StringTextComponent("%");
                    \u26034.func_150256_b().func_150221_a(this.func_150256_b());
                    this.field_150278_b.add((ITextComponent)\u26034);
                } else if ("s".equals(\u26032)) {
                    \u26034 = matcher.group(1);
                    int n3 = \u2603 = \u26034 != null ? Integer.parseInt((String)\u26034) - 1 : n2++;
                    if (\u2603 < this.field_150277_e.length) {
                        this.field_150278_b.add(this.func_150272_a(\u2603));
                    }
                } else {
                    throw new TranslationTextComponentFormatException(this, "Unsupported format: '" + \u26033 + "'");
                }
                n = \u2603;
            }
            if (n < string.length()) {
                StringTextComponent stringTextComponent = new StringTextComponent(String.format(string.substring(n), new Object[0]));
                stringTextComponent.func_150256_b().func_150221_a(this.func_150256_b());
                this.field_150278_b.add(stringTextComponent);
            }
        }
        catch (IllegalFormatException illegalFormatException) {
            throw new TranslationTextComponentFormatException(this, (Throwable)illegalFormatException);
        }
    }

    private ITextComponent func_150272_a(int n) {
        ITextComponent \u26032;
        if (n >= this.field_150277_e.length) {
            throw new TranslationTextComponentFormatException(this, n);
        }
        Object object = this.field_150277_e[n];
        if (object instanceof ITextComponent) {
            \u26032 = (ITextComponent)object;
        } else {
            \u26032 = new StringTextComponent(object == null ? "null" : object.toString());
            \u26032.func_150256_b().func_150221_a(this.func_150256_b());
        }
        return \u26032;
    }

    @Override
    public ITextComponent func_150255_a(Style style) {
        super.func_150255_a(style);
        for (Object object : this.field_150277_e) {
            if (!(object instanceof ITextComponent)) continue;
            ((ITextComponent)object).func_150256_b().func_150221_a(this.func_150256_b());
        }
        if (this.field_150275_g > -1L) {
            for (ITextComponent iTextComponent : this.field_150278_b) {
                iTextComponent.func_150256_b().func_150221_a(style);
            }
        }
        return this;
    }

    @Override
    public Stream<ITextComponent> func_212640_c() {
        this.func_150270_g();
        return Streams.concat((Stream[])new Stream[]{this.field_150278_b.stream(), this.field_150264_a.stream()}).flatMap(ITextComponent::func_212640_c);
    }

    @Override
    public String func_150261_e() {
        this.func_150270_g();
        StringBuilder stringBuilder = new StringBuilder();
        for (ITextComponent iTextComponent : this.field_150278_b) {
            stringBuilder.append(iTextComponent.func_150261_e());
        }
        return stringBuilder.toString();
    }

    @Override
    public TranslationTextComponent func_150259_f() {
        Object[] objectArray = new Object[this.field_150277_e.length];
        for (int i = 0; i < this.field_150277_e.length; ++i) {
            objectArray[i] = this.field_150277_e[i] instanceof ITextComponent ? ((ITextComponent)this.field_150277_e[i]).func_212638_h() : this.field_150277_e[i];
        }
        return new TranslationTextComponent(this.field_150276_d, objectArray);
    }

    @Override
    public ITextComponent func_197668_a(@Nullable CommandSource commandSource, @Nullable Entity entity, int n) throws CommandSyntaxException {
        Object[] objectArray = new Object[this.field_150277_e.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = this.field_150277_e[i];
            objectArray[i] = object instanceof ITextComponent ? TextComponentUtils.func_197680_a(commandSource, (ITextComponent)object, entity, n) : object;
        }
        return new TranslationTextComponent(this.field_150276_d, objectArray);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TranslationTextComponent) {
            TranslationTextComponent translationTextComponent = (TranslationTextComponent)object;
            return Arrays.equals(this.field_150277_e, translationTextComponent.field_150277_e) && this.field_150276_d.equals(translationTextComponent.field_150276_d) && super.equals(object);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + this.field_150276_d.hashCode();
        n = 31 * n + Arrays.hashCode(this.field_150277_e);
        return n;
    }

    @Override
    public String toString() {
        return "TranslatableComponent{key='" + this.field_150276_d + '\'' + ", args=" + Arrays.toString(this.field_150277_e) + ", siblings=" + this.field_150264_a + ", style=" + this.func_150256_b() + '}';
    }

    public String func_150268_i() {
        return this.field_150276_d;
    }

    public Object[] func_150271_j() {
        return this.field_150277_e;
    }

    @Override
    public /* synthetic */ ITextComponent func_150259_f() {
        return this.func_150259_f();
    }
}

