/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.ServerWorldLightManager;

public class ChunkStatus {
    private static final EnumSet<Heightmap.Type> field_222618_n = EnumSet.of(Heightmap.Type.OCEAN_FLOOR_WG, Heightmap.Type.WORLD_SURFACE_WG);
    private static final EnumSet<Heightmap.Type> field_222619_o = EnumSet.of(Heightmap.Type.OCEAN_FLOOR, Heightmap.Type.WORLD_SURFACE, Heightmap.Type.MOTION_BLOCKING, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
    private static final ILoadingWorker field_223211_p = (chunkStatus, serverWorld, templateManager, serverWorldLightManager, function, iChunk) -> {
        if (iChunk instanceof ChunkPrimer && !iChunk.func_201589_g().func_209003_a(chunkStatus)) {
            ((ChunkPrimer)iChunk).func_201574_a(chunkStatus);
        }
        return CompletableFuture.completedFuture(Either.left((Object)iChunk));
    };
    public static final ChunkStatus field_223226_a_ = ChunkStatus.func_223203_a("empty", null, -1, field_222618_n, Type.PROTOCHUNK, (serverWorld, chunkGenerator, list, iChunk) -> {});
    public static final ChunkStatus field_222606_b = ChunkStatus.func_223207_a("structure_starts", field_223226_a_, 0, field_222618_n, Type.PROTOCHUNK, (chunkStatus, serverWorld, chunkGenerator, templateManager, serverWorldLightManager, function, list, iChunk) -> {
        if (!iChunk.func_201589_g().func_209003_a(chunkStatus)) {
            if (serverWorld.func_72912_H().func_76089_r()) {
                chunkGenerator.func_227058_a_(serverWorld.func_225523_d_().func_226835_a_(chunkGenerator.func_202090_b()), iChunk, chunkGenerator, templateManager);
            }
            if (iChunk instanceof ChunkPrimer) {
                ((ChunkPrimer)iChunk).func_201574_a(chunkStatus);
            }
        }
        return CompletableFuture.completedFuture(Either.left((Object)iChunk));
    });
    public static final ChunkStatus field_222607_c = ChunkStatus.func_223203_a("structure_references", field_222606_b, 8, field_222618_n, Type.PROTOCHUNK, (serverWorld, chunkGenerator, list, iChunk) -> chunkGenerator.func_222528_a(new WorldGenRegion(serverWorld, list), iChunk));
    public static final ChunkStatus field_222608_d = ChunkStatus.func_223203_a("biomes", field_222607_c, 0, field_222618_n, Type.PROTOCHUNK, (serverWorld, chunkGenerator, list, iChunk) -> chunkGenerator.func_222539_a(iChunk));
    public static final ChunkStatus field_222609_e = ChunkStatus.func_223203_a("noise", field_222608_d, 8, field_222618_n, Type.PROTOCHUNK, (serverWorld, chunkGenerator, list, iChunk) -> chunkGenerator.func_222537_b(new WorldGenRegion(serverWorld, list), iChunk));
    public static final ChunkStatus field_222610_f = ChunkStatus.func_223203_a("surface", field_222609_e, 0, field_222618_n, Type.PROTOCHUNK, (serverWorld, chunkGenerator, list, iChunk) -> chunkGenerator.func_225551_a_(new WorldGenRegion(serverWorld, list), iChunk));
    public static final ChunkStatus field_222611_g = ChunkStatus.func_223203_a("carvers", field_222610_f, 0, field_222618_n, Type.PROTOCHUNK, (serverWorld, chunkGenerator, list, iChunk) -> chunkGenerator.func_225550_a_(serverWorld.func_225523_d_().func_226835_a_(chunkGenerator.func_202090_b()), iChunk, GenerationStage.Carving.AIR));
    public static final ChunkStatus field_222612_h = ChunkStatus.func_223203_a("liquid_carvers", field_222611_g, 0, field_222619_o, Type.PROTOCHUNK, (serverWorld, chunkGenerator, list, iChunk) -> chunkGenerator.func_225550_a_(serverWorld.func_225523_d_().func_226835_a_(chunkGenerator.func_202090_b()), iChunk, GenerationStage.Carving.LIQUID));
    public static final ChunkStatus field_222613_i = ChunkStatus.func_223207_a("features", field_222612_h, 8, field_222619_o, Type.PROTOCHUNK, (chunkStatus, serverWorld, chunkGenerator, templateManager, serverWorldLightManager, function, list, iChunk) -> {
        ChunkPrimer chunkPrimer = (ChunkPrimer)iChunk;
        chunkPrimer.func_217306_a(serverWorldLightManager);
        if (!iChunk.func_201589_g().func_209003_a(chunkStatus)) {
            Heightmap.func_222690_a(iChunk, EnumSet.of(Heightmap.Type.MOTION_BLOCKING, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, Heightmap.Type.OCEAN_FLOOR, Heightmap.Type.WORLD_SURFACE));
            chunkGenerator.func_202092_b(new WorldGenRegion(serverWorld, list));
            chunkPrimer.func_201574_a(chunkStatus);
        }
        return CompletableFuture.completedFuture(Either.left((Object)iChunk));
    });
    public static final ChunkStatus field_222614_j = ChunkStatus.func_223196_a("light", field_222613_i, 1, field_222619_o, Type.PROTOCHUNK, (chunkStatus, serverWorld, chunkGenerator, templateManager, serverWorldLightManager, function, list, iChunk) -> ChunkStatus.func_223206_a(chunkStatus, serverWorldLightManager, iChunk), (chunkStatus, serverWorld, templateManager, serverWorldLightManager, function, iChunk) -> ChunkStatus.func_223206_a(chunkStatus, serverWorldLightManager, iChunk));
    public static final ChunkStatus field_222615_k = ChunkStatus.func_223203_a("spawn", field_222614_j, 0, field_222619_o, Type.PROTOCHUNK, (serverWorld, chunkGenerator, list, iChunk) -> chunkGenerator.func_202093_c(new WorldGenRegion(serverWorld, list)));
    public static final ChunkStatus field_222616_l = ChunkStatus.func_223203_a("heightmaps", field_222615_k, 0, field_222619_o, Type.PROTOCHUNK, (serverWorld, chunkGenerator, list, iChunk) -> {});
    public static final ChunkStatus field_222617_m = ChunkStatus.func_223196_a("full", field_222616_l, 0, field_222619_o, Type.LEVELCHUNK, (chunkStatus, serverWorld, chunkGenerator, templateManager, serverWorldLightManager, function, list, iChunk) -> (CompletableFuture)function.apply(iChunk), (chunkStatus, serverWorld, templateManager, serverWorldLightManager, function, iChunk) -> (CompletableFuture)function.apply(iChunk));
    private static final List<ChunkStatus> field_222620_p = ImmutableList.of((Object)field_222617_m, (Object)field_222613_i, (Object)field_222612_h, (Object)field_222606_b, (Object)field_222606_b, (Object)field_222606_b, (Object)field_222606_b, (Object)field_222606_b, (Object)field_222606_b, (Object)field_222606_b, (Object)field_222606_b);
    private static final IntList field_222621_q = (IntList)Util.func_200696_a(new IntArrayList(ChunkStatus.func_222582_a().size()), intArrayList -> {
        int n = 0;
        for (\u2603 = ChunkStatus.func_222582_a().size() - 1; \u2603 >= 0; --\u2603) {
            while (n + 1 < field_222620_p.size() && \u2603 <= field_222620_p.get(n + 1).func_222584_c()) {
                ++n;
            }
            intArrayList.add(0, n);
        }
    });
    private final String field_202130_j;
    private final int field_222623_s;
    private final ChunkStatus field_222624_t;
    private final IGenerationWorker field_223212_v;
    private final ILoadingWorker field_225500_w;
    private final int field_202133_m;
    private final Type field_202134_n;
    private final EnumSet<Heightmap.Type> field_222625_x;

    private static CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> func_223206_a(ChunkStatus chunkStatus, ServerWorldLightManager serverWorldLightManager, IChunk iChunk) {
        boolean bl = ChunkStatus.func_223197_a(chunkStatus, iChunk);
        if (!iChunk.func_201589_g().func_209003_a(chunkStatus)) {
            ((ChunkPrimer)iChunk).func_201574_a(chunkStatus);
        }
        return serverWorldLightManager.func_215593_a(iChunk, bl).thenApply(Either::left);
    }

    private static ChunkStatus func_223203_a(String string, @Nullable ChunkStatus chunkStatus, int n, EnumSet<Heightmap.Type> enumSet, Type type, ISelectiveWorker iSelectiveWorker) {
        return ChunkStatus.func_223207_a(string, chunkStatus, n, enumSet, type, iSelectiveWorker);
    }

    private static ChunkStatus func_223207_a(String string, @Nullable ChunkStatus chunkStatus, int n, EnumSet<Heightmap.Type> enumSet, Type type, IGenerationWorker iGenerationWorker) {
        return ChunkStatus.func_223196_a(string, chunkStatus, n, enumSet, type, iGenerationWorker, field_223211_p);
    }

    private static ChunkStatus func_223196_a(String string, @Nullable ChunkStatus chunkStatus, int n, EnumSet<Heightmap.Type> enumSet, Type type, IGenerationWorker iGenerationWorker, ILoadingWorker iLoadingWorker) {
        return Registry.func_218325_a(Registry.field_218360_A, string, new ChunkStatus(string, chunkStatus, n, enumSet, type, iGenerationWorker, iLoadingWorker));
    }

    public static List<ChunkStatus> func_222582_a() {
        ArrayList arrayList = Lists.newArrayList();
        for (ChunkStatus chunkStatus = field_222617_m; chunkStatus.func_222593_e() != chunkStatus; chunkStatus = chunkStatus.func_222593_e()) {
            arrayList.add(chunkStatus);
        }
        arrayList.add(chunkStatus);
        Collections.reverse(arrayList);
        return arrayList;
    }

    private static boolean func_223197_a(ChunkStatus chunkStatus, IChunk iChunk) {
        return iChunk.func_201589_g().func_209003_a(chunkStatus) && iChunk.func_217310_r();
    }

    public static ChunkStatus func_222581_a(int n) {
        if (n >= field_222620_p.size()) {
            return field_223226_a_;
        }
        if (n < 0) {
            return field_222617_m;
        }
        return field_222620_p.get(n);
    }

    public static int func_222600_b() {
        return field_222620_p.size();
    }

    public static int func_222599_a(ChunkStatus chunkStatus) {
        return field_222621_q.getInt(chunkStatus.func_222584_c());
    }

    ChunkStatus(String string, @Nullable ChunkStatus chunkStatus, int n, EnumSet<Heightmap.Type> enumSet, Type type, IGenerationWorker iGenerationWorker, ILoadingWorker iLoadingWorker) {
        this.field_202130_j = string;
        this.field_222624_t = chunkStatus == null ? this : chunkStatus;
        this.field_223212_v = iGenerationWorker;
        this.field_225500_w = iLoadingWorker;
        this.field_202133_m = n;
        this.field_202134_n = type;
        this.field_222625_x = enumSet;
        this.field_222623_s = chunkStatus == null ? 0 : chunkStatus.func_222584_c() + 1;
    }

    public int func_222584_c() {
        return this.field_222623_s;
    }

    public String func_222596_d() {
        return this.field_202130_j;
    }

    public ChunkStatus func_222593_e() {
        return this.field_222624_t;
    }

    public CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> func_223198_a(ServerWorld serverWorld, ChunkGenerator<?> chunkGenerator, TemplateManager templateManager, ServerWorldLightManager serverWorldLightManager, Function<IChunk, CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>>> function, List<IChunk> list) {
        return this.field_223212_v.doWork(this, serverWorld, chunkGenerator, templateManager, serverWorldLightManager, function, list, list.get(list.size() / 2));
    }

    public CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> func_223201_a(ServerWorld serverWorld, TemplateManager templateManager, ServerWorldLightManager serverWorldLightManager, Function<IChunk, CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>>> function, IChunk iChunk) {
        return this.field_225500_w.doWork(this, serverWorld, templateManager, serverWorldLightManager, function, iChunk);
    }

    public int func_202128_c() {
        return this.field_202133_m;
    }

    public Type func_202129_d() {
        return this.field_202134_n;
    }

    public static ChunkStatus func_222591_a(String string) {
        return Registry.field_218360_A.func_82594_a(ResourceLocation.func_208304_a(string));
    }

    public EnumSet<Heightmap.Type> func_222595_h() {
        return this.field_222625_x;
    }

    public boolean func_209003_a(ChunkStatus chunkStatus) {
        return this.func_222584_c() >= chunkStatus.func_222584_c();
    }

    public String toString() {
        return Registry.field_218360_A.func_177774_c(this).toString();
    }

    public static enum Type {
        PROTOCHUNK,
        LEVELCHUNK;

    }

    static interface ISelectiveWorker
    extends IGenerationWorker {
        @Override
        default public CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> doWork(ChunkStatus chunkStatus, ServerWorld serverWorld, ChunkGenerator<?> chunkGenerator, TemplateManager templateManager, ServerWorldLightManager serverWorldLightManager, Function<IChunk, CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>>> function, List<IChunk> list, IChunk iChunk) {
            if (!iChunk.func_201589_g().func_209003_a(chunkStatus)) {
                this.doWork(serverWorld, chunkGenerator, list, iChunk);
                if (iChunk instanceof ChunkPrimer) {
                    ((ChunkPrimer)iChunk).func_201574_a(chunkStatus);
                }
            }
            return CompletableFuture.completedFuture(Either.left((Object)iChunk));
        }

        public void doWork(ServerWorld var1, ChunkGenerator<?> var2, List<IChunk> var3, IChunk var4);
    }

    static interface ILoadingWorker {
        public CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> doWork(ChunkStatus var1, ServerWorld var2, TemplateManager var3, ServerWorldLightManager var4, Function<IChunk, CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>>> var5, IChunk var6);
    }

    static interface IGenerationWorker {
        public CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> doWork(ChunkStatus var1, ServerWorld var2, ChunkGenerator<?> var3, TemplateManager var4, ServerWorldLightManager var5, Function<IChunk, CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>>> var6, List<IChunk> var7, IChunk var8);
    }
}

