/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.BigMushroomFeatureConfig;
import net.minecraft.world.gen.feature.Feature;

public abstract class AbstractBigMushroomFeature
extends Feature<BigMushroomFeatureConfig> {
    public AbstractBigMushroomFeature(Function<Dynamic<?>, ? extends BigMushroomFeatureConfig> function) {
        super(function);
    }

    protected void func_227210_a_(IWorld iWorld, Random random, BlockPos blockPos, BigMushroomFeatureConfig bigMushroomFeatureConfig, int n, BlockPos.Mutable mutable) {
        for (int i = 0; i < n; ++i) {
            mutable.func_189533_g(blockPos).func_189534_c(Direction.UP, i);
            if (iWorld.func_180495_p(mutable).func_200015_d(iWorld, mutable)) continue;
            this.func_202278_a(iWorld, mutable, bigMushroomFeatureConfig.field_227273_b_.func_225574_a_(random, blockPos));
        }
    }

    protected int func_227211_a_(Random random) {
        int n = random.nextInt(3) + 4;
        if (random.nextInt(12) == 0) {
            n *= 2;
        }
        return n;
    }

    protected boolean func_227209_a_(IWorld iWorld, BlockPos blockPos, int n, BlockPos.Mutable mutable, BigMushroomFeatureConfig bigMushroomFeatureConfig) {
        int n2 = blockPos.func_177956_o();
        if (n2 < 1 || n2 + n + 1 >= 256) {
            return false;
        }
        Block \u26032 = iWorld.func_180495_p(blockPos.func_177977_b()).func_177230_c();
        if (!AbstractBigMushroomFeature.func_227250_b_(\u26032)) {
            return false;
        }
        for (\u2603 = 0; \u2603 <= n; ++\u2603) {
            \u2603 = this.func_225563_a_(-1, -1, bigMushroomFeatureConfig.field_227274_c_, \u2603);
            for (\u2603 = -\u2603; \u2603 <= \u2603; ++\u2603) {
                for (\u2603 = -\u2603; \u2603 <= \u2603; ++\u2603) {
                    BlockState blockState = iWorld.func_180495_p(mutable.func_189533_g(blockPos).func_196234_d(\u2603, \u2603, \u2603));
                    if (blockState.func_196958_f() || blockState.func_203425_a(BlockTags.field_206952_E)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean func_212245_a(IWorld iWorld, ChunkGenerator<? extends GenerationSettings> chunkGenerator, Random random, BlockPos blockPos, BigMushroomFeatureConfig bigMushroomFeatureConfig) {
        int n = this.func_227211_a_(random);
        if (!this.func_227209_a_(iWorld, blockPos, n, \u2603 = new BlockPos.Mutable(), bigMushroomFeatureConfig)) {
            return false;
        }
        this.func_225564_a_(iWorld, random, blockPos, n, \u2603, bigMushroomFeatureConfig);
        this.func_227210_a_(iWorld, random, blockPos, bigMushroomFeatureConfig, n, \u2603);
        return true;
    }

    protected abstract int func_225563_a_(int var1, int var2, int var3, int var4);

    protected abstract void func_225564_a_(IWorld var1, Random var2, BlockPos var3, int var4, BlockPos.Mutable var5, BigMushroomFeatureConfig var6);
}

