/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import com.google.common.collect.Lists;
import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.LogBlock;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.TreeFeatureConfig;

public class FancyTreeFeature
extends AbstractTreeFeature<TreeFeatureConfig> {
    public FancyTreeFeature(Function<Dynamic<?>, ? extends TreeFeatureConfig> function) {
        super(function);
    }

    private void func_227233_a_(IWorldGenerationReader iWorldGenerationReader, Random random, BlockPos blockPos, float f, Set<BlockPos> set, MutableBoundingBox mutableBoundingBox, TreeFeatureConfig treeFeatureConfig) {
        int n = (int)((double)f + 0.618);
        for (\u2603 = -n; \u2603 <= n; ++\u2603) {
            for (\u2603 = -n; \u2603 <= n; ++\u2603) {
                if (!(Math.pow((double)Math.abs(\u2603) + 0.5, 2.0) + Math.pow((double)Math.abs(\u2603) + 0.5, 2.0) <= (double)(f * f))) continue;
                this.func_227219_b_(iWorldGenerationReader, random, blockPos.func_177982_a(\u2603, 0, \u2603), set, mutableBoundingBox, treeFeatureConfig);
            }
        }
    }

    private float func_227231_a_(int n, int n2) {
        if ((float)n2 < (float)n * 0.3f) {
            return -1.0f;
        }
        float f = (float)n / 2.0f;
        \u2603 = f - (float)n2;
        \u2603 = MathHelper.func_76129_c(f * f - \u2603 * \u2603);
        if (\u2603 == 0.0f) {
            \u2603 = f;
        } else if (Math.abs(\u2603) >= f) {
            return 0.0f;
        }
        return \u2603 * 0.5f;
    }

    private float func_227230_a_(int n) {
        if (n < 0 || n >= 5) {
            return -1.0f;
        }
        if (n == 0 || n == 4) {
            return 2.0f;
        }
        return 3.0f;
    }

    private void func_227236_a_(IWorldGenerationReader iWorldGenerationReader, Random random, BlockPos blockPos, Set<BlockPos> set, MutableBoundingBox mutableBoundingBox, TreeFeatureConfig treeFeatureConfig) {
        for (int i = 0; i < 5; ++i) {
            this.func_227233_a_(iWorldGenerationReader, random, blockPos.func_177981_b(i), this.func_227230_a_(i), set, mutableBoundingBox, treeFeatureConfig);
        }
    }

    private int func_227235_a_(IWorldGenerationReader iWorldGenerationReader, Random random, BlockPos blockPos, BlockPos blockPos2, boolean bl, Set<BlockPos> set, MutableBoundingBox mutableBoundingBox, TreeFeatureConfig treeFeatureConfig) {
        if (!bl && Objects.equals(blockPos, blockPos2)) {
            return -1;
        }
        BlockPos blockPos3 = blockPos2.func_177982_a(-blockPos.func_177958_n(), -blockPos.func_177956_o(), -blockPos.func_177952_p());
        int \u26032 = this.func_227237_a_(blockPos3);
        float \u26033 = (float)blockPos3.func_177958_n() / (float)\u26032;
        float \u26034 = (float)blockPos3.func_177956_o() / (float)\u26032;
        float \u26035 = (float)blockPos3.func_177952_p() / (float)\u26032;
        for (int i = 0; i <= \u26032; ++i) {
            BlockPos blockPos4 = blockPos.func_177963_a(0.5f + (float)i * \u26033, 0.5f + (float)i * \u26034, 0.5f + (float)i * \u26035);
            if (bl) {
                this.func_227217_a_(iWorldGenerationReader, blockPos4, (BlockState)treeFeatureConfig.field_227368_m_.func_225574_a_(random, blockPos4).func_206870_a(LogBlock.field_176298_M, this.func_227238_a_(blockPos, blockPos4)), mutableBoundingBox);
                set.add(blockPos4);
                continue;
            }
            if (FancyTreeFeature.func_214587_a(iWorldGenerationReader, blockPos4)) continue;
            return i;
        }
        return -1;
    }

    private int func_227237_a_(BlockPos blockPos) {
        int n = MathHelper.func_76130_a(blockPos.func_177958_n());
        \u2603 = MathHelper.func_76130_a(blockPos.func_177956_o());
        \u2603 = MathHelper.func_76130_a(blockPos.func_177952_p());
        if (\u2603 > n && \u2603 > \u2603) {
            return \u2603;
        }
        if (\u2603 > n) {
            return \u2603;
        }
        return n;
    }

    private Direction.Axis func_227238_a_(BlockPos blockPos, BlockPos blockPos2) {
        Direction.Axis axis = Direction.Axis.Y;
        int \u26032 = Math.abs(blockPos2.func_177958_n() - blockPos.func_177958_n());
        int \u26033 = Math.max(\u26032, \u2603 = Math.abs(blockPos2.func_177952_p() - blockPos.func_177952_p()));
        if (\u26033 > 0) {
            if (\u26032 == \u26033) {
                axis = Direction.Axis.X;
            } else if (\u2603 == \u26033) {
                axis = Direction.Axis.Z;
            }
        }
        return axis;
    }

    private void func_227232_a_(IWorldGenerationReader iWorldGenerationReader, Random random, int n, BlockPos blockPos, List<ExtendedPos> list, Set<BlockPos> set, MutableBoundingBox mutableBoundingBox, TreeFeatureConfig treeFeatureConfig) {
        for (ExtendedPos extendedPos : list) {
            if (!this.func_227239_b_(n, extendedPos.func_227243_r_() - blockPos.func_177956_o())) continue;
            this.func_227236_a_(iWorldGenerationReader, random, extendedPos, set, mutableBoundingBox, treeFeatureConfig);
        }
    }

    private boolean func_227239_b_(int n, int n2) {
        return (double)n2 >= (double)n * 0.2;
    }

    private void func_227234_a_(IWorldGenerationReader iWorldGenerationReader, Random random, BlockPos blockPos, int n, Set<BlockPos> set, MutableBoundingBox mutableBoundingBox, TreeFeatureConfig treeFeatureConfig) {
        this.func_227235_a_(iWorldGenerationReader, random, blockPos, blockPos.func_177981_b(n), true, set, mutableBoundingBox, treeFeatureConfig);
    }

    private void func_227240_b_(IWorldGenerationReader iWorldGenerationReader, Random random, int n, BlockPos blockPos, List<ExtendedPos> list, Set<BlockPos> set, MutableBoundingBox mutableBoundingBox, TreeFeatureConfig treeFeatureConfig) {
        for (ExtendedPos extendedPos : list) {
            int n2 = extendedPos.func_227243_r_();
            BlockPos \u26032 = new BlockPos(blockPos.func_177958_n(), n2, blockPos.func_177952_p());
            if (\u26032.equals(extendedPos) || !this.func_227239_b_(n, n2 - blockPos.func_177956_o())) continue;
            this.func_227235_a_(iWorldGenerationReader, random, \u26032, extendedPos, true, set, mutableBoundingBox, treeFeatureConfig);
        }
    }

    @Override
    public boolean func_225557_a_(IWorldGenerationReader iWorldGenerationReader, Random random, BlockPos blockPos, Set<BlockPos> set, Set<BlockPos> set2, MutableBoundingBox mutableBoundingBox, TreeFeatureConfig treeFeatureConfig) {
        Random random2 = new Random(random.nextLong());
        int \u26032 = this.func_227241_b_(iWorldGenerationReader, random, blockPos, 5 + random2.nextInt(12), set, mutableBoundingBox, treeFeatureConfig);
        if (\u26032 == -1) {
            return false;
        }
        this.func_214584_a(iWorldGenerationReader, blockPos.func_177977_b());
        int \u26033 = (int)((double)\u26032 * 0.618);
        if (\u26033 >= \u26032) {
            \u26033 = \u26032 - 1;
        }
        double \u26034 = 1.0;
        int \u26035 = (int)(1.382 + Math.pow(1.0 * (double)\u26032 / 13.0, 2.0));
        if (\u26035 < 1) {
            \u26035 = 1;
        }
        int \u26036 = blockPos.func_177956_o() + \u26033;
        ArrayList \u26037 = Lists.newArrayList();
        \u26037.add(new ExtendedPos(blockPos.func_177981_b(i), \u26036));
        for (int i = \u26032 - 5; i >= 0; --i) {
            float f = this.func_227231_a_(\u26032, i);
            if (f < 0.0f) continue;
            for (int j = 0; j < \u26035; ++j) {
                double d = 1.0;
                \u2603 = 1.0 * (double)f * ((double)random2.nextFloat() + 0.328);
                \u2603 = \u2603 * Math.sin(\u2603 = (double)(random2.nextFloat() * 2.0f) * Math.PI) + 0.5;
                BlockPos \u26038 = blockPos.func_177963_a(\u2603, i - 1, \u2603 = \u2603 * Math.cos(\u2603) + 0.5);
                if (this.func_227235_a_(iWorldGenerationReader, random, \u26038, \u2603 = \u26038.func_177981_b(5), false, set, mutableBoundingBox, treeFeatureConfig) != -1) continue;
                int \u26039 = blockPos.func_177958_n() - \u26038.func_177958_n();
                int \u260310 = blockPos.func_177952_p() - \u26038.func_177952_p();
                \u2603 = (double)\u26038.func_177956_o() - Math.sqrt(\u26039 * \u26039 + \u260310 * \u260310) * 0.381;
                int \u260311 = \u2603 > (double)\u26036 ? \u26036 : (int)\u2603;
                BlockPos \u260312 = new BlockPos(blockPos.func_177958_n(), \u260311, blockPos.func_177952_p());
                if (this.func_227235_a_(iWorldGenerationReader, random, \u260312, \u26038, false, set, mutableBoundingBox, treeFeatureConfig) != -1) continue;
                \u26037.add(new ExtendedPos(\u26038, \u260312.func_177956_o()));
            }
        }
        this.func_227232_a_(iWorldGenerationReader, random, \u26032, blockPos, \u26037, set2, mutableBoundingBox, treeFeatureConfig);
        this.func_227234_a_(iWorldGenerationReader, random, blockPos, \u26033, set, mutableBoundingBox, treeFeatureConfig);
        this.func_227240_b_(iWorldGenerationReader, random, \u26032, blockPos, \u26037, set, mutableBoundingBox, treeFeatureConfig);
        return true;
    }

    private int func_227241_b_(IWorldGenerationReader iWorldGenerationReader, Random random, BlockPos blockPos, int n, Set<BlockPos> set, MutableBoundingBox mutableBoundingBox, TreeFeatureConfig treeFeatureConfig) {
        if (!FancyTreeFeature.func_214585_i(iWorldGenerationReader, blockPos.func_177977_b())) {
            return -1;
        }
        int n2 = this.func_227235_a_(iWorldGenerationReader, random, blockPos, blockPos.func_177981_b(n - 1), false, set, mutableBoundingBox, treeFeatureConfig);
        if (n2 == -1) {
            return n;
        }
        if (n2 < 6) {
            return -1;
        }
        return n2;
    }

    static class ExtendedPos
    extends BlockPos {
        private final int field_227242_b_;

        public ExtendedPos(BlockPos blockPos, int n) {
            super(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
            this.field_227242_b_ = n;
        }

        public int func_227243_r_() {
            return this.field_227242_b_;
        }
    }
}

