/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.pattern.BlockMatcher;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class OreFeatureConfig
implements IFeatureConfig {
    public final FillerBlockType field_202442_b;
    public final int field_202443_c;
    public final BlockState field_202444_d;

    public OreFeatureConfig(FillerBlockType fillerBlockType, BlockState blockState, int n) {
        this.field_202443_c = n;
        this.field_202444_d = blockState;
        this.field_202442_b = fillerBlockType;
    }

    @Override
    public <T> Dynamic<T> func_214634_a(DynamicOps<T> dynamicOps) {
        return new Dynamic(dynamicOps, dynamicOps.createMap((Map)ImmutableMap.of((Object)dynamicOps.createString("size"), (Object)dynamicOps.createInt(this.field_202443_c), (Object)dynamicOps.createString("target"), (Object)dynamicOps.createString(this.field_202442_b.func_214737_a()), (Object)dynamicOps.createString("state"), (Object)BlockState.func_215689_a(dynamicOps, this.field_202444_d).getValue())));
    }

    public static OreFeatureConfig func_214641_a(Dynamic<?> dynamic) {
        int n = dynamic.get("size").asInt(0);
        FillerBlockType \u26032 = FillerBlockType.func_214736_a(dynamic.get("target").asString(""));
        BlockState \u26033 = dynamic.get("state").map(BlockState::func_215698_a).orElse(Blocks.field_150350_a.func_176223_P());
        return new OreFeatureConfig(\u26032, \u26033, n);
    }

    public static enum FillerBlockType {
        NATURAL_STONE("natural_stone", blockState -> {
            if (blockState != null) {
                Block block = blockState.func_177230_c();
                return block == Blocks.field_150348_b || block == Blocks.field_196650_c || block == Blocks.field_196654_e || block == Blocks.field_196656_g;
            }
            return false;
        }),
        NETHERRACK("netherrack", new BlockMatcher(Blocks.field_150424_aL));

        private static final Map<String, FillerBlockType> field_214741_c;
        private final String field_214742_d;
        private final Predicate<BlockState> field_214743_e;

        private FillerBlockType(String string2, Predicate<BlockState> predicate) {
            this.field_214742_d = string2;
            this.field_214743_e = predicate;
        }

        public String func_214737_a() {
            return this.field_214742_d;
        }

        public static FillerBlockType func_214736_a(String string) {
            return field_214741_c.get(string);
        }

        public Predicate<BlockState> func_214738_b() {
            return this.field_214743_e;
        }

        static {
            field_214741_c = Arrays.stream(FillerBlockType.values()).collect(Collectors.toMap(FillerBlockType::func_214737_a, fillerBlockType -> fillerBlockType));
        }
    }
}

