/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.specialsource;

import java.lang.reflect.Modifier;
import java.util.Collection;
import net.md_5.specialsource.Jar;
import net.md_5.specialsource.NodeType;
import net.md_5.specialsource.Ownable;
import net.md_5.specialsource.provider.InheritanceProvider;
import net.md_5.specialsource.provider.JarProvider;
import net.md_5.specialsource.repo.ClassRepo;
import net.md_5.specialsource.repo.JarRepo;
import net.md_5.specialsource.util.NoDupeList;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class JarComparer
extends ClassVisitor {
    private final MethodReferenceFinder methodVisitor = new MethodReferenceFinder();
    public final Jar jar;
    private final ClassRepo jarRepo;
    private final InheritanceProvider inheritance;
    private String myName;
    public int iterDepth;
    public NoDupeList<String> classes = new NoDupeList();
    public NoDupeList<Ownable> fields = new NoDupeList();
    public NoDupeList<Ownable> methods = new NoDupeList();

    private void visitType(Type type) {
        String name;
        if (type.getSort() == 10 && this.jar.containsClass(name = type.getInternalName())) {
            this.classes.add(name);
        }
        if (type.getSort() == 9) {
            this.visitType(type.getElementType());
        }
    }

    public JarComparer(Jar jar) {
        super(458752);
        this.jar = jar;
        this.jarRepo = new JarRepo(jar);
        this.inheritance = new JarProvider(jar);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.myName = name;
        for (String implement : interfaces) {
            if (!this.jar.containsClass(implement)) continue;
            this.classes.add(implement);
        }
        if (this.jar.containsClass(superName)) {
            this.classes.add(superName);
        }
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        Ownable field = new Ownable(NodeType.FIELD, this.myName, name, desc, access);
        this.fields.add(field);
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        Ownable method = new Ownable(NodeType.METHOD, this.myName, name, desc, access);
        String newN = this.getDeclarer(this.myName, method);
        if (newN != null) {
            method = new Ownable(method.type, newN, method.name, method.descriptor, method.access);
        }
        this.methods.add(method);
        for (Type t : Type.getArgumentTypes((String)desc)) {
            this.visitType(t);
        }
        this.visitType(Type.getReturnType((String)desc));
        return this.methodVisitor;
    }

    public String getDeclarer(String currentParent, Ownable node) {
        Collection<String> parents;
        String newParent = null;
        ClassNode n = this.jarRepo.findClass(currentParent);
        if (n == null) {
            return newParent;
        }
        block0 : switch (node.type) {
            case FIELD: {
                for (FieldNode field : n.fields) {
                    if (!field.name.equals(node.name) || !field.desc.equals(node.descriptor)) continue;
                    newParent = currentParent;
                    this.fields.remove(new Ownable(NodeType.FIELD, currentParent, node.name, node.descriptor, node.access));
                    break block0;
                }
                break;
            }
            case METHOD: {
                for (MethodNode method : n.methods) {
                    if (!method.name.equals(node.name) || !method.desc.equals(node.descriptor) || method.access != -1 && (Modifier.isPrivate(method.access) || Modifier.isStatic(method.access))) continue;
                    newParent = currentParent;
                    this.methods.remove(new Ownable(NodeType.METHOD, currentParent, node.name, node.descriptor, node.access));
                    this.methods.remove(node);
                    break block0;
                }
                break;
            }
        }
        if (!(!node.owner.equals(newParent) && newParent != null || node.access != -1 && (Modifier.isPrivate(node.access) || Modifier.isStatic(node.access)) || (parents = this.inheritance.getParents(currentParent)) == null)) {
            for (String parent : parents) {
                newParent = this.getDeclarer(parent, node);
                if (newParent == null) continue;
                return newParent;
            }
        }
        return newParent;
    }

    private class MethodReferenceFinder
    extends MethodVisitor {
        public MethodReferenceFinder() {
            super(458752);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (JarComparer.this.jar.containsClass(owner)) {
                JarComparer.this.classes.add(owner);
            }
        }

        public void visitLdcInsn(Object cst) {
            if (cst instanceof Type) {
                JarComparer.this.visitType((Type)cst);
            }
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (JarComparer.this.jar.containsClass(owner)) {
                JarComparer.this.classes.add(owner);
            }
        }

        public void visitTypeInsn(int opcode, String type) {
            if (JarComparer.this.jar.containsClass(type)) {
                JarComparer.this.classes.add(type);
            }
        }
    }
}

