/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.gson.JsonElement;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.JsonOps;
import java.nio.file.Path;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.util.FileUtil;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;

@OnlyIn(value=Dist.CLIENT)
public class CreateWorldScreen
extends Screen {
    private final Screen field_146332_f;
    private TextFieldWidget field_146333_g;
    private TextFieldWidget field_146335_h;
    private String field_146336_i;
    private GameMode field_228197_f_ = GameMode.SURVIVAL;
    @Nullable
    private GameMode field_228198_g_;
    private boolean field_146341_s = true;
    private boolean field_146340_t;
    private boolean field_146339_u;
    private boolean field_146338_v;
    private boolean field_146337_w;
    private boolean field_146345_x;
    private boolean field_146344_y;
    private Button field_195355_B;
    private Button field_146343_z;
    private Button field_146324_A;
    private Button field_146325_B;
    private Button field_146326_C;
    private Button field_146320_D;
    private Button field_146321_E;
    private Button field_146322_F;
    private String field_146323_G;
    private String field_146328_H;
    private String field_146329_I;
    private String field_146330_J;
    private int field_146331_K;
    public CompoundNBT field_146334_a = new CompoundNBT();

    public CreateWorldScreen(Screen p_i46320_1_) {
        super((ITextComponent)new TranslationTextComponent("selectWorld.create", new Object[0]));
        this.field_146332_f = p_i46320_1_;
        this.field_146329_I = "";
        this.field_146330_J = I18n.func_135052_a("selectWorld.newWorld", new Object[0]);
    }

    @Override
    public void tick() {
        this.field_146333_g.func_146178_a();
        this.field_146335_h.func_146178_a();
    }

    @Override
    protected void init() {
        this.minecraft.field_195559_v.func_197967_a(true);
        this.field_146333_g = new TextFieldWidget(this.font, this.width / 2 - 100, 60, 200, 20, I18n.func_135052_a("selectWorld.enterName", new Object[0])){

            protected String getNarrationMessage() {
                return super.getNarrationMessage() + ". " + I18n.func_135052_a("selectWorld.resultFolder", new Object[0]) + " " + CreateWorldScreen.this.field_146336_i;
            }
        };
        this.field_146333_g.func_146180_a(this.field_146330_J);
        this.field_146333_g.func_212954_a(p_214319_1_ -> {
            this.field_146330_J = p_214319_1_;
            this.field_195355_B.active = !this.field_146333_g.func_146179_b().isEmpty();
            this.func_146314_g();
        });
        this.children.add(this.field_146333_g);
        this.field_146343_z = this.addButton(new Button(this.width / 2 - 75, 115, 150, 20, I18n.func_135052_a("selectWorld.gameMode", new Object[0]), p_214316_1_ -> {
            switch (this.field_228197_f_) {
                case SURVIVAL: {
                    this.func_228200_a_(GameMode.HARDCORE);
                    break;
                }
                case HARDCORE: {
                    this.func_228200_a_(GameMode.CREATIVE);
                    break;
                }
                case CREATIVE: {
                    this.func_228200_a_(GameMode.SURVIVAL);
                }
            }
            p_214316_1_.queueNarration(250);
        }){

            public String getMessage() {
                return I18n.func_135052_a("selectWorld.gameMode", new Object[0]) + ": " + I18n.func_135052_a("selectWorld.gameMode." + CreateWorldScreen.this.field_228197_f_.field_228217_e_, new Object[0]);
            }

            protected String getNarrationMessage() {
                return super.getNarrationMessage() + ". " + CreateWorldScreen.this.field_146323_G + " " + CreateWorldScreen.this.field_146328_H;
            }
        });
        this.field_146335_h = new TextFieldWidget(this.font, this.width / 2 - 100, 60, 200, 20, I18n.func_135052_a("selectWorld.enterSeed", new Object[0]));
        this.field_146335_h.func_146180_a(this.field_146329_I);
        this.field_146335_h.func_212954_a(p_214313_1_ -> {
            this.field_146329_I = this.field_146335_h.func_146179_b();
        });
        this.children.add(this.field_146335_h);
        this.field_146325_B = this.addButton(new Button(this.width / 2 - 155, 100, 150, 20, I18n.func_135052_a("selectWorld.mapFeatures", new Object[0]), p_214322_1_ -> {
            this.field_146341_s = !this.field_146341_s;
            p_214322_1_.queueNarration(250);
        }){

            public String getMessage() {
                return I18n.func_135052_a("selectWorld.mapFeatures", new Object[0]) + ' ' + I18n.func_135052_a(CreateWorldScreen.this.field_146341_s ? "options.on" : "options.off", new Object[0]);
            }

            protected String getNarrationMessage() {
                return super.getNarrationMessage() + ". " + I18n.func_135052_a("selectWorld.mapFeatures.info", new Object[0]);
            }
        });
        this.field_146325_B.visible = false;
        this.field_146320_D = this.addButton(new Button(this.width / 2 + 5, 100, 150, 20, I18n.func_135052_a("selectWorld.mapType", new Object[0]), p_214320_1_ -> {
            ++this.field_146331_K;
            if (this.field_146331_K >= WorldType.field_77139_a.length) {
                this.field_146331_K = 0;
            }
            while (!this.func_175299_g()) {
                ++this.field_146331_K;
                if (this.field_146331_K < WorldType.field_77139_a.length) continue;
                this.field_146331_K = 0;
            }
            this.field_146334_a = new CompoundNBT();
            this.func_146316_a(this.field_146344_y);
            p_214320_1_.queueNarration(250);
        }){

            public String getMessage() {
                return I18n.func_135052_a("selectWorld.mapType", new Object[0]) + ' ' + I18n.func_135052_a(WorldType.field_77139_a[CreateWorldScreen.this.field_146331_K].func_77128_b(), new Object[0]);
            }

            protected String getNarrationMessage() {
                WorldType worldtype = WorldType.field_77139_a[CreateWorldScreen.this.field_146331_K];
                return worldtype.func_151357_h() ? super.getNarrationMessage() + ". " + I18n.func_135052_a(worldtype.func_151359_c(), new Object[0]) : super.getNarrationMessage();
            }
        });
        this.field_146320_D.visible = false;
        this.field_146322_F = this.addButton(new Button(this.width / 2 + 5, 120, 150, 20, I18n.func_135052_a("selectWorld.customizeType", new Object[0]), p_214314_1_ -> WorldType.field_77139_a[this.field_146331_K].onCustomizeButton(this.minecraft, this)));
        this.field_146322_F.visible = false;
        this.field_146321_E = this.addButton(new Button(this.width / 2 - 155, 151, 150, 20, I18n.func_135052_a("selectWorld.allowCommands", new Object[0]), p_214315_1_ -> {
            this.field_146339_u = true;
            this.field_146340_t = !this.field_146340_t;
            p_214315_1_.queueNarration(250);
        }){

            public String getMessage() {
                return I18n.func_135052_a("selectWorld.allowCommands", new Object[0]) + ' ' + I18n.func_135052_a(CreateWorldScreen.this.field_146340_t && !CreateWorldScreen.this.field_146337_w ? "options.on" : "options.off", new Object[0]);
            }

            protected String getNarrationMessage() {
                return super.getNarrationMessage() + ". " + I18n.func_135052_a("selectWorld.allowCommands.info", new Object[0]);
            }
        });
        this.field_146321_E.visible = false;
        this.field_146326_C = this.addButton(new Button(this.width / 2 + 5, 151, 150, 20, I18n.func_135052_a("selectWorld.bonusItems", new Object[0]), p_214312_1_ -> {
            this.field_146338_v = !this.field_146338_v;
            p_214312_1_.queueNarration(250);
        }){

            public String getMessage() {
                return I18n.func_135052_a("selectWorld.bonusItems", new Object[0]) + ' ' + I18n.func_135052_a(CreateWorldScreen.this.field_146338_v && !CreateWorldScreen.this.field_146337_w ? "options.on" : "options.off", new Object[0]);
            }
        });
        this.field_146326_C.visible = false;
        this.field_146324_A = this.addButton(new Button(this.width / 2 - 75, 187, 150, 20, I18n.func_135052_a("selectWorld.moreWorldOptions", new Object[0]), p_214321_1_ -> this.func_146315_i()));
        this.field_195355_B = this.addButton(new Button(this.width / 2 - 155, this.height - 28, 150, 20, I18n.func_135052_a("selectWorld.create", new Object[0]), p_214318_1_ -> this.func_195352_j()));
        this.field_195355_B.active = !this.field_146330_J.isEmpty();
        this.addButton(new Button(this.width / 2 + 5, this.height - 28, 150, 20, I18n.func_135052_a("gui.cancel", new Object[0]), p_214317_1_ -> this.minecraft.func_147108_a(this.field_146332_f)));
        this.func_146316_a(this.field_146344_y);
        this.func_212928_a((IGuiEventListener)this.field_146333_g);
        this.func_228200_a_(this.field_228197_f_);
        this.func_146314_g();
    }

    private void func_228199_a_() {
        this.field_146323_G = I18n.func_135052_a("selectWorld.gameMode." + this.field_228197_f_.field_228217_e_ + ".line1", new Object[0]);
        this.field_146328_H = I18n.func_135052_a("selectWorld.gameMode." + this.field_228197_f_.field_228217_e_ + ".line2", new Object[0]);
    }

    private void func_146314_g() {
        this.field_146336_i = this.field_146333_g.func_146179_b().trim();
        if (this.field_146336_i.isEmpty()) {
            this.field_146336_i = "World";
        }
        try {
            this.field_146336_i = FileUtil.func_214992_a((Path)this.minecraft.func_71359_d().func_215781_c(), (String)this.field_146336_i, (String)"");
        }
        catch (Exception var4) {
            this.field_146336_i = "World";
            try {
                this.field_146336_i = FileUtil.func_214992_a((Path)this.minecraft.func_71359_d().func_215781_c(), (String)this.field_146336_i, (String)"");
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not create save folder", exception);
            }
        }
    }

    @Override
    public void removed() {
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    private void func_195352_j() {
        this.minecraft.func_147108_a(null);
        if (!this.field_146345_x) {
            this.field_146345_x = true;
            long i = new Random().nextLong();
            String s = this.field_146335_h.func_146179_b();
            if (!StringUtils.isEmpty((CharSequence)s)) {
                try {
                    long j = Long.parseLong(s);
                    if (j != 0L) {
                        i = j;
                    }
                }
                catch (NumberFormatException var6) {
                    i = s.hashCode();
                }
            }
            WorldType.field_77139_a[this.field_146331_K].onGUICreateWorldPress();
            WorldSettings worldsettings = new WorldSettings(i, this.field_228197_f_.field_228218_f_, this.field_146341_s, this.field_146337_w, WorldType.field_77139_a[this.field_146331_K]);
            worldsettings.func_205390_a((JsonElement)Dynamic.convert((DynamicOps)NBTDynamicOps.field_210820_a, (DynamicOps)JsonOps.INSTANCE, (Object)this.field_146334_a));
            if (this.field_146338_v && !this.field_146337_w) {
                worldsettings.func_77159_a();
            }
            if (this.field_146340_t && !this.field_146337_w) {
                worldsettings.func_77166_b();
            }
            this.minecraft.func_71371_a(this.field_146336_i, this.field_146333_g.func_146179_b().trim(), worldsettings);
        }
    }

    private boolean func_175299_g() {
        WorldType worldtype = WorldType.field_77139_a[this.field_146331_K];
        if (worldtype != null && worldtype.func_77126_d()) {
            return worldtype == WorldType.field_180272_g ? CreateWorldScreen.hasShiftDown() : true;
        }
        return false;
    }

    private void func_146315_i() {
        this.func_146316_a(!this.field_146344_y);
    }

    private void func_228200_a_(GameMode p_228200_1_) {
        if (!this.field_146339_u) {
            boolean bl = this.field_146340_t = p_228200_1_ == GameMode.CREATIVE;
        }
        if (p_228200_1_ == GameMode.HARDCORE) {
            this.field_146337_w = true;
            this.field_146321_E.active = false;
            this.field_146326_C.active = false;
        } else {
            this.field_146337_w = false;
            this.field_146321_E.active = true;
            this.field_146326_C.active = true;
        }
        this.field_228197_f_ = p_228200_1_;
        this.func_228199_a_();
    }

    private void func_146316_a(boolean toggle) {
        this.field_146344_y = toggle;
        this.field_146343_z.visible = !this.field_146344_y;
        this.field_146320_D.visible = this.field_146344_y;
        if (WorldType.field_77139_a[this.field_146331_K] == WorldType.field_180272_g) {
            this.field_146343_z.active = false;
            if (this.field_228198_g_ == null) {
                this.field_228198_g_ = this.field_228197_f_;
            }
            this.func_228200_a_(GameMode.DEBUG);
            this.field_146325_B.visible = false;
            this.field_146326_C.visible = false;
            this.field_146321_E.visible = false;
            this.field_146322_F.visible = false;
        } else {
            this.field_146343_z.active = true;
            if (this.field_228198_g_ != null) {
                this.func_228200_a_(this.field_228198_g_);
            }
            this.field_146325_B.visible = this.field_146344_y && WorldType.field_77139_a[this.field_146331_K] != WorldType.field_180271_f;
            this.field_146326_C.visible = this.field_146344_y;
            this.field_146321_E.visible = this.field_146344_y;
            this.field_146322_F.visible = this.field_146344_y && WorldType.field_77139_a[this.field_146331_K].func_205393_e();
        }
        this.field_146335_h.func_146189_e(this.field_146344_y);
        this.field_146333_g.func_146189_e(!this.field_146344_y);
        if (this.field_146344_y) {
            this.field_146324_A.setMessage(I18n.func_135052_a("gui.done", new Object[0]));
        } else {
            this.field_146324_A.setMessage(I18n.func_135052_a("selectWorld.moreWorldOptions", new Object[0]));
        }
    }

    @Override
    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_)) {
            return true;
        }
        if (p_keyPressed_1_ != 257 && p_keyPressed_1_ != 335) {
            return false;
        }
        this.func_195352_j();
        return true;
    }

    @Override
    public void onClose() {
        if (this.field_146344_y) {
            this.func_146316_a(false);
        } else {
            this.minecraft.func_147108_a(this.field_146332_f);
        }
    }

    @Override
    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        this.renderBackground();
        this.drawCenteredString(this.font, this.title.func_150254_d(), this.width / 2, 20, -1);
        if (this.field_146344_y) {
            this.drawString(this.font, I18n.func_135052_a("selectWorld.enterSeed", new Object[0]), this.width / 2 - 100, 47, -6250336);
            this.drawString(this.font, I18n.func_135052_a("selectWorld.seedInfo", new Object[0]), this.width / 2 - 100, 85, -6250336);
            if (this.field_146325_B.visible) {
                this.drawString(this.font, I18n.func_135052_a("selectWorld.mapFeatures.info", new Object[0]), this.width / 2 - 150, 122, -6250336);
            }
            if (this.field_146321_E.visible) {
                this.drawString(this.font, I18n.func_135052_a("selectWorld.allowCommands.info", new Object[0]), this.width / 2 - 150, 172, -6250336);
            }
            this.field_146335_h.render(p_render_1_, p_render_2_, p_render_3_);
            if (WorldType.field_77139_a[this.field_146331_K].func_151357_h()) {
                this.font.func_78279_b(I18n.func_135052_a(WorldType.field_77139_a[this.field_146331_K].func_151359_c(), new Object[0]), this.field_146320_D.x + 2, this.field_146320_D.y + 22, this.field_146320_D.getWidth(), 0xA0A0A0);
            }
        } else {
            this.drawString(this.font, I18n.func_135052_a("selectWorld.enterName", new Object[0]), this.width / 2 - 100, 47, -6250336);
            this.drawString(this.font, I18n.func_135052_a("selectWorld.resultFolder", new Object[0]) + " " + this.field_146336_i, this.width / 2 - 100, 85, -6250336);
            this.field_146333_g.render(p_render_1_, p_render_2_, p_render_3_);
            this.drawCenteredString(this.font, this.field_146323_G, this.width / 2, 137, -6250336);
            this.drawCenteredString(this.font, this.field_146328_H, this.width / 2, 149, -6250336);
        }
        super.render(p_render_1_, p_render_2_, p_render_3_);
    }

    public void func_146318_a(WorldInfo original) {
        this.field_146330_J = original.func_76065_j();
        this.field_146329_I = Long.toString(original.func_76063_b());
        WorldType worldtype = original.func_76067_t() == WorldType.field_180271_f ? WorldType.field_77137_b : original.func_76067_t();
        this.field_146331_K = worldtype.func_82747_f();
        this.field_146334_a = original.func_211027_A();
        this.field_146341_s = original.func_76089_r();
        this.field_146340_t = original.func_76086_u();
        if (original.func_76093_s()) {
            this.field_228197_f_ = GameMode.HARDCORE;
        } else if (original.func_76077_q().func_77144_e()) {
            this.field_228197_f_ = GameMode.SURVIVAL;
        } else if (original.func_76077_q().func_77145_d()) {
            this.field_228197_f_ = GameMode.CREATIVE;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static enum GameMode {
        SURVIVAL("survival", GameType.SURVIVAL),
        HARDCORE("hardcore", GameType.SURVIVAL),
        CREATIVE("creative", GameType.CREATIVE),
        DEBUG("spectator", GameType.SPECTATOR);

        private final String field_228217_e_;
        private final GameType field_228218_f_;

        private GameMode(String p_i225940_3_, GameType p_i225940_4_) {
            this.field_228217_e_ = p_i225940_3_;
            this.field_228218_f_ = p_i225940_4_;
        }
    }
}

