/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.gui.screen.AddServerScreen;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.ConnectingScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.ServerListScreen;
import net.minecraft.client.gui.screen.ServerSelectionList;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.network.LanServerDetector;
import net.minecraft.client.network.LanServerInfo;
import net.minecraft.client.network.ServerPinger;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class MultiplayerScreen
extends Screen {
    private static final Logger field_146802_a = LogManager.getLogger();
    private final ServerPinger field_146797_f = new ServerPinger();
    private final Screen field_146798_g;
    protected ServerSelectionList field_146803_h;
    private ServerList field_146804_i;
    private Button field_146810_r;
    private Button field_146809_s;
    private Button field_146808_t;
    private String field_146812_y;
    private ServerData field_146811_z;
    private LanServerDetector.LanServerList field_146799_A;
    private LanServerDetector.LanServerFindThread field_146800_B;
    private boolean field_146801_C;

    public MultiplayerScreen(Screen parentScreen) {
        super((ITextComponent)new TranslationTextComponent("multiplayer.title", new Object[0]));
        this.field_146798_g = parentScreen;
    }

    @Override
    protected void init() {
        super.init();
        this.minecraft.field_195559_v.func_197967_a(true);
        if (this.field_146801_C) {
            this.field_146803_h.updateSize(this.width, this.height, 32, this.height - 64);
        } else {
            this.field_146801_C = true;
            this.field_146804_i = new ServerList(this.minecraft);
            this.field_146804_i.func_78853_a();
            this.field_146799_A = new LanServerDetector.LanServerList();
            try {
                this.field_146800_B = new LanServerDetector.LanServerFindThread(this.field_146799_A);
                this.field_146800_B.start();
            }
            catch (Exception exception) {
                field_146802_a.warn("Unable to start LAN server detection: {}", (Object)exception.getMessage());
            }
            this.field_146803_h = new ServerSelectionList(this, this.minecraft, this.width, this.height, 32, this.height - 64, 36);
            this.field_146803_h.func_148195_a(this.field_146804_i);
        }
        this.children.add(this.field_146803_h);
        this.field_146809_s = this.addButton(new Button(this.width / 2 - 154, this.height - 52, 100, 20, I18n.func_135052_a("selectServer.select", new Object[0]), p_214293_1_ -> this.func_146796_h()));
        this.addButton(new Button(this.width / 2 - 50, this.height - 52, 100, 20, I18n.func_135052_a("selectServer.direct", new Object[0]), p_214286_1_ -> {
            this.field_146811_z = new ServerData(I18n.func_135052_a("selectServer.defaultName", new Object[0]), "", false);
            this.minecraft.func_147108_a((Screen)new ServerListScreen((Screen)this, this::func_214290_d, this.field_146811_z));
        }));
        this.addButton(new Button(this.width / 2 + 4 + 50, this.height - 52, 100, 20, I18n.func_135052_a("selectServer.add", new Object[0]), p_214288_1_ -> {
            this.field_146811_z = new ServerData(I18n.func_135052_a("selectServer.defaultName", new Object[0]), "", false);
            this.minecraft.func_147108_a((Screen)new AddServerScreen((Screen)this, this::func_214284_c, this.field_146811_z));
        }));
        this.field_146810_r = this.addButton(new Button(this.width / 2 - 154, this.height - 28, 70, 20, I18n.func_135052_a("selectServer.edit", new Object[0]), p_214283_1_ -> {
            ServerSelectionList.Entry serverselectionlist$entry = (ServerSelectionList.Entry)((Object)((Object)this.field_146803_h.getSelected()));
            if (serverselectionlist$entry instanceof ServerSelectionList.NormalEntry) {
                ServerData serverdata = ((ServerSelectionList.NormalEntry)serverselectionlist$entry).func_148296_a();
                this.field_146811_z = new ServerData(serverdata.field_78847_a, serverdata.field_78845_b, false);
                this.field_146811_z.func_152583_a(serverdata);
                this.minecraft.func_147108_a((Screen)new AddServerScreen((Screen)this, this::func_214292_b, this.field_146811_z));
            }
        }));
        this.field_146808_t = this.addButton(new Button(this.width / 2 - 74, this.height - 28, 70, 20, I18n.func_135052_a("selectServer.delete", new Object[0]), p_214294_1_ -> {
            String s;
            ServerSelectionList.Entry serverselectionlist$entry = (ServerSelectionList.Entry)((Object)((Object)this.field_146803_h.getSelected()));
            if (serverselectionlist$entry instanceof ServerSelectionList.NormalEntry && (s = ((ServerSelectionList.NormalEntry)serverselectionlist$entry).func_148296_a().field_78847_a) != null) {
                TranslationTextComponent itextcomponent = new TranslationTextComponent("selectServer.deleteQuestion", new Object[0]);
                TranslationTextComponent itextcomponent1 = new TranslationTextComponent("selectServer.deleteWarning", s);
                String s1 = I18n.func_135052_a("selectServer.deleteButton", new Object[0]);
                String s2 = I18n.func_135052_a("gui.cancel", new Object[0]);
                this.minecraft.func_147108_a((Screen)new ConfirmScreen(this::func_214285_a, (ITextComponent)itextcomponent, (ITextComponent)itextcomponent1, s1, s2));
            }
        }));
        this.addButton(new Button(this.width / 2 + 4, this.height - 28, 70, 20, I18n.func_135052_a("selectServer.refresh", new Object[0]), p_214291_1_ -> this.func_146792_q()));
        this.addButton(new Button(this.width / 2 + 4 + 76, this.height - 28, 75, 20, I18n.func_135052_a("gui.cancel", new Object[0]), p_214289_1_ -> this.minecraft.func_147108_a(this.field_146798_g)));
        this.func_214295_b();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.field_146799_A.func_77553_a()) {
            List list = this.field_146799_A.func_77554_c();
            this.field_146799_A.func_77552_b();
            this.field_146803_h.func_148194_a(list);
        }
        this.field_146797_f.func_147223_a();
    }

    @Override
    public void removed() {
        this.minecraft.field_195559_v.func_197967_a(false);
        if (this.field_146800_B != null) {
            this.field_146800_B.interrupt();
            this.field_146800_B = null;
        }
        this.field_146797_f.func_147226_b();
    }

    private void func_146792_q() {
        this.minecraft.func_147108_a(new MultiplayerScreen(this.field_146798_g));
    }

    private void func_214285_a(boolean p_214285_1_) {
        ServerSelectionList.Entry serverselectionlist$entry = (ServerSelectionList.Entry)((Object)this.field_146803_h.getSelected());
        if (p_214285_1_ && serverselectionlist$entry instanceof ServerSelectionList.NormalEntry) {
            this.field_146804_i.func_217506_a(((ServerSelectionList.NormalEntry)serverselectionlist$entry).func_148296_a());
            this.field_146804_i.func_78855_b();
            this.field_146803_h.setSelected((ServerSelectionList.Entry)null);
            this.field_146803_h.func_148195_a(this.field_146804_i);
        }
        this.minecraft.func_147108_a(this);
    }

    private void func_214292_b(boolean p_214292_1_) {
        ServerSelectionList.Entry serverselectionlist$entry = (ServerSelectionList.Entry)((Object)this.field_146803_h.getSelected());
        if (p_214292_1_ && serverselectionlist$entry instanceof ServerSelectionList.NormalEntry) {
            ServerData serverdata = ((ServerSelectionList.NormalEntry)serverselectionlist$entry).func_148296_a();
            serverdata.field_78847_a = this.field_146811_z.field_78847_a;
            serverdata.field_78845_b = this.field_146811_z.field_78845_b;
            serverdata.func_152583_a(this.field_146811_z);
            this.field_146804_i.func_78855_b();
            this.field_146803_h.func_148195_a(this.field_146804_i);
        }
        this.minecraft.func_147108_a(this);
    }

    private void func_214284_c(boolean p_214284_1_) {
        if (p_214284_1_) {
            this.field_146804_i.func_78849_a(this.field_146811_z);
            this.field_146804_i.func_78855_b();
            this.field_146803_h.setSelected((ServerSelectionList.Entry)null);
            this.field_146803_h.func_148195_a(this.field_146804_i);
        }
        this.minecraft.func_147108_a(this);
    }

    private void func_214290_d(boolean p_214290_1_) {
        if (p_214290_1_) {
            this.func_146791_a(this.field_146811_z);
        } else {
            this.minecraft.func_147108_a(this);
        }
    }

    @Override
    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_)) {
            return true;
        }
        if (p_keyPressed_1_ == 294) {
            this.func_146792_q();
            return true;
        }
        if (this.field_146803_h.getSelected() != null) {
            if (p_keyPressed_1_ != 257 && p_keyPressed_1_ != 335) {
                return this.field_146803_h.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
            }
            this.func_146796_h();
            return true;
        }
        return false;
    }

    @Override
    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        this.field_146812_y = null;
        this.renderBackground();
        this.field_146803_h.render(p_render_1_, p_render_2_, p_render_3_);
        this.drawCenteredString(this.font, this.title.func_150254_d(), this.width / 2, 20, 0xFFFFFF);
        super.render(p_render_1_, p_render_2_, p_render_3_);
        if (this.field_146812_y != null) {
            this.renderTooltip(Lists.newArrayList((Iterable)Splitter.on((String)"\n").split((CharSequence)this.field_146812_y)), p_render_1_, p_render_2_);
        }
    }

    public void func_146796_h() {
        ServerSelectionList.Entry serverselectionlist$entry = (ServerSelectionList.Entry)((Object)this.field_146803_h.getSelected());
        if (serverselectionlist$entry instanceof ServerSelectionList.NormalEntry) {
            this.func_146791_a(((ServerSelectionList.NormalEntry)serverselectionlist$entry).func_148296_a());
        } else if (serverselectionlist$entry instanceof ServerSelectionList.LanDetectedEntry) {
            LanServerInfo lanserverinfo = ((ServerSelectionList.LanDetectedEntry)serverselectionlist$entry).func_189995_a();
            this.func_146791_a(new ServerData(lanserverinfo.func_77487_a(), lanserverinfo.func_77488_b(), true));
        }
    }

    private void func_146791_a(ServerData server) {
        this.minecraft.func_147108_a((Screen)new ConnectingScreen((Screen)this, this.minecraft, server));
    }

    public void func_214287_a(ServerSelectionList.Entry p_214287_1_) {
        this.field_146803_h.setSelected(p_214287_1_);
        this.func_214295_b();
    }

    protected void func_214295_b() {
        this.field_146809_s.active = false;
        this.field_146810_r.active = false;
        this.field_146808_t.active = false;
        ServerSelectionList.Entry serverselectionlist$entry = (ServerSelectionList.Entry)((Object)this.field_146803_h.getSelected());
        if (serverselectionlist$entry != null && !(serverselectionlist$entry instanceof ServerSelectionList.LanScanEntry)) {
            this.field_146809_s.active = true;
            if (serverselectionlist$entry instanceof ServerSelectionList.NormalEntry) {
                this.field_146810_r.active = true;
                this.field_146808_t.active = true;
            }
        }
    }

    @Override
    public void onClose() {
        this.minecraft.func_147108_a(this.field_146798_g);
    }

    public ServerPinger func_146789_i() {
        return this.field_146797_f;
    }

    public void func_146793_a(String p_146793_1_) {
        this.field_146812_y = p_146793_1_;
    }

    public ServerList func_146795_p() {
        return this.field_146804_i;
    }
}

