/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.BlockPartRotation;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ItemModelGenerator {
    public static final List<String> field_178398_a = Lists.newArrayList((Object[])new String[]{"layer0", "layer1", "layer2", "layer3", "layer4"});

    public BlockModel func_209579_a(Function<Material, TextureAtlasSprite> textureGetter, BlockModel blockModelIn) {
        String s;
        HashMap map = Maps.newHashMap();
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < field_178398_a.size() && blockModelIn.func_178300_b(s = field_178398_a.get(i)); ++i) {
            Material material = blockModelIn.func_228816_c_(s);
            map.put(s, Either.left((Object)material));
            TextureAtlasSprite textureatlassprite = textureGetter.apply(material);
            list.addAll(this.func_178394_a(i, s, textureatlassprite));
        }
        map.put("particle", blockModelIn.func_178300_b("particle") ? Either.left((Object)blockModelIn.func_228816_c_("particle")) : (Either)map.get("layer0"));
        BlockModel blockmodel = new BlockModel(null, list, map, false, blockModelIn.func_230176_c_(), blockModelIn.func_181682_g(), blockModelIn.func_187966_f());
        blockmodel.field_178317_b = blockModelIn.field_178317_b;
        blockmodel.customData.copyFrom(blockModelIn.customData);
        return blockmodel;
    }

    private List<BlockPart> func_178394_a(int tintIndex, String textureIn, TextureAtlasSprite spriteIn) {
        HashMap map = Maps.newHashMap();
        map.put(Direction.SOUTH, new BlockPartFace((Direction)null, tintIndex, textureIn, new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0)));
        map.put(Direction.NORTH, new BlockPartFace((Direction)null, tintIndex, textureIn, new BlockFaceUV(new float[]{16.0f, 0.0f, 0.0f, 16.0f}, 0)));
        ArrayList list = Lists.newArrayList();
        list.add(new BlockPart(new Vector3f(0.0f, 0.0f, 7.5f), new Vector3f(16.0f, 16.0f, 8.5f), (Map)map, (BlockPartRotation)null, true));
        list.addAll(this.func_178397_a(spriteIn, textureIn, tintIndex));
        return list;
    }

    private List<BlockPart> func_178397_a(TextureAtlasSprite spriteIn, String textureIn, int tintIndexIn) {
        float f = spriteIn.func_94211_a();
        float f1 = spriteIn.func_94216_b();
        ArrayList list = Lists.newArrayList();
        for (Span itemmodelgenerator$span : this.func_178393_a(spriteIn)) {
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 0.0f;
            float f8 = 0.0f;
            float f9 = 0.0f;
            float f10 = 16.0f / f;
            float f11 = 16.0f / f1;
            float f12 = itemmodelgenerator$span.func_178385_b();
            float f13 = itemmodelgenerator$span.func_178384_c();
            float f14 = itemmodelgenerator$span.func_178381_d();
            SpanFacing itemmodelgenerator$spanfacing = itemmodelgenerator$span.func_178383_a();
            switch (itemmodelgenerator$spanfacing) {
                case UP: {
                    f6 = f12;
                    f2 = f12;
                    f4 = f7 = f13 + 1.0f;
                    f8 = f14;
                    f3 = f14;
                    f5 = f14;
                    f9 = f14 + 1.0f;
                    break;
                }
                case DOWN: {
                    f8 = f14;
                    f9 = f14 + 1.0f;
                    f6 = f12;
                    f2 = f12;
                    f4 = f7 = f13 + 1.0f;
                    f3 = f14 + 1.0f;
                    f5 = f14 + 1.0f;
                    break;
                }
                case LEFT: {
                    f6 = f14;
                    f2 = f14;
                    f4 = f14;
                    f7 = f14 + 1.0f;
                    f9 = f12;
                    f3 = f12;
                    f5 = f8 = f13 + 1.0f;
                    break;
                }
                case RIGHT: {
                    f6 = f14;
                    f7 = f14 + 1.0f;
                    f2 = f14 + 1.0f;
                    f4 = f14 + 1.0f;
                    f9 = f12;
                    f3 = f12;
                    f5 = f8 = f13 + 1.0f;
                }
            }
            f2 *= f10;
            f4 *= f10;
            f3 *= f11;
            f5 *= f11;
            f3 = 16.0f - f3;
            f5 = 16.0f - f5;
            HashMap map = Maps.newHashMap();
            map.put(itemmodelgenerator$spanfacing.func_178367_a(), new BlockPartFace((Direction)null, tintIndexIn, textureIn, new BlockFaceUV(new float[]{f6 *= f10, f8 *= f11, f7 *= f10, f9 *= f11}, 0)));
            switch (itemmodelgenerator$spanfacing) {
                case UP: {
                    list.add(new BlockPart(new Vector3f(f2, f3, 7.5f), new Vector3f(f4, f3, 8.5f), (Map)map, (BlockPartRotation)null, true));
                    break;
                }
                case DOWN: {
                    list.add(new BlockPart(new Vector3f(f2, f5, 7.5f), new Vector3f(f4, f5, 8.5f), (Map)map, (BlockPartRotation)null, true));
                    break;
                }
                case LEFT: {
                    list.add(new BlockPart(new Vector3f(f2, f3, 7.5f), new Vector3f(f2, f5, 8.5f), (Map)map, (BlockPartRotation)null, true));
                    break;
                }
                case RIGHT: {
                    list.add(new BlockPart(new Vector3f(f4, f3, 7.5f), new Vector3f(f4, f5, 8.5f), (Map)map, (BlockPartRotation)null, true));
                }
            }
        }
        return list;
    }

    private List<Span> func_178393_a(TextureAtlasSprite spriteIn) {
        int i = spriteIn.func_94211_a();
        int j = spriteIn.func_94216_b();
        ArrayList list = Lists.newArrayList();
        for (int k = 0; k < spriteIn.func_110970_k(); ++k) {
            for (int l = 0; l < j; ++l) {
                for (int i1 = 0; i1 < i; ++i1) {
                    boolean flag = !this.func_199339_a(spriteIn, k, i1, l, i, j);
                    this.func_199338_a(SpanFacing.UP, list, spriteIn, k, i1, l, i, j, flag);
                    this.func_199338_a(SpanFacing.DOWN, list, spriteIn, k, i1, l, i, j, flag);
                    this.func_199338_a(SpanFacing.LEFT, list, spriteIn, k, i1, l, i, j, flag);
                    this.func_199338_a(SpanFacing.RIGHT, list, spriteIn, k, i1, l, i, j, flag);
                }
            }
        }
        return list;
    }

    private void func_199338_a(SpanFacing spanFacingIn, List<Span> listSpansIn, TextureAtlasSprite spriteIn, int frameIndex, int pixelX, int pixelY, int spiteWidth, int spriteHeight, boolean p_199338_9_) {
        boolean flag;
        boolean bl = flag = this.func_199339_a(spriteIn, frameIndex, pixelX + spanFacingIn.func_178372_b(), pixelY + spanFacingIn.func_178371_c(), spiteWidth, spriteHeight) && p_199338_9_;
        if (flag) {
            this.func_178395_a(listSpansIn, spanFacingIn, pixelX, pixelY);
        }
    }

    private void func_178395_a(List<Span> listSpansIn, SpanFacing spanFacingIn, int pixelX, int pixelY) {
        int k;
        Span itemmodelgenerator$span = null;
        for (Span itemmodelgenerator$span1 : listSpansIn) {
            int i;
            if (itemmodelgenerator$span1.func_178383_a() != spanFacingIn) continue;
            int n = i = spanFacingIn.func_178369_d() ? pixelY : pixelX;
            if (itemmodelgenerator$span1.func_178381_d() != i) continue;
            itemmodelgenerator$span = itemmodelgenerator$span1;
            break;
        }
        int j = spanFacingIn.func_178369_d() ? pixelY : pixelX;
        int n = k = spanFacingIn.func_178369_d() ? pixelX : pixelY;
        if (itemmodelgenerator$span == null) {
            listSpansIn.add(new Span(spanFacingIn, k, j));
        } else {
            itemmodelgenerator$span.func_178382_a(k);
        }
    }

    private boolean func_199339_a(TextureAtlasSprite spriteIn, int frameIndex, int pixelX, int pixelY, int spiteWidth, int spriteHeight) {
        return pixelX >= 0 && pixelY >= 0 && pixelX < spiteWidth && pixelY < spriteHeight ? spriteIn.func_195662_a(frameIndex, pixelX, pixelY) : true;
    }

    @OnlyIn(value=Dist.CLIENT)
    static enum SpanFacing {
        UP(Direction.UP, 0, -1),
        DOWN(Direction.DOWN, 0, 1),
        LEFT(Direction.EAST, -1, 0),
        RIGHT(Direction.WEST, 1, 0);

        private final Direction field_178376_e;
        private final int field_178373_f;
        private final int field_178374_g;

        private SpanFacing(Direction facing, int xOffsetIn, int yOffsetIn) {
            this.field_178376_e = facing;
            this.field_178373_f = xOffsetIn;
            this.field_178374_g = yOffsetIn;
        }

        public Direction func_178367_a() {
            return this.field_178376_e;
        }

        public int func_178372_b() {
            return this.field_178373_f;
        }

        public int func_178371_c() {
            return this.field_178374_g;
        }

        private boolean func_178369_d() {
            return this == DOWN || this == UP;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Span {
        private final SpanFacing field_178389_a;
        private int field_178387_b;
        private int field_178388_c;
        private final int field_178386_d;

        public Span(SpanFacing spanFacingIn, int minIn, int maxIn) {
            this.field_178389_a = spanFacingIn;
            this.field_178387_b = minIn;
            this.field_178388_c = minIn;
            this.field_178386_d = maxIn;
        }

        public void func_178382_a(int posIn) {
            if (posIn < this.field_178387_b) {
                this.field_178387_b = posIn;
            } else if (posIn > this.field_178388_c) {
                this.field_178388_c = posIn;
            }
        }

        public SpanFacing func_178383_a() {
            return this.field_178389_a;
        }

        public int func_178385_b() {
            return this.field_178387_b;
        }

        public int func_178384_c() {
            return this.field_178388_c;
        }

        public int func_178381_d() {
            return this.field_178386_d;
        }
    }
}

