/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.util.UUIDTypeAdapter;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class Session {
    private final String field_74286_b;
    private final String field_148257_b;
    private final String field_148258_c;
    private final Type field_152429_d;
    private PropertyMap properties;

    public Session(String usernameIn, String playerIDIn, String tokenIn, String sessionTypeIn) {
        if (usernameIn == null || usernameIn.isEmpty()) {
            usernameIn = "MissingName";
            tokenIn = "NotValid";
            playerIDIn = "NotValid";
            Logger logger = LogManager.getLogger((String)this.getClass().getName());
            logger.log(Level.WARN, "=========================================================");
            logger.log(Level.WARN, "WARNING!! the username was not set for this session, typically");
            logger.log(Level.WARN, "this means you installed Forge incorrectly. We have set your");
            logger.log(Level.WARN, "name to \"MissingName\" and your session to nothing. Please");
            logger.log(Level.WARN, "check your installation and post a console log from the launcher");
            logger.log(Level.WARN, "when asking for help!");
            logger.log(Level.WARN, "=========================================================");
        }
        this.field_74286_b = usernameIn;
        this.field_148257_b = playerIDIn;
        this.field_148258_c = tokenIn;
        this.field_152429_d = Type.func_152421_a(sessionTypeIn);
    }

    public String func_111286_b() {
        return "token:" + this.field_148258_c + ":" + this.field_148257_b;
    }

    public String func_148255_b() {
        return this.field_148257_b;
    }

    public String func_111285_a() {
        return this.field_74286_b;
    }

    public String func_148254_d() {
        return this.field_148258_c;
    }

    public GameProfile func_148256_e() {
        try {
            UUID uuid = UUIDTypeAdapter.fromString((String)this.func_148255_b());
            GameProfile ret = new GameProfile(uuid, this.func_111285_a());
            if (this.properties != null) {
                ret.getProperties().putAll((Multimap)this.properties);
            }
            return ret;
        }
        catch (IllegalArgumentException var2) {
            return new GameProfile((UUID)null, this.func_111285_a());
        }
    }

    public void setProperties(PropertyMap properties) {
        if (this.properties == null) {
            this.properties = properties;
        }
    }

    public boolean hasCachedProperties() {
        return this.properties != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Type {
        LEGACY("legacy"),
        MOJANG("mojang");

        private static final Map<String, Type> field_152425_c;
        private final String field_152426_d;

        private Type(String sessionTypeIn) {
            this.field_152426_d = sessionTypeIn;
        }

        @Nullable
        public static Type func_152421_a(String sessionTypeIn) {
            return field_152425_c.get(sessionTypeIn.toLowerCase(Locale.ROOT));
        }

        static {
            field_152425_c = Arrays.stream(Type.values()).collect(Collectors.toMap(p_199876_0_ -> p_199876_0_.field_152426_d, Function.identity()));
        }
    }
}

