/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk.storage;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.storage.RegionFile;

public final class RegionFileCache
implements AutoCloseable {
    private final Long2ObjectLinkedOpenHashMap<RegionFile> field_219102_c = new Long2ObjectLinkedOpenHashMap();
    private final File field_219101_a;

    RegionFileCache(File worldDir) {
        this.field_219101_a = worldDir;
    }

    private RegionFile func_219098_a(ChunkPos pos) throws IOException {
        long i = ChunkPos.func_77272_a((int)pos.func_222241_h(), (int)pos.func_222242_i());
        RegionFile regionfile = (RegionFile)this.field_219102_c.getAndMoveToFirst(i);
        if (regionfile != null) {
            return regionfile;
        }
        if (this.field_219102_c.size() >= 256) {
            ((RegionFile)this.field_219102_c.removeLast()).close();
        }
        if (!this.field_219101_a.exists()) {
            this.field_219101_a.mkdirs();
        }
        File file1 = new File(this.field_219101_a, "r." + pos.func_222241_h() + "." + pos.func_222242_i() + ".mca");
        RegionFile regionfile1 = new RegionFile(file1, this.field_219101_a).extractLargeChunks(pos);
        this.field_219102_c.putAndMoveToFirst(i, (Object)regionfile1);
        return regionfile1;
    }

    @Nullable
    public CompoundNBT func_219099_e(ChunkPos pos) throws IOException {
        CompoundNBT compoundnbt;
        RegionFile regionfile = this.func_219098_a(pos);
        try (DataInputStream datainputstream = regionfile.func_222666_a(pos);){
            if (datainputstream != null) {
                CompoundNBT compoundnbt2;
                CompoundNBT compoundNBT = compoundnbt2 = CompressedStreamTools.func_74794_a(datainputstream);
                return compoundNBT;
            }
            compoundnbt = null;
        }
        return compoundnbt;
    }

    protected void func_219100_a(ChunkPos pos, CompoundNBT compound) throws IOException {
        RegionFile regionfile = this.func_219098_a(pos);
        try (DataOutputStream dataoutputstream = regionfile.func_222661_c(pos);){
            CompressedStreamTools.func_74800_a(compound, dataoutputstream);
        }
    }

    @Override
    public void close() throws IOException {
        for (RegionFile regionfile : this.field_219102_c.values()) {
            regionfile.close();
        }
    }
}

