/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Blocks;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.treedecorator.TreeDecorator;
import net.minecraftforge.common.IPlantable;

public class HugeTreeFeatureConfig
extends BaseTreeFeatureConfig {
    public final int field_227275_a_;
    public final int field_227276_b_;

    protected HugeTreeFeatureConfig(BlockStateProvider trunkProviderIn, BlockStateProvider leavesProviderIn, List<TreeDecorator> decoratorsIn, int baseHeightIn, int heightIntervalIn, int crownHeightIn) {
        super(trunkProviderIn, leavesProviderIn, decoratorsIn, baseHeightIn);
        this.field_227275_a_ = heightIntervalIn;
        this.field_227276_b_ = crownHeightIn;
    }

    @Override
    public <T> Dynamic<T> func_214634_a(DynamicOps<T> ops) {
        Dynamic dynamic = new Dynamic(ops, ops.createMap((Map)ImmutableMap.of((Object)ops.createString("height_interval"), (Object)ops.createInt(this.field_227275_a_), (Object)ops.createString("crown_height"), (Object)ops.createInt(this.field_227276_b_))));
        return dynamic.merge(super.func_214634_a(ops));
    }

    @Override
    protected HugeTreeFeatureConfig setSapling(IPlantable value) {
        super.setSapling(value);
        return this;
    }

    public static <T> HugeTreeFeatureConfig func_227277_a_(Dynamic<T> p_227277_0_) {
        BaseTreeFeatureConfig basetreefeatureconfig = BaseTreeFeatureConfig.func_227376_b_(p_227277_0_);
        return new HugeTreeFeatureConfig(basetreefeatureconfig.field_227368_m_, basetreefeatureconfig.field_227369_n_, basetreefeatureconfig.field_227370_o_, basetreefeatureconfig.field_227371_p_, p_227277_0_.get("height_interval").asInt(0), p_227277_0_.get("crown_height").asInt(0));
    }

    public static <T> HugeTreeFeatureConfig deserializeDarkOak(Dynamic<T> data) {
        return HugeTreeFeatureConfig.func_227277_a_(data).setSapling((IPlantable)Blocks.field_196680_y);
    }

    public static <T> HugeTreeFeatureConfig deserializeSpruce(Dynamic<T> data) {
        return HugeTreeFeatureConfig.func_227277_a_(data).setSapling((IPlantable)Blocks.field_196675_u);
    }

    public static <T> HugeTreeFeatureConfig deserializeJungle(Dynamic<T> data) {
        return HugeTreeFeatureConfig.func_227277_a_(data).setSapling((IPlantable)Blocks.field_196678_w);
    }

    public static class Builder
    extends BaseTreeFeatureConfig.Builder {
        private List<TreeDecorator> field_227278_c_ = ImmutableList.of();
        private int field_227279_d_;
        private int field_227280_e_;
        private int field_227281_f_;

        public Builder(BlockStateProvider trunkProviderIn, BlockStateProvider leavesProviderIn) {
            super(trunkProviderIn, leavesProviderIn);
        }

        public Builder func_227282_a_(List<TreeDecorator> p_227282_1_) {
            this.field_227278_c_ = p_227282_1_;
            return this;
        }

        @Override
        public Builder func_225569_d_(int baseHeightIn) {
            this.field_227279_d_ = baseHeightIn;
            return this;
        }

        public Builder func_227283_b_(int heightIntervalIn) {
            this.field_227280_e_ = heightIntervalIn;
            return this;
        }

        public Builder func_227284_c_(int crownHeightIn) {
            this.field_227281_f_ = crownHeightIn;
            return this;
        }

        @Override
        public Builder setSapling(IPlantable value) {
            super.setSapling(value);
            return this;
        }

        @Override
        public HugeTreeFeatureConfig func_225568_b_() {
            return new HugeTreeFeatureConfig(this.field_227377_a_, this.field_227378_b_, this.field_227278_c_, this.field_227279_d_, this.field_227280_e_, this.field_227281_f_).setSapling(this.sapling);
        }
    }
}

