/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.RailBlock;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.minecart.ChestMinecartEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.MineshaftStructure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTables;

public class MineshaftPieces {
    private static Piece func_189940_a(List<StructurePiece> p_189940_0_, Random p_189940_1_, int p_189940_2_, int p_189940_3_, int p_189940_4_, @Nullable Direction p_189940_5_, int p_189940_6_, MineshaftStructure.Type p_189940_7_) {
        int i = p_189940_1_.nextInt(100);
        if (i >= 80) {
            MutableBoundingBox mutableboundingbox = Cross.func_175813_a(p_189940_0_, p_189940_1_, p_189940_2_, p_189940_3_, p_189940_4_, p_189940_5_);
            if (mutableboundingbox != null) {
                return new Cross(p_189940_6_, mutableboundingbox, p_189940_5_, p_189940_7_);
            }
        } else if (i >= 70) {
            MutableBoundingBox mutableboundingbox1 = Stairs.func_175812_a(p_189940_0_, p_189940_1_, p_189940_2_, p_189940_3_, p_189940_4_, p_189940_5_);
            if (mutableboundingbox1 != null) {
                return new Stairs(p_189940_6_, mutableboundingbox1, p_189940_5_, p_189940_7_);
            }
        } else {
            MutableBoundingBox mutableboundingbox2 = Corridor.func_175814_a(p_189940_0_, p_189940_1_, p_189940_2_, p_189940_3_, p_189940_4_, p_189940_5_);
            if (mutableboundingbox2 != null) {
                return new Corridor(p_189940_6_, p_189940_1_, mutableboundingbox2, p_189940_5_, p_189940_7_);
            }
        }
        return null;
    }

    private static Piece func_189938_b(StructurePiece p_189938_0_, List<StructurePiece> p_189938_1_, Random p_189938_2_, int p_189938_3_, int p_189938_4_, int p_189938_5_, Direction p_189938_6_, int p_189938_7_) {
        if (p_189938_7_ > 8) {
            return null;
        }
        if (Math.abs(p_189938_3_ - p_189938_0_.func_74874_b().field_78897_a) <= 80 && Math.abs(p_189938_5_ - p_189938_0_.func_74874_b().field_78896_c) <= 80) {
            MineshaftStructure.Type mineshaftstructure$type = ((Piece)p_189938_0_).field_189920_a;
            Piece mineshaftpieces$piece = MineshaftPieces.func_189940_a(p_189938_1_, p_189938_2_, p_189938_3_, p_189938_4_, p_189938_5_, p_189938_6_, p_189938_7_ + 1, mineshaftstructure$type);
            if (mineshaftpieces$piece != null) {
                p_189938_1_.add(mineshaftpieces$piece);
                mineshaftpieces$piece.func_74861_a(p_189938_0_, p_189938_1_, p_189938_2_);
            }
            return mineshaftpieces$piece;
        }
        return null;
    }

    public static class Stairs
    extends Piece {
        public Stairs(int p_i50449_1_, MutableBoundingBox p_i50449_2_, Direction p_i50449_3_, MineshaftStructure.Type p_i50449_4_) {
            super(IStructurePieceType.field_214783_d, p_i50449_1_, p_i50449_4_);
            this.func_186164_a(p_i50449_3_);
            this.field_74887_e = p_i50449_2_;
        }

        public Stairs(TemplateManager p_i50450_1_, CompoundNBT p_i50450_2_) {
            super(IStructurePieceType.field_214783_d, p_i50450_2_);
        }

        public static MutableBoundingBox func_175812_a(List<StructurePiece> listIn, Random rand, int x, int y, int z, Direction facing) {
            MutableBoundingBox mutableboundingbox = new MutableBoundingBox(x, y - 5, z, x, y + 3 - 1, z);
            switch (facing) {
                default: {
                    mutableboundingbox.field_78893_d = x + 3 - 1;
                    mutableboundingbox.field_78896_c = z - 8;
                    break;
                }
                case SOUTH: {
                    mutableboundingbox.field_78893_d = x + 3 - 1;
                    mutableboundingbox.field_78892_f = z + 8;
                    break;
                }
                case WEST: {
                    mutableboundingbox.field_78897_a = x - 8;
                    mutableboundingbox.field_78892_f = z + 3 - 1;
                    break;
                }
                case EAST: {
                    mutableboundingbox.field_78893_d = x + 8;
                    mutableboundingbox.field_78892_f = z + 3 - 1;
                }
            }
            return StructurePiece.func_74883_a(listIn, mutableboundingbox) != null ? null : mutableboundingbox;
        }

        @Override
        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            int i = this.func_74877_c();
            Direction direction = this.func_186165_e();
            if (direction != null) {
                switch (direction) {
                    default: {
                        MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, Direction.NORTH, i);
                        break;
                    }
                    case SOUTH: {
                        MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i);
                        break;
                    }
                    case WEST: {
                        MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, Direction.WEST, i);
                        break;
                    }
                    case EAST: {
                        MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, Direction.EAST, i);
                    }
                }
            }
        }

        @Override
        public boolean func_225577_a_(IWorld worldIn, ChunkGenerator<?> chunkGeneratorIn, Random randomIn, MutableBoundingBox mutableBoundingBoxIn, ChunkPos chunkPosIn) {
            if (this.func_74860_a((IBlockReader)((Object)worldIn), mutableBoundingBoxIn)) {
                return false;
            }
            this.func_175804_a(worldIn, mutableBoundingBoxIn, 0, 5, 0, 2, 7, 1, field_202556_l, field_202556_l, false);
            this.func_175804_a(worldIn, mutableBoundingBoxIn, 0, 0, 7, 2, 2, 8, field_202556_l, field_202556_l, false);
            for (int i = 0; i < 5; ++i) {
                this.func_175804_a(worldIn, mutableBoundingBoxIn, 0, 5 - i - (i < 4 ? 1 : 0), 2 + i, 2, 7 - i, 2 + i, field_202556_l, field_202556_l, false);
            }
            return true;
        }
    }

    public static class Room
    extends Piece {
        private final List<MutableBoundingBox> field_74949_a = Lists.newLinkedList();

        public Room(int p_i47137_1_, Random p_i47137_2_, int p_i47137_3_, int p_i47137_4_, MineshaftStructure.Type typeIn) {
            super(IStructurePieceType.field_214782_c, p_i47137_1_, typeIn);
            this.field_189920_a = typeIn;
            this.field_74887_e = new MutableBoundingBox(p_i47137_3_, 50, p_i47137_4_, p_i47137_3_ + 7 + p_i47137_2_.nextInt(6), 54 + p_i47137_2_.nextInt(6), p_i47137_4_ + 7 + p_i47137_2_.nextInt(6));
        }

        public Room(TemplateManager templateManagerIn, CompoundNBT nbt) {
            super(IStructurePieceType.field_214782_c, nbt);
            ListNBT listnbt = nbt.func_150295_c("Entrances", 11);
            for (int i = 0; i < listnbt.size(); ++i) {
                this.field_74949_a.add(new MutableBoundingBox(listnbt.func_150306_c(i)));
            }
        }

        @Override
        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            int k;
            int i = this.func_74877_c();
            int j = this.field_74887_e.func_78882_c() - 3 - 1;
            if (j <= 0) {
                j = 1;
            }
            for (k = 0; k < this.field_74887_e.func_78883_b() && (k += rand.nextInt(this.field_74887_e.func_78883_b())) + 3 <= this.field_74887_e.func_78883_b(); k += 4) {
                Piece mineshaftpieces$piece = MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a + k, this.field_74887_e.field_78895_b + rand.nextInt(j) + 1, this.field_74887_e.field_78896_c - 1, Direction.NORTH, i);
                if (mineshaftpieces$piece == null) continue;
                MutableBoundingBox mutableboundingbox = mineshaftpieces$piece.func_74874_b();
                this.field_74949_a.add(new MutableBoundingBox(mutableboundingbox.field_78897_a, mutableboundingbox.field_78895_b, this.field_74887_e.field_78896_c, mutableboundingbox.field_78893_d, mutableboundingbox.field_78894_e, this.field_74887_e.field_78896_c + 1));
            }
            for (k = 0; k < this.field_74887_e.func_78883_b() && (k += rand.nextInt(this.field_74887_e.func_78883_b())) + 3 <= this.field_74887_e.func_78883_b(); k += 4) {
                Piece mineshaftpieces$piece1 = MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a + k, this.field_74887_e.field_78895_b + rand.nextInt(j) + 1, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i);
                if (mineshaftpieces$piece1 == null) continue;
                MutableBoundingBox mutableboundingbox1 = mineshaftpieces$piece1.func_74874_b();
                this.field_74949_a.add(new MutableBoundingBox(mutableboundingbox1.field_78897_a, mutableboundingbox1.field_78895_b, this.field_74887_e.field_78892_f - 1, mutableboundingbox1.field_78893_d, mutableboundingbox1.field_78894_e, this.field_74887_e.field_78892_f));
            }
            for (k = 0; k < this.field_74887_e.func_78880_d() && (k += rand.nextInt(this.field_74887_e.func_78880_d())) + 3 <= this.field_74887_e.func_78880_d(); k += 4) {
                Piece mineshaftpieces$piece2 = MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + rand.nextInt(j) + 1, this.field_74887_e.field_78896_c + k, Direction.WEST, i);
                if (mineshaftpieces$piece2 == null) continue;
                MutableBoundingBox mutableboundingbox2 = mineshaftpieces$piece2.func_74874_b();
                this.field_74949_a.add(new MutableBoundingBox(this.field_74887_e.field_78897_a, mutableboundingbox2.field_78895_b, mutableboundingbox2.field_78896_c, this.field_74887_e.field_78897_a + 1, mutableboundingbox2.field_78894_e, mutableboundingbox2.field_78892_f));
            }
            for (k = 0; k < this.field_74887_e.func_78880_d() && (k += rand.nextInt(this.field_74887_e.func_78880_d())) + 3 <= this.field_74887_e.func_78880_d(); k += 4) {
                Piece structurepiece = MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + rand.nextInt(j) + 1, this.field_74887_e.field_78896_c + k, Direction.EAST, i);
                if (structurepiece == null) continue;
                MutableBoundingBox mutableboundingbox3 = structurepiece.func_74874_b();
                this.field_74949_a.add(new MutableBoundingBox(this.field_74887_e.field_78893_d - 1, mutableboundingbox3.field_78895_b, mutableboundingbox3.field_78896_c, this.field_74887_e.field_78893_d, mutableboundingbox3.field_78894_e, mutableboundingbox3.field_78892_f));
            }
        }

        @Override
        public boolean func_225577_a_(IWorld worldIn, ChunkGenerator<?> chunkGeneratorIn, Random randomIn, MutableBoundingBox mutableBoundingBoxIn, ChunkPos chunkPosIn) {
            if (this.func_74860_a((IBlockReader)((Object)worldIn), mutableBoundingBoxIn)) {
                return false;
            }
            this.func_175804_a(worldIn, mutableBoundingBoxIn, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f, Blocks.field_150346_d.func_176223_P(), field_202556_l, true);
            this.func_175804_a(worldIn, mutableBoundingBoxIn, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 1, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, Math.min(this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78894_e), this.field_74887_e.field_78892_f, field_202556_l, field_202556_l, false);
            for (MutableBoundingBox mutableboundingbox : this.field_74949_a) {
                this.func_175804_a(worldIn, mutableBoundingBoxIn, mutableboundingbox.field_78897_a, mutableboundingbox.field_78894_e - 2, mutableboundingbox.field_78896_c, mutableboundingbox.field_78893_d, mutableboundingbox.field_78894_e, mutableboundingbox.field_78892_f, field_202556_l, field_202556_l, false);
            }
            this.func_180777_a(worldIn, mutableBoundingBoxIn, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 4, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, field_202556_l, false);
            return true;
        }

        @Override
        public void func_181138_a(int x, int y, int z) {
            super.func_181138_a(x, y, z);
            for (MutableBoundingBox mutableboundingbox : this.field_74949_a) {
                mutableboundingbox.func_78886_a(x, y, z);
            }
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            ListNBT listnbt = new ListNBT();
            for (MutableBoundingBox mutableboundingbox : this.field_74949_a) {
                listnbt.add((Object)mutableboundingbox.func_151535_h());
            }
            tagCompound.func_218657_a("Entrances", (INBT)listnbt);
        }
    }

    static abstract class Piece
    extends StructurePiece {
        protected MineshaftStructure.Type field_189920_a;

        public Piece(IStructurePieceType structurePieceTypeIn, int componentTypeIn, MineshaftStructure.Type typeIn) {
            super(structurePieceTypeIn, componentTypeIn);
            this.field_189920_a = typeIn;
        }

        public Piece(IStructurePieceType structurePieceTypeIn, CompoundNBT nbt) {
            super(structurePieceTypeIn, nbt);
            this.field_189920_a = MineshaftStructure.Type.func_189910_a((int)nbt.func_74762_e("MST"));
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            tagCompound.func_74768_a("MST", this.field_189920_a.ordinal());
        }

        protected BlockState func_189917_F_() {
            switch (this.field_189920_a) {
                default: {
                    return Blocks.field_196662_n.func_176223_P();
                }
                case MESA: 
            }
            return Blocks.field_196672_s.func_176223_P();
        }

        protected BlockState func_189919_b() {
            switch (this.field_189920_a) {
                default: {
                    return Blocks.field_180407_aO.func_176223_P();
                }
                case MESA: 
            }
            return Blocks.field_180406_aS.func_176223_P();
        }

        protected boolean func_189918_a(IBlockReader blockReaderIn, MutableBoundingBox boundsIn, int xStartIn, int xEndIn, int p_189918_5_, int zIn) {
            for (int i = xStartIn; i <= xEndIn; ++i) {
                if (!this.func_175807_a(blockReaderIn, i, p_189918_5_ + 1, zIn, boundsIn).func_196958_f()) continue;
                return false;
            }
            return true;
        }
    }

    public static class Cross
    extends Piece {
        private final Direction field_74953_a;
        private final boolean field_74952_b;

        public Cross(TemplateManager p_i50454_1_, CompoundNBT p_i50454_2_) {
            super(IStructurePieceType.field_214781_b, p_i50454_2_);
            this.field_74952_b = p_i50454_2_.func_74767_n("tf");
            this.field_74953_a = Direction.func_176731_b(p_i50454_2_.func_74762_e("D"));
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74757_a("tf", this.field_74952_b);
            tagCompound.func_74768_a("D", this.field_74953_a.func_176736_b());
        }

        public Cross(int p_i50455_1_, MutableBoundingBox p_i50455_2_, @Nullable Direction p_i50455_3_, MineshaftStructure.Type p_i50455_4_) {
            super(IStructurePieceType.field_214781_b, p_i50455_1_, p_i50455_4_);
            this.field_74953_a = p_i50455_3_;
            this.field_74887_e = p_i50455_2_;
            this.field_74952_b = p_i50455_2_.func_78882_c() > 3;
        }

        public static MutableBoundingBox func_175813_a(List<StructurePiece> listIn, Random rand, int x, int y, int z, Direction facing) {
            MutableBoundingBox mutableboundingbox = new MutableBoundingBox(x, y, z, x, y + 3 - 1, z);
            if (rand.nextInt(4) == 0) {
                mutableboundingbox.field_78894_e += 4;
            }
            switch (facing) {
                default: {
                    mutableboundingbox.field_78897_a = x - 1;
                    mutableboundingbox.field_78893_d = x + 3;
                    mutableboundingbox.field_78896_c = z - 4;
                    break;
                }
                case SOUTH: {
                    mutableboundingbox.field_78897_a = x - 1;
                    mutableboundingbox.field_78893_d = x + 3;
                    mutableboundingbox.field_78892_f = z + 3 + 1;
                    break;
                }
                case WEST: {
                    mutableboundingbox.field_78897_a = x - 4;
                    mutableboundingbox.field_78896_c = z - 1;
                    mutableboundingbox.field_78892_f = z + 3;
                    break;
                }
                case EAST: {
                    mutableboundingbox.field_78893_d = x + 3 + 1;
                    mutableboundingbox.field_78896_c = z - 1;
                    mutableboundingbox.field_78892_f = z + 3;
                }
            }
            return StructurePiece.func_74883_a(listIn, mutableboundingbox) != null ? null : mutableboundingbox;
        }

        @Override
        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            int i = this.func_74877_c();
            switch (this.field_74953_a) {
                default: {
                    MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, Direction.NORTH, i);
                    MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.WEST, i);
                    MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.EAST, i);
                    break;
                }
                case SOUTH: {
                    MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i);
                    MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.WEST, i);
                    MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.EAST, i);
                    break;
                }
                case WEST: {
                    MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, Direction.NORTH, i);
                    MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i);
                    MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.WEST, i);
                    break;
                }
                case EAST: {
                    MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, Direction.NORTH, i);
                    MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i);
                    MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.EAST, i);
                }
            }
            if (this.field_74952_b) {
                if (rand.nextBoolean()) {
                    MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c - 1, Direction.NORTH, i);
                }
                if (rand.nextBoolean()) {
                    MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c + 1, Direction.WEST, i);
                }
                if (rand.nextBoolean()) {
                    MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c + 1, Direction.EAST, i);
                }
                if (rand.nextBoolean()) {
                    MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i);
                }
            }
        }

        @Override
        public boolean func_225577_a_(IWorld worldIn, ChunkGenerator<?> chunkGeneratorIn, Random randomIn, MutableBoundingBox mutableBoundingBoxIn, ChunkPos chunkPosIn) {
            if (this.func_74860_a((IBlockReader)((Object)worldIn), mutableBoundingBoxIn)) {
                return false;
            }
            BlockState blockstate = this.func_189917_F_();
            if (this.field_74952_b) {
                this.func_175804_a(worldIn, mutableBoundingBoxIn, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b + 3 - 1, this.field_74887_e.field_78892_f, field_202556_l, field_202556_l, false);
                this.func_175804_a(worldIn, mutableBoundingBoxIn, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b + 3 - 1, this.field_74887_e.field_78892_f - 1, field_202556_l, field_202556_l, false);
                this.func_175804_a(worldIn, mutableBoundingBoxIn, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e - 2, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, field_202556_l, field_202556_l, false);
                this.func_175804_a(worldIn, mutableBoundingBoxIn, this.field_74887_e.field_78897_a, this.field_74887_e.field_78894_e - 2, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f - 1, field_202556_l, field_202556_l, false);
                this.func_175804_a(worldIn, mutableBoundingBoxIn, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78892_f - 1, field_202556_l, field_202556_l, false);
            } else {
                this.func_175804_a(worldIn, mutableBoundingBoxIn, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, field_202556_l, field_202556_l, false);
                this.func_175804_a(worldIn, mutableBoundingBoxIn, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f - 1, field_202556_l, field_202556_l, false);
            }
            this.func_189923_b(worldIn, mutableBoundingBoxIn, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78894_e);
            this.func_189923_b(worldIn, mutableBoundingBoxIn, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 1, this.field_74887_e.field_78894_e);
            this.func_189923_b(worldIn, mutableBoundingBoxIn, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78894_e);
            this.func_189923_b(worldIn, mutableBoundingBoxIn, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 1, this.field_74887_e.field_78894_e);
            for (int i = this.field_74887_e.field_78897_a; i <= this.field_74887_e.field_78893_d; ++i) {
                for (int j = this.field_74887_e.field_78896_c; j <= this.field_74887_e.field_78892_f; ++j) {
                    if (!this.func_175807_a((IBlockReader)((Object)worldIn), i, this.field_74887_e.field_78895_b - 1, j, mutableBoundingBoxIn).func_196958_f() || !this.func_189916_b(worldIn, i, this.field_74887_e.field_78895_b - 1, j, mutableBoundingBoxIn)) continue;
                    this.func_175811_a(worldIn, blockstate, i, this.field_74887_e.field_78895_b - 1, j, mutableBoundingBoxIn);
                }
            }
            return true;
        }

        private void func_189923_b(IWorld p_189923_1_, MutableBoundingBox p_189923_2_, int p_189923_3_, int p_189923_4_, int p_189923_5_, int p_189923_6_) {
            if (!this.func_175807_a((IBlockReader)((Object)p_189923_1_), p_189923_3_, p_189923_6_ + 1, p_189923_5_, p_189923_2_).func_196958_f()) {
                this.func_175804_a(p_189923_1_, p_189923_2_, p_189923_3_, p_189923_4_, p_189923_5_, p_189923_3_, p_189923_6_, p_189923_5_, this.func_189917_F_(), field_202556_l, false);
            }
        }
    }

    public static class Corridor
    extends Piece {
        private final boolean field_74958_a;
        private final boolean field_74956_b;
        private boolean field_74957_c;
        private final int field_74955_d;

        public Corridor(TemplateManager p_i50456_1_, CompoundNBT p_i50456_2_) {
            super(IStructurePieceType.field_214780_a, p_i50456_2_);
            this.field_74958_a = p_i50456_2_.func_74767_n("hr");
            this.field_74956_b = p_i50456_2_.func_74767_n("sc");
            this.field_74957_c = p_i50456_2_.func_74767_n("hps");
            this.field_74955_d = p_i50456_2_.func_74762_e("Num");
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74757_a("hr", this.field_74958_a);
            tagCompound.func_74757_a("sc", this.field_74956_b);
            tagCompound.func_74757_a("hps", this.field_74957_c);
            tagCompound.func_74768_a("Num", this.field_74955_d);
        }

        public Corridor(int p_i47140_1_, Random p_i47140_2_, MutableBoundingBox p_i47140_3_, Direction p_i47140_4_, MineshaftStructure.Type p_i47140_5_) {
            super(IStructurePieceType.field_214780_a, p_i47140_1_, p_i47140_5_);
            this.func_186164_a(p_i47140_4_);
            this.field_74887_e = p_i47140_3_;
            this.field_74958_a = p_i47140_2_.nextInt(3) == 0;
            this.field_74956_b = !this.field_74958_a && p_i47140_2_.nextInt(23) == 0;
            this.field_74955_d = this.func_186165_e().func_176740_k() == Direction.Axis.Z ? p_i47140_3_.func_78880_d() / 5 : p_i47140_3_.func_78883_b() / 5;
        }

        public static MutableBoundingBox func_175814_a(List<StructurePiece> p_175814_0_, Random rand, int x, int y, int z, Direction facing) {
            int i;
            MutableBoundingBox mutableboundingbox = new MutableBoundingBox(x, y, z, x, y + 3 - 1, z);
            for (i = rand.nextInt(3) + 2; i > 0; --i) {
                int j = i * 5;
                switch (facing) {
                    default: {
                        mutableboundingbox.field_78893_d = x + 3 - 1;
                        mutableboundingbox.field_78896_c = z - (j - 1);
                        break;
                    }
                    case SOUTH: {
                        mutableboundingbox.field_78893_d = x + 3 - 1;
                        mutableboundingbox.field_78892_f = z + j - 1;
                        break;
                    }
                    case WEST: {
                        mutableboundingbox.field_78897_a = x - (j - 1);
                        mutableboundingbox.field_78892_f = z + 3 - 1;
                        break;
                    }
                    case EAST: {
                        mutableboundingbox.field_78893_d = x + j - 1;
                        mutableboundingbox.field_78892_f = z + 3 - 1;
                    }
                }
                if (StructurePiece.func_74883_a(p_175814_0_, mutableboundingbox) == null) break;
            }
            return i > 0 ? mutableboundingbox : null;
        }

        @Override
        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            block24: {
                int i = this.func_74877_c();
                int j = rand.nextInt(4);
                Direction direction = this.func_186165_e();
                if (direction != null) {
                    switch (direction) {
                        default: {
                            if (j <= 1) {
                                MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c - 1, direction, i);
                                break;
                            }
                            if (j == 2) {
                                MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c, Direction.WEST, i);
                                break;
                            }
                            MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c, Direction.EAST, i);
                            break;
                        }
                        case SOUTH: {
                            if (j <= 1) {
                                MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f + 1, direction, i);
                                break;
                            }
                            if (j == 2) {
                                MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f - 3, Direction.WEST, i);
                                break;
                            }
                            MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f - 3, Direction.EAST, i);
                            break;
                        }
                        case WEST: {
                            if (j <= 1) {
                                MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c, direction, i);
                                break;
                            }
                            if (j == 2) {
                                MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c - 1, Direction.NORTH, i);
                                break;
                            }
                            MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i);
                            break;
                        }
                        case EAST: {
                            if (j <= 1) {
                                MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c, direction, i);
                                break;
                            }
                            if (j == 2) {
                                MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78893_d - 3, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c - 1, Direction.NORTH, i);
                                break;
                            }
                            MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78893_d - 3, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i);
                        }
                    }
                }
                if (i >= 8) break block24;
                if (direction != Direction.NORTH && direction != Direction.SOUTH) {
                    int i1 = this.field_74887_e.field_78897_a + 3;
                    while (i1 + 3 <= this.field_74887_e.field_78893_d) {
                        int j1 = rand.nextInt(5);
                        if (j1 == 0) {
                            MineshaftPieces.func_189938_b(componentIn, listIn, rand, i1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, Direction.NORTH, i + 1);
                        } else if (j1 == 1) {
                            MineshaftPieces.func_189938_b(componentIn, listIn, rand, i1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, i + 1);
                        }
                        i1 += 5;
                    }
                } else {
                    int k = this.field_74887_e.field_78896_c + 3;
                    while (k + 3 <= this.field_74887_e.field_78892_f) {
                        int l = rand.nextInt(5);
                        if (l == 0) {
                            MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, k, Direction.WEST, i + 1);
                        } else if (l == 1) {
                            MineshaftPieces.func_189938_b(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, k, Direction.EAST, i + 1);
                        }
                        k += 5;
                    }
                }
            }
        }

        @Override
        protected boolean func_186167_a(IWorld worldIn, MutableBoundingBox structurebb, Random randomIn, int x, int y, int z, ResourceLocation loot) {
            BlockPos blockpos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
            if (structurebb.func_175898_b((Vec3i)blockpos) && worldIn.func_180495_p(blockpos).isAir((IBlockReader)((Object)worldIn), blockpos) && !worldIn.func_180495_p(blockpos.func_177977_b()).isAir((IBlockReader)((Object)worldIn), blockpos.func_177977_b())) {
                BlockState blockstate = (BlockState)((Object)Blocks.field_150448_aq.func_176223_P().func_206870_a((IProperty)RailBlock.field_176565_b, (Comparable)(randomIn.nextBoolean() ? RailShape.NORTH_SOUTH : RailShape.EAST_WEST)));
                this.func_175811_a(worldIn, blockstate, x, y, z, structurebb);
                ChestMinecartEntity chestminecartentity = new ChestMinecartEntity(worldIn.func_201672_e(), (double)((float)blockpos.func_177958_n() + 0.5f), (double)((float)blockpos.func_177956_o() + 0.5f), (double)((float)blockpos.func_177952_p() + 0.5f));
                chestminecartentity.func_184289_a(loot, randomIn.nextLong());
                worldIn.func_217376_c((Entity)chestminecartentity);
                return true;
            }
            return false;
        }

        @Override
        public boolean func_225577_a_(IWorld worldIn, ChunkGenerator<?> chunkGeneratorIn, Random randomIn, MutableBoundingBox mutableBoundingBoxIn, ChunkPos chunkPosIn) {
            if (this.func_74860_a((IBlockReader)((Object)worldIn), mutableBoundingBoxIn)) {
                return false;
            }
            boolean i = false;
            int j = 2;
            boolean k = false;
            int l = 2;
            int i1 = this.field_74955_d * 5 - 1;
            BlockState blockstate = this.func_189917_F_();
            this.func_175804_a(worldIn, mutableBoundingBoxIn, 0, 0, 0, 2, 1, i1, field_202556_l, field_202556_l, false);
            this.func_189914_a(worldIn, mutableBoundingBoxIn, randomIn, 0.8f, 0, 2, 0, 2, 2, i1, field_202556_l, field_202556_l, false, false);
            if (this.field_74956_b) {
                this.func_189914_a(worldIn, mutableBoundingBoxIn, randomIn, 0.6f, 0, 0, 0, 2, 1, i1, Blocks.field_196553_aF.func_176223_P(), field_202556_l, false, true);
            }
            for (int j1 = 0; j1 < this.field_74955_d; ++j1) {
                int k2;
                int k1 = 2 + j1 * 5;
                this.func_189921_a(worldIn, mutableBoundingBoxIn, 0, 0, k1, 2, 2, randomIn);
                this.func_189922_a(worldIn, mutableBoundingBoxIn, randomIn, 0.1f, 0, 2, k1 - 1);
                this.func_189922_a(worldIn, mutableBoundingBoxIn, randomIn, 0.1f, 2, 2, k1 - 1);
                this.func_189922_a(worldIn, mutableBoundingBoxIn, randomIn, 0.1f, 0, 2, k1 + 1);
                this.func_189922_a(worldIn, mutableBoundingBoxIn, randomIn, 0.1f, 2, 2, k1 + 1);
                this.func_189922_a(worldIn, mutableBoundingBoxIn, randomIn, 0.05f, 0, 2, k1 - 2);
                this.func_189922_a(worldIn, mutableBoundingBoxIn, randomIn, 0.05f, 2, 2, k1 - 2);
                this.func_189922_a(worldIn, mutableBoundingBoxIn, randomIn, 0.05f, 0, 2, k1 + 2);
                this.func_189922_a(worldIn, mutableBoundingBoxIn, randomIn, 0.05f, 2, 2, k1 + 2);
                if (randomIn.nextInt(100) == 0) {
                    this.func_186167_a(worldIn, mutableBoundingBoxIn, randomIn, 2, 0, k1 - 1, LootTables.field_186424_f);
                }
                if (randomIn.nextInt(100) == 0) {
                    this.func_186167_a(worldIn, mutableBoundingBoxIn, randomIn, 0, 0, k1 + 1, LootTables.field_186424_f);
                }
                if (!this.field_74956_b || this.field_74957_c) continue;
                int l1 = this.func_74862_a(0);
                int i2 = k1 - 1 + randomIn.nextInt(3);
                int j2 = this.func_74865_a(1, i2);
                BlockPos blockpos = new BlockPos(j2, l1, k2 = this.func_74873_b(1, i2));
                if (!mutableBoundingBoxIn.func_175898_b((Vec3i)blockpos) || !this.func_189916_b(worldIn, 1, 0, i2, mutableBoundingBoxIn)) continue;
                this.field_74957_c = true;
                worldIn.func_180501_a(blockpos, Blocks.field_150474_ac.func_176223_P(), 2);
                TileEntity tileentity = worldIn.func_175625_s(blockpos);
                if (!(tileentity instanceof MobSpawnerTileEntity)) continue;
                ((MobSpawnerTileEntity)tileentity).func_145881_a().func_200876_a(EntityType.field_200794_h);
            }
            for (int l2 = 0; l2 <= 2; ++l2) {
                for (int i3 = 0; i3 <= i1; ++i3) {
                    int k3 = -1;
                    BlockState blockstate3 = this.func_175807_a((IBlockReader)((Object)worldIn), l2, -1, i3, mutableBoundingBoxIn);
                    if (!blockstate3.func_196958_f() || !this.func_189916_b(worldIn, l2, -1, i3, mutableBoundingBoxIn)) continue;
                    int l3 = -1;
                    this.func_175811_a(worldIn, blockstate, l2, -1, i3, mutableBoundingBoxIn);
                }
            }
            if (this.field_74958_a) {
                BlockState blockstate1 = (BlockState)((Object)Blocks.field_150448_aq.func_176223_P().func_206870_a((IProperty)RailBlock.field_176565_b, (Comparable)RailShape.NORTH_SOUTH));
                for (int j3 = 0; j3 <= i1; ++j3) {
                    BlockState blockstate2 = this.func_175807_a((IBlockReader)((Object)worldIn), 1, -1, j3, mutableBoundingBoxIn);
                    if (blockstate2.func_196958_f() || !blockstate2.func_200015_d((IBlockReader)((Object)worldIn), new BlockPos(this.func_74865_a(1, j3), this.func_74862_a(-1), this.func_74873_b(1, j3)))) continue;
                    float f = this.func_189916_b(worldIn, 1, 0, j3, mutableBoundingBoxIn) ? 0.7f : 0.9f;
                    this.func_175809_a(worldIn, mutableBoundingBoxIn, randomIn, f, 1, 0, j3, blockstate1);
                }
            }
            return true;
        }

        private void func_189921_a(IWorld p_189921_1_, MutableBoundingBox p_189921_2_, int p_189921_3_, int p_189921_4_, int p_189921_5_, int p_189921_6_, int p_189921_7_, Random p_189921_8_) {
            if (this.func_189918_a((IBlockReader)((Object)p_189921_1_), p_189921_2_, p_189921_3_, p_189921_7_, p_189921_6_, p_189921_5_)) {
                BlockState blockstate = this.func_189917_F_();
                BlockState blockstate1 = this.func_189919_b();
                this.func_175804_a(p_189921_1_, p_189921_2_, p_189921_3_, p_189921_4_, p_189921_5_, p_189921_3_, p_189921_6_ - 1, p_189921_5_, (BlockState)((Object)blockstate1.func_206870_a((IProperty)FenceBlock.field_196414_y, Boolean.valueOf(true))), field_202556_l, false);
                this.func_175804_a(p_189921_1_, p_189921_2_, p_189921_7_, p_189921_4_, p_189921_5_, p_189921_7_, p_189921_6_ - 1, p_189921_5_, (BlockState)((Object)blockstate1.func_206870_a((IProperty)FenceBlock.field_196411_b, Boolean.valueOf(true))), field_202556_l, false);
                if (p_189921_8_.nextInt(4) == 0) {
                    this.func_175804_a(p_189921_1_, p_189921_2_, p_189921_3_, p_189921_6_, p_189921_5_, p_189921_3_, p_189921_6_, p_189921_5_, blockstate, field_202556_l, false);
                    this.func_175804_a(p_189921_1_, p_189921_2_, p_189921_7_, p_189921_6_, p_189921_5_, p_189921_7_, p_189921_6_, p_189921_5_, blockstate, field_202556_l, false);
                } else {
                    this.func_175804_a(p_189921_1_, p_189921_2_, p_189921_3_, p_189921_6_, p_189921_5_, p_189921_7_, p_189921_6_, p_189921_5_, blockstate, field_202556_l, false);
                    this.func_175809_a(p_189921_1_, p_189921_2_, p_189921_8_, 0.05f, p_189921_3_ + 1, p_189921_6_, p_189921_5_ - 1, (BlockState)((Object)Blocks.field_196591_bQ.func_176223_P().func_206870_a((IProperty)WallTorchBlock.field_196532_a, (Comparable)((Object)Direction.NORTH))));
                    this.func_175809_a(p_189921_1_, p_189921_2_, p_189921_8_, 0.05f, p_189921_3_ + 1, p_189921_6_, p_189921_5_ + 1, (BlockState)((Object)Blocks.field_196591_bQ.func_176223_P().func_206870_a((IProperty)WallTorchBlock.field_196532_a, (Comparable)((Object)Direction.SOUTH))));
                }
            }
        }

        private void func_189922_a(IWorld p_189922_1_, MutableBoundingBox p_189922_2_, Random p_189922_3_, float p_189922_4_, int p_189922_5_, int p_189922_6_, int p_189922_7_) {
            if (this.func_189916_b(p_189922_1_, p_189922_5_, p_189922_6_, p_189922_7_, p_189922_2_)) {
                this.func_175809_a(p_189922_1_, p_189922_2_, p_189922_3_, p_189922_4_, p_189922_5_, p_189922_6_, p_189922_7_, Blocks.field_196553_aF.func_176223_P());
            }
        }
    }
}

