/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.mojang.datafixers.DataFixer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.storage.IPlayerFileData;
import net.minecraft.world.storage.SaveFormat;
import net.minecraft.world.storage.SessionLockException;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.WorldPersistenceHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SaveHandler
implements IPlayerFileData {
    private static final Logger field_215773_b = LogManager.getLogger();
    private final File field_215774_c;
    private final File field_215775_d;
    private final long field_215776_e = Util.func_211177_b();
    private final String field_215777_f;
    private final TemplateManager field_215778_g;
    protected final DataFixer field_215772_a;

    public SaveHandler(File p_i51278_1_, String p_i51278_2_, @Nullable MinecraftServer p_i51278_3_, DataFixer p_i51278_4_) {
        this.field_215772_a = p_i51278_4_;
        this.field_215774_c = new File(p_i51278_1_, p_i51278_2_);
        this.field_215774_c.mkdirs();
        this.field_215775_d = new File(this.field_215774_c, "playerdata");
        this.field_215777_f = p_i51278_2_;
        if (p_i51278_3_ != null) {
            this.field_215775_d.mkdirs();
            this.field_215778_g = new TemplateManager(p_i51278_3_, this.field_215774_c, p_i51278_4_);
        } else {
            this.field_215778_g = null;
        }
        this.func_215770_h();
    }

    public void func_75755_a(WorldInfo worldInformation, @Nullable CompoundNBT tagCompound) {
        worldInformation.func_76078_e(19133);
        CompoundNBT compoundnbt = worldInformation.func_76082_a(tagCompound);
        CompoundNBT compoundnbt1 = new CompoundNBT();
        compoundnbt1.func_218657_a("Data", compoundnbt);
        WorldPersistenceHooks.handleWorldDataSave((SaveHandler)this, (WorldInfo)worldInformation, (CompoundNBT)compoundnbt1);
        try {
            File file1 = new File(this.field_215774_c, "level.dat_new");
            File file2 = new File(this.field_215774_c, "level.dat_old");
            File file3 = new File(this.field_215774_c, "level.dat");
            CompressedStreamTools.func_74799_a(compoundnbt1, new FileOutputStream(file1));
            if (file2.exists()) {
                file2.delete();
            }
            file3.renameTo(file2);
            if (file3.exists()) {
                file3.delete();
            }
            file1.renameTo(file3);
            if (file1.exists()) {
                file1.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void func_215770_h() {
        try {
            File file1 = new File(this.field_215774_c, "session.lock");
            try (DataOutputStream dataoutputstream = new DataOutputStream(new FileOutputStream(file1));){
                dataoutputstream.writeLong(this.field_215776_e);
            }
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
            throw new RuntimeException("Failed to check session lock, aborting");
        }
    }

    public File func_75765_b() {
        return this.field_215774_c;
    }

    public void func_75762_c() throws SessionLockException {
        try {
            File file1 = new File(this.field_215774_c, "session.lock");
            try (DataInputStream datainputstream = new DataInputStream(new FileInputStream(file1));){
                if (datainputstream.readLong() != this.field_215776_e) {
                    throw new SessionLockException("The save is being accessed from another location, aborting");
                }
            }
        }
        catch (IOException var7) {
            throw new SessionLockException("Failed to check session lock, aborting");
        }
    }

    @Nullable
    public WorldInfo func_75757_d() {
        WorldInfo worldinfo;
        File file1 = new File(this.field_215774_c, "level.dat");
        if (file1.exists() && (worldinfo = SaveFormat.getWorldData(file1, this.field_215772_a, this)) != null) {
            return worldinfo;
        }
        file1 = new File(this.field_215774_c, "level.dat_old");
        return file1.exists() ? SaveFormat.getWorldData(file1, this.field_215772_a, this) : null;
    }

    public void func_75761_a(WorldInfo worldInformation) {
        this.func_75755_a(worldInformation, null);
    }

    public void func_75753_a(PlayerEntity player) {
        try {
            CompoundNBT compoundnbt = player.func_189511_e(new CompoundNBT());
            File file1 = new File(this.field_215775_d, player.func_189512_bd() + ".dat.tmp");
            File file2 = new File(this.field_215775_d, player.func_189512_bd() + ".dat");
            CompressedStreamTools.func_74799_a(compoundnbt, new FileOutputStream(file1));
            if (file2.exists()) {
                file2.delete();
            }
            file1.renameTo(file2);
            ForgeEventFactory.firePlayerSavingEvent((PlayerEntity)player, (File)this.field_215775_d, (String)player.func_110124_au().toString());
        }
        catch (Exception var5) {
            field_215773_b.warn("Failed to save player data for {}", (Object)player.func_200200_C_().getString());
        }
    }

    @Nullable
    public CompoundNBT func_75752_b(PlayerEntity player) {
        CompoundNBT compoundnbt = null;
        try {
            File file1 = new File(this.field_215775_d, player.func_189512_bd() + ".dat");
            if (file1.exists() && file1.isFile()) {
                compoundnbt = CompressedStreamTools.func_74796_a(new FileInputStream(file1));
            }
        }
        catch (Exception var4) {
            field_215773_b.warn("Failed to load player data for {}", (Object)player.func_200200_C_().getString());
        }
        if (compoundnbt != null) {
            int i = compoundnbt.func_150297_b("DataVersion", 3) ? compoundnbt.func_74762_e("DataVersion") : -1;
            player.func_70020_e(NBTUtil.func_210822_a((DataFixer)this.field_215772_a, (DefaultTypeReferences)DefaultTypeReferences.PLAYER, (CompoundNBT)compoundnbt, (int)i));
        }
        ForgeEventFactory.firePlayerLoadingEvent((PlayerEntity)player, (File)this.field_215775_d, (String)player.func_110124_au().toString());
        return compoundnbt;
    }

    public String[] func_215771_d() {
        String[] astring = this.field_215775_d.list();
        if (astring == null) {
            astring = new String[]{};
        }
        for (int i = 0; i < astring.length; ++i) {
            if (!astring[i].endsWith(".dat")) continue;
            astring[i] = astring[i].substring(0, astring[i].length() - 4);
        }
        return astring;
    }

    public TemplateManager func_186340_h() {
        return this.field_215778_g;
    }

    public DataFixer func_197718_i() {
        return this.field_215772_a;
    }

    public CompoundNBT getPlayerNBT(ServerPlayerEntity player) {
        try {
            File file1 = new File(this.field_215775_d, player.func_189512_bd() + ".dat");
            if (file1.exists() && file1.isFile()) {
                CompoundNBT nbt = CompressedStreamTools.func_74796_a(new FileInputStream(file1));
                if (nbt != null) {
                    nbt = NBTUtil.func_210822_a((DataFixer)this.field_215772_a, (DefaultTypeReferences)DefaultTypeReferences.PLAYER, (CompoundNBT)nbt, (int)(nbt.func_150297_b("DataVersion", 3) ? nbt.func_74762_e("DataVersion") : -1));
                }
                return nbt;
            }
        }
        catch (Exception exception) {
            field_215773_b.warn("Failed to load player data for " + player.func_200200_C_());
        }
        return null;
    }

    public File getPlayerFolder() {
        return this.field_215775_d;
    }
}

