/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.WorldVersion;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;

public class HashCache {
    static final Logger f_123926_ = LogUtils.getLogger();
    private static final String f_236078_ = "// ";
    private final Path f_236079_;
    private final Path f_236080_;
    private final String f_236081_;
    private final Map<DataProvider, ProviderCache> f_236082_;
    private final Map<DataProvider, CacheUpdater> f_236083_ = new HashMap<DataProvider, CacheUpdater>();
    private final Set<Path> f_236084_ = new HashSet<Path>();
    private final int f_236085_;

    private Path m_236109_(DataProvider p_236110_) {
        return this.f_236080_.resolve(Hashing.sha1().hashString((CharSequence)p_236110_.m_6055_(), StandardCharsets.UTF_8).toString());
    }

    public HashCache(Path p_236087_, List<DataProvider> p_236088_, WorldVersion p_236089_) throws IOException {
        this.f_236081_ = p_236089_.getName();
        this.f_236079_ = p_236087_;
        this.f_236080_ = p_236087_.resolve(".cache");
        Files.createDirectories(this.f_236080_, new FileAttribute[0]);
        HashMap<DataProvider, ProviderCache> map = new HashMap<DataProvider, ProviderCache>();
        int i = 0;
        for (DataProvider dataprovider : p_236088_) {
            Path path = this.m_236109_(dataprovider);
            this.f_236084_.add(path);
            ProviderCache hashcache$providercache = HashCache.m_236092_(p_236087_, path);
            map.put(dataprovider, hashcache$providercache);
            i += hashcache$providercache.m_236133_();
        }
        this.f_236082_ = map;
        this.f_236085_ = i;
    }

    private static ProviderCache m_236092_(Path p_236093_, Path p_236094_) {
        if (Files.isReadable(p_236094_)) {
            try {
                return ProviderCache.m_236139_(p_236093_, p_236094_);
            }
            catch (Exception exception) {
                f_123926_.warn("Failed to parse cache {}, discarding", (Object)p_236094_, (Object)exception);
            }
        }
        return new ProviderCache("unknown");
    }

    public boolean m_236090_(DataProvider p_236091_) {
        ProviderCache hashcache$providercache = this.f_236082_.get(p_236091_);
        return hashcache$providercache == null || !hashcache$providercache.f_236126_.equals(this.f_236081_);
    }

    public CachedOutput m_236107_(DataProvider p_236108_) {
        return this.f_236083_.computeIfAbsent(p_236108_, p_236112_ -> {
            ProviderCache hashcache$providercache = this.f_236082_.get(p_236112_);
            if (hashcache$providercache == null) {
                throw new IllegalStateException("Provider not registered: " + p_236112_.m_6055_());
            }
            CacheUpdater hashcache$cacheupdater = new CacheUpdater(this.f_236081_, hashcache$providercache);
            this.f_236082_.put((DataProvider)p_236112_, hashcache$cacheupdater.f_236114_);
            return hashcache$cacheupdater;
        });
    }

    public void m_123937_() throws IOException {
        MutableInt mutableint = new MutableInt();
        this.f_236083_.forEach((p_236100_, p_236101_) -> {
            Path path = this.m_236109_((DataProvider)p_236100_);
            if (!p_236101_.f_236114_.equals(p_236101_.f_236113_) || !Files.exists(path, new LinkOption[0])) {
                p_236101_.f_236114_.m_236142_(this.f_236079_, path, DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(LocalDateTime.now()) + "\t" + p_236100_.m_6055_());
            }
            mutableint.add(p_236101_.f_236115_);
        });
        HashSet<Path> set = new HashSet<Path>();
        this.f_236082_.values().forEach(p_236097_ -> set.addAll(p_236097_.f_236127_().keySet()));
        set.add(this.f_236079_.resolve("version.json"));
        MutableInt mutableint1 = new MutableInt();
        MutableInt mutableint2 = new MutableInt();
        try (Stream<Path> stream = Files.walk(this.f_236079_, new FileVisitOption[0]);){
            stream.forEach(p_236106_ -> {
                if (!Files.isDirectory(p_236106_, new LinkOption[0]) && !this.f_236084_.contains(p_236106_)) {
                    mutableint1.increment();
                    if (!set.contains(p_236106_)) {
                        try {
                            Files.delete(p_236106_);
                        }
                        catch (IOException ioexception) {
                            f_123926_.warn("Failed to delete file {}", p_236106_, (Object)ioexception);
                        }
                        mutableint2.increment();
                    }
                }
            });
        }
        f_123926_.info("Caching: total files: {}, old count: {}, new count: {}, removed stale: {}, written: {}", new Object[]{mutableint1, this.f_236085_, set.size(), mutableint2, mutableint});
    }

    record ProviderCache(String f_236126_, Map<Path, HashCode> f_236127_) {
        ProviderCache(String p_236129_) {
            this(p_236129_, new HashMap<Path, HashCode>());
        }

        @Nullable
        public HashCode m_236134_(Path p_236135_) {
            return this.f_236127_.get(p_236135_);
        }

        public void m_236136_(Path p_236137_, HashCode p_236138_) {
            this.f_236127_.put(p_236137_, p_236138_);
        }

        public int m_236133_() {
            return this.f_236127_.size();
        }

        public static ProviderCache m_236139_(Path p_236140_, Path p_236141_) throws IOException {
            ProviderCache hashcache$providercache;
            try (BufferedReader bufferedreader = Files.newBufferedReader(p_236141_, StandardCharsets.UTF_8);){
                String s = bufferedreader.readLine();
                if (!s.startsWith(HashCache.f_236078_)) {
                    throw new IllegalStateException("Missing cache file header");
                }
                String[] astring = s.substring(HashCache.f_236078_.length()).split("\t", 2);
                String s1 = astring[0];
                HashMap map = new HashMap();
                bufferedreader.lines().forEach(p_236149_ -> {
                    int i = p_236149_.indexOf(32);
                    map.put(p_236140_.resolve(p_236149_.substring(i + 1)), HashCode.fromString((String)p_236149_.substring(0, i)));
                });
                hashcache$providercache = new ProviderCache(s1, Map.copyOf(map));
            }
            return hashcache$providercache;
        }

        public void m_236142_(Path p_236143_, Path p_236144_, String p_236145_) {
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(p_236144_, StandardCharsets.UTF_8, new OpenOption[0]);){
                bufferedwriter.write(HashCache.f_236078_);
                bufferedwriter.write(this.f_236126_);
                bufferedwriter.write(9);
                bufferedwriter.write(p_236145_);
                bufferedwriter.newLine();
                for (Map.Entry entry : this.f_236127_.entrySet().stream().sorted(Map.Entry.comparingByKey()).toList()) {
                    bufferedwriter.write(((HashCode)entry.getValue()).toString());
                    bufferedwriter.write(32);
                    bufferedwriter.write(p_236143_.relativize((Path)entry.getKey()).toString().replace("\\", "/"));
                    bufferedwriter.newLine();
                }
            }
            catch (IOException ioexception) {
                f_123926_.warn("Unable write cachefile {}: {}", (Object)p_236144_, (Object)ioexception);
            }
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ProviderCache.class, "version;data", "f_236126_", "f_236127_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ProviderCache.class, "version;data", "f_236126_", "f_236127_"}, this);
        }

        @Override
        public final boolean equals(Object p_236153_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ProviderCache.class, "version;data", "f_236126_", "f_236127_"}, this, p_236153_);
        }
    }

    static class CacheUpdater
    implements CachedOutput {
        private final ProviderCache f_236113_;
        final ProviderCache f_236114_;
        int f_236115_;

        CacheUpdater(String p_236117_, ProviderCache p_236118_) {
            this.f_236113_ = p_236118_;
            this.f_236114_ = new ProviderCache(p_236117_);
        }

        private boolean m_236119_(Path p_236120_, HashCode p_236121_) {
            return !Objects.equals(this.f_236113_.m_236134_(p_236120_), p_236121_) || !Files.exists(p_236120_, new LinkOption[0]);
        }

        public void m_213871_(Path p_236123_, byte[] p_236124_, HashCode p_236125_) throws IOException {
            if (this.m_236119_(p_236123_, p_236125_)) {
                ++this.f_236115_;
                Files.createDirectories(p_236123_.getParent(), new FileAttribute[0]);
                Files.write(p_236123_, p_236124_, new OpenOption[0]);
            }
            this.f_236114_.m_236136_(p_236123_, p_236125_);
        }
    }
}

