/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.FallbackResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceFilterSection;
import net.minecraft.server.packs.resources.ResourceManager;
import org.slf4j.Logger;

public class MultiPackResourceManager
implements CloseableResourceManager {
    private static final Logger f_215463_ = LogUtils.getLogger();
    private final Map<String, FallbackResourceManager> f_203794_;
    private final List<PackResources> f_203795_;

    public MultiPackResourceManager(PackType p_203797_, List<PackResources> p_203798_) {
        this.f_203795_ = List.copyOf(p_203798_);
        HashMap<String, FallbackResourceManager> map = new HashMap<String, FallbackResourceManager>();
        p_203798_.forEach(resourcePack -> resourcePack.init(p_203797_));
        List list = p_203798_.stream().flatMap(p_215471_ -> p_215471_.m_5698_(p_203797_).stream()).distinct().toList();
        for (PackResources packresources : p_203798_) {
            ResourceFilterSection resourcefiltersection = this.m_215467_(packresources);
            Set<String> set = packresources.m_5698_(p_203797_);
            Predicate<ResourceLocation> predicate = resourcefiltersection != null ? p_215474_ -> resourcefiltersection.m_215528_(p_215474_.m_135815_()) : null;
            for (String s : list) {
                boolean flag1;
                boolean flag = set.contains(s);
                boolean bl = flag1 = resourcefiltersection != null && resourcefiltersection.m_215523_(s);
                if (!flag && !flag1) continue;
                FallbackResourceManager fallbackresourcemanager = (FallbackResourceManager)map.get(s);
                if (fallbackresourcemanager == null) {
                    fallbackresourcemanager = new FallbackResourceManager(p_203797_, s);
                    map.put(s, fallbackresourcemanager);
                }
                if (flag && flag1) {
                    fallbackresourcemanager.m_215382_(packresources, predicate);
                    continue;
                }
                if (flag) {
                    fallbackresourcemanager.m_215377_(packresources);
                    continue;
                }
                fallbackresourcemanager.m_215399_(packresources.m_8017_(), predicate);
            }
        }
        this.f_203794_ = map;
    }

    @Nullable
    private ResourceFilterSection m_215467_(PackResources p_215468_) {
        try {
            return (ResourceFilterSection)p_215468_.m_5550_(ResourceFilterSection.f_215512_);
        }
        catch (IOException ioexception) {
            f_215463_.error("Failed to get filter section from pack {}", (Object)p_215468_.m_8017_());
            return null;
        }
    }

    public Set<String> m_7187_() {
        return this.f_203794_.keySet();
    }

    public Optional<Resource> m_213713_(ResourceLocation p_215482_) {
        ResourceManager resourcemanager = (ResourceManager)this.f_203794_.get(p_215482_.m_135827_());
        return resourcemanager != null ? resourcemanager.m_213713_(p_215482_) : Optional.empty();
    }

    public List<Resource> m_213829_(ResourceLocation p_215466_) {
        ResourceManager resourcemanager = (ResourceManager)this.f_203794_.get(p_215466_.m_135827_());
        return resourcemanager != null ? resourcemanager.m_213829_(p_215466_) : List.of();
    }

    public Map<ResourceLocation, Resource> m_214159_(String p_215476_, Predicate<ResourceLocation> p_215477_) {
        TreeMap<ResourceLocation, Resource> map = new TreeMap<ResourceLocation, Resource>();
        for (FallbackResourceManager fallbackresourcemanager : this.f_203794_.values()) {
            map.putAll(fallbackresourcemanager.m_214159_(p_215476_, p_215477_));
        }
        return map;
    }

    public Map<ResourceLocation, List<Resource>> m_214160_(String p_215479_, Predicate<ResourceLocation> p_215480_) {
        TreeMap<ResourceLocation, List<Resource>> map = new TreeMap<ResourceLocation, List<Resource>>();
        for (FallbackResourceManager fallbackresourcemanager : this.f_203794_.values()) {
            map.putAll(fallbackresourcemanager.m_214160_(p_215479_, p_215480_));
        }
        return map;
    }

    public Stream<PackResources> m_7536_() {
        return this.f_203795_.stream();
    }

    public void close() {
        this.f_203795_.forEach(PackResources::close);
    }
}

