/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world.entity.animal;

import io.izzel.arclight.common.bridge.core.entity.passive.AnimalEntityBridge;
import io.izzel.arclight.common.bridge.core.world.WorldBridge;
import io.izzel.arclight.common.mixin.core.world.entity.AgeableMobMixin;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import org.bukkit.craftbukkit.v1_19_R1.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityEnterLoveModeEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Animal.class})
public abstract class AnimalMixin
extends AgeableMobMixin
implements AnimalEntityBridge {
    @Shadow
    public int f_27554_;
    public ItemStack breedItem;
    private transient int arclight$loveTime;

    @Shadow
    public InteractionResult m_6071_(Player playerIn, InteractionHand hand) {
        return null;
    }

    @Shadow
    public abstract void m_27594_();

    @Shadow
    @Nullable
    public abstract ServerPlayer m_27592_();

    @Override
    @Overwrite
    public boolean m_6469_(DamageSource source, float amount) {
        return super.m_6469_(source, amount);
    }

    @Inject(method={"setInLove(Lnet/minecraft/world/entity/player/Player;)V"}, cancellable=true, at={@At(value="HEAD")})
    private void arclight$enterLove(Player player, CallbackInfo ci) {
        EntityEnterLoveModeEvent event = CraftEventFactory.callEntityEnterLoveModeEvent(player, (Animal)this, 600);
        if (event.isCancelled()) {
            ci.cancel();
        } else {
            this.arclight$loveTime = event.getTicksInLove();
        }
    }

    @Inject(method={"setInLove(Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="FIELD", shift=At.Shift.AFTER, target="Lnet/minecraft/world/entity/animal/Animal;inLove:I")})
    private void arclight$inLove(Player player, CallbackInfo ci) {
        this.f_27554_ = this.arclight$loveTime;
        if (player != null) {
            this.breedItem = player.m_150109_().m_36056_();
        }
    }

    @Override
    public ItemStack bridge$getBreedItem() {
        return this.breedItem;
    }

    @Overwrite
    public void m_27563_(ServerLevel world, Animal animalEntity) {
        AgeableMob child = this.m_142606_(world, (AgeableMob)animalEntity);
        BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((Mob)((Animal)this), (Mob)animalEntity, child);
        boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)event);
        child = event.getChild();
        if (cancelled) {
            this.m_146762_(6000);
            animalEntity.m_146762_(6000);
            this.m_27594_();
            animalEntity.m_27594_();
            return;
        }
        if (child != null) {
            int experience;
            EntityBreedEvent entityBreedEvent;
            ServerPlayer serverplayerentity = this.m_27592_();
            if (serverplayerentity == null && animalEntity.m_27592_() != null) {
                serverplayerentity = animalEntity.m_27592_();
            }
            if ((entityBreedEvent = CraftEventFactory.callEntityBreedEvent((LivingEntity)child, (LivingEntity)((Animal)this), (LivingEntity)animalEntity, (LivingEntity)serverplayerentity, this.breedItem, experience = this.m_217043_().m_188503_(7) + 1)).isCancelled()) {
                return;
            }
            experience = entityBreedEvent.getExperience();
            if (serverplayerentity != null) {
                serverplayerentity.m_36220_(Stats.f_12937_);
                CriteriaTriggers.f_10581_.m_147278_(serverplayerentity, (Animal)this, animalEntity, child);
            }
            this.m_146762_(6000);
            animalEntity.m_146762_(6000);
            this.m_27594_();
            animalEntity.m_27594_();
            child.m_6863_(true);
            child.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
            ((WorldBridge)world).bridge$pushAddEntityReason(CreatureSpawnEvent.SpawnReason.BREEDING);
            world.m_47205_((Entity)child);
            world.m_7605_((Entity)((Animal)this), (byte)18);
            if (world.m_46469_().m_46207_(GameRules.f_46135_) && experience > 0) {
                world.m_7967_((Entity)new ExperienceOrb((Level)world, this.m_20185_(), this.m_20186_(), this.m_20189_(), experience));
            }
        }
    }
}

