/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.boot.application;

import cpw.mods.jarhandling.SecureJar;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.LibraryFinder;
import net.minecraftforge.fml.loading.VersionInfo;
import net.minecraftforge.fml.loading.targets.CommonLaunchHandler;

public class ArclightLaunchHandler
extends CommonLaunchHandler {
    public ArclightLaunchHandler() {
        super(SERVER, "arclight_");
    }

    public String getNaming() {
        return "srg";
    }

    public boolean isProduction() {
        return true;
    }

    protected Path mvn(VersionInfo info, String artifact) {
        return this.mvn(info, artifact, "");
    }

    protected Path mvn(VersionInfo info, String artifact, String classifier) {
        return this.mvn(info.forgeGroup(), artifact, classifier, info.mcAndForgeVersion());
    }

    protected Path mvn(String group, String artifact, String classifier, String version) {
        return LibraryFinder.findPathForMaven((String)group, (String)artifact, (String)"", (String)classifier, (String)version);
    }

    public CommonLaunchHandler.LocatedPaths getMinecraftPaths() {
        VersionInfo vers = FMLLoader.versionInfo();
        List<Path> mc = this.getMCPaths(vers);
        Path forgejar = this.mvn(vers, "forge", "universal");
        Path fmlcore = this.mvn(vers, "fmlcore");
        Path javafmllang = this.mvn(vers, "javafmllanguage");
        Path lowcodelang = this.mvn(vers, "lowcodelanguage");
        Path mclang = this.mvn(vers, "mclanguage");
        return new CommonLaunchHandler.LocatedPaths(mc, null, List.of(List.of(forgejar)), List.of(fmlcore, javafmllang, lowcodelang, mclang));
    }

    protected String[] preLaunch(String[] arguments, ModuleLayer layer) {
        return arguments;
    }

    protected List<Path> getMCPaths(VersionInfo vers) {
        Path mc = this.mvn("net.minecraft", "server", "srg", vers.mcAndMCPVersion());
        Path mcextra = this.mvn("net.minecraft", "server", "extra", vers.mcAndMCPVersion());
        Path patches = this.mvn(vers, "forge", "server");
        BiPredicate<String, String> filter = (path, base) -> path.equals("META-INF/versions/") || !path.endsWith(".class") && !path.startsWith("META-INF/");
        mcextra = SecureJar.from(filter, (Path[])new Path[]{mcextra}).getRootPath();
        return List.of(mc, mcextra, patches);
    }
}

