/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.DetectedVersion;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.VillagerTradingManager;
import net.minecraftforge.common.WorldWorkerManager;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.AndCondition;
import net.minecraftforge.common.crafting.conditions.FalseCondition;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ItemExistsCondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.OrCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import net.minecraftforge.common.crafting.conditions.TrueCondition;
import net.minecraftforge.common.crafting.ingredients.CompoundIngredient;
import net.minecraftforge.common.crafting.ingredients.DifferenceIngredient;
import net.minecraftforge.common.crafting.ingredients.IIngredientSerializer;
import net.minecraftforge.common.crafting.ingredients.IntersectionIngredient;
import net.minecraftforge.common.crafting.ingredients.PartialNBTIngredient;
import net.minecraftforge.common.crafting.ingredients.StrictNBTIngredient;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeBiomeTagsProvider;
import net.minecraftforge.common.data.ForgeBlockTagsProvider;
import net.minecraftforge.common.data.ForgeEntityTypeTagsProvider;
import net.minecraftforge.common.data.ForgeFluidTagsProvider;
import net.minecraftforge.common.data.ForgeItemTagsProvider;
import net.minecraftforge.common.data.ForgeLootTableProvider;
import net.minecraftforge.common.data.ForgeRecipeProvider;
import net.minecraftforge.common.data.ForgeSpriteSourceProvider;
import net.minecraftforge.common.data.VanillaSoundDefinitionsProvider;
import net.minecraftforge.common.loot.CanToolPerformAction;
import net.minecraftforge.common.loot.LootTableIdCondition;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.common.world.NoneBiomeModifier;
import net.minecraftforge.common.world.NoneStructureModifier;
import net.minecraftforge.common.world.StructureModifier;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.CrashReportCallables;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.StartupMessageManager;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkInitialization;
import net.minecraftforge.network.tasks.ForgeNetworkConfigurationHandler;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeDeferredRegistriesSetup;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryInternal;
import net.minecraftforge.registries.IdMappingEvent;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.registries.holdersets.AndHolderSet;
import net.minecraftforge.registries.holdersets.AnyHolderSet;
import net.minecraftforge.registries.holdersets.HolderSetType;
import net.minecraftforge.registries.holdersets.NotHolderSet;
import net.minecraftforge.registries.holdersets.OrHolderSet;
import net.minecraftforge.server.command.EnumArgument;
import net.minecraftforge.server.command.ModIdArgument;
import net.minecraftforge.server.permission.events.PermissionGatherEvent;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContextKey;
import net.minecraftforge.server.permission.nodes.PermissionNode;
import net.minecraftforge.server.permission.nodes.PermissionTypes;
import net.minecraftforge.versions.forge.ForgeVersion;
import net.minecraftforge.versions.mcp.MCPVersion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.Nullable;

@Mod(value="forge")
public class ForgeMod {
    public static final String VERSION_CHECK_CAT = "version_checking";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker FORGEMOD = MarkerManager.getMarker((String)"FORGEMOD");
    private static final List<DeferredRegister<?>> registries = new ArrayList();
    private static final DeferredRegister<ArgumentTypeInfo<?, ?>> COMMAND_ARGUMENT_TYPES = ForgeMod.deferred(Registries.f_256982_);
    private static final DeferredRegister<Attribute> ATTRIBUTES;
    public static final RegistryObject<Attribute> SWIM_SPEED;
    public static final RegistryObject<Attribute> NAMETAG_DISTANCE;
    public static final RegistryObject<Attribute> ENTITY_GRAVITY;
    public static final RegistryObject<Attribute> BLOCK_REACH;
    public static final RegistryObject<Attribute> ENTITY_REACH;
    public static final RegistryObject<Attribute> STEP_HEIGHT_ADDITION;
    private static final DeferredRegister<Codec<? extends BiomeModifier>> BIOME_MODIFIER_SERIALIZERS;
    private static final DeferredRegister<Codec<? extends StructureModifier>> STRUCTURE_MODIFIER_SERIALIZERS;
    private static final DeferredRegister<HolderSetType> HOLDER_SET_TYPES;
    public static final RegistryObject<HolderSetType> ANY_HOLDER_SET;
    public static final RegistryObject<HolderSetType> AND_HOLDER_SET;
    public static final RegistryObject<HolderSetType> OR_HOLDER_SET;
    public static final RegistryObject<HolderSetType> NOT_HOLDER_SET;
    private static final DeferredRegister<FluidType> VANILLA_FLUID_TYPES;
    public static final RegistryObject<FluidType> EMPTY_TYPE;
    public static final RegistryObject<FluidType> WATER_TYPE;
    public static final RegistryObject<FluidType> LAVA_TYPE;
    private static final DeferredRegister<LootItemConditionType> LOOT_CONDITION_TYPES;
    private static final DeferredRegister<Codec<? extends ICondition>> CONDITION_SERIALIZERS;
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS;
    private static final DeferredRegister<IIngredientSerializer<?>> INGREDIENT_SERIALIZERS;
    private static boolean enableMilkFluid;
    public static final RegistryObject<SoundEvent> BUCKET_EMPTY_MILK;
    public static final RegistryObject<SoundEvent> BUCKET_FILL_MILK;
    public static final RegistryObject<FluidType> MILK_TYPE;
    public static final RegistryObject<Fluid> MILK;
    public static final RegistryObject<Fluid> FLOWING_MILK;
    private static ForgeMod INSTANCE;
    public static final PermissionNode<Boolean> USE_SELECTORS_PERMISSION;

    private static <T> DeferredRegister<T> deferred(ResourceKey<Registry<T>> key) {
        return ForgeMod.deferred(key, "forge");
    }

    private static <T> DeferredRegister<T> deferred(ResourceKey<Registry<T>> key, String modid) {
        DeferredRegister<T> ret = DeferredRegister.create(key, modid);
        registries.add(ret);
        return ret;
    }

    public static ForgeMod getInstance() {
        return INSTANCE;
    }

    public static void enableMilkFluid() {
        enableMilkFluid = true;
    }

    public ForgeMod() {
        LOGGER.info(FORGEMOD, "Forge mod loading, version {}, for MC {} with MCP {}", (Object)ForgeVersion.getVersion(), (Object)MCPVersion.getMCVersion(), (Object)MCPVersion.getMCPVersion());
        INSTANCE = this;
        MinecraftForge.initialize();
        CrashReportCallables.registerCrashCallable((String)"Crash Report UUID", () -> {
            UUID uuid = UUID.randomUUID();
            LOGGER.fatal("Preparing crash report with UUID {}", (Object)uuid);
            return uuid.toString();
        });
        NetworkInitialization.init();
        CrashReportCallables.registerCrashCallable((String)"FML", ForgeVersion::getSpec);
        CrashReportCallables.registerCrashCallable((String)"Forge", () -> ForgeVersion.getGroup() + ":" + ForgeVersion.getVersion());
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(event -> {
            event.dataPackRegistry(ForgeRegistries.Keys.BIOME_MODIFIERS, BiomeModifier.DIRECT_CODEC);
            event.dataPackRegistry(ForgeRegistries.Keys.STRUCTURE_MODIFIERS, StructureModifier.DIRECT_CODEC);
        });
        modEventBus.addListener(this::preInit);
        modEventBus.addListener(this::gatherData);
        modEventBus.addListener(this::loadComplete);
        modEventBus.addListener(this::registerFluids);
        modEventBus.addListener(this::registerVanillaDisplayContexts);
        modEventBus.register((Object)this);
        registries.forEach(r -> r.register(modEventBus));
        MinecraftForge.EVENT_BUS.addListener(this::serverStopping);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ForgeConfig.clientSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ForgeConfig.serverSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ForgeConfig.commonSpec);
        modEventBus.register(ForgeConfig.class);
        ForgeDeferredRegistriesSetup.setup(modEventBus);
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "ANY", (remote, isServer) -> true));
        StartupMessageManager.addModMessage((String)("Forge version " + ForgeVersion.getVersion()));
        MinecraftForge.EVENT_BUS.addListener(VillagerTradingManager::loadTrades);
        MinecraftForge.EVENT_BUS.register((Object)MinecraftForge.INTERNAL_HANDLER);
        MinecraftForge.EVENT_BUS.addListener(this::mappingChanged);
        MinecraftForge.EVENT_BUS.addListener(this::tagsUpdated);
        MinecraftForge.EVENT_BUS.addListener(this::registerPermissionNodes);
        MinecraftForge.EVENT_BUS.register((Object)new ForgeNetworkConfigurationHandler());
        ForgeRegistries.ITEMS.tags().addOptionalTagDefaults(Tags.Items.ENCHANTING_FUELS, Set.of(ForgeRegistries.ITEMS.getDelegateOrThrow(Items.f_42534_)));
        ForgeMod.addAlias(ForgeRegistries.ATTRIBUTES, new ResourceLocation("forge", "reach_distance"), new ResourceLocation("forge", "block_reach"));
        ForgeMod.addAlias(ForgeRegistries.ATTRIBUTES, new ResourceLocation("forge", "attack_range"), new ResourceLocation("forge", "entity_reach"));
    }

    public void preInit(FMLCommonSetupEvent evt) {
        VersionChecker.startVersionCheck();
    }

    public void loadComplete(FMLLoadCompleteEvent event) {
    }

    public void serverStopping(ServerStoppingEvent evt) {
        WorldWorkerManager.clear();
    }

    public void mappingChanged(IdMappingEvent evt) {
        Ingredient.invalidateAll();
    }

    public void tagsUpdated(TagsUpdatedEvent evt) {
        Ingredient.invalidateAll();
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput packOutput = gen.getPackOutput();
        CompletableFuture<HolderLookup.Provider> lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        gen.addProvider(true, (DataProvider)new PackMetadataGenerator(packOutput).m_247300_(PackMetadataSection.f_243696_, (Object)new PackMetadataSection((Component)Component.m_237115_((String)"pack.forge.description"), DetectedVersion.f_132476_.m_264084_(PackType.CLIENT_RESOURCES), Optional.empty())));
        ForgeBlockTagsProvider blockTags = new ForgeBlockTagsProvider(packOutput, lookupProvider, existingFileHelper);
        gen.addProvider(event.includeServer(), (DataProvider)blockTags);
        gen.addProvider(event.includeServer(), (DataProvider)new ForgeItemTagsProvider(packOutput, lookupProvider, blockTags.m_274426_(), existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new ForgeEntityTypeTagsProvider(packOutput, lookupProvider, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new ForgeFluidTagsProvider(packOutput, lookupProvider, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new ForgeRecipeProvider(packOutput));
        gen.addProvider(event.includeServer(), (DataProvider)new ForgeLootTableProvider(packOutput));
        gen.addProvider(event.includeServer(), (DataProvider)new ForgeBiomeTagsProvider(packOutput, lookupProvider, existingFileHelper));
        gen.addProvider(event.includeClient(), (DataProvider)new ForgeSpriteSourceProvider(packOutput, existingFileHelper));
        gen.addProvider(event.includeClient(), (DataProvider)new VanillaSoundDefinitionsProvider(packOutput, existingFileHelper));
    }

    public void registerFluids(RegisterEvent event) {
        if (enableMilkFluid) {
            event.register(ForgeRegistries.Keys.SOUND_EVENTS, helper -> {
                helper.register(BUCKET_EMPTY_MILK.getId(), SoundEvent.m_262824_((ResourceLocation)BUCKET_EMPTY_MILK.getId()));
                helper.register(BUCKET_FILL_MILK.getId(), SoundEvent.m_262824_((ResourceLocation)BUCKET_FILL_MILK.getId()));
            });
            event.register(ForgeRegistries.Keys.FLUID_TYPES, helper -> helper.register(MILK_TYPE.getId(), new FluidType(FluidType.Properties.create().density(1024).viscosity(1024).sound(SoundActions.BUCKET_FILL, BUCKET_FILL_MILK.get()).sound(SoundActions.BUCKET_EMPTY, BUCKET_EMPTY_MILK.get())){

                @Override
                public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                    consumer.accept(new IClientFluidTypeExtensions(){
                        private static final ResourceLocation MILK_STILL = new ResourceLocation("forge", "block/milk_still");
                        private static final ResourceLocation MILK_FLOW = new ResourceLocation("forge", "block/milk_flowing");

                        @Override
                        public ResourceLocation getStillTexture() {
                            return MILK_STILL;
                        }

                        @Override
                        public ResourceLocation getFlowingTexture() {
                            return MILK_FLOW;
                        }
                    });
                }
            }));
            event.register(ForgeRegistries.Keys.FLUIDS, helper -> {
                ForgeFlowingFluid.Properties properties = new ForgeFlowingFluid.Properties(MILK_TYPE, MILK, FLOWING_MILK).bucket(() -> Items.f_42455_);
                helper.register(MILK.getId(), new ForgeFlowingFluid.Source(properties));
                helper.register(FLOWING_MILK.getId(), new ForgeFlowingFluid.Flowing(properties));
            });
        }
    }

    public void registerVanillaDisplayContexts(RegisterEvent event) {
        if (event.getRegistryKey().equals(ForgeRegistries.Keys.DISPLAY_CONTEXTS)) {
            IForgeRegistryInternal forgeRegistry = (IForgeRegistryInternal)event.getForgeRegistry();
            if (forgeRegistry == null) {
                throw new IllegalStateException("Item display context was not a forge registry, wtf???");
            }
            Arrays.stream(ItemDisplayContext.values()).filter(Predicate.not(ItemDisplayContext::isModded)).forEach(ctx -> forgeRegistry.register(ctx.m_269462_(), new ResourceLocation("minecraft", ctx.m_7912_()), ctx));
        }
    }

    public void registerPermissionNodes(PermissionGatherEvent.Nodes event) {
        event.addNodes(USE_SELECTORS_PERMISSION);
    }

    @Deprecated(forRemoval=true, since="1.20")
    private static <T> void addAlias(IForgeRegistry<T> registry, ResourceLocation from, ResourceLocation to) {
        ForgeRegistry fReg = (ForgeRegistry)registry;
        fReg.addAlias(from, to);
    }

    static {
        RegistryObject<EnumArgument.Info> v = COMMAND_ARGUMENT_TYPES.register("enum", () -> (EnumArgument.Info)ArgumentTypeInfos.registerByClass(EnumArgument.class, new EnumArgument.Info()));
        COMMAND_ARGUMENT_TYPES.register("modid", () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass(ModIdArgument.class, (ArgumentTypeInfo)SingletonArgumentInfo.m_235451_(ModIdArgument::modIdArgument)));
        ATTRIBUTES = ForgeMod.deferred(ForgeRegistries.Keys.ATTRIBUTES);
        SWIM_SPEED = ATTRIBUTES.register("swim_speed", () -> new RangedAttribute("forge.swim_speed", 1.0, 0.0, 1024.0).m_22084_(true));
        NAMETAG_DISTANCE = ATTRIBUTES.register("nametag_distance", () -> new RangedAttribute("forge.name_tag_distance", 64.0, 0.0, 64.0).m_22084_(true));
        ENTITY_GRAVITY = ATTRIBUTES.register("entity_gravity", () -> new RangedAttribute("forge.entity_gravity", 0.08, -8.0, 8.0).m_22084_(true));
        BLOCK_REACH = ATTRIBUTES.register("block_reach", () -> new RangedAttribute("forge.block_reach", 4.5, 0.0, 1024.0).m_22084_(true));
        ENTITY_REACH = ATTRIBUTES.register("entity_reach", () -> new RangedAttribute("forge.entity_reach", 3.0, 0.0, 1024.0).m_22084_(true));
        STEP_HEIGHT_ADDITION = ATTRIBUTES.register("step_height_addition", () -> new RangedAttribute("forge.step_height", 0.0, -512.0, 512.0).m_22084_(true));
        BIOME_MODIFIER_SERIALIZERS = ForgeMod.deferred(ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS);
        BIOME_MODIFIER_SERIALIZERS.register("none", () -> NoneBiomeModifier.CODEC);
        BIOME_MODIFIER_SERIALIZERS.register("add_features", () -> ForgeBiomeModifiers.AddFeaturesBiomeModifier.CODEC);
        BIOME_MODIFIER_SERIALIZERS.register("remove_features", () -> ForgeBiomeModifiers.RemoveFeaturesBiomeModifier.CODEC);
        BIOME_MODIFIER_SERIALIZERS.register("add_spawns", () -> ForgeBiomeModifiers.AddSpawnsBiomeModifier.CODEC);
        BIOME_MODIFIER_SERIALIZERS.register("remove_spawns", () -> ForgeBiomeModifiers.RemoveSpawnsBiomeModifier.CODEC);
        STRUCTURE_MODIFIER_SERIALIZERS = ForgeMod.deferred(ForgeRegistries.Keys.STRUCTURE_MODIFIER_SERIALIZERS);
        STRUCTURE_MODIFIER_SERIALIZERS.register("none", () -> NoneStructureModifier.CODEC);
        HOLDER_SET_TYPES = ForgeMod.deferred(ForgeRegistries.Keys.HOLDER_SET_TYPES);
        ANY_HOLDER_SET = HOLDER_SET_TYPES.register("any", () -> AnyHolderSet::codec);
        AND_HOLDER_SET = HOLDER_SET_TYPES.register("and", () -> AndHolderSet::codec);
        OR_HOLDER_SET = HOLDER_SET_TYPES.register("or", () -> OrHolderSet::codec);
        NOT_HOLDER_SET = HOLDER_SET_TYPES.register("not", () -> NotHolderSet::codec);
        VANILLA_FLUID_TYPES = ForgeMod.deferred(ForgeRegistries.Keys.FLUID_TYPES, "minecraft");
        EMPTY_TYPE = VANILLA_FLUID_TYPES.register("empty", () -> new FluidType(FluidType.Properties.create().descriptionId("block.minecraft.air").motionScale(1.0).canPushEntity(false).canSwim(false).canDrown(false).fallDistanceModifier(1.0f).pathType(null).adjacentPathType(null).density(0).temperature(0).viscosity(0)){

            @Override
            public void setItemMovement(ItemEntity entity) {
                if (!entity.m_20068_()) {
                    entity.m_20256_(entity.m_20184_().m_82520_(0.0, -0.04, 0.0));
                }
            }
        });
        WATER_TYPE = VANILLA_FLUID_TYPES.register("water", () -> new FluidType(FluidType.Properties.create().descriptionId("block.minecraft.water").fallDistanceModifier(0.0f).canExtinguish(true).canConvertToSource(true).supportsBoating(true).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.f_11937_).canHydrate(true)){

            @Override
            @Nullable
            public BlockPathTypes getBlockPathType(FluidState state, BlockGetter level, BlockPos pos, @Nullable Mob mob, boolean canFluidLog) {
                return canFluidLog ? super.getBlockPathType(state, level, pos, mob, true) : null;
            }

            @Override
            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(new IClientFluidTypeExtensions(){
                    private static final ResourceLocation UNDERWATER_LOCATION = new ResourceLocation("textures/misc/underwater.png");
                    private static final ResourceLocation WATER_STILL = new ResourceLocation("block/water_still");
                    private static final ResourceLocation WATER_FLOW = new ResourceLocation("block/water_flow");
                    private static final ResourceLocation WATER_OVERLAY = new ResourceLocation("block/water_overlay");

                    @Override
                    public ResourceLocation getStillTexture() {
                        return WATER_STILL;
                    }

                    @Override
                    public ResourceLocation getFlowingTexture() {
                        return WATER_FLOW;
                    }

                    @Override
                    @Nullable
                    public ResourceLocation getOverlayTexture() {
                        return WATER_OVERLAY;
                    }

                    @Override
                    public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                        return UNDERWATER_LOCATION;
                    }

                    @Override
                    public int getTintColor() {
                        return -12618012;
                    }

                    @Override
                    public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                        return BiomeColors.m_108811_((BlockAndTintGetter)getter, (BlockPos)pos) | 0xFF000000;
                    }
                });
            }
        });
        LAVA_TYPE = VANILLA_FLUID_TYPES.register("lava", () -> new FluidType(FluidType.Properties.create().descriptionId("block.minecraft.lava").canSwim(false).canDrown(false).pathType(BlockPathTypes.LAVA).adjacentPathType(null).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11783_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11780_).lightLevel(15).density(3000).viscosity(6000).temperature(1300)){

            @Override
            public double motionScale(Entity entity) {
                return entity.m_9236_().m_6042_().f_63857_() ? 0.007 : 0.0023333333333333335;
            }

            @Override
            public void setItemMovement(ItemEntity entity) {
                Vec3 vec3 = entity.m_20184_();
                entity.m_20334_(vec3.f_82479_ * (double)0.95f, vec3.f_82480_ + (double)(vec3.f_82480_ < (double)0.06f ? 5.0E-4f : 0.0f), vec3.f_82481_ * (double)0.95f);
            }

            @Override
            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(new IClientFluidTypeExtensions(){
                    private static final ResourceLocation LAVA_STILL = new ResourceLocation("block/lava_still");
                    private static final ResourceLocation LAVA_FLOW = new ResourceLocation("block/lava_flow");

                    @Override
                    public ResourceLocation getStillTexture() {
                        return LAVA_STILL;
                    }

                    @Override
                    public ResourceLocation getFlowingTexture() {
                        return LAVA_FLOW;
                    }
                });
            }
        });
        LOOT_CONDITION_TYPES = ForgeMod.deferred(Registries.f_256976_);
        LOOT_CONDITION_TYPES.register("loot_table_id", () -> LootTableIdCondition.TYPE);
        LOOT_CONDITION_TYPES.register("can_tool_perform_action", () -> CanToolPerformAction.TYPE);
        CONDITION_SERIALIZERS = ForgeMod.deferred(ForgeRegistries.Keys.CONDITION_SERIALIZERS);
        CONDITION_SERIALIZERS.register("and", () -> AndCondition.CODEC);
        CONDITION_SERIALIZERS.register("false", () -> FalseCondition.CODEC);
        CONDITION_SERIALIZERS.register("item_exists", () -> ItemExistsCondition.CODEC);
        CONDITION_SERIALIZERS.register("mod_loaded", () -> ModLoadedCondition.CODEC);
        CONDITION_SERIALIZERS.register("not", () -> NotCondition.CODEC);
        CONDITION_SERIALIZERS.register("or", () -> OrCondition.CODEC);
        CONDITION_SERIALIZERS.register("true", () -> TrueCondition.CODEC);
        CONDITION_SERIALIZERS.register("tag_empty", () -> TagEmptyCondition.CODEC);
        RECIPE_SERIALIZERS = ForgeMod.deferred(ForgeRegistries.Keys.RECIPE_SERIALIZERS);
        RECIPE_SERIALIZERS.register("conditional", () -> ConditionalRecipe.SERIALZIER);
        INGREDIENT_SERIALIZERS = ForgeMod.deferred(ForgeRegistries.Keys.INGREDIENT_SERIALIZERS);
        INGREDIENT_SERIALIZERS.register("compound", () -> CompoundIngredient.SERIALIZER);
        INGREDIENT_SERIALIZERS.register("nbt", () -> StrictNBTIngredient.SERIALIZER);
        INGREDIENT_SERIALIZERS.register("partial_nbt", () -> PartialNBTIngredient.SERIALIZER);
        INGREDIENT_SERIALIZERS.register("difference", () -> DifferenceIngredient.SERIALIZER);
        INGREDIENT_SERIALIZERS.register("intersection", () -> IntersectionIngredient.SERIALIZER);
        enableMilkFluid = false;
        BUCKET_EMPTY_MILK = RegistryObject.create(new ResourceLocation("item.bucket.empty_milk"), ForgeRegistries.SOUND_EVENTS);
        BUCKET_FILL_MILK = RegistryObject.create(new ResourceLocation("item.bucket.fill_milk"), ForgeRegistries.SOUND_EVENTS);
        MILK_TYPE = RegistryObject.createOptional(new ResourceLocation("milk"), ForgeRegistries.Keys.FLUID_TYPES.m_135782_(), "minecraft");
        MILK = RegistryObject.create(new ResourceLocation("milk"), ForgeRegistries.FLUIDS);
        FLOWING_MILK = RegistryObject.create(new ResourceLocation("flowing_milk"), ForgeRegistries.FLUIDS);
        USE_SELECTORS_PERMISSION = new PermissionNode<Boolean>("forge", "use_entity_selectors", PermissionTypes.BOOLEAN, (player, uuid, contexts) -> player != null && player.m_20310_(2), new PermissionDynamicContextKey[0]);
    }
}

