/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceArrayMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.common.custom.DiscardedPayload;
import net.minecraft.network.protocol.login.ClientboundCustomQueryPacket;
import net.minecraft.network.protocol.login.ServerboundCustomQueryAnswerPacket;
import net.minecraft.network.protocol.login.custom.CustomQueryAnswerPayload;
import net.minecraft.network.protocol.login.custom.CustomQueryPayload;
import net.minecraft.network.protocol.login.custom.DiscardedQueryAnswerPayload;
import net.minecraft.network.protocol.login.custom.DiscardedQueryPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.ICustomPacket;

public enum NetworkDirection {
    PLAY_TO_SERVER(LogicalSide.CLIENT, ServerboundCustomPayloadPacket.class, 1, NetworkDirection::playServerbound),
    PLAY_TO_CLIENT(LogicalSide.SERVER, ClientboundCustomPayloadPacket.class, 0, NetworkDirection::playClientbound),
    LOGIN_TO_SERVER(LogicalSide.CLIENT, ServerboundCustomQueryAnswerPacket.class, 3, NetworkDirection::loginServerbound),
    LOGIN_TO_CLIENT(LogicalSide.SERVER, ClientboundCustomQueryPacket.class, 2, NetworkDirection::loginClientbound);

    private final LogicalSide logicalSide;
    private final Class<? extends Packet> packetClass;
    private final int otherWay;
    private final Factory factory;
    private static final Reference2ReferenceArrayMap<Class<? extends Packet>, NetworkDirection> packetLookup;
    private static final NetworkDirection[] values;

    private NetworkDirection(LogicalSide logicalSide, Class<? extends Packet> clazz, int i, Factory factory) {
        this.logicalSide = logicalSide;
        this.packetClass = clazz;
        this.otherWay = i;
        this.factory = factory;
    }

    private Class<? extends Packet> getPacketClass() {
        return this.packetClass;
    }

    public static <T extends ICustomPacket<?>> NetworkDirection directionFor(Class<T> customPacket) {
        return (NetworkDirection)((Object)packetLookup.get(customPacket));
    }

    public NetworkDirection reply() {
        return values[this.otherWay];
    }

    public LogicalSide getOriginationSide() {
        return this.logicalSide;
    }

    public LogicalSide getReceptionSide() {
        return this.reply().logicalSide;
    }

    public <T extends Packet<?>> ICustomPacket<T> buildPacket(FriendlyByteBuf data, ResourceLocation channelName) {
        return this.factory.create(data, 0, channelName);
    }

    private static ServerboundCustomPayloadPacket playServerbound(FriendlyByteBuf data, Integer index, ResourceLocation channelName) {
        return new ServerboundCustomPayloadPacket((CustomPacketPayload)new DiscardedPayload(channelName, data));
    }

    private static ClientboundCustomPayloadPacket playClientbound(FriendlyByteBuf data, Integer index, ResourceLocation channelName) {
        return new ClientboundCustomPayloadPacket((CustomPacketPayload)new DiscardedPayload(channelName, data));
    }

    private static ServerboundCustomQueryAnswerPacket loginServerbound(FriendlyByteBuf data, Integer index, ResourceLocation channelName) {
        return new ServerboundCustomQueryAnswerPacket(index.intValue(), (CustomQueryAnswerPayload)new DiscardedQueryAnswerPayload(data));
    }

    private static ClientboundCustomQueryPacket loginClientbound(FriendlyByteBuf data, Integer index, ResourceLocation channelName) {
        return new ClientboundCustomQueryPacket(index.intValue(), (CustomQueryPayload)new DiscardedQueryPayload(channelName, data));
    }

    static {
        packetLookup = new Reference2ReferenceArrayMap();
        for (NetworkDirection value : values = NetworkDirection.values()) {
            packetLookup.put(value.getPacketClass(), (Object)value);
        }
    }

    private static interface Factory<T extends Packet<?>> {
        public ICustomPacket<T> create(FriendlyByteBuf var1, Integer var2, ResourceLocation var3);
    }
}

