/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network;

import io.netty.buffer.Unpooled;
import io.netty.util.AttributeKey;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.Channel;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkInstance;
import org.apache.commons.lang3.function.TriConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class SimpleChannel
extends Channel<Object> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker MARKER = MarkerManager.getMarker((String)"SIMPLE_CHANNEL");
    private int lastIndex = 0;
    private Int2ObjectMap<Message<?>> byId = new Int2ObjectArrayMap();
    private Object2ObjectMap<Class<?>, Message<?>> byType = new Object2ObjectArrayMap();

    @ApiStatus.Internal
    SimpleChannel(NetworkInstance instance) {
        super(instance);
        instance.addListener(this::networkEventListener);
    }

    public <M> MessageBuilder<M> messageBuilder(Class<M> type) {
        return this.messageBuilder(type, this.nextIndex());
    }

    public <M> MessageBuilder<M> messageBuilder(Class<M> type, int discriminator) {
        return this.messageBuilder(type, discriminator, null);
    }

    public <M> MessageBuilder<M> messageBuilder(Class<M> type, NetworkDirection direction) {
        return this.messageBuilder(type, this.nextIndex(), direction);
    }

    public <M> MessageBuilder<M> messageBuilder(Class<M> type, int discriminator, NetworkDirection direction) {
        return new MessageBuilder<M>(this, type, discriminator, direction);
    }

    private int nextIndex() {
        while (this.byId.containsKey(this.lastIndex)) {
            ++this.lastIndex;
            if (this.lastIndex >= 0) continue;
            throw new IllegalStateException("Ran out of discriminator, only 2147483647 are allowed");
        }
        return this.lastIndex;
    }

    private void networkEventListener(CustomPayloadEvent event) {
        FriendlyByteBuf data = event.getPayload();
        if (data == null || !data.isReadable()) {
            LOGGER.error(MARKER, "Received empty payload on channel {} login index {}", (Object)this.getName(), (Object)event.getLoginIndex());
            return;
        }
        int id = data.m_130242_();
        Message msg = (Message)this.byId.get(id);
        if (msg == null) {
            LOGGER.error(MARKER, "Received invalid discriminator {} on channel {}", (Object)id, (Object)this.getName());
            return;
        }
        Connection con = event.getSource().getConnection();
        NetworkDirection dir = event.getSource().getDirection();
        if (msg.direction.isPresent() && msg.direction.get() != dir) {
            String error = "Illegal packet received, terminating connection. " + msg.type().getName() + " expexted " + (Object)((Object)msg.direction.get()) + " but was " + dir;
            LOGGER.error(MARKER, error);
            con.m_129507_((Component)Component.m_237113_((String)error));
            throw new IllegalStateException(error);
        }
        SimpleChannel.decodeAndDispatch(data, event.getSource(), msg);
    }

    private static <MSG> void decodeAndDispatch(FriendlyByteBuf data, CustomPayloadEvent.Context ctx, Message<MSG> msg) {
        MSG message = msg.decoder().apply(data);
        msg.consumer.accept(message, ctx);
    }

    @Override
    public FriendlyByteBuf toBuffer(Object message) {
        Message msg = (Message)this.byType.get(message.getClass());
        if (msg == null) {
            LOGGER.error(MARKER, "Attempted to send invalid message {} on channel {}", (Object)message.getClass().getName(), (Object)this.getName());
            throw new IllegalArgumentException("Invalid message " + message.getClass().getName());
        }
        FriendlyByteBuf ret = new FriendlyByteBuf(Unpooled.buffer());
        ret.m_130130_(msg.index());
        if (msg.encoder() != null) {
            msg.encoder().accept(message, ret);
        }
        return ret;
    }

    public static class MessageBuilder<MSG> {
        private final SimpleChannel channel;
        private final Class<MSG> type;
        private final int id;
        private final Optional<NetworkDirection> direction;
        private BiConsumer<MSG, FriendlyByteBuf> encoder;
        private Function<FriendlyByteBuf, MSG> decoder;
        private BiConsumer<MSG, CustomPayloadEvent.Context> consumer;

        private MessageBuilder(SimpleChannel channel, Class<MSG> type, int id, @Nullable NetworkDirection networkDirection) {
            this.channel = channel;
            this.type = type;
            this.id = id;
            this.direction = Optional.ofNullable(networkDirection);
        }

        public MessageBuilder<MSG> encoder(BiConsumer<MSG, FriendlyByteBuf> encoder) {
            this.encoder = encoder;
            return this;
        }

        public MessageBuilder<MSG> decoder(Function<FriendlyByteBuf, MSG> decoder) {
            this.decoder = decoder;
            return this;
        }

        public MessageBuilder<MSG> consumerNetworkThread(BiConsumer<MSG, CustomPayloadEvent.Context> consumer) {
            this.consumer = consumer;
            return this;
        }

        public <C> MessageBuilder<MSG> consumerNetworkThread(AttributeKey<C> key, TriConsumer<C, MSG, CustomPayloadEvent.Context> consumer) {
            return this.consumerNetworkThread((MSG msg, CustomPayloadEvent.Context ctx) -> {
                Object inst = ctx.getConnection().channel().attr(key).get();
                consumer.accept(inst, msg, ctx);
            });
        }

        public MessageBuilder<MSG> consumerNetworkThread(ToBooleanBiFunction<MSG, CustomPayloadEvent.Context> handler) {
            this.consumer = (msg, ctx) -> ctx.setPacketHandled(handler.applyAsBool((Object)msg, (CustomPayloadEvent.Context)ctx));
            return this;
        }

        public <C> MessageBuilder<MSG> consumerNetworkThread(AttributeKey<C> key, ToBooleanTriFunction<C, MSG, CustomPayloadEvent.Context> handler) {
            return this.consumerNetworkThread((MSG msg, CustomPayloadEvent.Context ctx) -> {
                Object inst = ctx.getConnection().channel().attr(key).get();
                return handler.applyAsBool((Object)inst, (Object)msg, (CustomPayloadEvent.Context)ctx);
            });
        }

        public MessageBuilder<MSG> consumerMainThread(BiConsumer<MSG, CustomPayloadEvent.Context> consumer) {
            this.consumer = (msg, context) -> {
                CustomPayloadEvent.Context ctx = context;
                ctx.enqueueWork(() -> consumer.accept((Object)msg, (CustomPayloadEvent.Context)context));
                ctx.setPacketHandled(true);
            };
            return this;
        }

        public <C> MessageBuilder<MSG> consumerMainThread(AttributeKey<C> key, TriConsumer<C, MSG, CustomPayloadEvent.Context> consumer) {
            this.consumer = (msg, ctx) -> {
                ctx.enqueueWork(() -> {
                    Object inst = ctx.getConnection().channel().attr(key).get();
                    consumer.accept(inst, msg, ctx);
                });
                ctx.setPacketHandled(true);
            };
            return this;
        }

        public SimpleChannel add() {
            if (this.id < 0) {
                throw new IllegalStateException("Failed to register SimpleChannel message, Invalid ID " + this.id + ": " + this.type.getName());
            }
            Message<MSG> msg = new Message<MSG>(this.id, this.type, this.direction, this.encoder, this.decoder, this.consumer);
            if (this.channel.byId.containsKey(msg.index())) {
                throw new IllegalStateException("Failed to register SimpleChannel message, ID " + msg.index() + " already claimed: " + msg.type().getName());
            }
            if (this.channel.byType.containsKey(msg.type())) {
                throw new IllegalStateException("Failed to register SimpleChannel message, Class " + msg.type().getName() + " already registered");
            }
            this.channel.byId.put(msg.index(), msg);
            this.channel.byType.put(msg.type(), msg);
            return this.channel;
        }

        @FunctionalInterface
        public static interface ToBooleanBiFunction<T, U> {
            public boolean applyAsBool(T var1, U var2);
        }

        @FunctionalInterface
        public static interface ToBooleanTriFunction<T, U, V> {
            public boolean applyAsBool(T var1, U var2, V var3);
        }
    }

    private record Message<MSG>(int index, Class<MSG> type, Optional<NetworkDirection> direction, BiConsumer<MSG, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, MSG> decoder, BiConsumer<MSG, CustomPayloadEvent.Context> consumer) {
    }
}

