/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.earlydisplay;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;

public class PerformanceInfo {
    private final OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
    private final MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
    float memory;
    private String text;

    PerformanceInfo() {
    }

    void update() {
        MemoryUsage heapusage = this.memoryBean.getHeapMemoryUsage();
        this.memory = (float)heapusage.getUsed() / (float)heapusage.getMax();
        double cpuLoad = this.osBean.getProcessCpuLoad();
        String cpuText = cpuLoad == -1.0 ? String.format("*CPU: %.1f%%", this.osBean.getCpuLoad() * 100.0) : String.format("CPU: %.1f%%", cpuLoad * 100.0);
        this.text = String.format("Heap: %d/%d MB (%.1f%%) OffHeap: %d MB  %s", heapusage.getUsed() >> 20, heapusage.getMax() >> 20, (double)this.memory * 100.0, this.memoryBean.getNonHeapMemoryUsage().getUsed() >> 20, cpuText);
    }

    String text() {
        return this.text;
    }

    float memory() {
        return this.memory;
    }
}

