/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R2.block;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.InclusiveRange;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import org.bukkit.World;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.spawner.SpawnRule;
import org.bukkit.block.spawner.SpawnerEntry;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftEntitySnapshot;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftEntityType;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;

public class CraftCreatureSpawner
extends CraftBlockEntityState<SpawnerBlockEntity>
implements CreatureSpawner {
    public CraftCreatureSpawner(World world, SpawnerBlockEntity tileEntity) {
        super(world, tileEntity);
    }

    protected CraftCreatureSpawner(CraftCreatureSpawner state) {
        super(state);
    }

    @Override
    public EntityType getSpawnedType() {
        SpawnData spawnData = ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45444_;
        if (spawnData == null) {
            return null;
        }
        Optional type = net.minecraft.world.entity.EntityType.m_20637_((CompoundTag)spawnData.m_186567_());
        return type.map(CraftEntityType::minecraftToBukkit).orElse(null);
    }

    @Override
    public void setSpawnedType(EntityType entityType) {
        if (entityType == null) {
            ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45443_ = SimpleWeightedRandomList.m_185864_();
            ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45444_ = new SpawnData();
            return;
        }
        Preconditions.checkArgument((entityType != EntityType.UNKNOWN ? 1 : 0) != 0, (String)"Can't spawn EntityType %s from mob spawners!", (Object)entityType);
        RandomSource rand = this.isPlaced() ? this.getWorldHandle().m_213780_() : RandomSource.m_216327_();
        ((SpawnerBlockEntity)this.getSnapshot()).m_252803_(CraftEntityType.bukkitToMinecraft(entityType), rand);
    }

    @Override
    public EntitySnapshot getSpawnedEntity() {
        SpawnData spawnData = ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45444_;
        if (spawnData == null) {
            return null;
        }
        return CraftEntitySnapshot.create(spawnData.m_186567_());
    }

    @Override
    public void setSpawnedEntity(EntitySnapshot snapshot) {
        CompoundTag compoundTag = ((CraftEntitySnapshot)snapshot).getData();
        ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45443_ = SimpleWeightedRandomList.m_185864_();
        ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45444_ = new SpawnData(compoundTag, Optional.empty());
    }

    @Override
    public void addPotentialSpawn(EntitySnapshot snapshot, int weight, SpawnRule spawnRule) {
        CompoundTag compoundTag = ((CraftEntitySnapshot)snapshot).getData();
        SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.m_146263_();
        ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45443_.m_146338_().forEach(entry -> {
            SimpleWeightedRandomList.Builder builder2 = builder.m_146271_((Object)((SpawnData)entry.m_146310_()), entry.m_142631_().m_146281_());
        });
        builder.m_146271_((Object)new SpawnData(compoundTag, Optional.ofNullable(this.toMinecraftRule(spawnRule))), weight);
        ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45443_ = builder.m_146270_();
    }

    @Override
    public void addPotentialSpawn(SpawnerEntry spawnerEntry) {
        this.addPotentialSpawn(spawnerEntry.getSnapshot(), spawnerEntry.getSpawnWeight(), spawnerEntry.getSpawnRule());
    }

    @Override
    public void setPotentialSpawns(Collection<SpawnerEntry> entries) {
        SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.m_146263_();
        for (SpawnerEntry spawnerEntry : entries) {
            CompoundTag compoundTag = ((CraftEntitySnapshot)spawnerEntry.getSnapshot()).getData();
            builder.m_146271_((Object)new SpawnData(compoundTag, Optional.ofNullable(this.toMinecraftRule(spawnerEntry.getSpawnRule()))), spawnerEntry.getSpawnWeight());
        }
        ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45443_ = builder.m_146270_();
    }

    @Override
    public List<SpawnerEntry> getPotentialSpawns() {
        ArrayList<SpawnerEntry> entries = new ArrayList<SpawnerEntry>();
        for (WeightedEntry.Wrapper entry : ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45443_.m_146338_()) {
            CraftEntitySnapshot snapshot = CraftEntitySnapshot.create(((SpawnData)entry.m_146310_()).m_186567_());
            if (snapshot == null) continue;
            SpawnRule rule = ((SpawnData)entry.m_146310_()).f_186562_().map(this::fromMinecraftRule).orElse(null);
            entries.add(new SpawnerEntry(snapshot, entry.m_142631_().m_146281_(), rule));
        }
        return entries;
    }

    private SpawnData.CustomSpawnRules toMinecraftRule(SpawnRule rule) {
        if (rule == null) {
            return null;
        }
        return new SpawnData.CustomSpawnRules(new InclusiveRange((Comparable)Integer.valueOf(rule.getMinBlockLight()), (Comparable)Integer.valueOf(rule.getMaxBlockLight())), new InclusiveRange((Comparable)Integer.valueOf(rule.getMinSkyLight()), (Comparable)Integer.valueOf(rule.getMaxSkyLight())));
    }

    private SpawnRule fromMinecraftRule(SpawnData.CustomSpawnRules rule) {
        InclusiveRange blockLight = rule.f_186584_();
        InclusiveRange skyLight = rule.f_186585_();
        return new SpawnRule((Integer)blockLight.f_184564_(), (Integer)blockLight.f_184564_(), (Integer)skyLight.f_184563_(), (Integer)skyLight.f_184564_());
    }

    @Override
    public String getCreatureTypeName() {
        SpawnData spawnData = ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45444_;
        if (spawnData == null) {
            return null;
        }
        Optional type = net.minecraft.world.entity.EntityType.m_20637_((CompoundTag)spawnData.m_186567_());
        return type.map(entityTypes -> net.minecraft.world.entity.EntityType.m_20613_((net.minecraft.world.entity.EntityType)entityTypes).m_135815_()).orElse(null);
    }

    @Override
    public void setCreatureTypeByName(String creatureType) {
        EntityType type = EntityType.fromName(creatureType);
        if (type == null) {
            this.setSpawnedType(null);
            return;
        }
        this.setSpawnedType(type);
    }

    @Override
    public int getDelay() {
        return ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45442_;
    }

    @Override
    public void setDelay(int delay) {
        ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45442_ = delay;
    }

    @Override
    public int getMinSpawnDelay() {
        return ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45447_;
    }

    @Override
    public void setMinSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay <= this.getMaxSpawnDelay() ? 1 : 0) != 0, (Object)"Minimum Spawn Delay must be less than or equal to Maximum Spawn Delay");
        ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45447_ = spawnDelay;
    }

    @Override
    public int getMaxSpawnDelay() {
        return ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45448_;
    }

    @Override
    public void setMaxSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay > 0 ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than 0.");
        Preconditions.checkArgument((spawnDelay >= this.getMinSpawnDelay() ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than or equal to Minimum Spawn Delay");
        ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45448_ = spawnDelay;
    }

    @Override
    public int getMaxNearbyEntities() {
        return ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45451_;
    }

    @Override
    public void setMaxNearbyEntities(int maxNearbyEntities) {
        ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45451_ = maxNearbyEntities;
    }

    @Override
    public int getSpawnCount() {
        return ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45449_;
    }

    @Override
    public void setSpawnCount(int count) {
        ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45449_ = count;
    }

    @Override
    public int getRequiredPlayerRange() {
        return ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45452_;
    }

    @Override
    public void setRequiredPlayerRange(int requiredPlayerRange) {
        ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45452_ = requiredPlayerRange;
    }

    @Override
    public int getSpawnRange() {
        return ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45453_;
    }

    @Override
    public void setSpawnRange(int spawnRange) {
        ((SpawnerBlockEntity)this.getSnapshot()).m_59801_().f_45453_ = spawnRange;
    }

    @Override
    public CraftCreatureSpawner copy() {
        return new CraftCreatureSpawner(this);
    }
}

