/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R2.entity;

import com.google.common.base.Preconditions;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftEntityType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntitySnapshot;

public class CraftEntitySnapshot
implements EntitySnapshot {
    private final CompoundTag data;
    private final org.bukkit.entity.EntityType type;

    private CraftEntitySnapshot(CompoundTag data, org.bukkit.entity.EntityType type) {
        this.data = data;
        this.type = type;
    }

    @Override
    public org.bukkit.entity.EntityType getEntityType() {
        return this.type;
    }

    @Override
    public Entity createEntity(World world) {
        net.minecraft.world.entity.Entity internal = this.createInternal(world);
        return internal.getBukkitEntity();
    }

    @Override
    public Entity createEntity(Location location) {
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Location has no world");
        net.minecraft.world.entity.Entity internal = this.createInternal(location.getWorld());
        internal.m_6034_(location.getX(), location.getY(), location.getZ());
        return location.getWorld().addEntity(internal.getBukkitEntity());
    }

    private net.minecraft.world.entity.Entity createInternal(World world) {
        ServerLevel nms = ((CraftWorld)world).getHandle();
        net.minecraft.world.entity.Entity internal = EntityType.m_20645_((CompoundTag)this.data, (Level)nms, Function.identity());
        if (internal == null) {
            internal = CraftEntityType.bukkitToMinecraft(this.type).m_20615_((Level)nms);
        }
        Preconditions.checkArgument((internal != null ? 1 : 0) != 0, (Object)"Error creating new entity.");
        internal.m_20258_(this.data);
        return internal;
    }

    public CompoundTag getData() {
        return this.data;
    }

    public static CraftEntitySnapshot create(CraftEntity entity) {
        CompoundTag tag = new CompoundTag();
        if (!entity.getHandle().saveAsPassenger(tag, false)) {
            return null;
        }
        return new CraftEntitySnapshot(tag, entity.getType());
    }

    public static CraftEntitySnapshot create(CompoundTag tag, org.bukkit.entity.EntityType type) {
        if (tag == null || tag.m_128456_() || type == null) {
            return null;
        }
        return new CraftEntitySnapshot(tag, type);
    }

    public static CraftEntitySnapshot create(CompoundTag tag) {
        org.bukkit.entity.EntityType type = EntityType.m_20637_((CompoundTag)tag).map(CraftEntityType::minecraftToBukkit).orElse(null);
        return CraftEntitySnapshot.create(tag, type);
    }
}

