/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R2.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.projectile.AbstractArrow;
import org.bukkit.Color;
import org.bukkit.craftbukkit.v1_20_R2.CraftServer;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftArrow;
import org.bukkit.craftbukkit.v1_20_R2.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_20_R2.potion.CraftPotionType;
import org.bukkit.craftbukkit.v1_20_R2.potion.CraftPotionUtil;
import org.bukkit.entity.Arrow;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;

public class CraftTippedArrow
extends CraftArrow
implements Arrow {
    public CraftTippedArrow(CraftServer server, net.minecraft.world.entity.projectile.Arrow entity) {
        super(server, (AbstractArrow)entity);
    }

    public net.minecraft.world.entity.projectile.Arrow getHandle() {
        return (net.minecraft.world.entity.projectile.Arrow)this.entity;
    }

    @Override
    public String toString() {
        return "CraftTippedArrow";
    }

    @Override
    public boolean addCustomEffect(PotionEffect effect, boolean override) {
        MobEffect minecraft = CraftPotionEffectType.bukkitToMinecraft(effect.getType());
        MobEffectInstance existing = null;
        for (MobEffectInstance mobEffect : this.getHandle().f_36852_) {
            if (mobEffect.m_19544_() != minecraft) continue;
            existing = mobEffect;
        }
        if (existing != null) {
            if (!override) {
                return false;
            }
            this.getHandle().f_36852_.remove(existing);
        }
        this.getHandle().m_36870_(CraftPotionUtil.fromBukkit(effect));
        this.getHandle().m_36890_();
        return true;
    }

    @Override
    public void clearCustomEffects() {
        this.getHandle().f_36852_.clear();
        this.getHandle().m_36890_();
    }

    @Override
    public List<PotionEffect> getCustomEffects() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (MobEffectInstance effect : this.getHandle().f_36852_) {
            builder.add((Object)CraftPotionUtil.toBukkit(effect));
        }
        return builder.build();
    }

    @Override
    public boolean hasCustomEffect(PotionEffectType type) {
        for (MobEffectInstance effect : this.getHandle().f_36852_) {
            if (!CraftPotionUtil.equals(effect.m_19544_(), type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasCustomEffects() {
        return !this.getHandle().f_36852_.isEmpty();
    }

    @Override
    public boolean removeCustomEffect(PotionEffectType effect) {
        MobEffect minecraft = CraftPotionEffectType.bukkitToMinecraft(effect);
        MobEffectInstance existing = null;
        for (MobEffectInstance mobEffect : this.getHandle().f_36852_) {
            if (mobEffect.m_19544_() != minecraft) continue;
            existing = mobEffect;
        }
        if (existing == null) {
            return false;
        }
        this.getHandle().f_36852_.remove(existing);
        this.getHandle().m_36890_();
        return true;
    }

    @Override
    public void setBasePotionData(PotionData data) {
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"PotionData cannot be null");
        this.getHandle().f_36855_ = CraftPotionType.bukkitToMinecraft(CraftPotionUtil.fromBukkit(data));
    }

    @Override
    public PotionData getBasePotionData() {
        return CraftPotionUtil.toBukkit(CraftPotionType.minecraftToBukkit(this.getHandle().f_36855_));
    }

    @Override
    public void setBasePotionType(@NotNull PotionType potionType) {
        Preconditions.checkArgument((potionType != null ? 1 : 0) != 0, (Object)"PotionType cannot be null use PotionType.UNCRAFTABLE to represent no effect instead.");
        this.getHandle().f_36855_ = CraftPotionType.bukkitToMinecraft(potionType);
    }

    @Override
    @NotNull
    public PotionType getBasePotionType() {
        return CraftPotionType.minecraftToBukkit(this.getHandle().f_36855_);
    }

    @Override
    public void setColor(Color color) {
        int colorRGB = color == null ? -1 : color.asRGB();
        this.getHandle().m_36882_(colorRGB);
    }

    @Override
    public Color getColor() {
        if (this.getHandle().m_36889_() <= -1) {
            return null;
        }
        return Color.fromRGB(this.getHandle().m_36889_());
    }
}

