/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R2.packs;

import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.util.InclusiveRange;
import org.bukkit.Bukkit;
import org.bukkit.FeatureFlag;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_20_R2.CraftFeatureFlag;
import org.bukkit.craftbukkit.v1_20_R2.CraftServer;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftChatMessage;
import org.bukkit.packs.DataPack;

public class CraftDataPack
implements DataPack {
    private final Pack handle;
    private final PackMetadataSection resourcePackInfo;

    public CraftDataPack(Pack handler) {
        this.handle = handler;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (PackResources iresourcepack = this.handle.f_244124_.m_293078_(this.handle.m_10446_());){
                this.resourcePackInfo = (PackMetadataSection)iresourcepack.m_5550_((MetadataSectionSerializer)PackMetadataSection.f_243696_);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Pack getHandle() {
        return this.handle;
    }

    public String getRawId() {
        return this.getHandle().m_10446_();
    }

    @Override
    public String getTitle() {
        return CraftChatMessage.fromComponent(this.getHandle().m_10429_());
    }

    @Override
    public String getDescription() {
        return CraftChatMessage.fromComponent(this.getHandle().m_10442_());
    }

    @Override
    public int getPackFormat() {
        return this.resourcePackInfo.f_10368_();
    }

    @Override
    public int getMinSupportedPackFormat() {
        return (Integer)this.resourcePackInfo.f_290577_().orElse(new InclusiveRange((Comparable)Integer.valueOf(this.getPackFormat()))).f_184563_();
    }

    @Override
    public int getMaxSupportedPackFormat() {
        return (Integer)this.resourcePackInfo.f_290577_().orElse(new InclusiveRange((Comparable)Integer.valueOf(this.getPackFormat()))).f_184564_();
    }

    @Override
    public boolean isRequired() {
        return this.getHandle().m_10449_();
    }

    @Override
    public DataPack.Compatibility getCompatibility() {
        return switch (this.getHandle().m_10443_()) {
            case PackCompatibility.COMPATIBLE -> DataPack.Compatibility.COMPATIBLE;
            case PackCompatibility.TOO_NEW -> DataPack.Compatibility.NEW;
            case PackCompatibility.TOO_OLD -> DataPack.Compatibility.OLD;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    @Override
    public boolean isEnabled() {
        return ((CraftServer)Bukkit.getServer()).getServer().m_129891_().m_10523_().contains(this.getRawId());
    }

    @Override
    public DataPack.Source getSource() {
        if (this.getHandle().m_10453_() == PackSource.f_10528_) {
            return DataPack.Source.BUILT_IN;
        }
        if (this.getHandle().m_10453_() == PackSource.f_244201_) {
            return DataPack.Source.FEATURE;
        }
        if (this.getHandle().m_10453_() == PackSource.f_10529_) {
            return DataPack.Source.WORLD;
        }
        if (this.getHandle().m_10453_() == PackSource.f_10530_) {
            return DataPack.Source.SERVER;
        }
        return DataPack.Source.DEFAULT;
    }

    @Override
    public Set<FeatureFlag> getRequestedFeatures() {
        return CraftFeatureFlag.getFromNMS(this.getHandle().m_245532_()).stream().map(FeatureFlag.class::cast).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public NamespacedKey getKey() {
        return NamespacedKey.fromString(this.getRawId());
    }

    public String toString() {
        String requestedFeatures = this.getRequestedFeatures().stream().map(featureFlag -> featureFlag.getKey().toString()).collect(Collectors.joining(","));
        return "CraftDataPack{rawId=" + this.getRawId() + ",id=" + this.getKey() + ",title=" + this.getTitle() + ",description=" + this.getDescription() + ",packformat=" + this.getPackFormat() + ",minSupportedPackFormat=" + this.getMinSupportedPackFormat() + ",maxSupportedPackFormat=" + this.getMaxSupportedPackFormat() + ",compatibility=" + (Object)((Object)this.getCompatibility()) + ",source=" + (Object)((Object)this.getSource()) + ",enabled=" + this.isEnabled() + ",requestedFeatures=[" + requestedFeatures + "]}";
    }
}

