/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R2.util;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.bukkit.Bukkit;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R2.generator.CraftLimitedRegion;
import org.bukkit.craftbukkit.v1_20_R2.generator.structure.CraftStructure;
import org.bukkit.event.world.AsyncStructureGenerateEvent;
import org.bukkit.util.BlockTransformer;
import org.bukkit.util.EntityTransformer;

public class CraftStructureTransformer {
    private CraftLimitedRegion limitedRegion;
    private BlockTransformer[] blockTransformers;
    private EntityTransformer[] entityTransformers;

    public CraftStructureTransformer(AsyncStructureGenerateEvent.Cause cause, WorldGenLevel generatoraccessseed, StructureManager structuremanager, Structure structure, BoundingBox structureboundingbox, ChunkPos chunkcoordintpair) {
        AsyncStructureGenerateEvent event = new AsyncStructureGenerateEvent(structuremanager.f_220460_.getMinecraftWorld().getWorld(), !Bukkit.isPrimaryThread(), cause, CraftStructure.minecraftToBukkit(structure, structuremanager.m_220521_()), new org.bukkit.util.BoundingBox(structureboundingbox.m_162395_(), structureboundingbox.m_162396_(), structureboundingbox.m_162398_(), structureboundingbox.m_162399_(), structureboundingbox.m_162400_(), structureboundingbox.m_162401_()), chunkcoordintpair.f_45578_, chunkcoordintpair.f_45579_);
        Bukkit.getPluginManager().callEvent(event);
        this.blockTransformers = (BlockTransformer[])event.getBlockTransformers().values().toArray(BlockTransformer[]::new);
        this.entityTransformers = (EntityTransformer[])event.getEntityTransformers().values().toArray(EntityTransformer[]::new);
        this.limitedRegion = new CraftLimitedRegion(generatoraccessseed, chunkcoordintpair);
    }

    public boolean transformEntity(Entity entity) {
        EntityTransformer[] transformers = this.entityTransformers;
        if (transformers == null || transformers.length == 0) {
            return true;
        }
        CraftLimitedRegion region = this.limitedRegion;
        if (region == null) {
            return true;
        }
        entity.generation = true;
        CraftEntity craftEntity = entity.getBukkitEntity();
        int x = entity.m_146903_();
        int y = entity.m_146904_();
        int z = entity.m_146907_();
        boolean allowedToSpawn = true;
        EntityTransformer[] entityTransformerArray = transformers;
        int n = transformers.length;
        int n2 = 0;
        while (n2 < n) {
            EntityTransformer transformer = entityTransformerArray[n2];
            allowedToSpawn = transformer.transform(region, x, y, z, craftEntity, allowedToSpawn);
            ++n2;
        }
        return allowedToSpawn;
    }

    public boolean canTransformBlocks() {
        return this.blockTransformers != null && this.blockTransformers.length != 0 && this.limitedRegion != null;
    }

    public CraftBlockState transformCraftState(CraftBlockState originalState) {
        BlockTransformer[] transformers = this.blockTransformers;
        if (transformers == null || transformers.length == 0) {
            return originalState;
        }
        CraftLimitedRegion region = this.limitedRegion;
        if (region == null) {
            return originalState;
        }
        originalState.setWorldHandle((LevelAccessor)region.getHandle());
        BlockPos position = originalState.getPosition();
        BlockState blockState = originalState.copy();
        CraftTransformationState transformationState = new CraftTransformationState(originalState, region.getBlockState(position.m_123341_(), position.m_123342_(), position.m_123343_()));
        BlockTransformer[] blockTransformerArray = transformers;
        int n = transformers.length;
        int n2 = 0;
        while (n2 < n) {
            BlockTransformer transformer = blockTransformerArray[n2];
            blockState = Objects.requireNonNull(transformer.transform(region, position.m_123341_(), position.m_123342_(), position.m_123343_(), blockState, transformationState), "BlockState can't be null");
            transformationState.destroyCopies();
            ++n2;
        }
        return blockState;
    }

    public void discard() {
        this.limitedRegion.saveEntities();
        this.limitedRegion.breakLink();
        this.limitedRegion = null;
        this.blockTransformers = null;
        this.entityTransformers = null;
    }

    private static class CraftTransformationState
    implements BlockTransformer.TransformationState {
        private final BlockState original;
        private final BlockState world;
        private BlockState originalCopy;
        private BlockState worldCopy;

        private CraftTransformationState(BlockState original, BlockState world) {
            this.original = original;
            this.world = world;
        }

        @Override
        public BlockState getOriginal() {
            if (this.originalCopy != null) {
                return this.originalCopy;
            }
            this.originalCopy = this.original.copy();
            return this.originalCopy;
        }

        @Override
        public BlockState getWorld() {
            if (this.worldCopy != null) {
                return this.worldCopy;
            }
            this.worldCopy = this.world.copy();
            return this.worldCopy;
        }

        private void destroyCopies() {
            this.originalCopy = null;
            this.worldCopy = null;
        }
    }
}

