/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ExtraCodecs;

public class AdvancementProgress
implements Comparable<AdvancementProgress> {
    private static final DateTimeFormatter f_291415_ = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss Z", Locale.ROOT);
    private static final Codec<Instant> f_291732_ = ExtraCodecs.m_216170_(f_291415_).xmap(Instant::from, p_296108_ -> p_296108_.atZone(ZoneId.systemDefault()));
    private static final Codec<Map<String, CriterionProgress>> f_291192_ = Codec.unboundedMap((Codec)Codec.STRING, f_291732_).xmap(p_296104_ -> p_296104_.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, p_296110_ -> new CriterionProgress((Instant)p_296110_.getValue()))), p_296101_ -> p_296101_.entrySet().stream().filter(p_296109_ -> ((CriterionProgress)p_296109_.getValue()).m_12911_()).collect(Collectors.toMap(Map.Entry::getKey, p_296103_ -> Objects.requireNonNull(((CriterionProgress)p_296103_.getValue()).m_12920_()))));
    public static final Codec<AdvancementProgress> f_291693_ = RecordCodecBuilder.create(p_296105_ -> p_296105_.group((App)ExtraCodecs.m_295827_(f_291192_, "criteria", Map.of()).forGetter(p_296102_ -> p_296102_.f_8190_), (App)Codec.BOOL.fieldOf("done").orElse((Object)true).forGetter(AdvancementProgress::m_8193_)).apply((Applicative)p_296105_, (p_296106_, p_296107_) -> new AdvancementProgress(new HashMap<String, CriterionProgress>((Map<String, CriterionProgress>)p_296106_))));
    private final Map<String, CriterionProgress> f_8190_;
    private AdvancementRequirements f_8191_ = AdvancementRequirements.f_291378_;

    private AdvancementProgress(Map<String, CriterionProgress> p_144358_) {
        this.f_8190_ = p_144358_;
    }

    public AdvancementProgress() {
        this.f_8190_ = Maps.newHashMap();
    }

    public void m_8198_(AdvancementRequirements p_300626_) {
        Set<String> $$1 = p_300626_.m_294727_();
        this.f_8190_.entrySet().removeIf(p_8203_ -> !$$1.contains(p_8203_.getKey()));
        for (String $$2 : $$1) {
            this.f_8190_.putIfAbsent($$2, new CriterionProgress());
        }
        this.f_8191_ = p_300626_;
    }

    public boolean m_8193_() {
        return this.f_8191_.m_295452_(this::m_293648_);
    }

    public boolean m_8206_() {
        for (CriterionProgress $$0 : this.f_8190_.values()) {
            if (!$$0.m_12911_()) continue;
            return true;
        }
        return false;
    }

    public boolean m_8196_(String p_8197_) {
        CriterionProgress $$1 = this.f_8190_.get(p_8197_);
        if ($$1 != null && !$$1.m_12911_()) {
            $$1.m_12916_();
            return true;
        }
        return false;
    }

    public boolean m_8209_(String p_8210_) {
        CriterionProgress $$1 = this.f_8190_.get(p_8210_);
        if ($$1 != null && $$1.m_12911_()) {
            $$1.m_12919_();
            return true;
        }
        return false;
    }

    public String toString() {
        return "AdvancementProgress{criteria=" + this.f_8190_ + ", requirements=" + this.f_8191_ + "}";
    }

    public void m_8204_(FriendlyByteBuf p_8205_) {
        p_8205_.m_236831_(this.f_8190_, FriendlyByteBuf::m_130070_, (p_144360_, p_144361_) -> p_144361_.m_12914_((FriendlyByteBuf)((Object)p_144360_)));
    }

    public static AdvancementProgress m_8211_(FriendlyByteBuf p_8212_) {
        Map<String, CriterionProgress> $$1 = p_8212_.m_236847_(FriendlyByteBuf::m_130277_, CriterionProgress::m_12917_);
        return new AdvancementProgress($$1);
    }

    @Nullable
    public CriterionProgress m_8214_(String p_8215_) {
        return this.f_8190_.get(p_8215_);
    }

    private boolean m_293648_(String p_301316_) {
        CriterionProgress $$1 = this.m_8214_(p_301316_);
        return $$1 != null && $$1.m_12911_();
    }

    public float m_8213_() {
        if (this.f_8190_.isEmpty()) {
            return 0.0f;
        }
        float $$0 = this.f_8191_.m_294969_();
        float $$1 = this.m_8222_();
        return $$1 / $$0;
    }

    @Nullable
    public Component m_8218_() {
        if (this.f_8190_.isEmpty()) {
            return null;
        }
        int $$0 = this.f_8191_.m_294969_();
        if ($$0 <= 1) {
            return null;
        }
        int $$1 = this.m_8222_();
        return Component.m_237110_("advancements.progress", $$1, $$0);
    }

    private int m_8222_() {
        return this.f_8191_.m_292826_(this::m_293648_);
    }

    public Iterable<String> m_8219_() {
        ArrayList $$0 = Lists.newArrayList();
        for (Map.Entry<String, CriterionProgress> $$1 : this.f_8190_.entrySet()) {
            if ($$1.getValue().m_12911_()) continue;
            $$0.add($$1.getKey());
        }
        return $$0;
    }

    public Iterable<String> m_8220_() {
        ArrayList $$0 = Lists.newArrayList();
        for (Map.Entry<String, CriterionProgress> $$1 : this.f_8190_.entrySet()) {
            if (!$$1.getValue().m_12911_()) continue;
            $$0.add($$1.getKey());
        }
        return $$0;
    }

    @Nullable
    public Instant m_8221_() {
        return this.f_8190_.values().stream().map(CriterionProgress::m_12920_).filter(Objects::nonNull).min(Comparator.naturalOrder()).orElse(null);
    }

    @Override
    public int compareTo(AdvancementProgress p_8195_) {
        Instant $$1 = this.m_8221_();
        Instant $$2 = p_8195_.m_8221_();
        if ($$1 == null && $$2 != null) {
            return 1;
        }
        if ($$1 != null && $$2 == null) {
            return -1;
        }
        if ($$1 == null && $$2 == null) {
            return 0;
        }
        return $$1.compareTo($$2);
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.compareTo((AdvancementProgress)object);
    }
}

