/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.JsonOps;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.Settings;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import org.slf4j.Logger;

public class DedicatedServerProperties
extends Settings<DedicatedServerProperties> {
    static final Logger f_214805_ = LogUtils.getLogger();
    private static final Pattern f_214806_ = Pattern.compile("^[a-fA-F0-9]{40}$");
    private static final Splitter f_243988_ = Splitter.on((char)',').trimResults();
    public final boolean f_139728_ = this.m_139836_("online-mode", true);
    public final boolean f_139729_ = this.m_139836_("prevent-proxy-connections", false);
    public final String f_139730_ = this.m_139811_("server-ip", "");
    public final boolean f_139731_ = this.m_139836_("spawn-animals", true);
    public final boolean f_139732_ = this.m_139836_("spawn-npcs", true);
    public final boolean f_139733_ = this.m_139836_("pvp", true);
    public final boolean f_139734_ = this.m_139836_("allow-flight", false);
    public final String f_139736_ = this.m_139811_("motd", "A Minecraft Server");
    public final boolean f_139737_ = this.m_139836_("force-gamemode", false);
    public final boolean f_139738_ = this.m_139836_("enforce-whitelist", false);
    public final Difficulty f_139739_ = this.m_139821_("difficulty", DedicatedServerProperties.m_139850_(Difficulty::m_19029_, Difficulty::m_19031_), Difficulty::m_19036_, Difficulty.EASY);
    public final GameType f_139740_ = this.m_139821_("gamemode", DedicatedServerProperties.m_139850_(GameType::m_46393_, GameType::m_46400_), GameType::m_46405_, GameType.SURVIVAL);
    public final String f_139741_ = this.m_139811_("level-name", "world");
    public final int f_139742_ = this.m_139805_("server-port", 25565);
    @Nullable
    public final Boolean f_139744_ = this.m_139859_("announce-player-achievements");
    public final boolean f_139745_ = this.m_139836_("enable-query", false);
    public final int f_139746_ = this.m_139805_("query.port", 25565);
    public final boolean f_139747_ = this.m_139836_("enable-rcon", false);
    public final int f_139748_ = this.m_139805_("rcon.port", 25575);
    public final String f_139749_ = this.m_139811_("rcon.password", "");
    public final boolean f_139752_ = this.m_139836_("hardcore", false);
    public final boolean f_139753_ = this.m_139836_("allow-nether", true);
    public final boolean f_139705_ = this.m_139836_("spawn-monsters", true);
    public final boolean f_139707_ = this.m_139836_("use-native-transport", true);
    public final boolean f_139708_ = this.m_139836_("enable-command-block", false);
    public final int f_139709_ = this.m_139805_("spawn-protection", 16);
    public final int f_139710_ = this.m_139805_("op-permission-level", 4);
    public final int f_139711_ = this.m_139805_("function-permission-level", 2);
    public final long f_139712_ = this.m_139808_("max-tick-time", TimeUnit.MINUTES.toMillis(1L));
    public final int f_214801_ = this.m_139805_("max-chained-neighbor-updates", 1000000);
    public final int f_139713_ = this.m_139805_("rate-limit", 0);
    public final int f_139714_ = this.m_139805_("view-distance", 10);
    public final int f_183715_ = this.m_139805_("simulation-distance", 10);
    public final int f_139715_ = this.m_139805_("max-players", 20);
    public final int f_139716_ = this.m_139805_("network-compression-threshold", 256);
    public final boolean f_139717_ = this.m_139836_("broadcast-rcon-to-ops", true);
    public final boolean f_139718_ = this.m_139836_("broadcast-console-to-ops", true);
    public final int f_139719_ = this.m_139832_("max-world-size", p_139771_ -> Mth.m_14045_(p_139771_, 1, 29999984), 29999984);
    public final boolean f_139720_ = this.m_139836_("sync-chunk-writes", true);
    public final boolean f_139721_ = this.m_139836_("enable-jmx-monitoring", false);
    public final boolean f_139722_ = this.m_139836_("enable-status", true);
    public final boolean f_183716_ = this.m_139836_("hide-online-players", false);
    public final int f_139723_ = this.m_139832_("entity-broadcast-range-percentage", p_139769_ -> Mth.m_14045_(p_139769_, 10, 1000), 100);
    public final String f_139724_ = this.m_139811_("text-filtering-config", "");
    public final Optional<MinecraftServer.ServerResourcePackInfo> f_214802_;
    public final DataPackConfig f_243997_;
    public final Settings.MutableValue<Integer> f_139725_ = this.m_139861_("player-idle-timeout", 0);
    public final Settings.MutableValue<Boolean> f_139726_ = this.m_139873_("white-list", false);
    public final boolean f_214804_ = this.m_139836_("enforce-secure-profile", true);
    public final boolean f_290960_ = this.m_139836_("log-ips", true);
    private final WorldDimensionData f_244504_;
    public final WorldOptions f_243824_;

    public DedicatedServerProperties(Properties p_180926_) {
        super(p_180926_);
        String $$1 = this.m_139811_("level-seed", "");
        boolean $$2 = this.m_139836_("generate-structures", true);
        long $$3 = WorldOptions.m_261063_($$1).orElse(WorldOptions.m_255240_());
        this.f_243824_ = new WorldOptions($$3, $$2, false);
        this.f_244504_ = new WorldDimensionData(this.m_139817_("generator-settings", p_211543_ -> GsonHelper.m_13864_(!p_211543_.isEmpty() ? p_211543_ : "{}"), new JsonObject()), this.m_139817_("level-type", p_211541_ -> p_211541_.toLowerCase(Locale.ROOT), WorldPresets.f_226437_.m_135782_().toString()));
        this.f_214802_ = DedicatedServerProperties.m_214808_(this.m_139811_("resource-pack", ""), this.m_139811_("resource-pack-sha1", ""), this.m_139803_("resource-pack-hash"), this.m_139836_("require-resource-pack", false), this.m_139811_("resource-pack-prompt", ""));
        this.f_243997_ = DedicatedServerProperties.m_247013_(this.m_139811_("initial-enabled-packs", String.join((CharSequence)",", WorldDataConfiguration.f_244649_.f_244096_().m_45850_())), this.m_139811_("initial-disabled-packs", String.join((CharSequence)",", WorldDataConfiguration.f_244649_.f_244096_().m_45855_())));
    }

    public static DedicatedServerProperties m_180929_(Path p_180930_) {
        return new DedicatedServerProperties(DedicatedServerProperties.m_139839_(p_180930_));
    }

    @Override
    protected DedicatedServerProperties m_6764_(RegistryAccess p_139761_, Properties p_139762_) {
        return new DedicatedServerProperties(p_139762_);
    }

    @Nullable
    private static Component m_214814_(String p_214815_) {
        if (!Strings.isNullOrEmpty((String)p_214815_)) {
            try {
                return Component.Serializer.m_130701_(p_214815_);
            }
            catch (Exception $$1) {
                f_214805_.warn("Failed to parse resource pack prompt '{}'", (Object)p_214815_, (Object)$$1);
            }
        }
        return null;
    }

    private static Optional<MinecraftServer.ServerResourcePackInfo> m_214808_(String p_214809_, String p_214810_, @Nullable String p_214811_, boolean p_214812_, String p_214813_) {
        String $$7;
        if (p_214809_.isEmpty()) {
            return Optional.empty();
        }
        if (!p_214810_.isEmpty()) {
            String $$5 = p_214810_;
            if (!Strings.isNullOrEmpty((String)p_214811_)) {
                f_214805_.warn("resource-pack-hash is deprecated and found along side resource-pack-sha1. resource-pack-hash will be ignored.");
            }
        } else if (!Strings.isNullOrEmpty((String)p_214811_)) {
            f_214805_.warn("resource-pack-hash is deprecated. Please use resource-pack-sha1 instead.");
            String $$6 = p_214811_;
        } else {
            $$7 = "";
        }
        if ($$7.isEmpty()) {
            f_214805_.warn("You specified a resource pack without providing a sha1 hash. Pack will be updated on the client only if you change the name of the pack.");
        } else if (!f_214806_.matcher($$7).matches()) {
            f_214805_.warn("Invalid sha1 for resource-pack-sha1");
        }
        Component $$8 = DedicatedServerProperties.m_214814_(p_214813_);
        return Optional.of(new MinecraftServer.ServerResourcePackInfo(p_214809_, $$7, p_214812_, $$8));
    }

    private static DataPackConfig m_247013_(String p_251757_, String p_249979_) {
        List $$2 = f_243988_.splitToList((CharSequence)p_251757_);
        List $$3 = f_243988_.splitToList((CharSequence)p_249979_);
        return new DataPackConfig($$2, $$3);
    }

    private static FeatureFlagSet m_246391_(String p_251025_) {
        return FeatureFlags.f_244280_.m_247416_(f_243988_.splitToStream((CharSequence)p_251025_).mapMulti((p_248197_, p_248198_) -> {
            ResourceLocation $$2 = ResourceLocation.m_135820_(p_248197_);
            if ($$2 == null) {
                f_214805_.warn("Invalid resource location {}, ignoring", p_248197_);
            } else {
                p_248198_.accept($$2);
            }
        }).collect(Collectors.toList()));
    }

    public WorldDimensions m_246483_(RegistryAccess p_250466_) {
        return this.f_244504_.m_247373_(p_250466_);
    }

    @Override
    protected /* synthetic */ Settings m_6764_(RegistryAccess registryAccess, Properties properties) {
        return this.m_6764_(registryAccess, properties);
    }

    record WorldDimensionData(JsonObject f_244404_, String f_243780_) {
        private static final Map<String, ResourceKey<WorldPreset>> f_244358_ = Map.of("default", WorldPresets.f_226437_, "largebiomes", WorldPresets.f_226439_);

        public WorldDimensions m_247373_(RegistryAccess p_248812_) {
            Registry<WorldPreset> $$1 = p_248812_.m_175515_(Registries.f_256729_);
            Holder.Reference<WorldPreset> $$2 = $$1.m_203636_(WorldPresets.f_226437_).or(() -> $$1.m_203611_().findAny()).orElseThrow(() -> new IllegalStateException("Invalid datapack contents: can't find default preset"));
            Holder $$3 = Optional.ofNullable(ResourceLocation.m_135820_(this.f_243780_)).map(p_258240_ -> ResourceKey.m_135785_(Registries.f_256729_, p_258240_)).or(() -> Optional.ofNullable(f_244358_.get(this.f_243780_))).flatMap($$1::m_203636_).orElseGet(() -> {
                f_214805_.warn("Failed to parse level-type {}, defaulting to {}", (Object)this.f_243780_, (Object)$$2.m_205785_().m_135782_());
                return $$2;
            });
            WorldDimensions $$4 = ((WorldPreset)$$3.m_203334_()).m_247748_();
            if ($$3.m_203565_(WorldPresets.f_226438_)) {
                RegistryOps $$5 = RegistryOps.m_255058_(JsonOps.INSTANCE, p_248812_);
                Optional $$6 = FlatLevelGeneratorSettings.f_70347_.parse(new Dynamic($$5, (Object)this.f_244404_())).resultOrPartial(arg_0 -> ((Logger)f_214805_).error(arg_0));
                if ($$6.isPresent()) {
                    return $$4.m_246747_(p_248812_, new FlatLevelSource((FlatLevelGeneratorSettings)$$6.get()));
                }
            }
            return $$4;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{WorldDimensionData.class, "generatorSettings;levelType", "f_244404_", "f_243780_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{WorldDimensionData.class, "generatorSettings;levelType", "f_244404_", "f_243780_"}, this);
        }

        @Override
        public final boolean equals(Object p_248741_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{WorldDimensionData.class, "generatorSettings;levelType", "f_244404_", "f_243780_"}, this, p_248741_);
        }
    }
}

