/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.CompositePackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.IoSupplier;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class FilePackResources
extends AbstractPackResources {
    static final Logger f_215322_ = LogUtils.getLogger();
    private final SharedZipFileAccess f_291183_;
    private final String f_291427_;

    FilePackResources(String p_256076_, SharedZipFileAccess p_298373_, boolean p_256556_, String p_298638_) {
        super(p_256076_, p_256556_);
        this.f_291183_ = p_298373_;
        this.f_291427_ = p_298638_;
    }

    private static String m_245721_(PackType p_250585_, ResourceLocation p_251470_) {
        return String.format(Locale.ROOT, "%s/%s/%s", p_250585_.m_10305_(), p_251470_.m_135827_(), p_251470_.m_135815_());
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... p_248514_) {
        return this.m_247280_(String.join((CharSequence)"/", p_248514_));
    }

    @Override
    public IoSupplier<InputStream> m_214146_(PackType p_249605_, ResourceLocation p_252147_) {
        return this.m_247280_(FilePackResources.m_245721_(p_249605_, p_252147_));
    }

    private String m_292954_(String p_299206_) {
        if (this.f_291427_.isEmpty()) {
            return p_299206_;
        }
        return this.f_291427_ + "/" + p_299206_;
    }

    @Nullable
    private IoSupplier<InputStream> m_247280_(String p_251795_) {
        ZipFile $$1 = this.f_291183_.m_295521_();
        if ($$1 == null) {
            return null;
        }
        ZipEntry $$2 = $$1.getEntry(this.m_292954_(p_251795_));
        if ($$2 == null) {
            return null;
        }
        return IoSupplier.m_247178_($$1, $$2);
    }

    @Override
    public Set<String> m_5698_(PackType p_10238_) {
        ZipFile $$1 = this.f_291183_.m_295521_();
        if ($$1 == null) {
            return Set.of();
        }
        Enumeration<? extends ZipEntry> $$2 = $$1.entries();
        HashSet $$3 = Sets.newHashSet();
        String $$4 = this.m_292954_(p_10238_.m_10305_() + "/");
        while ($$2.hasMoreElements()) {
            ZipEntry $$5 = $$2.nextElement();
            String $$6 = $$5.getName();
            String $$7 = FilePackResources.m_293189_($$4, $$6);
            if ($$7.isEmpty()) continue;
            if (ResourceLocation.m_135843_($$7)) {
                $$3.add($$7);
                continue;
            }
            f_215322_.warn("Non [a-z0-9_.-] character in namespace {} in pack {}, ignoring", (Object)$$7, (Object)this.f_291183_.f_291821_);
        }
        return $$3;
    }

    @VisibleForTesting
    public static String m_293189_(String p_298682_, String p_300360_) {
        if (!p_300360_.startsWith(p_298682_)) {
            return "";
        }
        int $$2 = p_298682_.length();
        int $$3 = p_300360_.indexOf(47, $$2);
        if ($$3 == -1) {
            return p_300360_.substring($$2);
        }
        return p_300360_.substring($$2, $$3);
    }

    @Override
    public void close() {
        this.f_291183_.close();
    }

    @Override
    public void m_8031_(PackType p_250500_, String p_249598_, String p_251613_, PackResources.ResourceOutput p_250655_) {
        ZipFile $$4 = this.f_291183_.m_295521_();
        if ($$4 == null) {
            return;
        }
        Enumeration<? extends ZipEntry> $$5 = $$4.entries();
        String $$6 = this.m_292954_(p_250500_.m_10305_() + "/" + p_249598_ + "/");
        String $$7 = $$6 + p_251613_ + "/";
        while ($$5.hasMoreElements()) {
            String $$9;
            ZipEntry $$8 = $$5.nextElement();
            if ($$8.isDirectory() || !($$9 = $$8.getName()).startsWith($$7)) continue;
            String $$10 = $$9.substring($$6.length());
            ResourceLocation $$11 = ResourceLocation.m_214293_(p_249598_, $$10);
            if ($$11 != null) {
                p_250655_.accept($$11, IoSupplier.m_247178_($$4, $$8));
                continue;
            }
            f_215322_.warn("Invalid path in datapack: {}:{}, ignoring", (Object)p_249598_, (Object)$$10);
        }
    }

    static class SharedZipFileAccess
    implements AutoCloseable {
        final File f_291821_;
        @Nullable
        private ZipFile f_291060_;
        private boolean f_291441_;

        SharedZipFileAccess(File p_300196_) {
            this.f_291821_ = p_300196_;
        }

        @Nullable
        ZipFile m_295521_() {
            if (this.f_291441_) {
                return null;
            }
            if (this.f_291060_ == null) {
                try {
                    this.f_291060_ = new ZipFile(this.f_291821_);
                }
                catch (IOException $$0) {
                    f_215322_.error("Failed to open pack {}", (Object)this.f_291821_, (Object)$$0);
                    this.f_291441_ = true;
                    return null;
                }
            }
            return this.f_291060_;
        }

        @Override
        public void close() {
            if (this.f_291060_ != null) {
                IOUtils.closeQuietly((Closeable)this.f_291060_);
                this.f_291060_ = null;
            }
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }

    public static class FileResourcesSupplier
    implements Pack.ResourcesSupplier {
        private final File f_290829_;
        private final boolean f_290522_;

        public FileResourcesSupplier(Path p_301133_, boolean p_297682_) {
            this(p_301133_.toFile(), p_297682_);
        }

        public FileResourcesSupplier(File p_299311_, boolean p_298123_) {
            this.f_290522_ = p_298123_;
            this.f_290829_ = p_299311_;
        }

        @Override
        public PackResources m_293078_(String p_297270_) {
            SharedZipFileAccess $$1 = new SharedZipFileAccess(this.f_290829_);
            return new FilePackResources(p_297270_, $$1, this.f_290522_, "");
        }

        @Override
        public PackResources m_247679_(String p_299586_, Pack.Info p_299388_) {
            SharedZipFileAccess $$2 = new SharedZipFileAccess(this.f_290829_);
            FilePackResources $$3 = new FilePackResources(p_299586_, $$2, this.f_290522_, "");
            List<String> $$4 = p_299388_.f_291122_();
            if ($$4.isEmpty()) {
                return $$3;
            }
            ArrayList<PackResources> $$5 = new ArrayList<PackResources>($$4.size());
            for (String $$6 : $$4) {
                $$5.add(new FilePackResources(p_299586_, $$2, this.f_290522_, $$6));
            }
            return new CompositePackResources($$3, $$5);
        }
    }
}

