/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.linkfs;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.ReadOnlyFileSystemException;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.server.packs.linkfs.DummyFileAttributes;
import net.minecraft.server.packs.linkfs.LinkFileSystem;
import net.minecraft.server.packs.linkfs.PathContents;

class LinkFSPath
implements Path {
    private static final BasicFileAttributes f_243881_ = new DummyFileAttributes(){

        @Override
        public boolean isRegularFile() {
            return false;
        }

        @Override
        public boolean isDirectory() {
            return true;
        }
    };
    private static final BasicFileAttributes f_243746_ = new DummyFileAttributes(){

        @Override
        public boolean isRegularFile() {
            return true;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }
    };
    private static final Comparator<LinkFSPath> f_244038_ = Comparator.comparing(LinkFSPath::m_245921_);
    private final String f_244036_;
    private final LinkFileSystem f_243986_;
    @Nullable
    private final LinkFSPath f_244587_;
    @Nullable
    private List<String> f_244015_;
    @Nullable
    private String f_243677_;
    private final PathContents f_244000_;

    public LinkFSPath(LinkFileSystem p_251111_, String p_250681_, @Nullable LinkFSPath p_251363_, PathContents p_251268_) {
        this.f_243986_ = p_251111_;
        this.f_244036_ = p_250681_;
        this.f_244587_ = p_251363_;
        this.f_244000_ = p_251268_;
    }

    private LinkFSPath m_245307_(@Nullable LinkFSPath p_249276_, String p_249966_) {
        return new LinkFSPath(this.f_243986_, p_249966_, p_249276_, PathContents.f_244185_);
    }

    @Override
    public LinkFileSystem getFileSystem() {
        return this.f_243986_;
    }

    @Override
    public boolean isAbsolute() {
        return this.f_244000_ != PathContents.f_244185_;
    }

    @Override
    public File toFile() {
        PathContents pathContents = this.f_244000_;
        if (pathContents instanceof PathContents.FileContents) {
            PathContents.FileContents $$0 = (PathContents.FileContents)pathContents;
            return $$0.f_244421_().toFile();
        }
        throw new UnsupportedOperationException("Path " + this.m_245921_() + " does not represent file");
    }

    @Override
    @Nullable
    public LinkFSPath getRoot() {
        if (this.isAbsolute()) {
            return this.f_243986_.m_247062_();
        }
        return null;
    }

    @Override
    public LinkFSPath getFileName() {
        return this.m_245307_(null, this.f_244036_);
    }

    @Override
    @Nullable
    public LinkFSPath getParent() {
        return this.f_244587_;
    }

    @Override
    public int getNameCount() {
        return this.m_246070_().size();
    }

    private List<String> m_246070_() {
        if (this.f_244036_.isEmpty()) {
            return List.of();
        }
        if (this.f_244015_ == null) {
            ImmutableList.Builder $$0 = ImmutableList.builder();
            if (this.f_244587_ != null) {
                $$0.addAll(this.f_244587_.m_246070_());
            }
            $$0.add((Object)this.f_244036_);
            this.f_244015_ = $$0.build();
        }
        return this.f_244015_;
    }

    @Override
    public LinkFSPath getName(int p_248550_) {
        List<String> $$1 = this.m_246070_();
        if (p_248550_ < 0 || p_248550_ >= $$1.size()) {
            throw new IllegalArgumentException("Invalid index: " + p_248550_);
        }
        return this.m_245307_(null, $$1.get(p_248550_));
    }

    @Override
    public LinkFSPath subpath(int p_251923_, int p_248807_) {
        List<String> $$2 = this.m_246070_();
        if (p_251923_ < 0 || p_248807_ > $$2.size() || p_251923_ >= p_248807_) {
            throw new IllegalArgumentException();
        }
        LinkFSPath $$3 = null;
        for (int $$4 = p_251923_; $$4 < p_248807_; ++$$4) {
            $$3 = this.m_245307_($$3, $$2.get($$4));
        }
        return $$3;
    }

    @Override
    public boolean startsWith(Path p_248923_) {
        if (p_248923_.isAbsolute() != this.isAbsolute()) {
            return false;
        }
        if (p_248923_ instanceof LinkFSPath) {
            LinkFSPath $$1 = (LinkFSPath)p_248923_;
            if ($$1.f_243986_ != this.f_243986_) {
                return false;
            }
            List<String> $$2 = this.m_246070_();
            List<String> $$3 = $$1.m_246070_();
            int $$4 = $$3.size();
            if ($$4 > $$2.size()) {
                return false;
            }
            for (int $$5 = 0; $$5 < $$4; ++$$5) {
                if ($$3.get($$5).equals($$2.get($$5))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean endsWith(Path p_250070_) {
        if (p_250070_.isAbsolute() && !this.isAbsolute()) {
            return false;
        }
        if (p_250070_ instanceof LinkFSPath) {
            LinkFSPath $$1 = (LinkFSPath)p_250070_;
            if ($$1.f_243986_ != this.f_243986_) {
                return false;
            }
            List<String> $$2 = this.m_246070_();
            List<String> $$3 = $$1.m_246070_();
            int $$4 = $$3.size();
            int $$5 = $$2.size() - $$4;
            if ($$5 < 0) {
                return false;
            }
            for (int $$6 = $$4 - 1; $$6 >= 0; --$$6) {
                if ($$3.get($$6).equals($$2.get($$5 + $$6))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public LinkFSPath normalize() {
        return this;
    }

    @Override
    public LinkFSPath resolve(Path p_251657_) {
        LinkFSPath $$1 = this.m_246027_(p_251657_);
        if (p_251657_.isAbsolute()) {
            return $$1;
        }
        return this.m_246014_($$1.m_246070_());
    }

    private LinkFSPath m_246014_(List<String> p_252101_) {
        LinkFSPath $$1 = this;
        for (String $$2 : p_252101_) {
            $$1 = $$1.m_247714_($$2);
        }
        return $$1;
    }

    LinkFSPath m_247714_(String p_249718_) {
        if (LinkFSPath.m_245789_(this.f_244000_)) {
            return new LinkFSPath(this.f_243986_, p_249718_, this, this.f_244000_);
        }
        PathContents pathContents = this.f_244000_;
        if (pathContents instanceof PathContents.DirectoryContents) {
            PathContents.DirectoryContents $$1 = (PathContents.DirectoryContents)pathContents;
            LinkFSPath $$2 = $$1.f_243989_().get(p_249718_);
            return $$2 != null ? $$2 : new LinkFSPath(this.f_243986_, p_249718_, this, PathContents.f_244612_);
        }
        if (this.f_244000_ instanceof PathContents.FileContents) {
            return new LinkFSPath(this.f_243986_, p_249718_, this, PathContents.f_244612_);
        }
        throw new AssertionError((Object)"All content types should be already handled");
    }

    private static boolean m_245789_(PathContents p_248750_) {
        return p_248750_ == PathContents.f_244612_ || p_248750_ == PathContents.f_244185_;
    }

    @Override
    public LinkFSPath relativize(Path p_250294_) {
        LinkFSPath $$1 = this.m_246027_(p_250294_);
        if (this.isAbsolute() != $$1.isAbsolute()) {
            throw new IllegalArgumentException("absolute mismatch");
        }
        List<String> $$2 = this.m_246070_();
        List<String> $$3 = $$1.m_246070_();
        if ($$2.size() >= $$3.size()) {
            throw new IllegalArgumentException();
        }
        for (int $$4 = 0; $$4 < $$2.size(); ++$$4) {
            if ($$2.get($$4).equals($$3.get($$4))) continue;
            throw new IllegalArgumentException();
        }
        return $$1.subpath($$2.size(), $$3.size());
    }

    @Override
    public URI toUri() {
        try {
            return new URI("x-mc-link", this.f_243986_.m_246857_().name(), this.m_245921_(), null);
        }
        catch (URISyntaxException $$0) {
            throw new AssertionError("Failed to create URI", $$0);
        }
    }

    @Override
    public LinkFSPath toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        return this.f_243986_.m_247062_().resolve(this);
    }

    @Override
    public LinkFSPath toRealPath(LinkOption ... p_251187_) {
        return this.toAbsolutePath();
    }

    @Override
    public WatchKey register(WatchService p_249189_, WatchEvent.Kind<?>[] p_249917_, WatchEvent.Modifier ... p_251602_) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareTo(Path p_250005_) {
        LinkFSPath $$1 = this.m_246027_(p_250005_);
        return f_244038_.compare(this, $$1);
    }

    @Override
    public boolean equals(Object p_248707_) {
        if (p_248707_ == this) {
            return true;
        }
        if (p_248707_ instanceof LinkFSPath) {
            LinkFSPath $$1 = (LinkFSPath)p_248707_;
            if (this.f_243986_ != $$1.f_243986_) {
                return false;
            }
            boolean $$2 = this.m_246418_();
            if ($$2 != $$1.m_246418_()) {
                return false;
            }
            if ($$2) {
                return this.f_244000_ == $$1.f_244000_;
            }
            return Objects.equals(this.f_244587_, $$1.f_244587_) && Objects.equals(this.f_244036_, $$1.f_244036_);
        }
        return false;
    }

    private boolean m_246418_() {
        return !LinkFSPath.m_245789_(this.f_244000_);
    }

    @Override
    public int hashCode() {
        return this.m_246418_() ? this.f_244000_.hashCode() : this.f_244036_.hashCode();
    }

    @Override
    public String toString() {
        return this.m_245921_();
    }

    private String m_245921_() {
        if (this.f_243677_ == null) {
            StringBuilder $$0 = new StringBuilder();
            if (this.isAbsolute()) {
                $$0.append("/");
            }
            Joiner.on((String)"/").appendTo($$0, this.m_246070_());
            this.f_243677_ = $$0.toString();
        }
        return this.f_243677_;
    }

    private LinkFSPath m_246027_(@Nullable Path p_250907_) {
        if (p_250907_ == null) {
            throw new NullPointerException();
        }
        if (p_250907_ instanceof LinkFSPath) {
            LinkFSPath $$1 = (LinkFSPath)p_250907_;
            if ($$1.f_243986_ == this.f_243986_) {
                return $$1;
            }
        }
        throw new ProviderMismatchException();
    }

    public boolean m_245626_() {
        return this.m_246418_();
    }

    @Nullable
    public Path m_247488_() {
        Path path;
        PathContents pathContents = this.f_244000_;
        if (pathContents instanceof PathContents.FileContents) {
            PathContents.FileContents $$0 = (PathContents.FileContents)pathContents;
            path = $$0.f_244421_();
        } else {
            path = null;
        }
        return path;
    }

    @Nullable
    public PathContents.DirectoryContents m_245177_() {
        PathContents.DirectoryContents $$0;
        PathContents pathContents = this.f_244000_;
        return pathContents instanceof PathContents.DirectoryContents ? ($$0 = (PathContents.DirectoryContents)pathContents) : null;
    }

    public BasicFileAttributeView m_246530_() {
        return new BasicFileAttributeView(){

            @Override
            public String name() {
                return "basic";
            }

            @Override
            public BasicFileAttributes readAttributes() throws IOException {
                return LinkFSPath.this.m_246308_();
            }

            @Override
            public void setTimes(FileTime p_249505_, FileTime p_250498_, FileTime p_251700_) {
                throw new ReadOnlyFileSystemException();
            }
        };
    }

    public BasicFileAttributes m_246308_() throws IOException {
        if (this.f_244000_ instanceof PathContents.DirectoryContents) {
            return f_243881_;
        }
        if (this.f_244000_ instanceof PathContents.FileContents) {
            return f_243746_;
        }
        throw new NoSuchFileException(this.m_245921_());
    }

    @Override
    public /* synthetic */ Path toRealPath(LinkOption[] linkOptionArray) throws IOException {
        return this.toRealPath(linkOptionArray);
    }

    @Override
    public /* synthetic */ Path toAbsolutePath() {
        return this.toAbsolutePath();
    }

    @Override
    public /* synthetic */ Path relativize(Path path) {
        return this.relativize(path);
    }

    @Override
    public /* synthetic */ Path resolve(Path path) {
        return this.resolve(path);
    }

    @Override
    public /* synthetic */ Path normalize() {
        return this.normalize();
    }

    @Override
    public /* synthetic */ Path subpath(int n, int n2) {
        return this.subpath(n, n2);
    }

    @Override
    public /* synthetic */ Path getName(int n) {
        return this.getName(n);
    }

    @Override
    @Nullable
    public /* synthetic */ Path getParent() {
        return this.getParent();
    }

    @Override
    public /* synthetic */ Path getFileName() {
        return this.getFileName();
    }

    @Override
    @Nullable
    public /* synthetic */ Path getRoot() {
        return this.getRoot();
    }

    @Override
    public /* synthetic */ FileSystem getFileSystem() {
        return this.getFileSystem();
    }
}

