/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.FileUtil;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.nbt.visitors.SkipFields;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.DirectoryLock;
import net.minecraft.util.MemoryReserve;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.PlayerDataStorage;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.minecraft.world.level.validation.ForbiddenSymlinkInfo;
import net.minecraft.world.level.validation.PathAllowList;
import org.slf4j.Logger;

public class LevelStorageSource {
    static final Logger f_78191_ = LogUtils.getLogger();
    static final DateTimeFormatter f_78192_ = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('_').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral('-').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral('-').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
    private static final ImmutableList<String> f_78193_ = ImmutableList.of((Object)"RandomSeed", (Object)"generatorName", (Object)"generatorOptions", (Object)"generatorVersion", (Object)"legacy_custom_options", (Object)"MapFeatures", (Object)"BonusChest");
    private static final String f_202311_ = "Data";
    private static final PathMatcher f_289833_ = p_296993_ -> false;
    public static final String f_289824_ = "allowed_symlinks.txt";
    private static final int f_301626_ = 0x6400000;
    private final Path f_78194_;
    private final Path f_78195_;
    final DataFixer f_78196_;
    private final DirectoryValidator f_289816_;

    public LevelStorageSource(Path p_289985_, Path p_289978_, DirectoryValidator p_289922_, DataFixer p_289940_) {
        this.f_78196_ = p_289940_;
        try {
            FileUtil.m_257659_(p_289985_);
        }
        catch (IOException $$4) {
            throw new UncheckedIOException($$4);
        }
        this.f_78194_ = p_289985_;
        this.f_78195_ = p_289978_;
        this.f_289816_ = p_289922_;
    }

    public static DirectoryValidator m_289881_(Path p_289968_) {
        if (Files.exists(p_289968_, new LinkOption[0])) {
            DirectoryValidator directoryValidator;
            block9: {
                BufferedReader $$1 = Files.newBufferedReader(p_289968_);
                try {
                    directoryValidator = new DirectoryValidator(PathAllowList.m_289888_($$1));
                    if ($$1 == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if ($$1 != null) {
                            try {
                                $$1.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception $$2) {
                        f_78191_.error("Failed to parse {}, disallowing all symbolic links", (Object)f_289824_, (Object)$$2);
                    }
                }
                $$1.close();
            }
            return directoryValidator;
        }
        return new DirectoryValidator(f_289833_);
    }

    public static LevelStorageSource m_78242_(Path p_78243_) {
        DirectoryValidator $$1 = LevelStorageSource.m_289881_(p_78243_.resolve(f_289824_));
        return new LevelStorageSource(p_78243_, p_78243_.resolve("../backups"), $$1, DataFixers.m_14512_());
    }

    private static <T> DataResult<WorldGenSettings> m_247212_(Dynamic<T> p_251661_, DataFixer p_251712_, int p_250368_) {
        Dynamic $$3 = p_251661_.get("WorldGenSettings").orElseEmptyMap();
        for (String $$4 : f_78193_) {
            Optional $$5 = p_251661_.get($$4).result();
            if (!$$5.isPresent()) continue;
            $$3 = $$3.set($$4, (Dynamic)$$5.get());
        }
        Dynamic $$6 = DataFixTypes.WORLD_GEN_SETTINGS.m_264140_(p_251712_, $$3, p_250368_);
        return WorldGenSettings.f_64600_.parse($$6);
    }

    private static WorldDataConfiguration m_245610_(Dynamic<?> p_250884_) {
        return WorldDataConfiguration.f_244621_.parse(p_250884_).resultOrPartial(arg_0 -> ((Logger)f_78191_).error(arg_0)).orElse(WorldDataConfiguration.f_244649_);
    }

    public String m_164909_() {
        return "Anvil";
    }

    public LevelCandidates m_230833_() throws LevelStorageException {
        LevelCandidates levelCandidates;
        block9: {
            if (!Files.isDirectory(this.f_78194_, new LinkOption[0])) {
                throw new LevelStorageException(Component.m_237115_("selectWorld.load_folder_access"));
            }
            Stream<Path> $$0 = Files.list(this.f_78194_);
            try {
                List<LevelDirectory> $$1 = $$0.filter(p_230839_ -> Files.isDirectory(p_230839_, new LinkOption[0])).map(LevelDirectory::new).filter(p_230835_ -> Files.isRegularFile(p_230835_.m_230858_(), new LinkOption[0]) || Files.isRegularFile(p_230835_.m_230859_(), new LinkOption[0])).toList();
                levelCandidates = new LevelCandidates($$1);
                if ($$0 == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if ($$0 != null) {
                        try {
                            $$0.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException $$2) {
                    throw new LevelStorageException(Component.m_237115_("selectWorld.load_folder_access"));
                }
            }
            $$0.close();
        }
        return levelCandidates;
    }

    public CompletableFuture<List<LevelSummary>> m_230813_(LevelCandidates p_230814_) {
        ArrayList<CompletableFuture<LevelSummary>> $$1 = new ArrayList<CompletableFuture<LevelSummary>>(p_230814_.f_230840_.size());
        for (LevelDirectory $$2 : p_230814_.f_230840_) {
            $$1.add(CompletableFuture.supplyAsync(() -> {
                try {
                    boolean $$1 = DirectoryLock.m_13642_($$2.f_230850_());
                }
                catch (Exception $$2) {
                    f_78191_.warn("Failed to read {} lock", (Object)$$2.f_230850_(), (Object)$$2);
                    return null;
                }
                try {
                    void $$3;
                    LevelSummary $$4 = this.m_230817_($$2, this.m_230820_($$2, (boolean)$$3));
                    if ($$4 != null) {
                        return $$4;
                    }
                }
                catch (OutOfMemoryError $$5) {
                    MemoryReserve.m_182328_();
                    System.gc();
                    String $$6 = "Ran out of memory trying to read summary of world folder \"" + $$2.m_230853_() + "\"";
                    f_78191_.error(LogUtils.FATAL_MARKER, $$6);
                    OutOfMemoryError $$7 = new OutOfMemoryError("Ran out of memory reading level data");
                    $$7.initCause($$5);
                    CrashReport $$8 = CrashReport.m_127521_($$7, $$6);
                    CrashReportCategory $$9 = $$8.m_127514_("World details");
                    $$9.m_128159_("Folder Name", $$2.m_230853_());
                    try {
                        long $$10 = Files.size($$2.m_230858_());
                        $$9.m_128159_("level.dat size", $$10);
                    }
                    catch (IOException $$11) {
                        $$9.m_128162_("level.dat size", $$11);
                    }
                    throw new ReportedException($$8);
                }
                return null;
            }, Util.m_183991_()));
        }
        return Util.m_214684_($$1).thenApply(p_230832_ -> p_230832_.stream().filter(Objects::nonNull).sorted().toList());
    }

    private int m_78265_() {
        return 19133;
    }

    @Nullable
    <T> T m_230817_(LevelDirectory p_230818_, BiFunction<Path, DataFixer, T> p_230819_) {
        T $$3;
        if (!Files.exists(p_230818_.f_230850_(), new LinkOption[0])) {
            return null;
        }
        Path $$2 = p_230818_.m_230858_();
        if (Files.exists($$2, new LinkOption[0]) && ($$3 = p_230819_.apply($$2, this.f_78196_)) != null) {
            return $$3;
        }
        $$2 = p_230818_.m_230859_();
        if (Files.exists($$2, new LinkOption[0])) {
            return p_230819_.apply($$2, this.f_78196_);
        }
        return null;
    }

    @Nullable
    private static WorldDataConfiguration m_230828_(Path p_230829_, DataFixer p_230830_) {
        try {
            Tag $$2 = LevelStorageSource.m_230836_(p_230829_);
            if ($$2 instanceof CompoundTag) {
                CompoundTag $$3 = (CompoundTag)$$2;
                CompoundTag $$4 = $$3.m_128469_(f_202311_);
                int $$5 = NbtUtils.m_264487_($$4, -1);
                Dynamic $$6 = DataFixTypes.LEVEL.m_264140_(p_230830_, new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)$$4), $$5);
                return LevelStorageSource.m_245610_($$6);
            }
        }
        catch (Exception $$7) {
            f_78191_.error("Exception reading {}", (Object)p_230829_, (Object)$$7);
        }
        return null;
    }

    static BiFunction<Path, DataFixer, Pair<WorldData, WorldDimensions.Complete>> m_245503_(DynamicOps<Tag> p_250592_, WorldDataConfiguration p_249054_, Registry<LevelStem> p_249363_, Lifecycle p_251214_) {
        return (p_265020_, p_265021_) -> {
            void $$8;
            try {
                CompoundTag $$6 = NbtIo.m_128937_(p_265020_.toFile());
            }
            catch (IOException $$7) {
                throw new UncheckedIOException($$7);
            }
            CompoundTag $$9 = $$8.m_128469_(f_202311_);
            CompoundTag $$10 = $$9.m_128425_("Player", 10) ? $$9.m_128469_("Player") : null;
            $$9.m_128473_("Player");
            int $$11 = NbtUtils.m_264487_($$9, -1);
            Dynamic $$12 = DataFixTypes.LEVEL.m_264140_((DataFixer)p_265021_, new Dynamic(p_250592_, (Object)$$9), $$11);
            WorldGenSettings $$13 = (WorldGenSettings)LevelStorageSource.m_247212_($$12, p_265021_, $$11).getOrThrow(false, Util.m_137489_("WorldGenSettings: ", arg_0 -> ((Logger)f_78191_).error(arg_0)));
            LevelVersion $$14 = LevelVersion.m_78390_($$12);
            LevelSettings $$15 = LevelSettings.m_46924_($$12, p_249054_);
            WorldDimensions.Complete $$16 = $$13.f_64605_().m_245300_(p_249363_);
            Lifecycle $$17 = $$16.m_245945_().add(p_251214_);
            PrimaryLevelData $$18 = PrimaryLevelData.m_78530_($$12, p_265021_, $$11, $$10, $$15, $$14, $$16.f_244634_(), $$13.f_243992_(), $$17);
            return Pair.of((Object)$$18, (Object)$$16);
        };
    }

    BiFunction<Path, DataFixer, LevelSummary> m_230820_(LevelDirectory p_230821_, boolean p_230822_) {
        return (p_296991_, p_296992_) -> {
            try {
                List<ForbiddenSymlinkInfo> $$4;
                if (Files.isSymbolicLink(p_296991_) && !($$4 = this.f_289816_.m_295373_((Path)p_296991_)).isEmpty()) {
                    f_78191_.warn("{}", (Object)ContentValidationException.m_289907_(p_296991_, $$4));
                    return new LevelSummary.SymlinkLevelSummary(p_230821_.m_230853_(), p_230821_.m_230860_());
                }
                Tag $$5 = LevelStorageSource.m_230836_(p_296991_);
                if ($$5 instanceof CompoundTag) {
                    int $$8;
                    CompoundTag $$6 = (CompoundTag)$$5;
                    CompoundTag $$7 = $$6.m_128469_(f_202311_);
                    Dynamic $$9 = DataFixTypes.LEVEL.m_264140_((DataFixer)p_296992_, new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)$$7), $$8 = NbtUtils.m_264487_($$7, -1));
                    LevelVersion $$10 = LevelVersion.m_78390_($$9);
                    int $$11 = $$10.m_78389_();
                    if ($$11 == 19132 || $$11 == 19133) {
                        boolean $$12 = $$11 != this.m_78265_();
                        Path $$13 = p_230821_.m_230860_();
                        WorldDataConfiguration $$14 = LevelStorageSource.m_245610_($$9);
                        LevelSettings $$15 = LevelSettings.m_46924_($$9, $$14);
                        FeatureFlagSet $$16 = LevelStorageSource.m_247076_($$9);
                        boolean $$17 = FeatureFlags.m_246811_($$16);
                        return new LevelSummary($$15, $$10, p_230821_.m_230853_(), $$12, p_230822_, $$17, $$13);
                    }
                } else {
                    f_78191_.warn("Invalid root tag in {}", p_296991_);
                }
                return null;
            }
            catch (Exception $$18) {
                f_78191_.error("Exception reading {}", p_296991_, (Object)$$18);
                return null;
            }
        };
    }

    private static FeatureFlagSet m_247076_(Dynamic<?> p_249466_) {
        Set<ResourceLocation> $$1 = p_249466_.get("enabled_features").asStream().flatMap(p_248492_ -> p_248492_.asString().result().map(ResourceLocation::m_135820_).stream()).collect(Collectors.toSet());
        return FeatureFlags.f_244280_.m_247021_($$1, p_248503_ -> {});
    }

    @Nullable
    private static Tag m_230836_(Path p_230837_) throws IOException {
        SkipFields $$1 = new SkipFields(new FieldSelector(f_202311_, CompoundTag.f_128326_, "Player"), new FieldSelector(f_202311_, CompoundTag.f_128326_, "WorldGenSettings"));
        NbtIo.m_202487_(p_230837_.toFile(), $$1, NbtAccounter.m_301677_(0x6400000L));
        return $$1.m_197713_();
    }

    public boolean m_78240_(String p_78241_) {
        try {
            Path $$1 = this.m_289874_(p_78241_);
            Files.createDirectory($$1, new FileAttribute[0]);
            Files.deleteIfExists($$1);
            return true;
        }
        catch (IOException $$2) {
            return false;
        }
    }

    public boolean m_78255_(String p_78256_) {
        try {
            return Files.isDirectory(this.m_289874_(p_78256_), new LinkOption[0]);
        }
        catch (InvalidPathException $$1) {
            return false;
        }
    }

    public Path m_289874_(String p_289974_) {
        return this.f_78194_.resolve(p_289974_);
    }

    public Path m_78257_() {
        return this.f_78194_;
    }

    public Path m_78262_() {
        return this.f_78195_;
    }

    public LevelStorageAccess m_289864_(String p_289980_) throws IOException, ContentValidationException {
        Path $$1 = this.m_289874_(p_289980_);
        List<ForbiddenSymlinkInfo> $$2 = this.f_289816_.m_294444_($$1, true);
        if (!$$2.isEmpty()) {
            throw new ContentValidationException($$1, $$2);
        }
        return new LevelStorageAccess(p_289980_, $$1);
    }

    public LevelStorageAccess m_78260_(String p_78261_) throws IOException {
        Path $$1 = this.m_289874_(p_78261_);
        return new LevelStorageAccess(p_78261_, $$1);
    }

    public DirectoryValidator m_289863_() {
        return this.f_289816_;
    }

    public record LevelCandidates(List<LevelDirectory> f_230840_) implements Iterable<LevelDirectory>
    {
        public boolean m_230843_() {
            return this.f_230840_.isEmpty();
        }

        @Override
        public Iterator<LevelDirectory> iterator() {
            return this.f_230840_.iterator();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{LevelCandidates.class, "levels", "f_230840_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LevelCandidates.class, "levels", "f_230840_"}, this);
        }

        @Override
        public final boolean equals(Object p_230846_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LevelCandidates.class, "levels", "f_230840_"}, this, p_230846_);
        }
    }

    public record LevelDirectory(Path f_230850_) {
        public String m_230853_() {
            return this.f_230850_.getFileName().toString();
        }

        public Path m_230858_() {
            return this.m_230854_(LevelResource.f_78178_);
        }

        public Path m_230859_() {
            return this.m_230854_(LevelResource.f_230800_);
        }

        public Path m_230856_(LocalDateTime p_230857_) {
            return this.f_230850_.resolve(LevelResource.f_78178_.m_78187_() + "_corrupted_" + p_230857_.format(f_78192_));
        }

        public Path m_230860_() {
            return this.m_230854_(LevelResource.f_230801_);
        }

        public Path m_230861_() {
            return this.m_230854_(LevelResource.f_230802_);
        }

        public Path m_230854_(LevelResource p_230855_) {
            return this.f_230850_.resolve(p_230855_.m_78187_());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{LevelDirectory.class, "path", "f_230850_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LevelDirectory.class, "path", "f_230850_"}, this);
        }

        @Override
        public final boolean equals(Object p_230863_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LevelDirectory.class, "path", "f_230850_"}, this, p_230863_);
        }
    }

    public class LevelStorageAccess
    implements AutoCloseable {
        final DirectoryLock f_78270_;
        final LevelDirectory f_230867_;
        private final String f_78272_;
        private final Map<LevelResource, Path> f_78273_ = Maps.newHashMap();

        LevelStorageAccess(String p_289967_, Path p_289988_) throws IOException {
            this.f_78272_ = p_289967_;
            this.f_230867_ = new LevelDirectory(p_289988_);
            this.f_78270_ = DirectoryLock.m_13640_(p_289988_);
        }

        public LevelStorageSource m_295711_() {
            return LevelStorageSource.this;
        }

        public String m_78277_() {
            return this.f_78272_;
        }

        public Path m_78283_(LevelResource p_78284_) {
            return this.f_78273_.computeIfAbsent(p_78284_, this.f_230867_::m_230854_);
        }

        public Path m_197394_(ResourceKey<Level> p_197395_) {
            return DimensionType.m_196975_(p_197395_, this.f_230867_.f_230850_());
        }

        private void m_78313_() {
            if (!this.f_78270_.m_13639_()) {
                throw new IllegalStateException("Lock is no longer valid");
            }
        }

        public PlayerDataStorage m_78301_() {
            this.m_78313_();
            return new PlayerDataStorage(this, LevelStorageSource.this.f_78196_);
        }

        @Nullable
        public LevelSummary m_78308_() {
            this.m_78313_();
            return LevelStorageSource.this.m_230817_(this.f_230867_, LevelStorageSource.this.m_230820_(this.f_230867_, false));
        }

        @Nullable
        public Pair<WorldData, WorldDimensions.Complete> m_246049_(DynamicOps<Tag> p_248747_, WorldDataConfiguration p_251873_, Registry<LevelStem> p_249187_, Lifecycle p_249736_) {
            this.m_78313_();
            return LevelStorageSource.this.m_230817_(this.f_230867_, LevelStorageSource.m_245503_(p_248747_, p_251873_, p_249187_, p_249736_));
        }

        @Nullable
        public WorldDataConfiguration m_247706_() {
            this.m_78313_();
            return LevelStorageSource.this.m_230817_(this.f_230867_, LevelStorageSource::m_230828_);
        }

        public void m_78287_(RegistryAccess p_78288_, WorldData p_78289_) {
            this.m_78290_(p_78288_, p_78289_, null);
        }

        public void m_78290_(RegistryAccess p_78291_, WorldData p_78292_, @Nullable CompoundTag p_78293_) {
            File $$3 = this.f_230867_.f_230850_().toFile();
            CompoundTag $$4 = p_78292_.m_6626_(p_78291_, p_78293_);
            CompoundTag $$5 = new CompoundTag();
            $$5.m_128365_(LevelStorageSource.f_202311_, $$4);
            try {
                File $$6 = File.createTempFile("level", ".dat", $$3);
                NbtIo.m_128944_($$5, $$6);
                File $$7 = this.f_230867_.m_230859_().toFile();
                File $$8 = this.f_230867_.m_230858_().toFile();
                Util.m_137462_($$8, $$6, $$7);
            }
            catch (Exception $$9) {
                f_78191_.error("Failed to save level {}", (Object)$$3, (Object)$$9);
            }
        }

        public Optional<Path> m_182514_() {
            if (!this.f_78270_.m_13639_()) {
                return Optional.empty();
            }
            return Optional.of(this.f_230867_.m_230860_());
        }

        public void m_78311_() throws IOException {
            this.m_78313_();
            final Path $$0 = this.f_230867_.m_230861_();
            f_78191_.info("Deleting level {}", (Object)this.f_78272_);
            for (int $$1 = 1; $$1 <= 5; ++$$1) {
                f_78191_.info("Attempt {}...", (Object)$$1);
                try {
                    Files.walkFileTree(this.f_230867_.f_230850_(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path p_78323_, BasicFileAttributes p_78324_) throws IOException {
                            if (!p_78323_.equals($$0)) {
                                f_78191_.debug("Deleting {}", (Object)p_78323_);
                                Files.delete(p_78323_);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path p_78320_, @Nullable IOException p_78321_) throws IOException {
                            if (p_78321_ != null) {
                                throw p_78321_;
                            }
                            if (p_78320_.equals(LevelStorageAccess.this.f_230867_.f_230850_())) {
                                LevelStorageAccess.this.f_78270_.close();
                                Files.deleteIfExists($$0);
                            }
                            Files.delete(p_78320_);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public /* synthetic */ FileVisitResult postVisitDirectory(Object object, @Nullable IOException iOException) throws IOException {
                            return this.postVisitDirectory((Path)object, iOException);
                        }

                        @Override
                        public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                            return this.visitFile((Path)object, basicFileAttributes);
                        }
                    });
                    break;
                }
                catch (IOException $$2) {
                    if ($$1 < 5) {
                        f_78191_.warn("Failed to delete {}", (Object)this.f_230867_.f_230850_(), (Object)$$2);
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    throw $$2;
                }
            }
        }

        public void m_78297_(String p_78298_) throws IOException {
            this.m_78313_();
            Path $$1 = this.f_230867_.m_230858_();
            if (Files.exists($$1, new LinkOption[0])) {
                CompoundTag $$2 = NbtIo.m_128937_($$1.toFile());
                CompoundTag $$3 = $$2.m_128469_(LevelStorageSource.f_202311_);
                $$3.m_128359_("LevelName", p_78298_);
                NbtIo.m_128944_($$2, $$1.toFile());
            }
        }

        public long m_78312_() throws IOException {
            this.m_78313_();
            String $$0 = LocalDateTime.now().format(f_78192_) + "_" + this.f_78272_;
            Path $$1 = LevelStorageSource.this.m_78262_();
            try {
                FileUtil.m_257659_($$1);
            }
            catch (IOException $$2) {
                throw new RuntimeException($$2);
            }
            Path $$3 = $$1.resolve(FileUtil.m_133730_($$1, $$0, ".zip"));
            try (final ZipOutputStream $$4 = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream($$3, new OpenOption[0])));){
                final Path $$5 = Paths.get(this.f_78272_, new String[0]);
                Files.walkFileTree(this.f_230867_.f_230850_(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path p_78339_, BasicFileAttributes p_78340_) throws IOException {
                        if (p_78339_.endsWith("session.lock")) {
                            return FileVisitResult.CONTINUE;
                        }
                        String $$2 = $$5.resolve(LevelStorageAccess.this.f_230867_.f_230850_().relativize(p_78339_)).toString().replace('\\', '/');
                        ZipEntry $$3 = new ZipEntry($$2);
                        $$4.putNextEntry($$3);
                        com.google.common.io.Files.asByteSource((File)p_78339_.toFile()).copyTo((OutputStream)$$4);
                        $$4.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                        return this.visitFile((Path)object, basicFileAttributes);
                    }
                });
            }
            return Files.size($$3);
        }

        @Override
        public void close() throws IOException {
            this.f_78270_.close();
        }
    }
}

