/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.securemodules;

import cpw.mods.jarhandling.SecureJar;
import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.net.URI;
import java.security.CodeSigner;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import net.minecraftforge.securemodules.SecureModuleReference;

public class SecureModuleFinder
implements ModuleFinder {
    private final Map<String, ModuleReference> references = new HashMap<String, ModuleReference>();

    protected SecureModuleFinder(SecureJar ... jars) {
        for (SecureJar jar : jars) {
            SecureJar.ModuleDataProvider data = jar.moduleDataProvider();
            if (this.references.containsKey(data.name())) {
                System.out.println("Ignoring duplicate module on SecureModuleFinder: " + data.name() + ": " + jar);
                continue;
            }
            this.references.put(data.name(), new Reference(data));
        }
    }

    @Override
    public Optional<ModuleReference> find(String name) {
        return Optional.ofNullable(this.references.get(name));
    }

    @Override
    public Set<ModuleReference> findAll() {
        return new HashSet<ModuleReference>(this.references.values());
    }

    public static SecureModuleFinder of(SecureJar ... jars) {
        return new SecureModuleFinder(jars);
    }

    private static class Reference
    extends SecureModuleReference {
        private final SecureJar.ModuleDataProvider jar;
        private final Manifest manifest;

        Reference(SecureJar.ModuleDataProvider jar) {
            super(jar.descriptor(), jar.uri());
            this.jar = jar;
            this.manifest = jar.getManifest();
        }

        @Override
        public ModuleReader open() throws IOException {
            return new Reader(this.jar);
        }

        @Override
        public Attributes getMainAttributes() {
            return this.manifest == null ? null : this.manifest.getMainAttributes();
        }

        @Override
        public Attributes getTrustedAttributes(String entry) {
            return this.manifest == null ? null : this.manifest.getAttributes(entry);
        }

        @Override
        public CodeSigner[] getCodeSigners(String entry, byte[] data) {
            return this.jar.verifyAndGetSigners(entry, data);
        }
    }

    private static class Reader
    implements ModuleReader {
        private final SecureJar.ModuleDataProvider jar;

        public Reader(SecureJar.ModuleDataProvider jar) {
            this.jar = jar;
        }

        @Override
        public Optional<URI> find(String name) throws IOException {
            return this.jar.findFile(name);
        }

        @Override
        public Optional<InputStream> open(String name) throws IOException {
            return this.jar.open(name);
        }

        @Override
        public Stream<String> list() throws IOException {
            return null;
        }

        @Override
        public void close() throws IOException {
        }

        public String toString() {
            return "JarModuleFinder.Reader[jar=" + this.jar + "]";
        }
    }
}

