/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.worldselection;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.FileUtil;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.GridLayoutTab;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.layouts.CommonLayouts;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.client.gui.screens.worldselection.ConfirmExperimentalFeaturesScreen;
import net.minecraft.client.gui.screens.worldselection.EditGameRulesScreen;
import net.minecraft.client.gui.screens.worldselection.ExperimentsScreen;
import net.minecraft.client.gui.screens.worldselection.PresetEditor;
import net.minecraft.client.gui.screens.worldselection.SwitchGrid;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.client.gui.screens.worldselection.WorldCreationUiState;
import net.minecraft.client.gui.screens.worldselection.WorldOpenFlows;
import net.minecraft.commands.Commands;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.resource.ResourcePackLoader;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class CreateWorldScreen
extends Screen {
    private static final int f_267463_ = 1;
    private static final int f_267486_ = 210;
    private static final int f_267453_ = 36;
    private static final Logger f_100848_ = LogUtils.getLogger();
    private static final String f_170147_ = "mcworld-";
    static final Component f_100849_ = Component.m_237115_((String)"selectWorld.gameMode");
    static final Component f_100852_ = Component.m_237115_((String)"selectWorld.enterName");
    static final Component f_268721_ = Component.m_237115_((String)"selectWorld.experiments");
    static final Component f_267456_ = Component.m_237115_((String)"selectWorld.allowCommands.info");
    private static final Component f_232866_ = Component.m_237115_((String)"createWorld.preparing");
    private static final int f_267420_ = 10;
    private static final int f_267460_ = 8;
    public static final ResourceLocation f_273823_ = new ResourceLocation("textures/gui/header_separator.png");
    public static final ResourceLocation f_273875_ = new ResourceLocation("textures/gui/footer_separator.png");
    public static final ResourceLocation f_279536_ = new ResourceLocation("textures/gui/light_dirt_background.png");
    final WorldCreationUiState f_267389_;
    private final TabManager f_267424_ = new TabManager(this::m_142416_, p_267853_ -> this.m_169411_((GuiEventListener)p_267853_));
    private boolean f_268587_;
    private final DirectoryValidator f_291518_;
    @Nullable
    private final Screen f_100855_;
    @Nullable
    private Path f_100831_;
    @Nullable
    private PackRepository f_100832_;
    @Nullable
    private GridLayout f_267391_;
    @Nullable
    private TabNavigationBar f_267490_;

    public static void m_232896_(Minecraft p_232897_, @Nullable Screen p_232898_) {
        CreateWorldScreen.m_232899_(p_232897_, f_232866_);
        PackRepository packrepository = new PackRepository(new RepositorySource[]{new ServerPacksSource(p_232897_.m_294312_())});
        ModLoader.get().postEvent((Event)new AddPackFindersEvent(PackType.SERVER_DATA, packrepository::addPackFinder));
        WorldLoader.InitConfig worldloader$initconfig = CreateWorldScreen.m_245574_(packrepository, WorldDataConfiguration.f_244649_);
        CompletableFuture<WorldCreationContext> completablefuture = WorldLoader.m_214362_(worldloader$initconfig, p_247792_ -> new WorldLoader.DataLoadOutput<DataPackReloadCookie>(new DataPackReloadCookie(new WorldGenSettings(WorldOptions.m_247394_(), WorldPresets.m_246552_((RegistryAccess)p_247792_.f_244104_())), p_247792_.f_244127_()), p_247792_.f_243759_()), (p_247798_, p_247799_, p_247800_, p_247801_) -> {
            p_247798_.close();
            return new WorldCreationContext(p_247801_.f_243966_(), (LayeredRegistryAccess<RegistryLayer>)p_247800_, p_247799_, p_247801_.f_243979_());
        }, Util.m_183991_(), (Executor)((Object)p_232897_));
        p_232897_.m_18701_(completablefuture::isDone);
        p_232897_.m_91152_(new CreateWorldScreen(p_232897_, p_232898_, completablefuture.join(), Optional.of(WorldPresets.f_226437_), OptionalLong.empty()));
    }

    public static CreateWorldScreen m_275847_(Minecraft p_276017_, @Nullable Screen p_276029_, LevelSettings p_276055_, WorldCreationContext p_276028_, @Nullable Path p_276040_) {
        CreateWorldScreen createworldscreen = new CreateWorldScreen(p_276017_, p_276029_, p_276028_, WorldPresets.m_246618_((Registry)p_276028_.f_243796_().f_243948_()), OptionalLong.of(p_276028_.f_244272_().m_245499_()));
        createworldscreen.f_268587_ = true;
        createworldscreen.f_267389_.m_267649_(p_276055_.m_46917_());
        createworldscreen.f_267389_.m_267601_(p_276055_.m_46932_());
        createworldscreen.f_267389_.m_267754_(p_276055_.m_46931_());
        createworldscreen.f_267389_.m_267721_().m_46176_(p_276055_.m_46933_(), (MinecraftServer)null);
        if (p_276055_.m_46930_()) {
            createworldscreen.f_267389_.m_267616_(WorldCreationUiState.SelectedGameMode.HARDCORE);
        } else if (p_276055_.m_46929_().m_46409_()) {
            createworldscreen.f_267389_.m_267616_(WorldCreationUiState.SelectedGameMode.SURVIVAL);
        } else if (p_276055_.m_46929_().m_46408_()) {
            createworldscreen.f_267389_.m_267616_(WorldCreationUiState.SelectedGameMode.CREATIVE);
        }
        createworldscreen.f_100831_ = p_276040_;
        return createworldscreen;
    }

    private CreateWorldScreen(Minecraft p_276053_, @Nullable Screen p_276049_, WorldCreationContext p_276047_, Optional<ResourceKey<WorldPreset>> p_276013_, OptionalLong p_276031_) {
        super((Component)Component.m_237115_((String)"selectWorld.create"));
        this.f_100855_ = p_276049_;
        this.f_291518_ = p_276053_.m_294312_();
        this.f_267389_ = new WorldCreationUiState(p_276053_.m_91392_().m_78257_(), p_276047_, p_276013_, p_276031_);
    }

    public WorldCreationUiState m_267748_() {
        return this.f_267389_;
    }

    @Override
    protected void m_7856_() {
        this.f_267490_ = TabNavigationBar.m_267630_((TabManager)this.f_267424_, (int)this.f_96543_).m_267824_(new Tab[]{new GameTab(), new WorldTab(), new MoreTab()}).m_267625_();
        this.m_142416_(this.f_267490_);
        this.f_267391_ = new GridLayout().m_267749_(10);
        GridLayout.RowHelper gridlayout$rowhelper = this.f_267391_.m_264606_(2);
        gridlayout$rowhelper.m_264139_((LayoutElement)Button.m_253074_((Component)Component.m_237115_((String)"selectWorld.create"), p_232938_ -> this.m_100972_()).m_253136_());
        gridlayout$rowhelper.m_264139_((LayoutElement)Button.m_253074_(CommonComponents.f_130656_, p_232903_ -> this.m_100967_()).m_253136_());
        this.f_267391_.m_264134_(p_267851_ -> {
            p_267851_.m_267708_(1);
            this.m_142416_(p_267851_);
        });
        this.f_267490_.m_276089_(0, false);
        this.f_267389_.m_267758_();
        this.m_267719_();
    }

    @Override
    public void m_267719_() {
        if (this.f_267490_ != null && this.f_267391_ != null) {
            this.f_267490_.m_267604_(this.f_96543_);
            this.f_267490_.m_267766_();
            this.f_267391_.m_264036_();
            FrameLayout.m_264159_((LayoutElement)this.f_267391_, (int)0, (int)(this.f_96544_ - 36), (int)this.f_96543_, (int)36);
            int i = this.f_267490_.m_264198_().m_274349_();
            ScreenRectangle screenrectangle = new ScreenRectangle(0, i, this.f_96543_, this.f_267391_.m_252907_() - i);
            this.f_267424_.m_267817_(screenrectangle);
        }
    }

    private static void m_232899_(Minecraft p_232900_, Component p_232901_) {
        p_232900_.m_91346_((Screen)new GenericDirtMessageScreen(p_232901_));
    }

    private void m_100972_() {
        WorldCreationContext worldcreationcontext = this.f_267389_.m_267573_();
        WorldDimensions.Complete worlddimensions$complete = worldcreationcontext.f_243796_().m_245300_(worldcreationcontext.f_244375_());
        LayeredRegistryAccess layeredregistryaccess = worldcreationcontext.f_243708_().m_247705_((Object)RegistryLayer.DIMENSIONS, new RegistryAccess.Frozen[]{worlddimensions$complete.m_245593_()});
        Lifecycle lifecycle = FeatureFlags.m_246811_((FeatureFlagSet)worldcreationcontext.f_243842_().f_243973_()) ? Lifecycle.experimental() : Lifecycle.stable();
        Lifecycle lifecycle1 = layeredregistryaccess.m_247579_().m_211816_();
        Lifecycle lifecycle2 = lifecycle1.add(lifecycle);
        boolean flag = !this.f_268587_ && lifecycle1 == Lifecycle.stable();
        WorldOpenFlows.m_269260_(this.f_96541_, this, lifecycle2, () -> this.m_245184_(worlddimensions$complete.f_244634_(), (LayeredRegistryAccess<RegistryLayer>)layeredregistryaccess, lifecycle2), flag);
    }

    private void m_245184_(PrimaryLevelData.SpecialWorldProperty p_250577_, LayeredRegistryAccess<RegistryLayer> p_249152_, Lifecycle p_249994_) {
        CreateWorldScreen.m_232899_(this.f_96541_, f_232866_);
        Optional<LevelStorageSource.LevelStorageAccess> optional = this.m_232868_();
        if (!optional.isEmpty()) {
            this.m_100976_();
            boolean flag = p_250577_ == PrimaryLevelData.SpecialWorldProperty.DEBUG;
            WorldCreationContext worldcreationcontext = this.f_267389_.m_267573_();
            LevelSettings levelsettings = this.m_205447_(flag);
            PrimaryLevelData worlddata = new PrimaryLevelData(levelsettings, worldcreationcontext.f_244272_(), p_250577_, p_249994_);
            this.f_96541_.m_231466_().m_245064_(optional.get(), worldcreationcontext.f_232990_(), p_249152_, worlddata);
        }
    }

    private LevelSettings m_205447_(boolean p_205448_) {
        String s = this.f_267389_.m_267597_().trim();
        if (p_205448_) {
            GameRules gamerules = new GameRules();
            ((GameRules.BooleanValue)gamerules.m_46170_(GameRules.f_46140_)).m_46246_(false, (MinecraftServer)null);
            return new LevelSettings(s, GameType.SPECTATOR, false, Difficulty.PEACEFUL, true, gamerules, WorldDataConfiguration.f_244649_);
        }
        return new LevelSettings(s, this.f_267389_.m_267761_().f_267485_, this.f_267389_.m_267790_(), this.f_267389_.m_267816_(), this.f_267389_.m_267823_(), this.f_267389_.m_267721_(), this.f_267389_.m_267573_().f_243842_());
    }

    @Override
    public boolean m_7933_(int p_100875_, int p_100876_, int p_100877_) {
        if (this.f_267490_.m_269419_(p_100875_)) {
            return true;
        }
        if (super.m_7933_(p_100875_, p_100876_, p_100877_)) {
            return true;
        }
        if (p_100875_ != 257 && p_100875_ != 335) {
            return false;
        }
        this.m_100972_();
        return true;
    }

    @Override
    public void m_7379_() {
        this.m_100967_();
    }

    public void m_100967_() {
        this.f_96541_.m_91152_(this.f_100855_);
        this.m_100976_();
    }

    @Override
    public void m_88315_(GuiGraphics p_282137_, int p_283640_, int p_281243_, float p_282743_) {
        super.m_88315_(p_282137_, p_283640_, p_281243_, p_282743_);
        p_282137_.m_280163_(f_273875_, 0, Mth.m_144941_((int)(this.f_96544_ - 36 - 2), (int)2), 0.0f, 0.0f, this.f_96543_, 2, 32, 2);
    }

    @Override
    public void m_280039_(GuiGraphics p_281950_) {
        int i = 32;
        p_281950_.m_280398_(f_279536_, 0, 0, 0, 0.0f, 0.0f, this.f_96543_, this.f_96544_, 32, 32);
    }

    @Override
    protected <T extends GuiEventListener & NarratableEntry> T m_7787_(T p_100948_) {
        return super.m_7787_(p_100948_);
    }

    @Override
    protected <T extends GuiEventListener & Renderable> T m_142416_(T p_170199_) {
        return super.m_142416_(p_170199_);
    }

    @Nullable
    private Path m_100968_() {
        if (this.f_100831_ == null) {
            try {
                this.f_100831_ = Files.createTempDirectory(f_170147_, new FileAttribute[0]);
            }
            catch (IOException ioexception) {
                f_100848_.warn("Failed to create temporary dir", (Throwable)ioexception);
                SystemToast.m_94875_((Minecraft)this.f_96541_, (String)this.f_267389_.m_275837_());
                this.m_100967_();
            }
        }
        return this.f_100831_;
    }

    void m_269545_(WorldDataConfiguration p_270214_) {
        Pair<Path, PackRepository> pair = this.m_267637_(p_270214_);
        if (pair != null) {
            this.f_96541_.m_91152_((Screen)new ExperimentsScreen((Screen)this, (PackRepository)pair.getSecond(), p_269636_ -> this.m_269443_((PackRepository)p_269636_, false, this::m_269545_)));
        }
    }

    void m_267734_(WorldDataConfiguration p_268186_) {
        Pair<Path, PackRepository> pair = this.m_267637_(p_268186_);
        if (pair != null) {
            this.f_96541_.m_91152_(new PackSelectionScreen((PackRepository)pair.getSecond(), p_269637_ -> this.m_269443_((PackRepository)p_269637_, true, this::m_267734_), (Path)pair.getFirst(), (Component)Component.m_237115_((String)"dataPack.title")));
        }
    }

    private void m_269443_(PackRepository p_270299_, boolean p_270896_, Consumer<WorldDataConfiguration> p_270760_) {
        List list1;
        ImmutableList list = ImmutableList.copyOf(p_270299_.m_10523_());
        WorldDataConfiguration worlddataconfiguration = new WorldDataConfiguration(new DataPackConfig((List<String>)list, list1 = (List)p_270299_.m_10514_().stream().filter(arg_0 -> CreateWorldScreen.m_232925_((List)list, arg_0)).collect(ImmutableList.toImmutableList())), this.f_267389_.m_267573_().f_243842_().f_243973_());
        if (this.f_267389_.m_267710_(worlddataconfiguration)) {
            this.f_96541_.m_91152_(this);
        } else {
            FeatureFlagSet featureflagset = p_270299_.m_245805_();
            if (FeatureFlags.m_246811_((FeatureFlagSet)featureflagset) && p_270896_) {
                this.f_96541_.m_91152_((Screen)new ConfirmExperimentalFeaturesScreen(p_270299_.m_10524_(), p_269635_ -> {
                    if (p_269635_) {
                        this.m_269431_(p_270299_, worlddataconfiguration, p_270760_);
                    } else {
                        p_270760_.accept(this.f_267389_.m_267573_().f_243842_());
                    }
                }));
            } else {
                this.m_269431_(p_270299_, worlddataconfiguration, p_270760_);
            }
        }
    }

    private void m_269431_(PackRepository p_270272_, WorldDataConfiguration p_270573_, Consumer<WorldDataConfiguration> p_270552_) {
        this.f_96541_.m_91346_((Screen)new GenericDirtMessageScreen((Component)Component.m_237115_((String)"dataPack.validation.working")));
        WorldLoader.InitConfig worldloader$initconfig = CreateWorldScreen.m_245574_(p_270272_, p_270573_);
        ((CompletableFuture)WorldLoader.m_214362_(worldloader$initconfig, p_247793_ -> {
            if (p_247793_.f_244104_().m_175515_(Registries.f_256729_).m_13562_() == 0) {
                throw new IllegalStateException("Needs at least one world preset to continue");
            }
            if (p_247793_.f_244104_().m_175515_(Registries.f_256952_).m_13562_() == 0) {
                throw new IllegalStateException("Needs at least one biome continue");
            }
            WorldCreationContext worldcreationcontext = this.f_267389_.m_267573_();
            RegistryOps dynamicops = RegistryOps.m_255058_(JsonOps.INSTANCE, (HolderLookup.Provider)worldcreationcontext.m_246480_());
            DataResult dataresult = WorldGenSettings.m_246823_(dynamicops, (WorldOptions)worldcreationcontext.f_244272_(), (WorldDimensions)worldcreationcontext.f_243796_()).setLifecycle(Lifecycle.stable());
            RegistryOps dynamicops1 = RegistryOps.m_255058_(JsonOps.INSTANCE, (HolderLookup.Provider)p_247793_.f_244104_());
            WorldGenSettings worldgensettings = (WorldGenSettings)dataresult.flatMap(p_232895_ -> WorldGenSettings.f_64600_.parse(dynamicops1, p_232895_)).getOrThrow(false, Util.m_137489_("Error parsing worldgen settings after loading data packs: ", arg_0 -> ((Logger)f_100848_).error(arg_0)));
            return new WorldLoader.DataLoadOutput<DataPackReloadCookie>(new DataPackReloadCookie(worldgensettings, p_247793_.f_244127_()), p_247793_.f_243759_());
        }, (p_247788_, p_247789_, p_247790_, p_247791_) -> {
            p_247788_.close();
            return new WorldCreationContext(p_247791_.f_243966_(), (LayeredRegistryAccess<RegistryLayer>)p_247790_, p_247789_, p_247791_.f_243979_());
        }, Util.m_183991_(), (Executor)((Object)this.f_96541_)).thenAcceptAsync(this.f_267389_::m_267692_, (Executor)((Object)this.f_96541_))).handle((p_280900_, p_280901_) -> {
            if (p_280901_ != null) {
                f_100848_.warn("Failed to validate datapack", p_280901_);
                this.f_96541_.m_91152_((Screen)new ConfirmScreen(p_269627_ -> {
                    if (p_269627_) {
                        p_270552_.accept(this.f_267389_.m_267573_().f_243842_());
                    } else {
                        p_270552_.accept(new WorldDataConfiguration(new DataPackConfig((List<String>)ImmutableList.of((Object)"vanilla"), (List<String>)ImmutableList.of()), FeatureFlags.f_244332_));
                    }
                }, (Component)Component.m_237115_((String)"dataPack.validation.failed"), CommonComponents.f_237098_, (Component)Component.m_237115_((String)"dataPack.validation.back"), (Component)Component.m_237115_((String)"dataPack.validation.reset")));
            } else {
                this.f_96541_.m_91152_(this);
            }
            return null;
        });
    }

    private static WorldLoader.InitConfig m_245574_(PackRepository p_251829_, WorldDataConfiguration p_251555_) {
        WorldLoader.PackConfig worldloader$packconfig = new WorldLoader.PackConfig(p_251829_, p_251555_, false, true);
        return new WorldLoader.InitConfig(worldloader$packconfig, Commands.CommandSelection.INTEGRATED, 2);
    }

    private void m_100976_() {
        if (this.f_100831_ != null) {
            try (Stream<Path> stream = Files.walk(this.f_100831_, new FileVisitOption[0]);){
                stream.sorted(Comparator.reverseOrder()).forEach(p_232942_ -> {
                    try {
                        Files.delete(p_232942_);
                    }
                    catch (IOException ioexception1) {
                        f_100848_.warn("Failed to remove temporary file {}", p_232942_, (Object)ioexception1);
                    }
                });
            }
            catch (IOException ioexception) {
                f_100848_.warn("Failed to list temporary dir {}", (Object)this.f_100831_);
            }
            this.f_100831_ = null;
        }
    }

    private static void m_100912_(Path p_100913_, Path p_100914_, Path p_100915_) {
        try {
            Util.m_137563_(p_100913_, p_100914_, p_100915_);
        }
        catch (IOException ioexception) {
            f_100848_.warn("Failed to copy datapack file from {} to {}", (Object)p_100915_, (Object)p_100914_);
            throw new UncheckedIOException(ioexception);
        }
    }

    private Optional<LevelStorageSource.LevelStorageAccess> m_232868_() {
        Optional<LevelStorageSource.LevelStorageAccess> optional;
        String s;
        block12: {
            LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess;
            block11: {
                s = this.f_267389_.m_275837_();
                levelstoragesource$levelstorageaccess = this.f_96541_.m_91392_().m_78260_(s);
                if (this.f_100831_ != null) break block11;
                return Optional.of(levelstoragesource$levelstorageaccess);
            }
            Stream<Path> stream = Files.walk(this.f_100831_, new FileVisitOption[0]);
            try {
                Path path = levelstoragesource$levelstorageaccess.m_78283_(LevelResource.f_78180_);
                FileUtil.m_257659_((Path)path);
                stream.filter(p_232921_ -> !p_232921_.equals(this.f_100831_)).forEach(p_232945_ -> CreateWorldScreen.m_100912_(this.f_100831_, path, p_232945_));
                optional = Optional.of(levelstoragesource$levelstorageaccess);
                if (stream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | UncheckedIOException ioexception) {
                        f_100848_.warn("Failed to copy datapacks to world {}", (Object)s, (Object)ioexception);
                        levelstoragesource$levelstorageaccess.close();
                    }
                }
                catch (IOException | UncheckedIOException ioexception1) {
                    f_100848_.warn("Failed to create access for {}", (Object)s, (Object)ioexception1);
                }
            }
            stream.close();
        }
        return optional;
        SystemToast.m_94875_((Minecraft)this.f_96541_, (String)s);
        this.m_100967_();
        return Optional.empty();
    }

    @Nullable
    public static Path m_100906_(Path p_100907_, Minecraft p_100908_) {
        MutableObject mutableobject = new MutableObject();
        try (Stream<Path> stream = Files.walk(p_100907_, new FileVisitOption[0]);){
            stream.filter(p_232924_ -> !p_232924_.equals(p_100907_)).forEach(p_232933_ -> {
                Path path = (Path)mutableobject.getValue();
                if (path == null) {
                    try {
                        path = Files.createTempDirectory(f_170147_, new FileAttribute[0]);
                    }
                    catch (IOException ioexception1) {
                        f_100848_.warn("Failed to create temporary dir");
                        throw new UncheckedIOException(ioexception1);
                    }
                    mutableobject.setValue((Object)path);
                }
                CreateWorldScreen.m_100912_(p_100907_, path, p_232933_);
            });
        }
        catch (IOException | UncheckedIOException ioexception) {
            f_100848_.warn("Failed to copy datapacks from world {}", (Object)p_100907_, (Object)ioexception);
            SystemToast.m_94875_((Minecraft)p_100908_, (String)p_100907_.toString());
            return null;
        }
        return (Path)mutableobject.getValue();
    }

    @Nullable
    private Pair<Path, PackRepository> m_267637_(WorldDataConfiguration p_268328_) {
        Path path = this.m_100968_();
        if (path != null) {
            if (this.f_100832_ == null) {
                this.f_100832_ = ServerPacksSource.m_245786_(path, this.f_291518_);
                ResourcePackLoader.loadResourcePacks((PackRepository)this.f_100832_, ServerLifecycleHooks::buildPackFinder);
                this.f_100832_.m_10506_();
            }
            this.f_100832_.m_10509_(p_268328_.f_244096_().m_45850_());
            return Pair.of((Object)path, (Object)this.f_100832_);
        }
        return null;
    }

    private static /* synthetic */ boolean m_232925_(List p_232926_, String p_232927_) {
        return !p_232926_.contains(p_232927_);
    }

    @OnlyIn(value=Dist.CLIENT)
    class GameTab
    extends GridLayoutTab {
        private static final Component f_267405_ = Component.m_237115_((String)"createWorld.tab.game.title");
        private static final Component f_267376_ = Component.m_237115_((String)"selectWorld.allowCommands");
        private final EditBox f_267368_;

        GameTab() {
            super(f_267405_);
            GridLayout.RowHelper gridlayout$rowhelper = this.f_267367_.m_267750_(8).m_264606_(1);
            LayoutSettings layoutsettings = gridlayout$rowhelper.m_264551_();
            this.f_267368_ = new EditBox(CreateWorldScreen.this.f_96547_, 208, 20, (Component)Component.m_237115_((String)"selectWorld.enterName"));
            this.f_267368_.m_94144_(CreateWorldScreen.this.f_267389_.m_267597_());
            this.f_267368_.m_94151_(CreateWorldScreen.this.f_267389_::m_267649_);
            CreateWorldScreen.this.f_267389_.m_267755_(p_275871_ -> this.f_267368_.m_257544_(Tooltip.m_257550_((Component)Component.m_237110_((String)"selectWorld.targetFolder", (Object[])new Object[]{Component.m_237113_((String)p_275871_.m_275837_()).m_130940_(ChatFormatting.ITALIC)}))));
            CreateWorldScreen.this.m_264313_((GuiEventListener)this.f_267368_);
            gridlayout$rowhelper.m_264206_((LayoutElement)CommonLayouts.m_294456_((Font)CreateWorldScreen.this.f_96547_, (LayoutElement)this.f_267368_, (Component)f_100852_), gridlayout$rowhelper.m_264551_().m_264356_());
            CycleButton cyclebutton = (CycleButton)gridlayout$rowhelper.m_264206_((LayoutElement)CycleButton.m_168894_(p_268080_ -> p_268080_.f_267396_).m_168961_((Object[])new WorldCreationUiState.SelectedGameMode[]{WorldCreationUiState.SelectedGameMode.SURVIVAL, WorldCreationUiState.SelectedGameMode.HARDCORE, WorldCreationUiState.SelectedGameMode.CREATIVE}).m_168936_(0, 0, 210, 20, f_100849_, (p_268266_, p_268208_) -> CreateWorldScreen.this.f_267389_.m_267616_((WorldCreationUiState.SelectedGameMode)((Object)p_268208_))), layoutsettings);
            CreateWorldScreen.this.f_267389_.m_267755_(p_280907_ -> {
                cyclebutton.m_168892_((Object)p_280907_.m_267761_());
                p_280906_.f_93623_ = !p_280907_.m_267735_();
                cyclebutton.m_257544_(Tooltip.m_257550_((Component)p_280907_.m_267761_().m_267564_()));
            });
            CycleButton cyclebutton1 = (CycleButton)gridlayout$rowhelper.m_264206_((LayoutElement)CycleButton.m_168894_(Difficulty::m_19033_).m_168961_((Object[])Difficulty.values()).m_168936_(0, 0, 210, 20, (Component)Component.m_237115_((String)"options.difficulty"), (p_267962_, p_268338_) -> CreateWorldScreen.this.f_267389_.m_267754_((Difficulty)p_268338_)), layoutsettings);
            CreateWorldScreen.this.f_267389_.m_267755_(p_280905_ -> {
                cyclebutton1.m_168892_((Object)CreateWorldScreen.this.f_267389_.m_267816_());
                p_280904_.f_93623_ = !CreateWorldScreen.this.f_267389_.m_267790_();
                cyclebutton1.m_257544_(Tooltip.m_257550_((Component)CreateWorldScreen.this.f_267389_.m_267816_().m_267622_()));
            });
            CycleButton cyclebutton2 = (CycleButton)gridlayout$rowhelper.m_264139_((LayoutElement)CycleButton.m_168919_().m_232498_(p_267952_ -> Tooltip.m_257550_((Component)f_267456_)).m_168936_(0, 0, 210, 20, f_267376_, (p_268200_, p_268324_) -> CreateWorldScreen.this.f_267389_.m_267601_((boolean)p_268324_)));
            CreateWorldScreen.this.f_267389_.m_267755_(p_280903_ -> {
                cyclebutton2.m_168892_((Object)CreateWorldScreen.this.f_267389_.m_267823_());
                p_280902_.f_93623_ = !CreateWorldScreen.this.f_267389_.m_267735_() && !CreateWorldScreen.this.f_267389_.m_267790_();
            });
            if (!SharedConstants.m_183709_().m_132498_()) {
                gridlayout$rowhelper.m_264139_((LayoutElement)Button.m_253074_(f_268721_, p_269641_ -> CreateWorldScreen.this.m_269545_(CreateWorldScreen.this.f_267389_.m_267573_().f_243842_())).m_252780_(210).m_253136_());
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class WorldTab
    extends GridLayoutTab {
        private static final Component f_267449_ = Component.m_237115_((String)"createWorld.tab.world.title");
        private static final Component f_267381_ = Component.m_237115_((String)"generator.minecraft.amplified.info");
        private static final Component f_267413_ = Component.m_237115_((String)"selectWorld.mapFeatures");
        private static final Component f_267384_ = Component.m_237115_((String)"selectWorld.mapFeatures.info");
        private static final Component f_267474_ = Component.m_237115_((String)"selectWorld.bonusItems");
        private static final Component f_267471_ = Component.m_237115_((String)"selectWorld.enterSeed");
        static final Component f_267459_ = Component.m_237115_((String)"selectWorld.seedInfo").m_130940_(ChatFormatting.DARK_GRAY);
        private static final int f_267437_ = 310;
        private final EditBox f_267412_;
        private final Button f_267365_;

        WorldTab() {
            super(f_267449_);
            GridLayout.RowHelper gridlayout$rowhelper = this.f_267367_.m_267749_(10).m_267750_(8).m_264606_(2);
            CycleButton cyclebutton = (CycleButton)gridlayout$rowhelper.m_264139_((LayoutElement)CycleButton.m_168894_(WorldCreationUiState.WorldTypeEntry::m_267572_).m_232500_(this.m_267806_()).m_168959_(WorldTab::m_267591_).m_168936_(0, 0, 150, 20, (Component)Component.m_237115_((String)"selectWorld.mapType"), (p_268242_, p_267954_) -> CreateWorldScreen.this.f_267389_.m_267576_((WorldCreationUiState.WorldTypeEntry)p_267954_)));
            cyclebutton.m_168892_((Object)CreateWorldScreen.this.f_267389_.m_267828_());
            CreateWorldScreen.this.f_267389_.m_267755_(p_280909_ -> {
                WorldCreationUiState.WorldTypeEntry worldcreationuistate$worldtypeentry = p_280909_.m_267828_();
                cyclebutton.m_168892_((Object)worldcreationuistate$worldtypeentry);
                if (worldcreationuistate$worldtypeentry.m_267589_()) {
                    cyclebutton.m_257544_(Tooltip.m_257550_((Component)f_267381_));
                } else {
                    cyclebutton.m_257544_((Tooltip)null);
                }
                p_280908_.f_93623_ = CreateWorldScreen.this.f_267389_.m_267828_().f_267398_() != null;
            });
            this.f_267365_ = (Button)gridlayout$rowhelper.m_264139_((LayoutElement)Button.m_253074_((Component)Component.m_237115_((String)"selectWorld.customizeType"), p_268355_ -> this.m_267652_()).m_253136_());
            CreateWorldScreen.this.f_267389_.m_267755_(p_280910_ -> {
                this.f_267365_.f_93623_ = !p_280910_.m_267735_() && p_280910_.m_267744_() != null;
            });
            this.f_267412_ = new EditBox(CreateWorldScreen.this.f_96547_, 308, 20, (Component)Component.m_237115_((String)"selectWorld.enterSeed")){

                protected MutableComponent m_5646_() {
                    return super.m_5646_().m_7220_(CommonComponents.f_178389_).m_7220_(f_267459_);
                }
            };
            this.f_267412_.m_257771_(f_267459_);
            this.f_267412_.m_94144_(CreateWorldScreen.this.f_267389_.m_267707_());
            this.f_267412_.m_94151_(p_268342_ -> CreateWorldScreen.this.f_267389_.m_267759_(this.f_267412_.m_94155_()));
            gridlayout$rowhelper.m_264108_((LayoutElement)CommonLayouts.m_294456_((Font)CreateWorldScreen.this.f_96547_, (LayoutElement)this.f_267412_, (Component)f_267471_), 2);
            SwitchGrid.Builder switchgrid$builder = SwitchGrid.m_267742_((int)310);
            switchgrid$builder.m_267583_(f_267413_, CreateWorldScreen.this.f_267389_::m_267615_, CreateWorldScreen.this.f_267389_::m_267770_).m_267757_(() -> !CreateWorldScreen.this.f_267389_.m_267735_()).m_267664_(f_267384_);
            switchgrid$builder.m_267583_(f_267474_, CreateWorldScreen.this.f_267389_::m_267593_, CreateWorldScreen.this.f_267389_::m_267666_).m_267757_(() -> !CreateWorldScreen.this.f_267389_.m_267790_() && !CreateWorldScreen.this.f_267389_.m_267735_());
            SwitchGrid switchgrid = switchgrid$builder.m_267588_(p_267961_ -> gridlayout$rowhelper.m_264108_(p_267961_, 2));
            CreateWorldScreen.this.f_267389_.m_267755_(p_268209_ -> switchgrid.m_267819_());
        }

        private void m_267652_() {
            PresetEditor preseteditor = CreateWorldScreen.this.f_267389_.m_267744_();
            if (preseteditor != null) {
                CreateWorldScreen.this.f_96541_.m_91152_(preseteditor.m_232976_(CreateWorldScreen.this, CreateWorldScreen.this.f_267389_.m_267573_()));
            }
        }

        private CycleButton.ValueListSupplier<WorldCreationUiState.WorldTypeEntry> m_267806_() {
            return new CycleButton.ValueListSupplier<WorldCreationUiState.WorldTypeEntry>(){

                public List<WorldCreationUiState.WorldTypeEntry> m_142477_() {
                    return CycleButton.f_168856_.getAsBoolean() ? CreateWorldScreen.this.f_267389_.m_267674_() : CreateWorldScreen.this.f_267389_.m_267815_();
                }

                public List<WorldCreationUiState.WorldTypeEntry> m_142478_() {
                    return CreateWorldScreen.this.f_267389_.m_267815_();
                }
            };
        }

        private static MutableComponent m_267591_(CycleButton<WorldCreationUiState.WorldTypeEntry> p_268292_) {
            return ((WorldCreationUiState.WorldTypeEntry)p_268292_.m_168883_()).m_267589_() ? CommonComponents.m_267603_((Component[])new Component[]{p_268292_.m_168904_(), f_267381_}) : p_268292_.m_168904_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class MoreTab
    extends GridLayoutTab {
        private static final Component f_267379_ = Component.m_237115_((String)"createWorld.tab.more.title");
        private static final Component f_267394_ = Component.m_237115_((String)"selectWorld.gameRules");
        private static final Component f_267461_ = Component.m_237115_((String)"selectWorld.dataPacks");

        MoreTab() {
            super(f_267379_);
            GridLayout.RowHelper gridlayout$rowhelper = this.f_267367_.m_267750_(8).m_264606_(1);
            gridlayout$rowhelper.m_264139_((LayoutElement)Button.m_253074_(f_267394_, p_268028_ -> this.m_267650_()).m_252780_(210).m_253136_());
            gridlayout$rowhelper.m_264139_((LayoutElement)Button.m_253074_(f_268721_, p_269642_ -> CreateWorldScreen.this.m_269545_(CreateWorldScreen.this.f_267389_.m_267573_().f_243842_())).m_252780_(210).m_253136_());
            gridlayout$rowhelper.m_264139_((LayoutElement)Button.m_253074_(f_267461_, p_268345_ -> CreateWorldScreen.this.m_267734_(CreateWorldScreen.this.f_267389_.m_267573_().f_243842_())).m_252780_(210).m_253136_());
        }

        private void m_267650_() {
            CreateWorldScreen.this.f_96541_.m_91152_((Screen)new EditGameRulesScreen(CreateWorldScreen.this.f_267389_.m_267721_().m_46202_(), p_268107_ -> {
                CreateWorldScreen.this.f_96541_.m_91152_(CreateWorldScreen.this);
                p_268107_.ifPresent(CreateWorldScreen.this.f_267389_::m_267656_);
            }));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    record DataPackReloadCookie(WorldGenSettings f_243966_, WorldDataConfiguration f_243979_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{DataPackReloadCookie.class, "worldGenSettings;dataConfiguration", "f_243966_", "f_243979_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DataPackReloadCookie.class, "worldGenSettings;dataConfiguration", "f_243966_", "f_243979_"}, this);
        }

        @Override
        public final boolean equals(Object p_250700_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DataPackReloadCookie.class, "worldGenSettings;dataConfiguration", "f_243966_", "f_243979_"}, this, p_250700_);
        }
    }
}

