/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.server;

import com.google.common.collect.Lists;
import com.google.common.net.InetAddresses;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.client.server.LanServer;
import net.minecraft.client.server.LanServerPinger;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.DualStackUtils;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class LanServerDetection {
    static final AtomicInteger f_120081_ = new AtomicInteger(0);
    static final Logger f_120082_ = LogUtils.getLogger();

    @OnlyIn(value=Dist.CLIENT)
    public static class LanServerList {
        private final List<LanServer> f_120092_ = Lists.newArrayList();
        private boolean f_120093_;

        @Nullable
        public synchronized List<LanServer> m_247578_() {
            if (this.f_120093_) {
                List<LanServer> list = List.copyOf(this.f_120092_);
                this.f_120093_ = false;
                return list;
            }
            return null;
        }

        public synchronized void m_120096_(String p_120097_, InetAddress p_120098_) {
            String s = LanServerPinger.m_120111_(p_120097_);
            Object s1 = LanServerPinger.m_120116_(p_120097_);
            if (s1 != null) {
                s1 = DualStackUtils.checkIPv6((InetAddress)p_120098_) ? "[" + InetAddresses.toAddrString((InetAddress)p_120098_) + "]:" + (String)s1 : p_120098_.getHostAddress() + ":" + (String)s1;
                boolean flag = false;
                for (LanServer lanserver : this.f_120092_) {
                    if (!lanserver.m_120079_().equals(s1)) continue;
                    lanserver.m_120080_();
                    flag = true;
                    break;
                }
                if (!flag) {
                    this.f_120092_.add(new LanServer(s, (String)s1));
                    this.f_120093_ = true;
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LanServerDetector
    extends Thread {
        private final LanServerList f_120086_;
        private final InetAddress f_120087_;
        private final MulticastSocket f_120088_;

        public LanServerDetector(LanServerList p_120090_) throws IOException {
            super("LanServerDetector #" + f_120081_.incrementAndGet());
            this.f_120086_ = p_120090_;
            this.setDaemon(true);
            this.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(f_120082_));
            this.f_120088_ = new MulticastSocket(4445);
            this.f_120087_ = InetAddress.getByName(LanServerPinger.f_174974_);
            this.f_120088_.setSoTimeout(5000);
            this.f_120088_.joinGroup(this.f_120087_);
        }

        @Override
        public void run() {
            byte[] abyte = new byte[1024];
            while (!this.isInterrupted()) {
                DatagramPacket datagrampacket = new DatagramPacket(abyte, abyte.length);
                try {
                    this.f_120088_.receive(datagrampacket);
                }
                catch (SocketTimeoutException sockettimeoutexception) {
                    continue;
                }
                catch (IOException ioexception1) {
                    f_120082_.error("Couldn't ping server", (Throwable)ioexception1);
                    break;
                }
                String s = new String(datagrampacket.getData(), datagrampacket.getOffset(), datagrampacket.getLength(), StandardCharsets.UTF_8);
                f_120082_.debug("{}: {}", (Object)datagrampacket.getAddress(), (Object)s);
                this.f_120086_.m_120096_(s, datagrampacket.getAddress());
            }
            try {
                this.f_120088_.leaveGroup(this.f_120087_);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.f_120088_.close();
        }
    }
}

