/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import com.google.common.collect.ComparisonChain;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.extensions.IForgeMobEffectInstance;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

public class MobEffectInstance
implements Comparable<MobEffectInstance>,
IForgeMobEffectInstance {
    private static final Logger f_19501_ = LogUtils.getLogger();
    public static final int f_267388_ = -1;
    private static final String f_290519_ = "id";
    private static final String f_291631_ = "ambient";
    private static final String f_290481_ = "hidden_effect";
    private static final String f_290928_ = "amplifier";
    private static final String f_291169_ = "duration";
    private static final String f_290735_ = "show_particles";
    private static final String f_290610_ = "show_icon";
    private static final String f_290894_ = "factor_calculation_data";
    private final MobEffect f_19502_;
    private int f_19503_;
    private int f_19504_;
    private boolean f_19506_;
    private boolean f_19508_;
    private boolean f_19509_;
    @Nullable
    private MobEffectInstance f_19510_;
    private final Optional<FactorData> f_216885_;
    private List<ItemStack> curativeItems;

    public MobEffectInstance(MobEffect p_19513_) {
        this(p_19513_, 0, 0);
    }

    public MobEffectInstance(MobEffect p_19515_, int p_19516_) {
        this(p_19515_, p_19516_, 0);
    }

    public MobEffectInstance(MobEffect p_19518_, int p_19519_, int p_19520_) {
        this(p_19518_, p_19519_, p_19520_, false, true);
    }

    public MobEffectInstance(MobEffect p_19522_, int p_19523_, int p_19524_, boolean p_19525_, boolean p_19526_) {
        this(p_19522_, p_19523_, p_19524_, p_19525_, p_19526_, p_19526_);
    }

    public MobEffectInstance(MobEffect p_19528_, int p_19529_, int p_19530_, boolean p_19531_, boolean p_19532_, boolean p_19533_) {
        this(p_19528_, p_19529_, p_19530_, p_19531_, p_19532_, p_19533_, null, p_19528_.m_216881_());
    }

    public MobEffectInstance(MobEffect p_216887_, int p_216888_, int p_216889_, boolean p_216890_, boolean p_216891_, boolean p_216892_, @Nullable MobEffectInstance p_216893_, Optional<FactorData> p_216894_) {
        this.f_19502_ = p_216887_;
        this.f_19503_ = p_216888_;
        this.f_19504_ = p_216889_;
        this.f_19506_ = p_216890_;
        this.f_19508_ = p_216891_;
        this.f_19509_ = p_216892_;
        this.f_19510_ = p_216893_;
        this.f_216885_ = p_216894_;
    }

    public MobEffectInstance(MobEffectInstance p_19543_) {
        this.f_19502_ = p_19543_.f_19502_;
        this.f_216885_ = this.f_19502_.m_216881_();
        this.m_19548_(p_19543_);
    }

    public Optional<FactorData> m_216895_() {
        return this.f_216885_;
    }

    void m_19548_(MobEffectInstance p_19549_) {
        this.f_19503_ = p_19549_.f_19503_;
        this.f_19504_ = p_19549_.f_19504_;
        this.f_19506_ = p_19549_.f_19506_;
        this.f_19508_ = p_19549_.f_19508_;
        this.f_19509_ = p_19549_.f_19509_;
        this.curativeItems = p_19549_.curativeItems == null ? null : new ArrayList<ItemStack>(p_19549_.curativeItems);
    }

    public boolean m_19558_(MobEffectInstance p_19559_) {
        if (this.f_19502_ != p_19559_.f_19502_) {
            f_19501_.warn("This method should only be called for matching effects!");
        }
        boolean flag = false;
        if (p_19559_.f_19504_ > this.f_19504_) {
            if (p_19559_.m_267670_(this)) {
                MobEffectInstance mobeffectinstance = this.f_19510_;
                this.f_19510_ = new MobEffectInstance(this);
                this.f_19510_.f_19510_ = mobeffectinstance;
            }
            this.f_19504_ = p_19559_.f_19504_;
            this.f_19503_ = p_19559_.f_19503_;
            flag = true;
        } else if (this.m_267670_(p_19559_)) {
            if (p_19559_.f_19504_ == this.f_19504_) {
                this.f_19503_ = p_19559_.f_19503_;
                flag = true;
            } else if (this.f_19510_ == null) {
                this.f_19510_ = new MobEffectInstance(p_19559_);
            } else {
                this.f_19510_.m_19558_(p_19559_);
            }
        }
        if (!p_19559_.f_19506_ && this.f_19506_ || flag) {
            this.f_19506_ = p_19559_.f_19506_;
            flag = true;
        }
        if (p_19559_.f_19508_ != this.f_19508_) {
            this.f_19508_ = p_19559_.f_19508_;
            flag = true;
        }
        if (p_19559_.f_19509_ != this.f_19509_) {
            this.f_19509_ = p_19559_.f_19509_;
            flag = true;
        }
        return flag;
    }

    private boolean m_267670_(MobEffectInstance p_268133_) {
        return !this.m_267577_() && (this.f_19503_ < p_268133_.f_19503_ || p_268133_.m_267577_());
    }

    public boolean m_267577_() {
        return this.f_19503_ == -1;
    }

    public boolean m_267633_(int p_268088_) {
        return !this.m_267577_() && this.f_19503_ <= p_268088_;
    }

    public int m_267696_(Int2IntFunction p_268089_) {
        return !this.m_267577_() && this.f_19503_ != 0 ? p_268089_.applyAsInt(this.f_19503_) : this.f_19503_;
    }

    public MobEffect m_19544_() {
        return this.f_19502_ == null ? null : (MobEffect)ForgeRegistries.MOB_EFFECTS.getDelegateOrThrow((Object)this.f_19502_).get();
    }

    public int m_19557_() {
        return this.f_19503_;
    }

    public int m_19564_() {
        return this.f_19504_;
    }

    public boolean m_19571_() {
        return this.f_19506_;
    }

    public boolean m_19572_() {
        return this.f_19508_;
    }

    public boolean m_19575_() {
        return this.f_19509_;
    }

    public boolean m_19552_(LivingEntity p_19553_, Runnable p_19554_) {
        if (this.m_267725_()) {
            int i;
            int n = i = this.m_267577_() ? p_19553_.f_19797_ : this.f_19503_;
            if (this.f_19502_.m_19443_(i, this.f_19504_)) {
                this.f_19502_.m_6742_(p_19553_, this.f_19504_);
            }
            this.m_19579_();
            if (this.f_19503_ == 0 && this.f_19510_ != null) {
                this.m_19548_(this.f_19510_);
                this.f_19510_ = this.f_19510_.f_19510_;
                p_19554_.run();
            }
        }
        this.f_216885_.ifPresent(p_267917_ -> p_267917_.m_267690_(this));
        return this.m_267725_();
    }

    private boolean m_267725_() {
        return this.m_267577_() || this.f_19503_ > 0;
    }

    private int m_19579_() {
        if (this.f_19510_ != null) {
            this.f_19510_.m_19579_();
        }
        this.f_19503_ = this.m_267696_(p_267916_ -> p_267916_ - 1);
        return this.f_19503_;
    }

    public void m_292680_(LivingEntity p_297679_) {
        this.f_19502_.m_292868_(p_297679_, this.f_19504_);
    }

    public String m_19576_() {
        return this.f_19502_.m_19481_();
    }

    public String toString() {
        String s = this.f_19504_ > 0 ? this.m_19576_() + " x " + (this.f_19504_ + 1) + ", Duration: " + this.m_267740_() : this.m_19576_() + ", Duration: " + this.m_267740_();
        if (!this.f_19508_) {
            s = s + ", Particles: false";
        }
        if (!this.f_19509_) {
            s = s + ", Show Icon: false";
        }
        return s;
    }

    private String m_267740_() {
        return this.m_267577_() ? "infinite" : Integer.toString(this.f_19503_);
    }

    public boolean equals(Object p_19574_) {
        if (this == p_19574_) {
            return true;
        }
        if (!(p_19574_ instanceof MobEffectInstance)) {
            return false;
        }
        MobEffectInstance mobeffectinstance = (MobEffectInstance)p_19574_;
        return this.f_19503_ == mobeffectinstance.f_19503_ && this.f_19504_ == mobeffectinstance.f_19504_ && this.f_19506_ == mobeffectinstance.f_19506_ && this.f_19502_.equals(mobeffectinstance.f_19502_);
    }

    public int hashCode() {
        int i = this.f_19502_.hashCode();
        i = 31 * i + this.f_19503_;
        i = 31 * i + this.f_19504_;
        return 31 * i + (this.f_19506_ ? 1 : 0);
    }

    public CompoundTag m_19555_(CompoundTag p_19556_) {
        ResourceLocation resourcelocation = BuiltInRegistries.f_256974_.m_7981_((Object)this.f_19502_);
        p_19556_.m_128359_(f_290519_, resourcelocation.toString());
        this.m_19567_(p_19556_);
        return p_19556_;
    }

    private void m_19567_(CompoundTag p_19568_) {
        p_19568_.m_128344_(f_290928_, (byte)this.m_19564_());
        p_19568_.m_128405_(f_291169_, this.m_19557_());
        p_19568_.m_128379_(f_291631_, this.m_19571_());
        p_19568_.m_128379_(f_290735_, this.m_19572_());
        p_19568_.m_128379_(f_290610_, this.m_19575_());
        if (this.f_19510_ != null) {
            CompoundTag compoundtag = new CompoundTag();
            this.f_19510_.m_19555_(compoundtag);
            p_19568_.m_128365_(f_290481_, compoundtag);
        }
        this.writeCurativeItems(p_19568_);
        this.f_216885_.ifPresent(p_216903_ -> FactorData.f_216907_.encodeStart((DynamicOps)NbtOps.f_128958_, p_216903_).resultOrPartial(arg_0 -> ((Logger)f_19501_).error(arg_0)).ifPresent(p_216906_ -> p_19568_.m_128365_(f_290894_, (Tag)p_216906_)));
    }

    @Nullable
    public static MobEffectInstance m_19560_(CompoundTag p_19561_) {
        String s = p_19561_.m_128461_(f_290519_);
        MobEffect mobeffect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(ResourceLocation.m_135820_(s));
        return mobeffect == null ? null : MobEffectInstance.m_19545_(mobeffect, p_19561_);
    }

    private static MobEffectInstance m_19545_(MobEffect p_19546_, CompoundTag p_19547_) {
        byte i = p_19547_.m_128445_(f_290928_);
        int j = p_19547_.m_128451_(f_291169_);
        boolean flag = p_19547_.m_128471_(f_291631_);
        boolean flag1 = true;
        if (p_19547_.m_128425_(f_290735_, 1)) {
            flag1 = p_19547_.m_128471_(f_290735_);
        }
        boolean flag2 = flag1;
        if (p_19547_.m_128425_(f_290610_, 1)) {
            flag2 = p_19547_.m_128471_(f_290610_);
        }
        MobEffectInstance mobeffectinstance = null;
        if (p_19547_.m_128425_(f_290481_, 10)) {
            mobeffectinstance = MobEffectInstance.m_19545_(p_19546_, p_19547_.m_128469_(f_290481_));
        }
        Optional optional = p_19547_.m_128425_(f_290894_, 10) ? FactorData.f_216907_.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)p_19547_.m_128469_(f_290894_))).resultOrPartial(arg_0 -> ((Logger)f_19501_).error(arg_0)) : Optional.empty();
        return MobEffectInstance.readCurativeItems(new MobEffectInstance(p_19546_, j, Math.max(0, i), flag, flag1, flag2, mobeffectinstance, optional), p_19547_);
    }

    @Override
    public int compareTo(MobEffectInstance p_19566_) {
        int i = 32147;
        return !(this.m_19557_() > 32147 && p_19566_.m_19557_() > 32147 || this.m_19571_() && p_19566_.m_19571_()) ? ComparisonChain.start().compareFalseFirst(this.m_19571_(), p_19566_.m_19571_()).compareFalseFirst(this.m_267577_(), p_19566_.m_267577_()).compare(this.m_19557_(), p_19566_.m_19557_()).compare(this.m_19544_().getSortOrder(this), p_19566_.m_19544_().getSortOrder(this)).result() : ComparisonChain.start().compare(Boolean.valueOf(this.m_19571_()), Boolean.valueOf(p_19566_.m_19571_())).compare(this.m_19544_().getSortOrder(this), p_19566_.m_19544_().getSortOrder(this)).result();
    }

    public List<ItemStack> getCurativeItems() {
        if (this.curativeItems == null) {
            this.curativeItems = this.m_19544_().getCurativeItems();
        }
        return this.curativeItems;
    }

    public void setCurativeItems(List<ItemStack> curativeItems) {
        this.curativeItems = curativeItems;
    }

    private static MobEffectInstance readCurativeItems(MobEffectInstance effect, CompoundTag nbt) {
        if (nbt.m_128425_("CurativeItems", 9)) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            ListTag list = nbt.m_128437_("CurativeItems", 10);
            for (int i = 0; i < list.size(); ++i) {
                items.add(ItemStack.m_41712_(list.m_128728_(i)));
            }
            effect.setCurativeItems(items);
        }
        return effect;
    }

    public static class FactorData {
        public static final Codec<FactorData> f_216907_ = RecordCodecBuilder.create(p_216933_ -> p_216933_.group((App)ExtraCodecs.f_144628_.fieldOf("padding_duration").forGetter(p_216945_ -> p_216945_.f_216908_), (App)Codec.FLOAT.fieldOf("factor_start").orElse((Object)Float.valueOf(0.0f)).forGetter(p_216943_ -> Float.valueOf(p_216943_.f_216909_)), (App)Codec.FLOAT.fieldOf("factor_target").orElse((Object)Float.valueOf(1.0f)).forGetter(p_216941_ -> Float.valueOf(p_216941_.f_216910_)), (App)Codec.FLOAT.fieldOf("factor_current").orElse((Object)Float.valueOf(0.0f)).forGetter(p_216939_ -> Float.valueOf(p_216939_.f_216911_)), (App)ExtraCodecs.f_144628_.fieldOf("ticks_active").orElse((Object)0).forGetter(p_267918_ -> p_267918_.f_267473_), (App)Codec.FLOAT.fieldOf("factor_previous_frame").orElse((Object)Float.valueOf(0.0f)).forGetter(p_216935_ -> Float.valueOf(p_216935_.f_216913_)), (App)Codec.BOOL.fieldOf("had_effect_last_tick").orElse((Object)false).forGetter(p_216929_ -> p_216929_.f_216914_)).apply((Applicative)p_216933_, FactorData::new));
        private final int f_216908_;
        private float f_216909_;
        private float f_216910_;
        private float f_216911_;
        private int f_267473_;
        private float f_216913_;
        private boolean f_216914_;

        public FactorData(int p_216919_, float p_216920_, float p_216921_, float p_216922_, int p_216923_, float p_216924_, boolean p_216925_) {
            this.f_216908_ = p_216919_;
            this.f_216909_ = p_216920_;
            this.f_216910_ = p_216921_;
            this.f_216911_ = p_216922_;
            this.f_267473_ = p_216923_;
            this.f_216913_ = p_216924_;
            this.f_216914_ = p_216925_;
        }

        public FactorData(int p_216917_) {
            this(p_216917_, 0.0f, 1.0f, 0.0f, 0, 0.0f, false);
        }

        public void m_267690_(MobEffectInstance p_268212_) {
            this.f_216913_ = this.f_216911_;
            boolean flag = !p_268212_.m_267633_(this.f_216908_);
            ++this.f_267473_;
            if (this.f_216914_ != flag) {
                this.f_216914_ = flag;
                this.f_267473_ = 0;
                this.f_216909_ = this.f_216911_;
                this.f_216910_ = flag ? 1.0f : 0.0f;
            }
            float f = Mth.m_14036_((float)((float)this.f_267473_ / (float)this.f_216908_), (float)0.0f, (float)1.0f);
            this.f_216911_ = Mth.m_14179_((float)f, (float)this.f_216909_, (float)this.f_216910_);
        }

        public float m_238413_(LivingEntity p_238414_, float p_238415_) {
            if (p_238414_.m_213877_()) {
                this.f_216913_ = this.f_216911_;
            }
            return Mth.m_14179_((float)p_238415_, (float)this.f_216913_, (float)this.f_216911_);
        }
    }
}

