/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.slf4j.Logger;

public class RecipeManager
extends SimpleJsonResourceReloadListener {
    private static final Gson f_44005_ = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger f_44006_ = LogUtils.getLogger();
    private Map<RecipeType<?>, Map<ResourceLocation, RecipeHolder<?>>> f_44007_ = ImmutableMap.of();
    private Map<ResourceLocation, RecipeHolder<?>> f_199900_ = ImmutableMap.of();
    private boolean f_44008_;
    private final ICondition.IContext context;

    @Deprecated
    public RecipeManager() {
        this(ICondition.IContext.EMPTY);
    }

    public RecipeManager(ICondition.IContext context) {
        super(f_44005_, "recipes");
        this.context = context;
    }

    protected void m_5787_(Map<ResourceLocation, JsonElement> p_44037_, ResourceManager p_44038_, ProfilerFiller p_44039_) {
        this.f_44008_ = false;
        HashMap map = Maps.newHashMap();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<ResourceLocation, JsonElement> entry : p_44037_.entrySet()) {
            ResourceLocation resourcelocation = entry.getKey();
            if (resourcelocation.m_135815_().startsWith("_")) continue;
            try {
                if (entry.getValue().isJsonObject() && !ForgeHooks.readAndTestCondition((ICondition.IContext)this.context, (JsonObject)entry.getValue().getAsJsonObject())) {
                    f_44006_.debug("Skipping loading recipe {} as it's conditions were not met", (Object)resourcelocation);
                    continue;
                }
                RecipeHolder<?> recipeholder = RecipeManager.m_44045_(resourcelocation, GsonHelper.m_13918_((JsonElement)entry.getValue(), (String)"top element"));
                map.computeIfAbsent(recipeholder.f_291008_().m_6671_(), p_44075_ -> ImmutableMap.builder()).put((Object)resourcelocation, recipeholder);
                builder.put((Object)resourcelocation, recipeholder);
            }
            catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                f_44006_.error("Parsing error loading recipe {}", (Object)resourcelocation, (Object)jsonparseexception);
            }
        }
        this.f_44007_ = (Map)map.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, p_44033_ -> ((ImmutableMap.Builder)p_44033_.getValue()).build()));
        this.f_199900_ = builder.build();
        f_44006_.info("Loaded {} recipes", (Object)map.size());
    }

    public boolean m_151269_() {
        return this.f_44008_;
    }

    public <C extends Container, T extends Recipe<C>> Optional<RecipeHolder<T>> m_44015_(RecipeType<T> p_44016_, C p_44017_, Level p_44018_) {
        return this.m_44054_(p_44016_).values().stream().filter(p_296918_ -> p_296918_.f_291008_().m_5818_(p_44017_, p_44018_)).findFirst();
    }

    public <C extends Container, T extends Recipe<C>> Optional<Pair<ResourceLocation, RecipeHolder<T>>> m_220248_(RecipeType<T> p_220249_, C p_220250_, Level p_220251_, @Nullable ResourceLocation p_220252_) {
        RecipeHolder<T> recipeholder;
        Map<ResourceLocation, RecipeHolder<T>> map = this.m_44054_(p_220249_);
        if (p_220252_ != null && (recipeholder = map.get(p_220252_)) != null && recipeholder.f_291008_().m_5818_(p_220250_, p_220251_)) {
            return Optional.of(Pair.of((Object)p_220252_, recipeholder));
        }
        return map.entrySet().stream().filter(p_296906_ -> ((RecipeHolder)p_296906_.getValue()).f_291008_().m_5818_(p_220250_, p_220251_)).findFirst().map(p_296909_ -> Pair.of((Object)((ResourceLocation)p_296909_.getKey()), (Object)((RecipeHolder)p_296909_.getValue())));
    }

    public <C extends Container, T extends Recipe<C>> List<RecipeHolder<T>> m_44013_(RecipeType<T> p_44014_) {
        return List.copyOf(this.m_44054_(p_44014_).values());
    }

    public <C extends Container, T extends Recipe<C>> List<RecipeHolder<T>> m_44056_(RecipeType<T> p_44057_, C p_44058_, Level p_44059_) {
        return this.m_44054_(p_44057_).values().stream().filter(p_296912_ -> p_296912_.f_291008_().m_5818_(p_44058_, p_44059_)).sorted(Comparator.comparing(p_296908_ -> p_296908_.f_291008_().m_8043_(p_44059_.m_9598_()).m_41778_())).collect(Collectors.toList());
    }

    private <C extends Container, T extends Recipe<C>> Map<ResourceLocation, RecipeHolder<T>> m_44054_(RecipeType<T> p_44055_) {
        return this.f_44007_.getOrDefault(p_44055_, Collections.emptyMap());
    }

    public <C extends Container, T extends Recipe<C>> NonNullList<ItemStack> m_44069_(RecipeType<T> p_44070_, C p_44071_, Level p_44072_) {
        Optional<RecipeHolder<T>> optional = this.m_44015_(p_44070_, p_44071_, p_44072_);
        if (optional.isPresent()) {
            return optional.get().f_291008_().m_7457_(p_44071_);
        }
        NonNullList nonnulllist = NonNullList.m_122780_((int)p_44071_.m_6643_(), (Object)((Object)ItemStack.f_41583_));
        for (int i = 0; i < nonnulllist.size(); ++i) {
            nonnulllist.set(i, (Object)p_44071_.m_8020_(i));
        }
        return nonnulllist;
    }

    public Optional<RecipeHolder<?>> m_44043_(ResourceLocation p_44044_) {
        return Optional.ofNullable(this.f_199900_.get(p_44044_));
    }

    public Collection<RecipeHolder<?>> m_44051_() {
        return this.f_44007_.values().stream().flatMap(p_220270_ -> p_220270_.values().stream()).collect(Collectors.toSet());
    }

    public Stream<ResourceLocation> m_44073_() {
        return this.f_44007_.values().stream().flatMap(p_220258_ -> p_220258_.keySet().stream());
    }

    protected static RecipeHolder<?> m_44045_(ResourceLocation p_44046_, JsonObject p_44047_) {
        String s = GsonHelper.m_13906_((JsonObject)p_44047_, (String)"type");
        Codec codec = ((RecipeSerializer)BuiltInRegistries.f_256769_.m_6612_(new ResourceLocation(s)).orElseThrow(() -> new JsonSyntaxException("Invalid or unsupported recipe type '" + s + "'"))).m_292673_();
        Recipe recipe = (Recipe)Util.m_260975_(codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)p_44047_), JsonParseException::new);
        return new RecipeHolder(p_44046_, recipe);
    }

    public void m_44024_(Iterable<RecipeHolder<?>> p_44025_) {
        this.f_44008_ = false;
        HashMap map = Maps.newHashMap();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        p_44025_.forEach(p_296915_ -> {
            Map map1 = map.computeIfAbsent(p_296915_.f_291008_().m_6671_(), p_220272_ -> Maps.newHashMap());
            ResourceLocation resourcelocation = p_296915_.f_291676_();
            RecipeHolder recipeholder = map1.put(resourcelocation, p_296915_);
            builder.put((Object)resourcelocation, p_296915_);
            if (recipeholder != null) {
                throw new IllegalStateException("Duplicate recipe ignored with ID " + resourcelocation);
            }
        });
        this.f_44007_ = ImmutableMap.copyOf((Map)map);
        this.f_199900_ = builder.build();
    }

    public static <C extends Container, T extends Recipe<C>> CachedCheck<C, T> m_220267_(final RecipeType<T> p_220268_) {
        return new CachedCheck<C, T>(){
            @Nullable
            private ResourceLocation f_220274_;

            @Override
            public Optional<RecipeHolder<T>> m_213657_(C p_220278_, Level p_220279_) {
                RecipeManager recipemanager = p_220279_.m_7465_();
                Optional optional = recipemanager.m_220248_(p_220268_, p_220278_, p_220279_, this.f_220274_);
                if (optional.isPresent()) {
                    Pair pair = optional.get();
                    this.f_220274_ = (ResourceLocation)pair.getFirst();
                    return Optional.of((RecipeHolder)pair.getSecond());
                }
                return Optional.empty();
            }
        };
    }

    public static interface CachedCheck<C extends Container, T extends Recipe<C>> {
        public Optional<RecipeHolder<T>> m_213657_(C var1, Level var2);
    }
}

