/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.boot.forge.application;

import cpw.mods.jarhandling.SecureJar;
import cpw.mods.jarhandling.impl.SimpleJarMetadata;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraftforge.bootstrap.ForgeBootstrap;
import net.minecraftforge.bootstrap.api.BootstrapEntryPoint;
import net.minecraftforge.securemodules.SecureModuleClassLoader;
import net.minecraftforge.securemodules.SecureModuleFinder;

public class ApplicationBootstrap
extends ForgeBootstrap {
    public static void main(String[] args) throws Exception {
        new ApplicationBootstrap().start(args);
    }

    protected void bootstrapMain(String[] args, List<Path[]> classpath) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            List boot = this.selectBootModules(classpath);
            SecureJar arclight = classpath.stream().map(SecureJar::from).filter(it -> it.moduleDataProvider().name().equals("arclight.boot")).findAny().orElseThrow();
            SecureJar jar = SecureJar.from(it -> new SimpleJarMetadata("arclight.launch", "1.0", Set.of("io.izzel.arclight.boot.forge.application"), List.of()), (Path[])new Path[]{arclight.getPrimaryPath()});
            boot.add(jar);
            SecureModuleFinder finder = SecureModuleFinder.of((SecureJar[])((SecureJar[])boot.toArray(SecureJar[]::new)));
            List<String> targets = boot.stream().map(SecureJar::name).toList();
            Configuration cfg = ModuleLayer.boot().configuration().resolve((ModuleFinder)finder, ModuleFinder.ofSystem(), targets);
            ModuleLayer layer = ModuleLayer.boot().defineModulesWithOneLoader(cfg, cl);
            Module bootstrap = layer.findModule("arclight.launch").orElseThrow();
            ClassLoader moduleCl = bootstrap.getClassLoader();
            Class<?> self = Class.forName(((Object)((Object)this)).getClass().getName(), false, moduleCl);
            Object inst = self.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method moduleMain = self.getDeclaredMethod("moduleMain", String[].class, List.class);
            moduleMain.invoke(inst, args, classpath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moduleMain(String[] args, List<Path[]> classpath) throws Exception {
        ModuleLayer bootlayer = ((Object)((Object)this)).getClass().getModule().getLayer();
        Set<String> mergedModules = Set.of("maven.model", "maven.model.builder", "maven.repository.metadata", "maven.artifact");
        ArrayList secure = this.selectRuntimeModules(classpath).stream().filter(it -> !mergedModules.contains(it.moduleDataProvider().name()) && !it.moduleDataProvider().name().equals("arclight.boot")).collect(Collectors.toCollection(ArrayList::new));
        SecureJar mavenMerged = SecureJar.from((Path[])((Path[])classpath.stream().map(SecureJar::from).filter(it -> mergedModules.contains(it.moduleDataProvider().name())).map(SecureJar::getPrimaryPath).toArray(Path[]::new)));
        secure.add(mavenMerged);
        SecureJar arclight = classpath.stream().map(SecureJar::from).filter(it -> it.moduleDataProvider().name().equals("arclight.boot")).findAny().orElseThrow();
        secure.add(SecureJar.from(it -> new SimpleJarMetadata(arclight.name(), arclight.moduleDataProvider().descriptor().rawVersion().orElse("1.0"), arclight.getPackages().stream().filter(p -> !p.equals("io.izzel.arclight.boot.forge.application")).collect(Collectors.toSet()), arclight.getProviders()), (Path[])new Path[]{arclight.getPrimaryPath()}));
        SecureModuleFinder finder = SecureModuleFinder.of((SecureJar[])((SecureJar[])secure.toArray(SecureJar[]::new)));
        List<String> targets = secure.stream().map(SecureJar::name).toList();
        Configuration cfg = bootlayer.configuration().resolveAndBind((ModuleFinder)finder, ModuleFinder.ofSystem(), targets);
        List<ModuleLayer> parent = List.of(ModuleLayer.boot(), bootlayer);
        ClassLoader oldcl = Thread.currentThread().getContextClassLoader();
        SecureModuleClassLoader cl = new SecureModuleClassLoader("SECURE-BOOTSTRAP", null, cfg, parent, oldcl == null ? List.of() : List.of(oldcl));
        ModuleLayer layer = bootlayer.defineModules(cfg, module -> cl);
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)cl);
            List<ServiceLoader.Provider> services = ServiceLoader.load(layer, BootstrapEntryPoint.class).stream().filter(it -> it.type().getName().contains("arclight")).toList();
            if (services.isEmpty()) {
                throw new IllegalStateException("Could not find any " + BootstrapEntryPoint.class.getName() + " service providers");
            }
            if (services.size() > 1) {
                throw new IllegalStateException("Found multiple " + BootstrapEntryPoint.class.getName() + " service providers: " + services.stream().map(p -> ((BootstrapEntryPoint)p.get()).name()).collect(Collectors.joining(", ")));
            }
            BootstrapEntryPoint loader = (BootstrapEntryPoint)services.get(0).get();
            loader.main(args);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldcl);
        }
    }
}

