/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.boot.forge.mod;

import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import io.izzel.arclight.boot.asm.AsyncCatcher;
import io.izzel.arclight.boot.asm.EnumDefinalizer;
import io.izzel.arclight.boot.asm.Implementer;
import io.izzel.arclight.boot.asm.InventoryImplementer;
import io.izzel.arclight.boot.asm.LoggerTransformer;
import io.izzel.arclight.boot.asm.SwitchTableFixer;
import io.izzel.arclight.boot.forge.mod.ModBootstrap;
import io.izzel.arclight.boot.log.ArclightI18nLogger;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.jul.LogManager;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

public class ArclightImplementer
implements ILaunchPluginService {
    static final Logger LOGGER = ArclightI18nLogger.getLogger("Implementer");
    private static final EnumSet<ILaunchPluginService.Phase> OH_YES_SIR = EnumSet.of(ILaunchPluginService.Phase.AFTER);
    private static final EnumSet<ILaunchPluginService.Phase> NOT_TODAY = EnumSet.noneOf(ILaunchPluginService.Phase.class);
    private final Map<String, Implementer> implementers = new HashMap<String, Implementer>();
    private volatile Consumer<String[]> auditAcceptor;
    private ILaunchPluginService.ITransformerLoader transformerLoader;
    private final boolean logger;

    public ArclightImplementer() {
        this(ArclightImplementer.detectTransformLogger());
    }

    public ArclightImplementer(boolean logger) {
        this.logger = logger;
    }

    private static boolean detectTransformLogger() {
        boolean transformLogger;
        boolean bl = transformLogger = !(java.util.logging.LogManager.getLogManager() instanceof LogManager);
        if (transformLogger && !System.getProperties().contains("log4j.jul.LoggerAdapter")) {
            System.setProperty("log4j.jul.LoggerAdapter", "io.izzel.arclight.boot.log.ArclightLoggerAdapter");
        }
        return transformLogger;
    }

    public String name() {
        return "arclight_implementer";
    }

    public void initializeLaunch(ILaunchPluginService.ITransformerLoader transformerLoader) {
        ModBootstrap.postRun();
        this.transformerLoader = transformerLoader;
        this.implementers.put("inventory", new InventoryImplementer());
        this.implementers.put("switch", SwitchTableFixer.INSTANCE);
        this.implementers.put("async", AsyncCatcher.INSTANCE);
        this.implementers.put("enum", new EnumDefinalizer());
        if (this.logger) {
            this.implementers.put("logger", new LoggerTransformer());
        }
    }

    public EnumSet<ILaunchPluginService.Phase> handlesClass(Type classType, boolean isEmpty, String reason) {
        if ("mixin".equals(reason)) {
            return NOT_TODAY;
        }
        return isEmpty ? NOT_TODAY : OH_YES_SIR;
    }

    public EnumSet<ILaunchPluginService.Phase> handlesClass(Type classType, boolean isEmpty) {
        throw new IllegalStateException("Outdated ModLauncher");
    }

    public void customAuditConsumer(String className, Consumer<String[]> auditDataAcceptor) {
        this.auditAcceptor = auditDataAcceptor;
    }

    public boolean processClass(ILaunchPluginService.Phase phase, ClassNode classNode, Type classType, String reason) {
        if ("mixin".equals(reason)) {
            return false;
        }
        ArrayList<String> trails = new ArrayList<String>();
        for (Map.Entry<String, Implementer> entry : this.implementers.entrySet()) {
            String key = entry.getKey();
            Implementer implementer = entry.getValue();
            if (!implementer.processClass(classNode)) continue;
            trails.add(key);
        }
        if (this.auditAcceptor != null && !trails.isEmpty()) {
            this.auditAcceptor.accept(new String[]{String.join((CharSequence)",", trails)});
        }
        return !trails.isEmpty();
    }

    public boolean processClass(ILaunchPluginService.Phase phase, ClassNode classNode, Type classType) {
        throw new IllegalStateException("Outdated ModLauncher");
    }
}

