/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.installer;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.izzel.arclight.installer.FileDownloader;
import io.izzel.arclight.installer.ForgeInstaller;
import io.izzel.arclight.installer.InstallInfo;
import io.izzel.arclight.installer.MavenDownloader;
import io.izzel.arclight.installer.Mirrors;
import io.izzel.arclight.installer.Util;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class MinecraftProvider {
    static Function<Supplier<Path>, CompletableFuture<Path>> reportSupply(ExecutorService service, Consumer<String> logger) {
        return it -> CompletableFuture.supplyAsync(it, service).thenApply(path -> {
            logger.accept("Downloaded " + path);
            return path;
        });
    }

    public static List<Path> modInstall(Consumer<String> logger) throws Throwable {
        InputStream stream = ForgeInstaller.class.getModule().getResourceAsStream("/META-INF/installer.json");
        InstallInfo installInfo = (InstallInfo)new Gson().fromJson((Reader)new InputStreamReader(stream), InstallInfo.class);
        List<Supplier<Path>> suppliers = MinecraftProvider.checkMavenNoSource(installInfo.libraries);
        if (!suppliers.isEmpty()) {
            logger.accept("Downloading missing libraries ...");
            ExecutorService pool = Executors.newFixedThreadPool(8);
            CompletableFuture[] array = (CompletableFuture[])suppliers.stream().map(MinecraftProvider.reportSupply(pool, logger)).toArray(CompletableFuture[]::new);
            MinecraftProvider.handleFutures(logger, array);
            pool.shutdownNow();
        }
        return installInfo.libraries.keySet().stream().map(it -> Paths.get("libraries", new String[0]).resolve(Util.mavenToPath(it))).collect(Collectors.toList());
    }

    static CompletableFuture<MinecraftData> downloadMinecraftData(InstallInfo info, ExecutorService pool, Consumer<String> logger) {
        return CompletableFuture.supplyAsync(() -> {
            logger.accept("Downloading mc version manifest...");
            Iterator<Map.Entry<String, String>> iterator = Mirrors.getVersionManifest().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                try {
                    InputStream stream = FileDownloader.read(entry.getValue());
                    try {
                        byte[] bytes = stream.readAllBytes();
                        JsonObject element = new JsonParser().parse(new String(bytes, StandardCharsets.UTF_8)).getAsJsonObject();
                        JsonArray versions = element.getAsJsonArray("versions");
                        for (JsonElement version : versions) {
                            String id = version.getAsJsonObject().get("id").getAsString();
                            if (!Objects.equals(id, info.installer.minecraft)) continue;
                            String url = version.getAsJsonObject().get("url").getAsString();
                            try (InputStream versionStream = FileDownloader.read(url);){
                                JsonObject object = new JsonParser().parse(new String(versionStream.readAllBytes(), StandardCharsets.UTF_8)).getAsJsonObject();
                                JsonObject downloads = object.getAsJsonObject("downloads");
                                JsonObject server = downloads.getAsJsonObject("server");
                                String serverUrl = server.get("url").getAsString();
                                String serverHash = server.get("sha1").getAsString();
                                JsonObject mapping = downloads.getAsJsonObject("server_mappings");
                                String mappingUrl = mapping.get("url").getAsString();
                                String mappingHash = mapping.get("sha1").getAsString();
                                logger.accept("Minecraft version: %s, server: %s, mappings: %s".formatted(info.installer.minecraft, serverHash, mappingHash));
                                MinecraftData minecraftData = new MinecraftData(entry.getKey(), Mirrors.mapMojangMirror(serverUrl, entry.getKey()), serverHash, Mirrors.mapMojangMirror(mappingUrl, entry.getKey()), mappingHash);
                                return minecraftData;
                            }
                        }
                        logger.accept("Version %s not available in %s".formatted(info.installer.minecraft, entry.getKey()));
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (Exception e) {
                    logger.accept("Failed to download manifest from " + entry.getKey() + "\n  " + e);
                }
            }
            return null;
        }, pool);
    }

    static void handleFutures(Consumer<String> logger, CompletableFuture<?> ... futures) {
        for (CompletableFuture<?> future : futures) {
            try {
                future.join();
            }
            catch (CompletionException e) {
                logger.accept(e.getCause().toString());
                Util.throwException(e.getCause());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
    }

    static List<Supplier<Path>> checkMavenNoSource(Map<String, String> map) {
        LinkedHashMap<String, Map.Entry<String, String>> hashMap = new LinkedHashMap<String, Map.Entry<String, String>>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            hashMap.put(entry.getKey(), new AbstractMap.SimpleImmutableEntry<String, Object>(entry.getValue(), null));
        }
        return MinecraftProvider.checkMaven(hashMap);
    }

    static List<Supplier<Path>> checkMaven(Map<String, Map.Entry<String, String>> map) {
        ArrayList<Supplier<Path>> incomplete = new ArrayList<Supplier<Path>>();
        for (Map.Entry<String, Map.Entry<String, String>> entry : map.entrySet()) {
            String maven = entry.getKey();
            String hash = entry.getValue().getKey();
            String url = entry.getValue().getValue();
            String path = "libraries/" + Util.mavenToPath(maven);
            if (new File(path).exists()) {
                try {
                    String fileHash = Util.hash(path);
                    if (fileHash.equals(hash)) continue;
                    incomplete.add(new MavenDownloader(Mirrors.getMavenRepo(), maven, path, hash, url));
                }
                catch (Exception e) {
                    incomplete.add(new MavenDownloader(Mirrors.getMavenRepo(), maven, path, hash, url));
                }
                continue;
            }
            incomplete.add(new MavenDownloader(Mirrors.getMavenRepo(), maven, path, hash, url));
        }
        return incomplete;
    }

    record MinecraftData(String mirror, String serverUrl, String serverHash, String mappingUrl, String mappingHash) {
    }
}

