/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.installer;

import com.google.gson.Gson;
import io.izzel.arclight.api.Unsafe;
import io.izzel.arclight.installer.FileDownloader;
import io.izzel.arclight.installer.ForgeInstaller;
import io.izzel.arclight.installer.ForgeLikeProvider;
import io.izzel.arclight.installer.InstallInfo;
import io.izzel.arclight.installer.MinecraftProvider;
import io.izzel.arclight.installer.Util;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.module.Configuration;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessControlContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NeoforgeInstaller {
    private static final MethodHandles.Lookup IMPL_LOOKUP = Unsafe.lookup();

    public static Map.Entry<String, List<String>> applicationInstall() throws Throwable {
        boolean installForge;
        InputStream stream = ForgeInstaller.class.getResourceAsStream("/META-INF/installer.json");
        InstallInfo installInfo = (InstallInfo)new Gson().fromJson((Reader)new InputStreamReader(stream), InstallInfo.class);
        List<Supplier<Path>> suppliers = MinecraftProvider.checkMavenNoSource(installInfo.libraries);
        String sysType = File.pathSeparatorChar == ';' ? "win" : "unix";
        Path path = Paths.get("libraries", "net", "neoforged", "neoforge", installInfo.installer.neoforge, sysType + "_args.txt");
        boolean bl = installForge = !Files.exists(path, new LinkOption[0]) || NeoforgeInstaller.forgeClasspathMissing(path);
        if (!suppliers.isEmpty() || installForge) {
            System.out.println("Downloading missing libraries ...");
            ExecutorService pool = Executors.newWorkStealingPool(8);
            CompletableFuture[] array = (CompletableFuture[])suppliers.stream().map(MinecraftProvider.reportSupply(pool, System.out::println)).toArray(CompletableFuture[]::new);
            if (installForge) {
                CompletableFuture<Path>[] futures = NeoforgeInstaller.installForge(installInfo, pool, System.out::println);
                MinecraftProvider.handleFutures(System.out::println, futures);
                System.out.println("Forge installation is starting, please wait... ");
                try {
                    ProcessBuilder builder = new ProcessBuilder(new String[0]);
                    File file = new File(System.getProperty("java.home"), "bin/java");
                    builder.command(file.getCanonicalPath(), "-Djava.net.useSystemProxies=true", "-jar", futures[0].join().toString(), "--installServer", ".", "--debug");
                    builder.inheritIO();
                    Process process = builder.start();
                    if (process.waitFor() > 0) {
                        throw new Exception("Forge installation failed");
                    }
                }
                catch (IOException e) {
                    try (URLClassLoader loader = new URLClassLoader(new URL[]{futures[0].join().toUri().toURL()}, ForgeInstaller.class.getClassLoader().getParent());){
                        Method method = loader.loadClass("net.minecraftforge.installer.SimpleInstaller").getMethod("main", String[].class);
                        method.invoke(null, new Object[]{new String[]{"--installServer", ".", "--debug"}});
                    }
                }
            }
            MinecraftProvider.handleFutures(System.out::println, array);
            pool.shutdownNow();
        }
        return NeoforgeInstaller.classpath(path, installInfo);
    }

    private static CompletableFuture<Path>[] installForge(InstallInfo info, ExecutorService pool, Consumer<String> logger) {
        CompletableFuture<MinecraftProvider.MinecraftData> minecraftData = MinecraftProvider.downloadMinecraftData(info, pool, logger);
        String coord = String.format("net.neoforged:neoforge:%s:installer", info.installer.neoforge);
        String dist = String.format("neoforge-%s-installer.jar", info.installer.neoforge);
        CompletableFuture<Path> installerFuture = ForgeLikeProvider.downloadInstaller(coord, dist, info.installer.neoforgeHash, minecraftData, info, pool, logger);
        CompletionStage serverFuture = minecraftData.thenCompose(data -> MinecraftProvider.reportSupply(pool, logger).apply(new FileDownloader(String.format(data.serverUrl(), info.installer.minecraft), String.format("libraries/net/minecraft/server/%1$s/server-%1$s.jar", info.installer.minecraft), data.serverHash())));
        return new CompletableFuture[]{installerFuture, serverFuture};
    }

    private static boolean forgeClasspathMissing(Path path) throws Exception {
        for (String arg : Files.lines(path).toList()) {
            String classpath;
            String modules;
            if (!(arg.startsWith("-p ") ? !Arrays.stream((modules = arg.substring(2).trim()).split(File.pathSeparator)).map(x$0 -> Paths.get(x$0, new String[0])).allMatch(x$0 -> Files.exists(x$0, new LinkOption[0])) : arg.startsWith("-DlegacyClassPath") && !Arrays.stream((classpath = arg.substring("-DlegacyClassPath=".length()).trim()).split(File.pathSeparator)).map(x$0 -> Paths.get(x$0, new String[0])).allMatch(x$0 -> Files.exists(x$0, new LinkOption[0])))) continue;
            return true;
        }
        return false;
    }

    private static Map.Entry<String, List<String>> classpath(Path path, InstallInfo installInfo) throws Throwable {
        boolean jvmArgs = true;
        String mainClass = null;
        ArrayList<String> userArgs = new ArrayList<String>();
        ArrayList<String> opens = new ArrayList<String>();
        ArrayList<String> exports = new ArrayList<String>();
        exports.add("cpw.mods.bootstraplauncher/cpw.mods.bootstraplauncher=ALL-UNNAMED");
        ArrayList<String> ignores = new ArrayList<String>();
        ArrayList merges = new ArrayList();
        Path self = new File(ForgeInstaller.class.getProtectionDomain().getCodeSource().getLocation().toURI()).toPath();
        for (String arg : Files.lines(path).toList()) {
            if (jvmArgs && arg.startsWith("-")) {
                if (arg.startsWith("-p ")) {
                    NeoforgeInstaller.addModules(arg.substring(2).trim());
                    continue;
                }
                if (arg.startsWith("--add-opens ")) {
                    opens.add(arg.substring("--add-opens ".length()).trim());
                    continue;
                }
                if (arg.startsWith("--add-exports ")) {
                    exports.add(arg.substring("--add-exports ".length()).trim());
                    continue;
                }
                if (!arg.startsWith("-D")) continue;
                String[] split = arg.substring(2).split("=", 2);
                if (split[0].equals("legacyClassPath")) {
                    split[1] = Stream.concat(Stream.concat(Stream.concat(Stream.of(self.toString()), Arrays.stream(split[1].split(File.pathSeparator))), installInfo.libraries.keySet().stream().peek(it -> {
                        Path lib = Paths.get("libraries", Util.mavenToPath(it));
                        String name = lib.getFileName().toString();
                        if (name.contains("maven-model")) {
                            merges.add(name);
                        }
                    }).map(it -> "libraries/" + Util.mavenToPath(it))), Stream.empty()).sorted((a, b) -> {
                        if (a.contains("maven-repository-metadata")) {
                            return -1;
                        }
                        if (b.contains("maven-repository-metadata")) {
                            return 1;
                        }
                        return 0;
                    }).distinct().collect(Collectors.joining(File.pathSeparator));
                } else if (split[0].equals("ignoreList")) {
                    ignores.addAll(Arrays.asList(split[1].split(",")));
                }
                System.setProperty(split[0], split[1]);
                continue;
            }
            if (jvmArgs) {
                jvmArgs = false;
                mainClass = arg;
                continue;
            }
            userArgs.addAll(Arrays.asList(arg.split(" ")));
        }
        String merge = String.join((CharSequence)",", merges);
        String mergeModules = System.getProperty("mergeModules");
        if (mergeModules != null) {
            System.setProperty("mergeModules", mergeModules + ";" + merge);
        } else {
            System.setProperty("mergeModules", merge);
        }
        NeoforgeInstaller.addOpens(opens);
        NeoforgeInstaller.addExports(exports);
        return Map.entry(Objects.requireNonNull(mainClass, "No main class found"), userArgs);
    }

    public static void addExports(List<String> exports) throws Throwable {
        MethodHandle implAddExportsMH = IMPL_LOOKUP.findVirtual(Module.class, "implAddExports", MethodType.methodType(Void.TYPE, String.class, Module.class));
        MethodHandle implAddExportsToAllUnnamedMH = IMPL_LOOKUP.findVirtual(Module.class, "implAddExportsToAllUnnamed", MethodType.methodType(Void.TYPE, String.class));
        NeoforgeInstaller.addExtra(exports, implAddExportsMH, implAddExportsToAllUnnamedMH);
    }

    public static void addOpens(List<String> opens) throws Throwable {
        MethodHandle implAddOpensMH = IMPL_LOOKUP.findVirtual(Module.class, "implAddOpens", MethodType.methodType(Void.TYPE, String.class, Module.class));
        MethodHandle implAddOpensToAllUnnamedMH = IMPL_LOOKUP.findVirtual(Module.class, "implAddOpensToAllUnnamed", MethodType.methodType(Void.TYPE, String.class));
        NeoforgeInstaller.addExtra(opens, implAddOpensMH, implAddOpensToAllUnnamedMH);
    }

    private static ParserData parseModuleExtra(String extra) {
        String[] all = extra.split("=", 2);
        if (all.length < 2) {
            return null;
        }
        String[] source = all[0].split("/", 2);
        if (source.length < 2) {
            return null;
        }
        return new ParserData(source[0], source[1], all[1]);
    }

    private static void addExtra(List<String> extras, MethodHandle implAddExtraMH, MethodHandle implAddExtraToAllUnnamedMH) {
        extras.forEach(extra -> {
            ParserData data = NeoforgeInstaller.parseModuleExtra(extra);
            if (data != null) {
                ModuleLayer.boot().findModule(data.module).ifPresent(m -> {
                    try {
                        if ("ALL-UNNAMED".equals(data.target)) {
                            implAddExtraToAllUnnamedMH.invokeWithArguments(m, data.packages);
                        } else {
                            ModuleLayer.boot().findModule(data.target).ifPresent(tm -> {
                                try {
                                    implAddExtraMH.invokeWithArguments(m, data.packages, tm);
                                }
                                catch (Throwable t) {
                                    throw new RuntimeException(t);
                                }
                            });
                        }
                    }
                    catch (Throwable t) {
                        throw new RuntimeException(t);
                    }
                });
            }
        });
    }

    private static void addModules(String modulePath) throws Throwable {
        ModuleFinder finder = ModuleFinder.of((Path[])Arrays.stream(modulePath.split(File.pathSeparator)).map(x$0 -> Paths.get(x$0, new String[0])).peek(NeoforgeInstaller::addToPath).toArray(Path[]::new));
        MethodHandle loadModuleMH = IMPL_LOOKUP.findVirtual(Class.forName("jdk.internal.loader.BuiltinClassLoader"), "loadModule", MethodType.methodType(Void.TYPE, ModuleReference.class));
        Configuration config = Configuration.resolveAndBind(finder, List.of(ModuleLayer.boot().configuration()), finder, finder.findAll().stream().peek(mref -> {
            try {
                loadModuleMH.invokeWithArguments(ClassLoader.getSystemClassLoader(), mref);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }).map(ModuleReference::descriptor).map(ModuleDescriptor::name).collect(Collectors.toList()));
        MethodHandle graphGetter = IMPL_LOOKUP.findGetter(Configuration.class, "graph", Map.class);
        HashMap<ResolvedModule, Set> graphMap = new HashMap<ResolvedModule, Set>((Map)graphGetter.invokeWithArguments(config));
        MethodHandle cfSetter = IMPL_LOOKUP.findSetter(ResolvedModule.class, "cf", Configuration.class);
        graphMap.forEach((k, v) -> {
            try {
                cfSetter.invokeWithArguments(k, ModuleLayer.boot().configuration());
                v.forEach(m -> {
                    try {
                        cfSetter.invokeWithArguments(m, ModuleLayer.boot().configuration());
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable);
                    }
                });
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        });
        graphMap.putAll((Map)graphGetter.invokeWithArguments(ModuleLayer.boot().configuration()));
        IMPL_LOOKUP.findSetter(Configuration.class, "graph", Map.class).invokeWithArguments(ModuleLayer.boot().configuration(), new HashMap(graphMap));
        Set<ResolvedModule> oldBootModules = ModuleLayer.boot().configuration().modules();
        MethodHandle modulesSetter = IMPL_LOOKUP.findSetter(Configuration.class, "modules", Set.class);
        HashSet<ResolvedModule> modulesSet = new HashSet<ResolvedModule>(config.modules());
        modulesSetter.invokeWithArguments(ModuleLayer.boot().configuration(), new HashSet<ResolvedModule>(modulesSet));
        MethodHandle nameToModuleGetter = IMPL_LOOKUP.findGetter(Configuration.class, "nameToModule", Map.class);
        HashMap nameToModuleMap = new HashMap((Map)nameToModuleGetter.invokeWithArguments(ModuleLayer.boot().configuration()));
        nameToModuleMap.putAll((Map)nameToModuleGetter.invokeWithArguments(config));
        IMPL_LOOKUP.findSetter(Configuration.class, "nameToModule", Map.class).invokeWithArguments(ModuleLayer.boot().configuration(), new HashMap(nameToModuleMap));
        ((Map)IMPL_LOOKUP.findGetter(ModuleLayer.class, "nameToModule", Map.class).invokeWithArguments(ModuleLayer.boot())).putAll((Map)IMPL_LOOKUP.findStatic(Module.class, "defineModules", MethodType.methodType(Map.class, Configuration.class, Function.class, ModuleLayer.class)).invokeWithArguments(ModuleLayer.boot().configuration(), name -> ClassLoader.getSystemClassLoader(), ModuleLayer.boot()));
        modulesSet.addAll(oldBootModules);
        modulesSetter.invokeWithArguments(ModuleLayer.boot().configuration(), new HashSet<ResolvedModule>(modulesSet));
        IMPL_LOOKUP.findSetter(ModuleLayer.class, "modules", Set.class).invokeWithArguments(ModuleLayer.boot(), null);
        IMPL_LOOKUP.findSetter(ModuleLayer.class, "servicesCatalog", Class.forName("jdk.internal.module.ServicesCatalog")).invokeWithArguments(ModuleLayer.boot(), null);
        MethodHandle implAddReadsMH = IMPL_LOOKUP.findVirtual(Module.class, "implAddReads", MethodType.methodType(Void.TYPE, Module.class));
        config.modules().forEach(rm -> ModuleLayer.boot().findModule(rm.name()).ifPresent(m -> oldBootModules.forEach(brm -> ModuleLayer.boot().findModule(brm.name()).ifPresent(bm -> {
            try {
                implAddReadsMH.invokeWithArguments(m, bm);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }))));
    }

    public static void addToPath(Path path) {
        try {
            Field ucpField;
            ClassLoader loader = ClassLoader.getPlatformClassLoader();
            try {
                ucpField = loader.getClass().getDeclaredField("ucp");
            }
            catch (NoSuchFieldException e) {
                ucpField = loader.getClass().getSuperclass().getDeclaredField("ucp");
            }
            long offset = Unsafe.objectFieldOffset(ucpField);
            Object ucp = Unsafe.getObject(loader, offset);
            if (ucp == null) {
                Class<?> cl = Class.forName("jdk.internal.loader.URLClassPath");
                MethodHandle handle = Unsafe.lookup().findConstructor(cl, MethodType.methodType(Void.TYPE, URL[].class, AccessControlContext.class));
                ucp = handle.invoke(new URL[0], null);
                Unsafe.putObjectVolatile(loader, offset, ucp);
            }
            Method method = ucp.getClass().getDeclaredMethod("addURL", URL.class);
            Unsafe.lookup().unreflect(method).invoke(ucp, path.toUri().toURL());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private record ParserData(String module, String packages, String target) {
    }
}

