/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.mixin.injector;

import io.izzel.arclight.mixin.DecorationOps;
import io.izzel.arclight.mixin.Local;
import io.izzel.arclight.mixin.injector.EnhancedAnalyzerAdapter;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.points.MethodHead;
import org.spongepowered.asm.mixin.injection.selectors.ISelectorContext;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.injection.throwables.InvalidInjectionException;
import org.spongepowered.asm.util.Annotations;
import org.spongepowered.asm.util.Locals;

public class Decorator
extends Injector {
    private static final String DECORATION_LOCALS = "DECORATION_LOCALS";
    private static final Type DECORATION_TYPE = Type.getType(DecorationOps.class);
    private static final Type MH_TYPE = Type.getType(MethodHandle.class);
    private static final Type DECORATION_METHOD = Type.getMethodType((Type)MH_TYPE, (Type[])new Type[0]);
    private static final String DECORATION_CALLSITE = "callsite";
    private static final String DECORATION_CANCEL = "cancel";
    private static final String DECORATION_BLACKHOLE = "blackhole";
    private static final String MH_INVOKE = "invoke";
    private static final String LOCAL_DESC = Type.getDescriptor(Local.class);

    public Decorator(InjectionInfo info) {
        super(info, "@Decorate");
    }

    protected void preInject(Target target, InjectionNodes.InjectionNode node) {
        node.decorate(DECORATION_LOCALS, (Object)Locals.getLocalsAt((ClassNode)target.classNode, (MethodNode)target.method, (AbstractInsnNode)node.getCurrentTarget(), (Locals.Settings)Locals.Settings.DEFAULT));
    }

    protected void inject(Target target, InjectionNodes.InjectionNode node) {
        if (node.isReplaced()) {
            throw new UnsupportedOperationException("Indirect target failure for " + this.info);
        }
        this.methodNode.instructions.resetLabels();
        this.checkTargetForNode(target, node, InjectionPoint.RestrictTargetLevel.ALLOW_ALL);
        DecorationData decorationData = this.createDecorationData(target, node);
        this.guardInline(target, node, decorationData, decorationData.handlerArgs);
        decorationData.lvtMap = this.prepareLvtMapping(target, decorationData, (LocalVariableNode[])node.getDecoration(DECORATION_LOCALS));
        this.performInline(target, node, decorationData);
        this.info.addCallbackInvocation(this.methodNode);
    }

    protected DecorationData createDecorationData(Target target, InjectionNodes.InjectionNode node) {
        Type methodType;
        MethodInsnNode callsiteDecl = null;
        MethodInsnNode callsiteInvoke = null;
        HashMap<AbstractInsnNode, MethodInsnNode> cancels = new HashMap<AbstractInsnNode, MethodInsnNode>();
        HashMap<AbstractInsnNode, MethodInsnNode> blackholes = new HashMap<AbstractInsnNode, MethodInsnNode>();
        Enum lastDecl = null;
        MethodInsnNode lastDeclInsn = null;
        boolean requireFrame = false;
        for (AbstractInsnNode insn : this.methodNode.instructions) {
            if (insn.getOpcode() == 184 && insn instanceof MethodInsnNode) {
                MethodInsnNode mn = (MethodInsnNode)insn;
                if (!mn.owner.equals(DECORATION_TYPE.getInternalName()) || !mn.desc.equals(DECORATION_METHOD.getDescriptor())) continue;
                if (lastDecl != null) {
                    throw new InvalidInjectionException((ISelectorContext)this.info, "Nested DecorationOps at bci " + this.methodNode.instructions.indexOf((AbstractInsnNode)lastDeclInsn) + ", " + this.methodNode.instructions.indexOf((AbstractInsnNode)mn));
                }
                lastDeclInsn = mn;
                switch (mn.name) {
                    static enum LastDecl {
                        CALLSITE,
                        CANCEL,
                        BLACKHOLE;

                    }
                    case "callsite": {
                        if (callsiteDecl != null) {
                            throw new InvalidInjectionException((ISelectorContext)this.info, "Multiple callsite found in @Decorate: bci " + this.methodNode.instructions.indexOf((AbstractInsnNode)callsiteDecl) + ", " + this.methodNode.instructions.indexOf((AbstractInsnNode)mn));
                        }
                        callsiteDecl = mn;
                        lastDecl = LastDecl.CALLSITE;
                        break;
                    }
                    case "cancel": {
                        lastDecl = LastDecl.CANCEL;
                        break;
                    }
                    case "blackhole": {
                        lastDecl = LastDecl.BLACKHOLE;
                    }
                }
                continue;
            }
            if (insn.getOpcode() == 182 && insn instanceof MethodInsnNode) {
                MethodInsnNode mn = (MethodInsnNode)insn;
                if (!mn.owner.equals(MH_TYPE.getInternalName()) || !mn.name.equals(MH_INVOKE)) continue;
                if (lastDecl != null) {
                    switch (1.$SwitchMap$io$izzel$arclight$mixin$injector$Decorator$1LastDecl[lastDecl.ordinal()]) {
                        case 1: {
                            callsiteInvoke = mn;
                            break;
                        }
                        case 2: {
                            cancels.put((AbstractInsnNode)lastDeclInsn, mn);
                            break;
                        }
                        case 3: {
                            blackholes.put((AbstractInsnNode)lastDeclInsn, mn);
                        }
                    }
                }
                lastDecl = null;
                lastDeclInsn = null;
                continue;
            }
            if (insn instanceof FrameNode) {
                requireFrame = true;
                continue;
            }
            if (insn.getOpcode() < 172 || insn.getOpcode() > 177 || insn.getNext() == null) continue;
            requireFrame = true;
        }
        if (callsiteDecl == null || callsiteInvoke == null) {
            throw new InvalidInjectionException((ISelectorContext)this.info, "No callsite found in @Decorate");
        }
        if (lastDeclInsn != null) {
            throw new InvalidInjectionException((ISelectorContext)this.info, "Open DecorationOps in @Decorate: " + lastDecl + " at bci " + this.methodNode.instructions.indexOf(callsiteDecl));
        }
        for (MethodInsnNode invoke : cancels.values()) {
            methodType = Type.getMethodType((String)invoke.desc);
            Type[] argumentTypes = methodType.getArgumentTypes();
            if ((!target.returnType.equals((Object)Type.VOID_TYPE) || argumentTypes.length == 0) && (target.returnType.equals((Object)Type.VOID_TYPE) || argumentTypes.length == 1 && argumentTypes[0].equals((Object)target.returnType))) continue;
            throw new InvalidInjectionException((ISelectorContext)this.info, "Invalid DecorationOps.cancel argument types: bci " + this.methodNode.instructions.indexOf((AbstractInsnNode)invoke));
        }
        for (MethodInsnNode invoke : blackholes.values()) {
            methodType = Type.getMethodType((String)invoke.desc);
            if (methodType.getReturnType().equals((Object)Type.VOID_TYPE)) continue;
            throw new InvalidInjectionException((ISelectorContext)this.info, "Invalid DecorationOps.blackhole return type: bci " + this.methodNode.instructions.indexOf((AbstractInsnNode)invoke));
        }
        DecorationData data = new DecorationData(target, node, (AbstractInsnNode)callsiteDecl, (AbstractInsnNode)callsiteInvoke, (Map<AbstractInsnNode, MethodInsnNode>)cancels, (Map<AbstractInsnNode, MethodInsnNode>)blackholes, requireFrame, (LocalVariableNode[])node.getDecoration(DECORATION_LOCALS));
        if (!data.returnType.equals((Object)Type.getReturnType((String)this.methodNode.desc))) {
            throw new InvalidInjectionException((ISelectorContext)this.info, "Return type mismatch: expect " + data.returnType + ", found " + Type.getReturnType((String)this.methodNode.desc));
        }
        Type[] argTypes = Type.getArgumentTypes((String)this.methodNode.desc);
        Type[] handlerArgs = data.handlerArgs;
        for (int i = 0; i < handlerArgs.length; ++i) {
            Type handlerArg = handlerArgs[i];
            if (argTypes[i].equals((Object)handlerArg)) continue;
            throw new InvalidInjectionException((ISelectorContext)this.info, "Callback argument type mismatch at " + i + ": expect " + handlerArg + ", found " + argTypes[i]);
        }
        return data;
    }

    private void guardInline(Target target, InjectionNodes.InjectionNode node, DecorationData decorationData, Type[] handlerTypes) {
        int i;
        int handlerStartIndex;
        EnhancedAnalyzerAdapter adapter = new EnhancedAnalyzerAdapter(target.classNode.name, target.method.access, target.method.name, target.method.desc, null);
        int i2 = target.insns.indexOf(node.getCurrentTarget());
        for (int j = 0; j < i2; ++j) {
            target.insns.get(j).accept((MethodVisitor)adapter);
        }
        List<Object> currentLocal = adapter.getCurrent(adapter.locals);
        List<Object> currentStack = adapter.getCurrent(adapter.stack);
        decorationData.targetLocals = currentLocal;
        if (currentStack.size() < handlerTypes.length) {
            throw new InvalidInjectionException((ISelectorContext)this.info, "Stack size is not large enough");
        }
        for (int i3 = 0; i3 < handlerTypes.length; ++i3) {
            Type handlerType = handlerTypes[i3];
            if (EnhancedAnalyzerAdapter.canFit(currentStack.get(currentStack.size() - handlerTypes.length + i3), handlerType)) continue;
            throw new InvalidInjectionException((ISelectorContext)this.info, "Stack element not match argument type: frame " + currentStack.get(i3) + ", argument " + handlerType);
        }
        InsnList beforeDecorate = new InsnList();
        InsnList afterDecorate = new InsnList();
        int unusedStackElmSize = currentStack.subList(handlerTypes.length, currentStack.size()).stream().mapToInt(it -> it == Opcodes.LONG || it == Opcodes.DOUBLE ? 2 : 1).sum();
        decorationData.handlerLocalsStart = handlerStartIndex = adapter.locals.size() + unusedStackElmSize;
        decorationData.handlerStackStart = adapter.stack.size();
        int lvIndex = handlerStartIndex;
        for (i = 0; i < handlerTypes.length; ++i) {
            beforeDecorate.insert((AbstractInsnNode)new VarInsnNode(handlerTypes[i].getOpcode(54), lvIndex));
            lvIndex += handlerTypes[i].getSize();
        }
        lvIndex = adapter.locals.size();
        for (i = currentStack.size() - handlerTypes.length - 1; i >= 0; --i) {
            beforeDecorate.add((AbstractInsnNode)new VarInsnNode(EnhancedAnalyzerAdapter.getOpcode(54, currentStack.get(i)), lvIndex));
            afterDecorate.insert((AbstractInsnNode)new VarInsnNode(EnhancedAnalyzerAdapter.getOpcode(21, currentStack.get(i)), lvIndex));
            lvIndex += currentStack.get(i) == Opcodes.LONG || currentStack.get(i) == Opcodes.DOUBLE ? 2 : 1;
        }
        if (!decorationData.requireFrame && afterDecorate.size() == 0) {
            target.insertBefore(node.getCurrentTarget(), beforeDecorate);
            return;
        }
        Type[] callbackArgs = Type.getArgumentTypes((String)this.methodNode.desc);
        Object[] callbackLocals = Arrays.stream(decorationData.handlerArgs).map(EnhancedAnalyzerAdapter::getFrameItem).toArray();
        Object[] mergedLocals = new Object[currentLocal.size() + currentStack.size() + callbackArgs.length];
        System.arraycopy(currentLocal.toArray(), 0, mergedLocals, 0, currentLocal.size());
        System.arraycopy(currentStack.toArray(), 0, mergedLocals, currentLocal.size(), currentStack.size());
        System.arraycopy(callbackLocals, 0, mergedLocals, currentLocal.size() + currentStack.size(), callbackLocals.length);
        beforeDecorate.add((AbstractInsnNode)new LabelNode(decorationData.begin));
        beforeDecorate.add((AbstractInsnNode)new FrameNode(0, mergedLocals.length, mergedLocals, 0, null));
        ListIterator iterator = target.insns.iterator(target.insns.indexOf(node.getCurrentTarget()));
        while (iterator.hasNext()) {
            AbstractInsnNode insn = (AbstractInsnNode)iterator.next();
            insn.accept((MethodVisitor)adapter);
            if (insn != decorationData.nodeEnd) continue;
            break;
        }
        List<Object> afterLocal = adapter.getCurrent(adapter.locals);
        List<Object> afterStack = adapter.getCurrent(adapter.stack);
        if (afterDecorate.size() > 0) {
            Object[] objectArray;
            boolean callbackHasReturn = Type.getReturnType((String)this.methodNode.desc).getSize() > 0;
            Object[] afterWithUnused = new Object[afterLocal.size() + currentLocal.size() - handlerTypes.length + (callbackHasReturn ? 1 : 0)];
            System.arraycopy(afterLocal.toArray(), 0, afterWithUnused, 0, afterLocal.size());
            System.arraycopy(currentStack.toArray(), 0, afterWithUnused, afterLocal.size(), currentLocal.size() - handlerTypes.length);
            if (callbackHasReturn) {
                afterWithUnused[afterWithUnused.length - 1] = EnhancedAnalyzerAdapter.getFrameItem(Type.getReturnType((String)this.methodNode.desc));
                afterDecorate.insert((AbstractInsnNode)new VarInsnNode(Type.getReturnType((String)this.methodNode.desc).getOpcode(54), handlerStartIndex));
            }
            int n = afterWithUnused.length;
            int n2 = callbackHasReturn ? 1 : 0;
            if (callbackHasReturn) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = afterWithUnused[afterWithUnused.length - 1];
            } else {
                objectArray = null;
            }
            afterDecorate.insert((AbstractInsnNode)new FrameNode(0, n, afterWithUnused, n2, objectArray));
            if (callbackHasReturn) {
                afterDecorate.add((AbstractInsnNode)new VarInsnNode(Type.getReturnType((String)this.methodNode.desc).getOpcode(21), handlerStartIndex));
            }
        }
        decorationData.hasEnd = true;
        afterDecorate.add((AbstractInsnNode)new FrameNode(0, afterLocal.size(), afterLocal.toArray(), afterStack.size(), afterStack.toArray()));
        ListIterator iterator2 = target.insns.iterator(target.insns.indexOf(decorationData.nodeEnd) + 1);
        while (iterator2.hasNext()) {
            AbstractInsnNode insn = (AbstractInsnNode)iterator2.next();
            insn.accept((MethodVisitor)adapter);
            if (!(insn instanceof FrameNode)) continue;
            FrameNode fn = (FrameNode)insn;
            if (fn.type == 0) break;
            List<Object> locals = adapter.getCurrent(adapter.locals);
            List<Object> stack = adapter.getCurrent(adapter.stack);
            iterator2.set(new FrameNode(0, locals.size(), locals.toArray(), stack.size(), stack.toArray()));
            break;
        }
        target.insns.insertBefore(node.getCurrentTarget(), beforeDecorate);
        target.insns.insert(decorationData.nodeEnd, afterDecorate);
    }

    private int[] prepareLvtMapping(Target target, DecorationData decorationData, LocalVariableNode[] lvns) {
        int i;
        int[] lvtMap = new int[this.methodNode.maxLocals];
        Arrays.fill(lvtMap, -1);
        int lvIndex = 0;
        int offset = 0;
        if (!Modifier.isStatic(this.methodNode.access)) {
            lvtMap[lvIndex] = offset++;
            ++lvIndex;
        }
        int targetArgsStart = decorationData.handlerArgs.length;
        for (int i2 = 0; i2 < targetArgsStart; ++i2) {
            lvtMap[lvIndex] = lvIndex - offset + decorationData.handlerLocalsStart;
            lvIndex += this.methodArgs[i2].getSize();
        }
        int localsStart = targetArgsStart + target.arguments.length;
        for (int i3 = targetArgsStart; i3 < Math.min(this.methodArgs.length, localsStart); ++i3) {
            lvtMap[lvIndex] = offset;
            lvIndex += this.methodArgs[i3].getSize();
            offset += this.methodArgs[i3].getSize();
        }
        int handlerLocalsOffset = offset;
        for (i = localsStart; i < this.methodArgs.length; ++i) {
            handlerLocalsOffset += this.methodArgs[i].getSize();
        }
        decorationData.handlerLocalsOffset = handlerLocalsOffset;
        for (i = localsStart; i < this.methodArgs.length; ++i) {
            lvtMap[lvIndex] = this.findLv(target, decorationData, i, lvns);
            lvIndex += this.methodArgs[i].getSize();
            offset += this.methodArgs[i].getSize();
        }
        for (i = lvIndex; i < this.methodNode.maxLocals; ++i) {
            lvtMap[lvIndex] = lvIndex - offset + decorationData.handlerLocalsStart;
            ++lvIndex;
        }
        return lvtMap;
    }

    private int findLv(Target target, DecorationData decorationData, int i, LocalVariableNode[] locals) {
        AnnotationNode localNode;
        Type type = this.methodArgs[i];
        if (this.methodNode.invisibleAnnotableParameterCount > i && (localNode = (AnnotationNode)this.methodNode.invisibleParameterAnnotations[i].stream().filter(it -> it.desc.equals(LOCAL_DESC)).findAny().orElse(null)) != null) {
            Integer index = (Integer)Annotations.getValue((AnnotationNode)localNode, (String)"ordinal");
            String allocate = (String)Annotations.getValue((AnnotationNode)localNode, (String)"allocate");
            if (index != null && allocate != null) {
                throw new InvalidInjectionException((ISelectorContext)this.info, "Only one of 'ordinal' and 'allocate' can exist on @Local at parameter " + i);
            }
            if (index != null) {
                List<LocalVariableNode> lvns = Arrays.stream(locals).filter(it -> Type.getType((String)it.desc).equals((Object)type)).toList();
                if (index < 0) {
                    index = lvns.size() + index;
                }
                if (index < lvns.size()) {
                    return lvns.get((int)index.intValue()).index;
                }
                throw new InvalidInjectionException((ISelectorContext)this.info, "Cannot find local at " + i + " with ordinal " + localNode.values.get(1) + "\nAvailable locals:\n" + lvns.stream().map(it -> "Index: " + it.index + " Type " + it.desc + " Name " + it.name).collect(Collectors.joining("\n")));
            }
            if (allocate != null) {
                Optional<LocalVariableNode> allocated = target.method.localVariables.stream().filter(it -> {
                    if (!(it instanceof AllocatedLocalVariableNode)) return false;
                    AllocatedLocalVariableNode al = (AllocatedLocalVariableNode)((Object)it);
                    if (!al.id.equals(allocate)) return false;
                    return true;
                }).findFirst();
                if (allocated.isPresent()) {
                    if (!allocated.get().desc.equals(this.methodArgs[i].getDescriptor())) {
                        throw new InvalidInjectionException((ISelectorContext)this.info, "@Local allocate has different desc " + this.methodArgs[i].getDescriptor() + " and " + allocated.get().desc);
                    }
                    return allocated.get().index;
                }
                int allocateStart = Math.max(target.method.maxLocals, this.methodNode.maxLocals - decorationData.handlerLocalsOffset + decorationData.handlerLocalsStart);
                target.method.maxLocals = allocateStart + this.methodArgs[i].getSize();
                target.method.localVariables.add(new AllocatedLocalVariableNode(allocate, this.methodArgs[i].getDescriptor(), null, new LabelNode(decorationData.begin), new LabelNode(decorationData.end), allocateStart));
                return allocateStart;
            }
            throw new InvalidInjectionException((ISelectorContext)this.info, "Invalid @Local at parameter " + i);
        }
        throw new InvalidInjectionException((ISelectorContext)this.info, "@Local not exist at local " + i + ": " + type);
    }

    private void performInline(Target target, InjectionNodes.InjectionNode node, DecorationData decorationData) {
        List lvns;
        CollectingVisitor collector = new CollectingVisitor(589824, target, decorationData);
        for (LocalVariableNode lvn : this.methodNode.localVariables) {
            lvn.accept((MethodVisitor)collector);
        }
        for (TryCatchBlockNode tryCatch : this.methodNode.tryCatchBlocks) {
            tryCatch.accept((MethodVisitor)collector);
        }
        switch (decorationData.decorationTarget) {
            case INVOKE: 
            case FIELD: 
            case HEAD: 
            case RETURN: {
                for (AbstractInsnNode insn2 : this.methodNode.instructions) {
                    if (insn2 == decorationData.callsiteDecl) continue;
                    if (insn2 == decorationData.callsiteInvoke) {
                        collector.step();
                        continue;
                    }
                    collector.next(insn2);
                }
                collector.visitEnd();
                target.insns.insertBefore(node.getCurrentTarget(), collector.blocks.get((int)0).instructions);
                target.insns.insert(decorationData.nodeEnd, collector.blocks.get((int)1).instructions);
                break;
            }
            case NEW: {
                AbstractInsnNode insn;
                for (AbstractInsnNode insn2 : this.methodNode.instructions) {
                    if (insn2 == decorationData.callsiteDecl) {
                        collector.step();
                        continue;
                    }
                    if (insn2 == decorationData.callsiteInvoke) {
                        collector.step();
                        continue;
                    }
                    collector.next(insn2);
                }
                collector.visitEnd();
                InsnList initInsns = new InsnList();
                AbstractInsnNode startNode = decorationData.node.getNext();
                if (startNode.getOpcode() == 89) {
                    startNode = startNode.getNext();
                }
                ListIterator iterator = target.insns.iterator(target.insns.indexOf(startNode));
                while (iterator.hasNext() && (insn = (AbstractInsnNode)iterator.next()) != decorationData.nodeEnd) {
                    initInsns.add(insn);
                    iterator.remove();
                }
                target.insns.insertBefore(decorationData.node, initInsns);
                target.insns.insertBefore(decorationData.node, collector.blocks.get((int)0).instructions);
                target.insns.insertBefore(decorationData.nodeEnd, collector.blocks.get((int)1).instructions);
                target.insns.insert(decorationData.nodeEnd, collector.blocks.get((int)2).instructions);
                break;
            }
            default: {
                throw new InvalidInjectionException((ISelectorContext)this.info, "Unknown decoration target: " + decorationData.decorationTarget);
            }
        }
        List tcns = collector.blocks.get((int)0).tryCatchBlocks;
        if (tcns != null) {
            target.method.tryCatchBlocks.addAll(this.findTryCatchIndex(target.method, tcns), tcns);
        }
        if ((lvns = collector.blocks.get((int)0).localVariables) != null) {
            target.method.localVariables.addAll(lvns.stream().filter(it -> it.index >= decorationData.handlerLocalsStart).toList());
        }
        target.method.maxLocals = Math.max(target.method.maxLocals, this.methodNode.maxLocals - decorationData.handlerLocalsOffset + decorationData.handlerLocalsStart);
        target.method.maxStack = Math.max(target.method.maxStack, this.methodNode.maxStack + decorationData.handlerStackStart);
    }

    private int findTryCatchIndex(MethodNode target, List<TryCatchBlockNode> tcns) {
        HashMap<AbstractInsnNode, Integer> labelIndexes = new HashMap<AbstractInsnNode, Integer>();
        for (AbstractInsnNode node : target.instructions) {
            if (node.getType() != 8) continue;
            labelIndexes.put(node, target.instructions.indexOf(node));
        }
        for (int i = target.tryCatchBlocks.size() - 1; i >= 0; --i) {
            TryCatchBlockNode tcn = (TryCatchBlockNode)target.tryCatchBlocks.get(i);
            if (!tcns.stream().anyMatch(it -> (Integer)labelIndexes.get(it.start) <= (Integer)labelIndexes.get(tcn.start) && (Integer)labelIndexes.get(it.end) >= (Integer)labelIndexes.get(tcn.end))) continue;
            return i + 1;
        }
        return 0;
    }

    protected static class DecorationData
    extends Injector.InjectorData {
        final AbstractInsnNode node;
        final AbstractInsnNode nodeEnd;
        final DecorationTarget decorationTarget;
        final Type returnType;
        final Type[] handlerArgs;
        final AbstractInsnNode callsiteDecl;
        final AbstractInsnNode callsiteInvoke;
        final Map<AbstractInsnNode, MethodInsnNode> cancels;
        final Map<AbstractInsnNode, MethodInsnNode> blackholes;
        final boolean requireFrame;
        final Label begin = new Label();
        final Label end = new Label();
        final LocalVariableNode[] locals;
        boolean hasEnd = false;
        int handlerLocalsStart;
        int handlerStackStart;
        int handlerLocalsOffset;
        List<Object> targetLocals;
        int[] lvtMap;

        DecorationData(Target target, InjectionNodes.InjectionNode injectionNode, AbstractInsnNode callsiteDecl, AbstractInsnNode callsiteInvoke, Map<AbstractInsnNode, MethodInsnNode> cancels, Map<AbstractInsnNode, MethodInsnNode> blackholes, boolean requireFrame, LocalVariableNode[] locals) {
            super(target);
            this.node = injectionNode.getCurrentTarget();
            this.callsiteDecl = callsiteDecl;
            this.callsiteInvoke = callsiteInvoke;
            this.cancels = cancels;
            this.blackholes = blackholes;
            this.requireFrame = requireFrame;
            this.locals = locals;
            if (injectionNode.getDecoration("DECORATOR_ORIGINAL_INJECTION_POINT") instanceof MethodHead) {
                this.returnType = Type.VOID_TYPE;
                this.handlerArgs = new Type[0];
                this.nodeEnd = this.node;
                this.decorationTarget = DecorationTarget.HEAD;
            } else {
                AbstractInsnNode abstractInsnNode = this.node;
                if (abstractInsnNode instanceof MethodInsnNode) {
                    MethodInsnNode mn = (MethodInsnNode)abstractInsnNode;
                    this.returnType = Type.getReturnType((String)mn.desc);
                    AbstractInsnNode handlerArgs = targetArgs = Type.getArgumentTypes((String)mn.desc);
                    if (this.node.getOpcode() != 184) {
                        handlerArgs = new Type[((Type[])targetArgs).length + 1];
                        handlerArgs[0] = Type.getObjectType((String)mn.owner);
                        System.arraycopy(targetArgs, 0, handlerArgs, 1, ((Type[])targetArgs).length);
                    }
                    this.handlerArgs = handlerArgs;
                    this.nodeEnd = this.node;
                    this.decorationTarget = DecorationTarget.INVOKE;
                } else {
                    targetArgs = this.node;
                    if (targetArgs instanceof FieldInsnNode) {
                        FieldInsnNode fn = (FieldInsnNode)targetArgs;
                        switch (this.node.getOpcode()) {
                            case 180: {
                                this.returnType = Type.getType((String)fn.desc);
                                this.handlerArgs = new Type[]{Type.getObjectType((String)fn.owner)};
                                break;
                            }
                            case 178: {
                                this.returnType = Type.getType((String)fn.desc);
                                this.handlerArgs = new Type[0];
                                break;
                            }
                            case 181: {
                                this.returnType = Type.VOID_TYPE;
                                this.handlerArgs = new Type[]{Type.getObjectType((String)fn.owner), Type.getType((String)fn.desc)};
                                break;
                            }
                            case 179: {
                                this.returnType = Type.VOID_TYPE;
                                this.handlerArgs = new Type[]{Type.getType((String)fn.desc)};
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Unknown opcode " + this.node.getOpcode());
                            }
                        }
                        this.nodeEnd = this.node;
                        this.decorationTarget = DecorationTarget.FIELD;
                    } else {
                        TypeInsnNode tn;
                        targetArgs = this.node;
                        if (targetArgs instanceof TypeInsnNode && (tn = (TypeInsnNode)targetArgs).getOpcode() == 187) {
                            this.returnType = Type.getObjectType((String)tn.desc);
                            MethodInsnNode initNode = target.findInitNodeFor(tn);
                            if (initNode == null) {
                                throw new IllegalArgumentException("No <init> call for NEW at bci " + target.method.instructions.indexOf((AbstractInsnNode)tn));
                            }
                            this.handlerArgs = Type.getArgumentTypes((String)initNode.desc);
                            this.nodeEnd = initNode;
                            this.decorationTarget = DecorationTarget.NEW;
                        } else {
                            InsnNode insn;
                            abstractInsnNode = this.node;
                            if (abstractInsnNode instanceof InsnNode && (insn = (InsnNode)abstractInsnNode).getOpcode() >= 172 && insn.getOpcode() <= 177) {
                                this.returnType = Type.VOID_TYPE;
                                this.handlerArgs = new Type[]{target.returnType};
                                this.nodeEnd = this.node;
                                this.decorationTarget = DecorationTarget.RETURN;
                            } else {
                                throw new UnsupportedOperationException("Invalid target type " + this.node);
                            }
                        }
                    }
                }
            }
        }
    }

    private static class AllocatedLocalVariableNode
    extends LocalVariableNode {
        private final String id;

        public AllocatedLocalVariableNode(String id, String descriptor, String signature, LabelNode start, LabelNode end, int index) {
            super("decorator_" + id, descriptor, signature, start, end, index);
            this.id = id;
        }

        public void accept(MethodVisitor methodVisitor) {
        }
    }

    protected class CollectingVisitor
    extends MethodVisitor {
        private final Target target;
        private final DecorationData decorationData;
        final List<MethodNode> blocks;
        private AbstractInsnNode pendingCancel;
        private AbstractInsnNode pendingBlackhole;
        private boolean cancelReturn;

        protected CollectingVisitor(int api, Target target, DecorationData decorationData) {
            super(api, null);
            this.blocks = new ArrayList<MethodNode>();
            this.cancelReturn = false;
            this.target = target;
            this.decorationData = decorationData;
            this.step();
        }

        void next(AbstractInsnNode insn) {
            if (this.pendingCancel == insn) {
                super.visitInsn(this.target.returnType.getOpcode(172));
                this.pendingCancel = null;
                this.cancelReturn = true;
            } else if (this.pendingBlackhole == insn) {
                this.pendingBlackhole = null;
            } else if (this.pendingBlackhole == null) {
                if (this.pendingCancel == null && this.decorationData.cancels.get(insn) != null) {
                    this.pendingCancel = (AbstractInsnNode)this.decorationData.cancels.get(insn);
                } else if (this.decorationData.blackholes.get(insn) != null) {
                    this.pendingBlackhole = (AbstractInsnNode)this.decorationData.blackholes.get(insn);
                } else if (this.cancelReturn) {
                    if (insn.getOpcode() >= 172 && insn.getOpcode() <= 177) {
                        this.cancelReturn = false;
                    }
                } else {
                    insn.accept((MethodVisitor)this);
                }
            }
        }

        void step() {
            MethodNode mn = new MethodNode();
            this.blocks.add(mn);
            this.mv = mn;
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            if (owner.equals(((Decorator)Decorator.this).classNode.name) && name.equals(((Decorator)Decorator.this).methodNode.name) && descriptor.equals(((Decorator)Decorator.this).methodNode.desc)) {
                throw new InvalidInjectionException((ISelectorContext)Decorator.this.info, "Inlining recursive method");
            }
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        }

        public void visitVarInsn(int opcode, int varIndex) {
            super.visitVarInsn(opcode, this.decorationData.lvtMap[varIndex]);
        }

        public void visitIincInsn(int varIndex, int increment) {
            super.visitIincInsn(this.decorationData.lvtMap[varIndex], increment);
        }

        public void visitFrame(int type, int numLocal, Object[] local, int numStack, Object[] stack) {
            if (type == 0 || type == -1) {
                int mergedNum = numLocal + this.decorationData.targetLocals.size();
                Object[] mergedLocal = new Object[mergedNum];
                System.arraycopy(this.decorationData.targetLocals.toArray(), 0, mergedLocal, 0, this.decorationData.targetLocals.size());
                System.arraycopy(local, 0, mergedLocal, this.decorationData.targetLocals.size(), numLocal);
                super.visitFrame(type, mergedNum, mergedLocal, numStack, stack);
            } else {
                super.visitFrame(type, numLocal, local, numStack, stack);
            }
        }

        public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
            super.visitLocalVariable(name, descriptor, signature, start, end, this.decorationData.lvtMap[index]);
        }

        public void visitLineNumber(int line, Label start) {
        }

        public void visitInsn(int opcode) {
            if (opcode == this.decorationData.returnType.getOpcode(172)) {
                if (this.decorationData.hasEnd) {
                    super.visitJumpInsn(167, this.decorationData.end);
                }
            } else {
                super.visitInsn(opcode);
            }
        }

        public void visitEnd() {
            if (this.decorationData.hasEnd) {
                super.visitLabel(this.decorationData.end);
            }
            super.visitEnd();
        }
    }

    static enum DecorationTarget {
        INVOKE,
        FIELD,
        NEW,
        RETURN,
        HEAD;

    }
}

