/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootDataResolver;

public record Advancement(Optional<ResourceLocation> f_138298_, Optional<DisplayInfo> f_138299_, AdvancementRewards f_138300_, Map<String, Criterion<?>> f_138302_, AdvancementRequirements f_138303_, boolean f_285575_, Optional<Component> f_291795_) {
    private static final Codec<Map<String, Criterion<?>>> f_302506_ = ExtraCodecs.m_264370_(Codec.unboundedMap((Codec)Codec.STRING, Criterion.f_303845_), p_308091_ -> p_308091_.isEmpty() ? DataResult.error(() -> "Advancement criteria cannot be empty") : DataResult.success((Object)p_308091_));
    public static final Codec<Advancement> f_303179_ = ExtraCodecs.m_264370_(RecordCodecBuilder.create(p_308092_ -> p_308092_.group((App)ExtraCodecs.m_294263_(ResourceLocation.f_135803_, "parent").forGetter(Advancement::f_138298_), (App)ExtraCodecs.m_294263_(DisplayInfo.f_302437_, "display").forGetter(Advancement::f_138299_), (App)ExtraCodecs.m_295827_(AdvancementRewards.f_303002_, "rewards", AdvancementRewards.f_9978_).forGetter(Advancement::f_138300_), (App)f_302506_.fieldOf("criteria").forGetter(Advancement::f_138302_), (App)ExtraCodecs.m_294263_(AdvancementRequirements.f_302300_, "requirements").forGetter(p_308099_ -> Optional.of(p_308099_.f_138303_())), (App)ExtraCodecs.m_295827_(Codec.BOOL, "sends_telemetry_event", false).forGetter(Advancement::f_285575_)).apply((Applicative)p_308092_, (p_308085_, p_308086_, p_308087_, p_308088_, p_308089_, p_308090_) -> {
        AdvancementRequirements advancementrequirements = p_308089_.orElseGet(() -> AdvancementRequirements.m_295902_(p_308088_.keySet()));
        return new Advancement((Optional<ResourceLocation>)p_308085_, (Optional<DisplayInfo>)p_308086_, (AdvancementRewards)p_308087_, (Map<String, Criterion<?>>)p_308088_, advancementrequirements, (boolean)p_308090_);
    })), Advancement::m_307846_);

    public Advancement(Optional<ResourceLocation> p_299284_, Optional<DisplayInfo> p_301017_, AdvancementRewards p_286389_, Map<String, Criterion<?>> p_286635_, AdvancementRequirements p_300504_, boolean p_286478_) {
        this(p_299284_, p_301017_, p_286389_, Map.copyOf(p_286635_), p_300504_, p_286478_, p_301017_.map(Advancement::m_294861_));
    }

    private static DataResult<Advancement> m_307846_(Advancement p_312373_) {
        return p_312373_.f_138303_().m_305436_(p_312373_.f_138302_().keySet()).map(p_308094_ -> p_312373_);
    }

    private static Component m_294861_(DisplayInfo p_300038_) {
        Component component = p_300038_.m_14977_();
        ChatFormatting chatformatting = p_300038_.m_306629_().m_305069_();
        MutableComponent component1 = ComponentUtils.m_130750_(component.m_6881_(), Style.f_131099_.m_131140_(chatformatting)).m_130946_("\n").m_7220_(p_300038_.m_14985_());
        MutableComponent component2 = component.m_6881_().m_130938_(p_138316_ -> p_138316_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, component1)));
        return ComponentUtils.m_130748_(component2).m_130940_(chatformatting);
    }

    public static Component m_292915_(AdvancementHolder p_297556_) {
        return p_297556_.f_290952_().f_291795_().orElseGet(() -> Component.m_237113_(p_297556_.f_291758_().toString()));
    }

    public void m_295649_(FriendlyByteBuf p_299393_) {
        p_299393_.m_236835_(this.f_138298_, FriendlyByteBuf::m_130085_);
        p_299393_.m_236835_(this.f_138299_, (p_296098_, p_296099_) -> p_296099_.m_14983_((FriendlyByteBuf)((Object)p_296098_)));
        this.f_138303_.m_292869_(p_299393_);
        p_299393_.writeBoolean(this.f_285575_);
    }

    public static Advancement m_293151_(FriendlyByteBuf p_300670_) {
        return new Advancement(p_300670_.m_236860_(FriendlyByteBuf::m_130281_), p_300670_.m_236860_(DisplayInfo::m_14988_), AdvancementRewards.f_9978_, Map.of(), new AdvancementRequirements(p_300670_), p_300670_.readBoolean());
    }

    public boolean m_295578_() {
        return this.f_138298_.isEmpty();
    }

    public void m_306920_(ProblemReporter p_310503_, LootDataResolver p_311286_) {
        this.f_138302_.forEach((p_308097_, p_308098_) -> {
            CriterionValidator criterionvalidator = new CriterionValidator(p_310503_.m_306146_((String)p_308097_), p_311286_);
            p_308098_.f_290685_().m_7683_(criterionvalidator);
        });
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{Advancement.class, "parent;display;rewards;criteria;requirements;sendsTelemetryEvent;name", "f_138298_", "f_138299_", "f_138300_", "f_138302_", "f_138303_", "f_285575_", "f_291795_"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Advancement.class, "parent;display;rewards;criteria;requirements;sendsTelemetryEvent;name", "f_138298_", "f_138299_", "f_138300_", "f_138302_", "f_138303_", "f_285575_", "f_291795_"}, this);
    }

    @Override
    public final boolean equals(Object p_138324_) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Advancement.class, "parent;display;rewards;criteria;requirements;sendsTelemetryEvent;name", "f_138298_", "f_138299_", "f_138300_", "f_138302_", "f_138303_", "f_285575_", "f_291795_"}, this, p_138324_);
    }

    public static class Builder {
        private Optional<ResourceLocation> f_138333_ = Optional.empty();
        private Optional<DisplayInfo> f_138334_ = Optional.empty();
        private AdvancementRewards f_138335_ = AdvancementRewards.f_9978_;
        private final ImmutableMap.Builder<String, Criterion<?>> f_138336_ = ImmutableMap.builder();
        private Optional<AdvancementRequirements> f_138337_ = Optional.empty();
        private AdvancementRequirements.Strategy f_138338_ = AdvancementRequirements.Strategy.f_290313_;
        private boolean f_285655_;

        public static Builder m_138353_() {
            return new Builder().m_293041_();
        }

        public static Builder m_285878_() {
            return new Builder();
        }

        public Builder m_138398_(AdvancementHolder p_300513_) {
            this.f_138333_ = Optional.of(p_300513_.f_291758_());
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder m_138396_(ResourceLocation p_138397_) {
            this.f_138333_ = Optional.of(p_138397_);
            return this;
        }

        public Builder m_138362_(ItemStack p_138363_, Component p_138364_, Component p_138365_, @Nullable ResourceLocation p_138366_, AdvancementType p_310090_, boolean p_138368_, boolean p_138369_, boolean p_138370_) {
            return this.m_138358_(new DisplayInfo(p_138363_, p_138364_, p_138365_, Optional.ofNullable(p_138366_), p_310090_, p_138368_, p_138369_, p_138370_));
        }

        public Builder m_138371_(ItemLike p_138372_, Component p_138373_, Component p_138374_, @Nullable ResourceLocation p_138375_, AdvancementType p_309840_, boolean p_138377_, boolean p_138378_, boolean p_138379_) {
            return this.m_138358_(new DisplayInfo(new ItemStack(p_138372_.m_5456_()), p_138373_, p_138374_, Optional.ofNullable(p_138375_), p_309840_, p_138377_, p_138378_, p_138379_));
        }

        public Builder m_138358_(DisplayInfo p_138359_) {
            this.f_138334_ = Optional.of(p_138359_);
            return this;
        }

        public Builder m_138354_(AdvancementRewards.Builder p_138355_) {
            return this.m_138356_(p_138355_.m_10004_());
        }

        public Builder m_138356_(AdvancementRewards p_138357_) {
            this.f_138335_ = p_138357_;
            return this;
        }

        public Builder m_138383_(String p_138384_, Criterion<?> p_138385_) {
            this.f_138336_.put((Object)p_138384_, p_138385_);
            return this;
        }

        public Builder m_138360_(AdvancementRequirements.Strategy p_298091_) {
            this.f_138338_ = p_298091_;
            return this;
        }

        public Builder m_143951_(AdvancementRequirements p_300756_) {
            this.f_138337_ = Optional.of(p_300756_);
            return this;
        }

        public Builder m_293041_() {
            this.f_285655_ = true;
            return this;
        }

        public AdvancementHolder m_138403_(ResourceLocation p_138404_) {
            ImmutableMap map = this.f_138336_.buildOrThrow();
            AdvancementRequirements advancementrequirements = this.f_138337_.orElseGet(() -> this.m_291968_((Map)map));
            return new AdvancementHolder(p_138404_, new Advancement(this.f_138333_, this.f_138334_, this.f_138335_, (Map<String, Criterion<?>>)map, advancementrequirements, this.f_285655_));
        }

        public AdvancementHolder m_138389_(Consumer<AdvancementHolder> p_138390_, String p_138391_) {
            return this.save(p_138390_, new ResourceLocation(p_138391_));
        }

        public AdvancementHolder save(Consumer<AdvancementHolder> p_138390_, ResourceLocation id) {
            AdvancementHolder advancementholder = this.m_138403_(id);
            p_138390_.accept(advancementholder);
            return advancementholder;
        }

        private /* synthetic */ AdvancementRequirements m_291968_(Map p_296100_) {
            return this.f_138338_.m_294843_(p_296100_.keySet());
        }
    }
}

