/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMaps;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerRecipeBook;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.stats.StatsCounter;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public record PlayerPredicate(MinMaxBounds.Ints f_62245_, Optional<GameType> f_62246_, List<StatMatcher<?>> f_62247_, Object2BooleanMap<ResourceLocation> f_62248_, Map<ResourceLocation, AdvancementPredicate> f_62249_, Optional<EntityPredicate> f_156744_) implements EntitySubPredicate
{
    public static final int f_156743_ = 100;
    public static final MapCodec<PlayerPredicate> f_291796_ = RecordCodecBuilder.mapCodec(p_296141_ -> p_296141_.group((App)ExtraCodecs.m_295827_(MinMaxBounds.Ints.f_290636_, "level", MinMaxBounds.Ints.f_55364_).forGetter(PlayerPredicate::f_62245_), (App)GameType.f_262729_.optionalFieldOf("gamemode").forGetter(PlayerPredicate::f_62246_), (App)ExtraCodecs.m_295827_(StatMatcher.f_290355_.listOf(), "stats", List.of()).forGetter(PlayerPredicate::f_62247_), (App)ExtraCodecs.m_295827_(ExtraCodecs.m_293159_(ResourceLocation.f_135803_), "recipes", Object2BooleanMaps.emptyMap()).forGetter(PlayerPredicate::f_62248_), (App)ExtraCodecs.m_295827_(Codec.unboundedMap(ResourceLocation.f_135803_, AdvancementPredicate.f_290587_), "advancements", Map.of()).forGetter(PlayerPredicate::f_62249_), (App)ExtraCodecs.m_294263_(EntityPredicate.f_291089_, "looking_at").forGetter(PlayerPredicate::f_156744_)).apply((Applicative)p_296141_, PlayerPredicate::new));

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean m_213868_(Entity p_222484_, ServerLevel p_222485_, @Nullable Vec3 p_222486_) {
        void $$4;
        if (!(p_222484_ instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer $$3 = (ServerPlayer)p_222484_;
        if (!this.f_62245_.m_55390_($$4.f_36078_)) {
            return false;
        }
        if (this.f_62246_.isPresent() && this.f_62246_.get() != $$4.f_8941_.m_9290_()) {
            return false;
        }
        ServerStatsCounter $$5 = $$4.m_8951_();
        for (StatMatcher<?> statMatcher : this.f_62247_) {
            if (statMatcher.m_294347_($$5)) continue;
            return false;
        }
        ServerRecipeBook $$7 = $$4.m_8952_();
        for (Object2BooleanMap.Entry $$8 : this.f_62248_.object2BooleanEntrySet()) {
            if ($$7.m_12711_((ResourceLocation)$$8.getKey()) == $$8.getBooleanValue()) continue;
            return false;
        }
        if (!this.f_62249_.isEmpty()) {
            PlayerAdvancements playerAdvancements = $$4.m_8960_();
            ServerAdvancementManager $$10 = $$4.m_20194_().m_129889_();
            for (Map.Entry<ResourceLocation, AdvancementPredicate> $$11 : this.f_62249_.entrySet()) {
                AdvancementHolder $$12 = $$10.m_294099_($$11.getKey());
                if ($$12 != null && $$11.getValue().test(playerAdvancements.m_135996_($$12))) continue;
                return false;
            }
        }
        if (this.f_156744_.isPresent()) {
            Vec3 vec3 = $$4.m_146892_();
            Vec3 $$14 = $$4.m_20252_(1.0f);
            Vec3 $$15 = vec3.m_82520_($$14.f_82479_ * 100.0, $$14.f_82480_ * 100.0, $$14.f_82481_ * 100.0);
            EntityHitResult $$16 = ProjectileUtil.m_150175_($$4.m_9236_(), (Entity)$$4, vec3, $$15, new AABB(vec3, $$15).m_82400_(1.0), p_156765_ -> !p_156765_.m_5833_(), 0.0f);
            if ($$16 == null || $$16.m_6662_() != HitResult.Type.ENTITY) {
                return false;
            }
            Entity $$17 = $$16.m_82443_();
            if (!this.f_156744_.get().m_36611_((ServerPlayer)$$4, $$17) || !$$4.m_142582_($$17)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public EntitySubPredicate.Type m_213836_() {
        return EntitySubPredicate.Types.f_218850_;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{PlayerPredicate.class, "level;gameType;stats;recipes;advancements;lookingAt", "f_62245_", "f_62246_", "f_62247_", "f_62248_", "f_62249_", "f_156744_"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PlayerPredicate.class, "level;gameType;stats;recipes;advancements;lookingAt", "f_62245_", "f_62246_", "f_62247_", "f_62248_", "f_62249_", "f_156744_"}, this);
    }

    @Override
    public final boolean equals(Object p_298228_) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PlayerPredicate.class, "level;gameType;stats;recipes;advancements;lookingAt", "f_62245_", "f_62246_", "f_62247_", "f_62248_", "f_62249_", "f_156744_"}, this, p_298228_);
    }

    record StatMatcher<T>(StatType<T> f_290937_, Holder<T> f_291891_, MinMaxBounds.Ints f_291204_, Supplier<Stat<T>> f_291673_) {
        public static final Codec<StatMatcher<?>> f_290355_ = BuiltInRegistries.f_256899_.m_194605_().dispatch(StatMatcher::f_290937_, StatMatcher::m_293532_);

        public StatMatcher(StatType<T> p_297612_, Holder<T> p_301288_, MinMaxBounds.Ints p_298901_) {
            this(p_297612_, p_301288_, p_298901_, (Supplier<Stat<T>>)Suppliers.memoize(() -> p_297612_.m_12902_(p_301288_.m_203334_())));
        }

        private static <T> Codec<StatMatcher<T>> m_293532_(StatType<T> p_297243_) {
            return RecordCodecBuilder.create(p_298561_ -> p_298561_.group((App)p_297243_.m_12893_().m_206110_().fieldOf("stat").forGetter(StatMatcher::f_291891_), (App)ExtraCodecs.m_295827_(MinMaxBounds.Ints.f_290636_, "value", MinMaxBounds.Ints.f_55364_).forGetter(StatMatcher::f_291204_)).apply((Applicative)p_298561_, (p_301267_, p_297932_) -> new StatMatcher(p_297243_, p_301267_, (MinMaxBounds.Ints)p_297932_)));
        }

        public boolean m_294347_(StatsCounter p_300296_) {
            return this.f_291204_.m_55390_(p_300296_.m_13015_(this.f_291673_.get()));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{StatMatcher.class, "type;value;range;stat", "f_290937_", "f_291891_", "f_291204_", "f_291673_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{StatMatcher.class, "type;value;range;stat", "f_290937_", "f_291891_", "f_291204_", "f_291673_"}, this);
        }

        @Override
        public final boolean equals(Object p_301070_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{StatMatcher.class, "type;value;range;stat", "f_290937_", "f_291891_", "f_291204_", "f_291673_"}, this, p_301070_);
        }
    }

    static interface AdvancementPredicate
    extends Predicate<AdvancementProgress> {
        public static final Codec<AdvancementPredicate> f_290587_ = Codec.either(AdvancementDonePredicate.f_290875_, AdvancementCriterionsPredicate.f_290814_).xmap(p_300258_ -> (AdvancementPredicate)p_300258_.map(p_301189_ -> p_301189_, p_300077_ -> p_300077_), p_298131_ -> {
            if (p_298131_ instanceof AdvancementDonePredicate) {
                AdvancementDonePredicate $$1 = (AdvancementDonePredicate)p_298131_;
                return Either.left((Object)$$1);
            }
            if (p_298131_ instanceof AdvancementCriterionsPredicate) {
                AdvancementCriterionsPredicate $$2 = (AdvancementCriterionsPredicate)p_298131_;
                return Either.right((Object)$$2);
            }
            throw new UnsupportedOperationException();
        });
    }

    public static class Builder {
        private MinMaxBounds.Ints f_62307_ = MinMaxBounds.Ints.f_55364_;
        private Optional<GameType> f_62308_ = Optional.empty();
        private final ImmutableList.Builder<StatMatcher<?>> f_62309_ = ImmutableList.builder();
        private final Object2BooleanMap<ResourceLocation> f_62310_ = new Object2BooleanOpenHashMap();
        private final Map<ResourceLocation, AdvancementPredicate> f_62311_ = Maps.newHashMap();
        private Optional<EntityPredicate> f_156766_ = Optional.empty();

        public static Builder m_156767_() {
            return new Builder();
        }

        public Builder m_156775_(MinMaxBounds.Ints p_156776_) {
            this.f_62307_ = p_156776_;
            return this;
        }

        public <T> Builder m_156768_(StatType<T> p_300081_, Holder.Reference<T> p_298048_, MinMaxBounds.Ints p_156770_) {
            this.f_62309_.add(new StatMatcher<T>(p_300081_, p_298048_, p_156770_));
            return this;
        }

        public Builder m_156780_(ResourceLocation p_156781_, boolean p_156782_) {
            this.f_62310_.put((Object)p_156781_, p_156782_);
            return this;
        }

        public Builder m_156773_(GameType p_156774_) {
            this.f_62308_ = Optional.of(p_156774_);
            return this;
        }

        public Builder m_156771_(EntityPredicate.Builder p_299861_) {
            this.f_156766_ = Optional.of(p_299861_.m_36662_());
            return this;
        }

        public Builder m_156783_(ResourceLocation p_156784_, boolean p_156785_) {
            this.f_62311_.put(p_156784_, new AdvancementDonePredicate(p_156785_));
            return this;
        }

        public Builder m_156777_(ResourceLocation p_156778_, Map<String, Boolean> p_156779_) {
            this.f_62311_.put(p_156778_, new AdvancementCriterionsPredicate((Object2BooleanMap<String>)new Object2BooleanOpenHashMap(p_156779_)));
            return this;
        }

        public PlayerPredicate m_62313_() {
            return new PlayerPredicate(this.f_62307_, this.f_62308_, (List<StatMatcher<?>>)this.f_62309_.build(), this.f_62310_, this.f_62311_, this.f_156766_);
        }
    }

    record AdvancementCriterionsPredicate(Object2BooleanMap<String> f_62291_) implements AdvancementPredicate
    {
        public static final Codec<AdvancementCriterionsPredicate> f_290814_ = ExtraCodecs.m_293159_(Codec.STRING).xmap(AdvancementCriterionsPredicate::new, AdvancementCriterionsPredicate::f_62291_);

        @Override
        public boolean test(AdvancementProgress p_62296_) {
            for (Object2BooleanMap.Entry $$1 : this.f_62291_.object2BooleanEntrySet()) {
                CriterionProgress $$2 = p_62296_.m_8214_((String)$$1.getKey());
                if ($$2 != null && $$2.m_12911_() == $$1.getBooleanValue()) continue;
                return false;
            }
            return true;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{AdvancementCriterionsPredicate.class, "criterions", "f_62291_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{AdvancementCriterionsPredicate.class, "criterions", "f_62291_"}, this);
        }

        @Override
        public final boolean equals(Object p_299402_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{AdvancementCriterionsPredicate.class, "criterions", "f_62291_"}, this, p_299402_);
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((AdvancementProgress)object);
        }
    }

    record AdvancementDonePredicate(boolean f_62299_) implements AdvancementPredicate
    {
        public static final Codec<AdvancementDonePredicate> f_290875_ = Codec.BOOL.xmap(AdvancementDonePredicate::new, AdvancementDonePredicate::f_62299_);

        @Override
        public boolean test(AdvancementProgress p_62304_) {
            return p_62304_.m_8193_() == this.f_62299_;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{AdvancementDonePredicate.class, "state", "f_62299_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{AdvancementDonePredicate.class, "state", "f_62299_"}, this);
        }

        @Override
        public final boolean equals(Object p_298631_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{AdvancementDonePredicate.class, "state", "f_62299_"}, this, p_298631_);
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((AdvancementProgress)object);
        }
    }
}

